/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery;

import akka.actor.Address;
import akka.remote.UniqueAddress;
import akka.remote.artery.Association;
import akka.remote.artery.AssociationState;
import akka.remote.artery.ImmutableLongMap;
import akka.remote.artery.ImmutableLongMap$;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.MapLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005%a!B\u0001\u0003\u0001\u0011A!aE!tg>\u001c\u0017.\u0019;j_:\u0014VmZ5tiJL(BA\u0002\u0005\u0003\u0019\t'\u000f^3ss*\u0011QAB\u0001\u0007e\u0016lw\u000e^3\u000b\u0003\u001d\tA!Y6lCN\u0011\u0001!\u0003\t\u0003\u00155i\u0011a\u0003\u0006\u0002\u0019\u0005)1oY1mC&\u0011ab\u0003\u0002\u0007\u0003:L(+\u001a4\t\u0011A\u0001!\u0011!Q\u0001\nI\t\u0011c\u0019:fCR,\u0017i]:pG&\fG/[8o\u0007\u0001\u0001BAC\n\u00167%\u0011Ac\u0003\u0002\n\rVt7\r^5p]F\u0002\"AF\r\u000e\u0003]Q!\u0001\u0007\u0004\u0002\u000b\u0005\u001cGo\u001c:\n\u0005i9\"aB!eIJ,7o\u001d\t\u00039ui\u0011AA\u0005\u0003=\t\u00111\"Q:t_\u000eL\u0017\r^5p]\")\u0001\u0005\u0001C\u0001C\u00051A(\u001b8jiz\"\"AI\u0012\u0011\u0005q\u0001\u0001\"\u0002\t \u0001\u0004\u0011\u0002BB\u0013\u0001A\u0003%a%A\u000bbgN|7-[1uS>t7OQ=BI\u0012\u0014Xm]:\u0011\u0007\u001d\u0002$'D\u0001)\u0015\tI#&\u0001\u0004bi>l\u0017n\u0019\u0006\u0003W1\n!bY8oGV\u0014(/\u001a8u\u0015\tic&\u0001\u0003vi&d'\"A\u0018\u0002\t)\fg/Y\u0005\u0003c!\u0012q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-\u001a\t\u0005gi*2D\u0004\u00025qA\u0011QgC\u0007\u0002m)\u0011q'E\u0001\u0007yI|w\u000e\u001e \n\u0005eZ\u0011A\u0002)sK\u0012,g-\u0003\u0002<y\t\u0019Q*\u00199\u000b\u0005eZ\u0001B\u0002 \u0001A\u0003%q(A\tbgN|7-[1uS>t7OQ=VS\u0012\u00042a\n\u0019A!\ra\u0012iG\u0005\u0003\u0005\n\u0011\u0001#S7nkR\f'\r\\3M_:<W*\u00199\t\u000b\u0011\u0003AQA#\u0002\u0017\u0005\u001c8o\\2jCRLwN\u001c\u000b\u00037\u0019CQaR\"A\u0002U\tQB]3n_R,\u0017\t\u001a3sKN\u001c\bFA\"J!\tQU*D\u0001L\u0015\ta5\"\u0001\u0006b]:|G/\u0019;j_:L!AT&\u0003\u000fQ\f\u0017\u000e\u001c:fG\")A\t\u0001C\u0001!R\u0011\u0011K\u0016\t\u0004%R[R\"A*\u000b\u000552\u0011BA+T\u0005%y\u0005\u000f^5p]Z\u000bG\u000eC\u0003X\u001f\u0002\u0007\u0001,A\u0002vS\u0012\u0004\"AC-\n\u0005i[!\u0001\u0002'p]\u001eDQ\u0001\u0018\u0001\u0005\u0006u\u000baa]3u+&#ECA\u000e_\u0011\u0015y6\f1\u0001a\u0003\u0011\u0001X-\u001a:\u0011\u0005\u0005\u0014W\"\u0001\u0003\n\u0005\r$!!D+oSF,X-\u00113ee\u0016\u001c8\u000f\u000b\u0002\\\u0013\")a\r\u0001C\u0001O\u0006y\u0011\r\u001c7BgN|7-[1uS>t7/F\u0001i!\r\u0019\u0014nG\u0005\u0003Ur\u00121aU3u\u0011\u0015a\u0007\u0001\"\u0001n\u0003]\u0011X-\\8wKVsWo]3e#V\f'/\u00198uS:,G\r\u0006\u0002ocB\u0011!b\\\u0005\u0003a.\u0011A!\u00168ji\")!o\u001ba\u0001g\u0006)\u0011M\u001a;feB\u0011A\u000f_\u0007\u0002k*\u0011ao^\u0001\tIV\u0014\u0018\r^5p]*\u00111fC\u0005\u0003sV\u0014aBR5oSR,G)\u001e:bi&|g\u000eC\u0003|\u0001\u0011%A0\u0001\u0011sK6|g/Z+okN,G-U;be\u0006tG/\u001b8fI\nK\u0018\t\u001a3sKN\u001cHC\u00018~\u0011\u0015\u0011(\u00101\u0001tQ\tQ\u0018\nC\u0004\u0002\u0002\u0001!I!a\u0001\u00029I,Wn\u001c<f+:,8/\u001a3Rk\u0006\u0014\u0018M\u001c;j]\u0016$')_+jIR\u0019a.!\u0002\t\u000bI|\b\u0019A:)\u0005}L\u0005")
public class AssociationRegistry {
    private final Function1<Address, Association> createAssociation;
    private final AtomicReference<Map<Address, Association>> associationsByAddress;
    private final AtomicReference<ImmutableLongMap<Association>> associationsByUid;

    public final Association association(Address remoteAddress) {
        Association association;
        block2: {
            Option option;
            block3: {
                Association newAssociation;
                while (true) {
                    Map<Address, Association> currentMap;
                    if ((option = (currentMap = this.associationsByAddress.get()).get((Object)remoteAddress)) instanceof Some) {
                        Association existing;
                        Some some = (Some)option;
                        association = existing = (Association)some.value();
                        break block2;
                    }
                    if (!None$.MODULE$.equals(option)) break block3;
                    newAssociation = (Association)this.createAssociation.apply((Object)remoteAddress);
                    Map newMap = currentMap.updated((Object)remoteAddress, (Object)newAssociation);
                    if (this.associationsByAddress.compareAndSet(currentMap, (Map<Address, Association>)newMap)) break;
                }
                newAssociation.associate();
                association = newAssociation;
                break block2;
            }
            throw new MatchError((Object)option);
        }
        return association;
    }

    public Association association(long uid) {
        return this.associationsByUid.get().get(uid);
    }

    public final Association setUID(UniqueAddress peer) {
        Association association;
        block3: {
            Association a;
            while (true) {
                a = this.association(peer.address());
                ImmutableLongMap<Association> currentMap = this.associationsByUid.get();
                Association association2 = currentMap.get(peer.uid());
                Association association3 = (Association)OptionVal.Some$.MODULE$.unapply((Object)association2);
                if (!OptionVal$.MODULE$.isEmpty$extension((Object)association3)) {
                    Association previous = (Association)OptionVal$.MODULE$.get$extension((Object)association3);
                    if (previous != a) {
                        throw new IllegalArgumentException(new StringBuilder(27).append("UID collision old [").append(previous).append("] new [").append(a).append("]").toString());
                    }
                    association = a;
                    break block3;
                }
                ImmutableLongMap<Association> newMap = currentMap.updated(peer.uid(), a);
                if (this.associationsByUid.compareAndSet(currentMap, newMap)) break;
            }
            association = a;
        }
        return association;
    }

    public Set<Association> allAssociations() {
        return ((MapLike)this.associationsByAddress.get()).values().toSet();
    }

    public void removeUnusedQuarantined(FiniteDuration after) {
        this.removeUnusedQuarantinedByAddress(after);
        this.removeUnusedQuarantinedByUid(after);
    }

    private void removeUnusedQuarantinedByAddress(FiniteDuration after) {
        block1: {
            BoxedUnit boxedUnit;
            while (true) {
                long now = System.nanoTime();
                long afterNanos = after.toNanos();
                Map<Address, Association> currentMap = this.associationsByAddress.get();
                Map remove = (Map)currentMap.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(x0$8, x1$2) -> {
                    Tuple2 tuple2;
                    Map acc;
                    block3: {
                        Tuple2 tuple22;
                        block2: {
                            tuple22 = new Tuple2(x0$8, x1$2);
                            if (tuple22 == null) break block2;
                            acc = (Map)tuple22._1();
                            tuple2 = (Tuple2)tuple22._2();
                            if (tuple2 != null) break block3;
                        }
                        throw new MatchError((Object)tuple22);
                    }
                    Address address = (Address)tuple2._1();
                    Association association = (Association)tuple2._2();
                    AssociationState state = association.associationState();
                    Map map = state.isQuarantined() && now - state.lastUsedTimestamp().get() >= afterNanos ? acc.updated((Object)address, (Object)association) : acc;
                    return map;
                });
                if (!remove.nonEmpty()) break;
                Map newMap = (Map)currentMap.$minus$minus((GenTraversableOnce)remove.keysIterator());
                if (!this.associationsByAddress.compareAndSet(currentMap, (Map<Address, Association>)newMap)) continue;
                remove.valuesIterator().foreach((Function1 & Serializable & scala.Serializable)x$19 -> {
                    x$19.removedAfterQuarantined();
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
                break block1;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void removeUnusedQuarantinedByUid(FiniteDuration after) {
        block1: {
            BoxedUnit boxedUnit;
            while (true) {
                long now = System.nanoTime();
                long afterNanos = after.toNanos();
                ImmutableLongMap<Association> currentMap = this.associationsByUid.get();
                ObjectRef remove = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
                currentMap.keysIterator().foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)uid -> {
                    block0: {
                        Association association = (Association)OptionVal$.MODULE$.get$extension(currentMap.get(uid));
                        AssociationState state = association.associationState();
                        if (!state.isQuarantined() || now - state.lastUsedTimestamp().get() < afterNanos) break block0;
                        remove$1.elem = ((Map)remove$1.elem).updated((Object)BoxesRunTime.boxToLong((long)uid), (Object)association);
                    }
                });
                if (!((Map)remove.elem).nonEmpty()) break;
                ImmutableLongMap newMap = (ImmutableLongMap)((Map)remove.elem).keysIterator().foldLeft(currentMap, (Function2 & Serializable & scala.Serializable)(acc, uid) -> acc.remove(BoxesRunTime.unboxToLong((Object)uid)));
                if (!this.associationsByUid.compareAndSet(currentMap, newMap)) continue;
                ((Map)remove.elem).valuesIterator().foreach((Function1 & Serializable & scala.Serializable)x$20 -> {
                    x$20.removedAfterQuarantined();
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
                break block1;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public AssociationRegistry(Function1<Address, Association> createAssociation) {
        this.createAssociation = createAssociation;
        this.associationsByAddress = new AtomicReference<Map>(Predef$.MODULE$.Map().empty());
        this.associationsByUid = new AtomicReference(ImmutableLongMap$.MODULE$.empty(ClassTag$.MODULE$.apply(Association.class)));
    }
}

