/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.ClientConductor;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersReader;

public class Counter
extends AtomicCounter {
    private final long registrationId;
    private final ClientConductor clientConductor;
    private volatile boolean isClosed = false;

    Counter(long registrationId, ClientConductor clientConductor, AtomicBuffer buffer, int counterId) {
        super(buffer, counterId);
        this.registrationId = registrationId;
        this.clientConductor = clientConductor;
    }

    Counter(CountersReader countersReader, long registrationId, int counterId) {
        super(countersReader.valuesBuffer(), counterId);
        if (countersReader.getCounterState(counterId) != 1) {
            throw new IllegalStateException("Counter id has not been allocated: " + counterId);
        }
        this.registrationId = registrationId;
        this.clientConductor = null;
    }

    public long registrationId() {
        return this.registrationId;
    }

    public void close() {
        if (null != this.clientConductor) {
            this.clientConductor.releaseCounter(this);
        } else {
            this.isClosed = true;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    void internalClose() {
        super.close();
        this.isClosed = true;
    }
}

