/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.transport.netty;

import akka.ConfigurationException;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.Address$;
import akka.actor.ExtendedActorSystem;
import akka.dispatch.Dispatchers;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.event.MarkerLoggingAdapter;
import akka.remote.RARP;
import akka.remote.RARP$;
import akka.remote.transport.AssociationHandle;
import akka.remote.transport.Transport;
import akka.remote.transport.netty.ClientHandler;
import akka.remote.transport.netty.NettyFutureBridge$;
import akka.remote.transport.netty.NettySSLSupport$;
import akka.remote.transport.netty.NettyTransport$;
import akka.remote.transport.netty.NettyTransportException;
import akka.remote.transport.netty.NettyTransportExceptionNoStack;
import akka.remote.transport.netty.NettyTransportSettings;
import akka.remote.transport.netty.NettyTransportSettings$Tcp$;
import akka.remote.transport.netty.NettyTransportSettings$Udp$;
import akka.remote.transport.netty.SSLEngineProvider;
import akka.remote.transport.netty.ServerHandler;
import akka.remote.transport.netty.TcpClientHandler;
import akka.remote.transport.netty.TcpServerHandler;
import akka.remote.transport.netty.UdpAssociationHandle;
import akka.remote.transport.netty.UdpClientHandler;
import akka.remote.transport.netty.UdpServerHandler;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.DefaultChannelPipeline;
import org.jboss.netty.channel.FixedReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.LengthFieldPrepender;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\rErAB\u0001\u0003\u0011\u0003!!\"\u0001\bOKR$\u0018\u0010\u0016:b]N\u0004xN\u001d;\u000b\u0005\r!\u0011!\u00028fiRL(BA\u0003\u0007\u0003%!(/\u00198ta>\u0014HO\u0003\u0002\b\u0011\u00051!/Z7pi\u0016T\u0011!C\u0001\u0005C.\\\u0017\r\u0005\u0002\f\u00195\t!A\u0002\u0004\u000e\u0005!\u0005AA\u0004\u0002\u000f\u001d\u0016$H/\u001f+sC:\u001c\bo\u001c:u'\taq\u0002\u0005\u0002\u0011'5\t\u0011CC\u0001\u0013\u0003\u0015\u00198-\u00197b\u0013\t!\u0012C\u0001\u0004B]f\u0014VM\u001a\u0005\u0006-1!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t!\u0002C\u0004\u001b\u0019\t\u0007I\u0011A\u000e\u0002-\u0019\u0013\u0018-\\3MK:<G\u000f\u001b$jK2$G*\u001a8hi\",\u0012\u0001\b\t\u0003!uI!AH\t\u0003\u0007%sG\u000f\u0003\u0004!\u0019\u0001\u0006I\u0001H\u0001\u0018\rJ\fW.\u001a'f]\u001e$\bNR5fY\u0012dUM\\4uQ\u0002BQA\t\u0007\u0005\u0002\r\nQb\u001a:bG\u00164W\u000f\\\"m_N,GC\u0001\u00131)\t)\u0003\u0006\u0005\u0002\u0011M%\u0011q%\u0005\u0002\u0005+:LG\u000fC\u0003*C\u0001\u000f!&\u0001\u0002fGB\u00111FL\u0007\u0002Y)\u0011Q&E\u0001\u000bG>t7-\u001e:sK:$\u0018BA\u0018-\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fC\u00032C\u0001\u0007!'A\u0004dQ\u0006tg.\u001a7\u0011\u0005MRT\"\u0001\u001b\u000b\u0005E*$BA\u00027\u0015\t9\u0004(A\u0003kE>\u001c8OC\u0001:\u0003\ry'oZ\u0005\u0003wQ\u0012qa\u00115b]:,G\u000eC\u0004>\u0019\t\u0007I\u0011\u0001 \u0002\u001fUt\u0017.];f\u0013\u0012\u001cu.\u001e8uKJ,\u0012a\u0010\t\u0003\u0001\"k\u0011!\u0011\u0006\u0003\u0005\u000e\u000ba!\u0019;p[&\u001c'BA\u0017E\u0015\t)e)\u0001\u0003vi&d'\"A$\u0002\t)\fg/Y\u0005\u0003\u0013\u0006\u0013Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\bBB&\rA\u0003%q(\u0001\tv]&\fX/Z%e\u0007>,h\u000e^3sA!)Q\n\u0004C\u0001\u001d\u0006A\u0012\r\u001a3sKN\u001chI]8n'>\u001c7.\u001a;BI\u0012\u0014Xm]:\u0015\r=C\u0006-\\8s!\r\u0001\u0002KU\u0005\u0003#F\u0011aa\u00149uS>t\u0007CA*W\u001b\u0005!&BA+\t\u0003\u0015\t7\r^8s\u0013\t9FKA\u0004BI\u0012\u0014Xm]:\t\u000bec\u0005\u0019\u0001.\u0002\t\u0005$GM\u001d\t\u00037zk\u0011\u0001\u0018\u0006\u0003;\u001a\u000b1A\\3u\u0013\tyFLA\u0007T_\u000e\\W\r^!eIJ,7o\u001d\u0005\u0006C2\u0003\rAY\u0001\u0011g\u000eDW-\\3JI\u0016tG/\u001b4jKJ\u0004\"a\u00196\u000f\u0005\u0011D\u0007CA3\u0012\u001b\u00051'BA4\u0018\u0003\u0019a$o\\8u}%\u0011\u0011.E\u0001\u0007!J,G-\u001a4\n\u0005-d'AB*ue&twM\u0003\u0002j#!)a\u000e\u0014a\u0001E\u0006Q1/_:uK6t\u0015-\\3\t\u000bAd\u0005\u0019A9\u0002\u0011!|7\u000f\u001e(b[\u0016\u00042\u0001\u0005)c\u0011\u0015\u0019H\n1\u0001u\u0003\u0011\u0001xN\u001d;\u0011\u0007A\u0001F\u0004C\u0003N\u0019\u0011\u0005a\u000fF\u0003PobL(\u0010C\u0003Zk\u0002\u0007!\fC\u0003bk\u0002\u0007!\rC\u0003ok\u0002\u0007!\rC\u0003qk\u0002\u0007\u0011O\u0002\u0003\u000e\u0005\u0001a8cA>\u0010{B\u0011ap`\u0007\u0002\t%\u0019\u0011\u0011\u0001\u0003\u0003\u0013Q\u0013\u0018M\\:q_J$\bBCA\u0003w\n\u0015\r\u0011\"\u0001\u0002\b\u0005A1/\u001a;uS:<7/\u0006\u0002\u0002\nA\u00191\"a\u0003\n\u0007\u00055!A\u0001\fOKR$\u0018\u0010\u0016:b]N\u0004xN\u001d;TKR$\u0018N\\4t\u0011)\t\tb\u001fB\u0001B\u0003%\u0011\u0011B\u0001\ng\u0016$H/\u001b8hg\u0002B!\"!\u0006|\u0005\u000b\u0007I\u0011AA\f\u0003\u0019\u0019\u0018p\u001d;f[V\u0011\u0011\u0011\u0004\t\u0004'\u0006m\u0011bAA\u000f)\n\u0019R\t\u001f;f]\u0012,G-Q2u_J\u001c\u0016p\u001d;f[\"Q\u0011\u0011E>\u0003\u0002\u0003\u0006I!!\u0007\u0002\u000fML8\u000f^3nA!1ac\u001fC\u0001\u0003K!b!a\n\u0002*\u0005-\u0002CA\u0006|\u0011!\t)!a\tA\u0002\u0005%\u0001\u0002CA\u000b\u0003G\u0001\r!!\u0007\t\rYYH\u0011AA\u0018)\u0019\t9#!\r\u00024!A\u0011QCA\u0017\u0001\u0004\tI\u0002\u0003\u0005\u00026\u00055\u0002\u0019AA\u001c\u0003\u0011\u0019wN\u001c4\u0011\t\u0005e\u0012qI\u0007\u0003\u0003wQA!!\u0010\u0002@\u000511m\u001c8gS\u001eTA!!\u0011\u0002D\u0005AA/\u001f9fg\u00064WM\u0003\u0002\u0002F\u0005\u00191m\\7\n\t\u0005%\u00131\b\u0002\u0007\u0007>tg-[4\t\u0013\u000553P1A\u0005\u0004\u0005=\u0013\u0001E3yK\u000e,H/[8o\u0007>tG/\u001a=u+\u0005Q\u0003bBA*w\u0002\u0006IAK\u0001\u0012Kb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004\u0003\u0002C1|\u0005\u0004%\t%a\u0016\u0016\u0003\tDq!a\u0017|A\u0003%!-A\ttG\",W.Z%eK:$\u0018NZ5fe\u0002Ba!a\u0018|\t\u0003Z\u0012aE7bq&lW/\u001c)bs2|\u0017\r\u001a\"zi\u0016\u001c\b\"CA2w\n\u0007IQBA3\u0003)I7\u000fR1uC\u001e\u0014\u0018-\\\u000b\u0003\u0003O\u00022\u0001EA5\u0013\r\tY'\u0005\u0002\b\u0005>|G.Z1o\u0011!\tyg\u001fQ\u0001\u000e\u0005\u001d\u0014aC5t\t\u0006$\u0018m\u001a:b[\u0002B1\"a\u001d|\u0001\u0004\u0005\r\u0011\"\u0003\u0002v\u0005aAn\\2bY\u0006#GM]3tgV\t!\u000bC\u0006\u0002zm\u0004\r\u00111A\u0005\n\u0005m\u0014\u0001\u00057pG\u0006d\u0017\t\u001a3sKN\u001cx\fJ3r)\r)\u0013Q\u0010\u0005\n\u0003\u007f\n9(!AA\u0002I\u000b1\u0001\u001f\u00132\u0011)\t\u0019i\u001fa\u0001\u0002\u0003\u0006KAU\u0001\u000eY>\u001c\u0017\r\\!eIJ,7o\u001d\u0011)\t\u0005\u0005\u0015q\u0011\t\u0004!\u0005%\u0015bAAF#\tAao\u001c7bi&dW\rC\u0006\u0002\u0010n\u0004\r\u00111A\u0005\n\u0005U\u0014a\u00022pk:$Gk\u001c\u0005\f\u0003'[\b\u0019!a\u0001\n\u0013\t)*A\u0006c_VtG\rV8`I\u0015\fHcA\u0013\u0002\u0018\"I\u0011qPAI\u0003\u0003\u0005\rA\u0015\u0005\u000b\u00037[\b\u0019!A!B\u0013\u0011\u0016\u0001\u00032pk:$Gk\u001c\u0011)\t\u0005e\u0015q\u0011\u0005\f\u0003C[\b\u0019!a\u0001\n\u0013\t\u0019+A\u0007tKJ4XM]\"iC:tW\r\\\u000b\u0002e!Y\u0011qU>A\u0002\u0003\u0007I\u0011BAU\u0003E\u0019XM\u001d<fe\u000eC\u0017M\u001c8fY~#S-\u001d\u000b\u0004K\u0005-\u0006\"CA@\u0003K\u000b\t\u00111\u00013\u0011)\tyk\u001fa\u0001\u0002\u0003\u0006KAM\u0001\u000fg\u0016\u0014h/\u001a:DQ\u0006tg.\u001a7!Q\u0011\ti+a\"\t\u0013\u0005U6P1A\u0005\n\u0005]\u0016a\u00017pOV\u0011\u0011\u0011\u0018\t\u0005\u0003w\u000b\t-\u0004\u0002\u0002>*\u0019\u0011q\u0018\u0005\u0002\u000b\u00154XM\u001c;\n\t\u0005\r\u0017Q\u0018\u0002\u0015\u001b\u0006\u00148.\u001a:M_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\t\u0011\u0005\u001d7\u0010)A\u0005\u0003s\u000bA\u0001\\8hA!Q\u00111Z>C\u0002\u0013\u0015!!!4\u0002%U$\u0007oQ8o]\u0016\u001cG/[8o)\u0006\u0014G.Z\u000b\u0003\u0003\u001f\u0004r!!5\u0002Tj\u000b9.D\u0001D\u0013\r\t)n\u0011\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\b\u0003BAm\u0003WtA!a7\u0002h:!\u0011Q\\As\u001d\u0011\ty.a9\u000f\u0007\u0015\f\t/C\u0001\n\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u0019\u0011\u0011\u001e\u0003\u0002#\u0005\u001b8o\\2jCRLwN\u001c%b]\u0012dW-\u0003\u0003\u0002n\u0006=(a\u0005%b]\u0012dW-\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014(bAAu\t!A\u00111_>!\u0002\u001b\ty-A\nvIB\u001cuN\u001c8fGRLwN\u001c+bE2,\u0007\u0005C\u0004\u0002xn$I!!?\u0002+\r\u0014X-\u0019;f\u000bb,7-\u001e;peN+'O^5dKR\u0011\u00111 \t\u0005\u0003#\fi0C\u0002\u0002\u0000\u000e\u0013\u0001\"\u0012=fGV$xN\u001d\u0005\n\u0005\u0007Y(\u0019!C\u0001\u0005\u000b\tAb\u00195b]:,Gn\u0012:pkB,\"Aa\u0002\u0011\t\t%!qB\u0007\u0003\u0005\u0017Q1A!\u00045\u0003\u00159'o\\;q\u0013\u0011\u0011\tBa\u0003\u0003'\u0011+g-Y;mi\u000eC\u0017M\u001c8fY\u001e\u0013x.\u001e9\t\u0011\tU1\u0010)A\u0005\u0005\u000f\tQb\u00195b]:,Gn\u0012:pkB\u0004\u0003\"\u0003B\rw\n\u0007I\u0011\u0002B\u000e\u0003Q\u0019G.[3oi\u000eC\u0017M\u001c8fY\u001a\u000b7\r^8ssV\u0011!Q\u0004\t\u0004g\t}\u0011b\u0001B\u0011i\tq1\t[1o]\u0016dg)Y2u_JL\b\u0002\u0003B\u0013w\u0002\u0006IA!\b\u0002+\rd\u0017.\u001a8u\u0007\"\fgN\\3m\r\u0006\u001cGo\u001c:zA!I!\u0011F>C\u0002\u0013%!1D\u0001\u0015g\u0016\u0014h/\u001a:DQ\u0006tg.\u001a7GC\u000e$xN]=\t\u0011\t52\u0010)A\u0005\u0005;\tQc]3sm\u0016\u00148\t[1o]\u0016dg)Y2u_JL\b\u0005C\u0004\u00032m$IAa\r\u0002\u00179,w\u000fU5qK2Lg.Z\u000b\u0003\u0005k\u00012a\rB\u001c\u0013\r\u0011I\u0004\u000e\u0002\u0017\t\u00164\u0017-\u001e7u\u0007\"\fgN\\3m!&\u0004X\r\\5oK\"I!QH>C\u0002\u0013%!qH\u0001\u001bCN\u001cxnY5bi&|g\u000eT5ti\u0016tWM\u001d)s_6L7/Z\u000b\u0003\u0005\u0003\u0002Ra\u000bB\"\u0005\u000fJ1A!\u0012-\u0005\u001d\u0001&o\\7jg\u0016\u0004BA!\u0013\u0003P9!\u00111\u001cB&\u0013\r\u0011i\u0005B\u0001\n)J\fgn\u001d9peRLAA!\u0015\u0003T\tA\u0012i]:pG&\fG/[8o\u000bZ,g\u000e\u001e'jgR,g.\u001a:\u000b\u0007\t5C\u0001\u0003\u0005\u0003Xm\u0004\u000b\u0011\u0002B!\u0003m\t7o]8dS\u0006$\u0018n\u001c8MSN$XM\\3s!J|W.[:fA!I!1L>C\u0002\u0013%!QL\u0001\u0012gNdWI\\4j]\u0016\u0004&o\u001c<jI\u0016\u0014XC\u0001B0!\u0019\u0011\tG!\u001a\u0003j5\u0011!1\r\u0006\u0003\u000b\"IAAa\u001a\u0003d\tIq\n\u001d;j_:4\u0016\r\u001c\t\u0004\u0017\t-\u0014b\u0001B7\u0005\t\t2k\u0015'F]\u001eLg.\u001a)s_ZLG-\u001a:\t\u0011\tE4\u0010)A\u0005\u0005?\n!c]:m\u000b:<\u0017N\\3Qe>4\u0018\u000eZ3sA!9!QO>\u0005\n\t]\u0014AC:tY\"\u000bg\u000e\u001a7feR!!\u0011\u0010BE!\u0011\u0011YH!\"\u000e\u0005\tu$\u0002\u0002B@\u0005\u0003\u000b1a]:m\u0015\r\u0011\u0019)N\u0001\bQ\u0006tG\r\\3s\u0013\u0011\u00119I! \u0003\u0015M\u001bH\u000eS1oI2,'\u000f\u0003\u0005\u0003\f\nM\u0004\u0019AA4\u0003!I7o\u00117jK:$\b\"\u0003BHw\n\u0007I\u0011\u0002BI\u0003U\u0019XM\u001d<feBK\u0007/\u001a7j]\u00164\u0015m\u0019;pef,\"Aa%\u0011\u0007M\u0012)*C\u0002\u0003\u0018R\u0012ac\u00115b]:,G\u000eU5qK2Lg.\u001a$bGR|'/\u001f\u0005\t\u00057[\b\u0015!\u0003\u0003\u0014\u000612/\u001a:wKJ\u0004\u0016\u000e]3mS:,g)Y2u_JL\b\u0005C\u0004\u0003 n$IA!)\u0002+\rd\u0017.\u001a8u!&\u0004X\r\\5oK\u001a\u000b7\r^8ssR!!1\u0013BR\u0011\u001d\u0011)K!(A\u0002I\u000bQB]3n_R,\u0017\t\u001a3sKN\u001c\bb\u0002BUw\u0012%!1V\u0001\u000fg\u0016$X\u000f\u001d\"p_R\u001cHO]1q+\u0011\u0011iKa-\u0015\r\t=&1\u001aBg!\u0011\u0011\tLa-\r\u0001\u0011A!Q\u0017BT\u0005\u0004\u00119LA\u0001C#\u0011\u0011ILa0\u0011\u0007A\u0011Y,C\u0002\u0003>F\u0011qAT8uQ&tw\r\u0005\u0003\u0003B\n\u001dWB\u0001Bb\u0015\r\u0011)-N\u0001\nE>|Go\u001d;sCBLAA!3\u0003D\nI!i\\8ugR\u0014\u0018\r\u001d\u0005\t\u0005\u000b\u00149\u000b1\u0001\u00030\"A!q\u001aBT\u0001\u0004\u0011\u0019*A\bqSB,G.\u001b8f\r\u0006\u001cGo\u001c:z\u0011%\u0011\u0019n\u001fb\u0001\n\u0013\u0011).\u0001\tj]\n|WO\u001c3C_>$8\u000f\u001e:baV\u0011!q\u0018\u0005\t\u00053\\\b\u0015!\u0003\u0003@\u0006\t\u0012N\u001c2pk:$'i\\8ugR\u0014\u0018\r\u001d\u0011\t\u000f\tu7\u0010\"\u0003\u0003`\u0006\tr.\u001e;c_VtGMQ8piN$(/\u00199\u0015\t\t\u0005(q\u001d\t\u0005\u0005\u0003\u0014\u0019/\u0003\u0003\u0003f\n\r'aD\"mS\u0016tGOQ8piN$(/\u00199\t\u000f\t\u0015&1\u001ca\u0001%\"9!1^>\u0005B\t5\u0018\u0001E5t%\u0016\u001c\bo\u001c8tS\ndWMR8s)\u0011\t9Ga<\t\u000f\tE(\u0011\u001ea\u0001%\u00069\u0011\r\u001a3sKN\u001c\bb\u0002B{w\u0012\u0005!q_\u0001\u0017C\u0012$'/Z:t)>\u001cvnY6fi\u0006#GM]3tgR!!\u0011`B\u0003!\u0015Y#1 B\u0000\u0013\r\u0011i\u0010\f\u0002\u0007\rV$XO]3\u0011\u0007m\u001b\t!C\u0002\u0004\u0004q\u0013\u0011#\u00138fiN{7m[3u\u0003\u0012$'/Z:t\u0011\u0019I&1\u001fa\u0001%\"91\u0011B>\u0005B\r-\u0011A\u00027jgR,g.\u0006\u0002\u0004\u000eA)1Fa?\u0004\u0010A1\u0001c!\u0005S\u0005\u0003J1aa\u0005\u0012\u0005\u0019!V\u000f\u001d7fe!A1qC>\u0005\u0002!\t)(\u0001\u0007c_VtG-\u00113ee\u0016\u001c8\u000fC\u0004\u0004\u001cm$\te!\b\u0002\u0013\u0005\u001c8o\\2jCR,G\u0003BB\u0010\u0007O\u0001Ra\u000bB~\u0007C\u00012A`B\u0012\u0013\r\u0019)\u0003\u0002\u0002\u0012\u0003N\u001cxnY5bi&|g\u000eS1oI2,\u0007b\u0002BS\u00073\u0001\rA\u0015\u0005\b\u0007WYH\u0011IB\u0017\u0003!\u0019\b.\u001e;e_^tGCAB\u0018!\u0015Y#1`A4\u0001")
public class NettyTransport
implements Transport {
    private final NettyTransportSettings settings;
    private final ExtendedActorSystem system;
    private final ExecutionContext executionContext;
    private final String schemeIdentifier;
    private final boolean akka$remote$transport$netty$NettyTransport$$isDatagram;
    private volatile Address localAddress;
    private volatile Address boundTo;
    private volatile Channel serverChannel;
    private final MarkerLoggingAdapter akka$remote$transport$netty$NettyTransport$$log;
    private final ConcurrentHashMap<SocketAddress, AssociationHandle.HandleEventListener> udpConnectionTable;
    private final DefaultChannelGroup channelGroup;
    private final ChannelFactory clientChannelFactory;
    private final ChannelFactory serverChannelFactory;
    private final Promise<Transport.AssociationEventListener> akka$remote$transport$netty$NettyTransport$$associationListenerPromise;
    private final SSLEngineProvider sslEngineProvider;
    private final ChannelPipelineFactory serverPipelineFactory;
    private final Bootstrap inboundBootstrap;

    public static Option<Address> addressFromSocketAddress(SocketAddress socketAddress, String string, String string2, Option<String> option) {
        return NettyTransport$.MODULE$.addressFromSocketAddress(socketAddress, string, string2, option);
    }

    public static Option<Address> addressFromSocketAddress(SocketAddress socketAddress, String string, String string2, Option<String> option, Option<Object> option2) {
        return NettyTransport$.MODULE$.addressFromSocketAddress(socketAddress, string, string2, option, option2);
    }

    public static AtomicInteger uniqueIdCounter() {
        return NettyTransport$.MODULE$.uniqueIdCounter();
    }

    public static void gracefulClose(Channel channel, ExecutionContext executionContext) {
        NettyTransport$.MODULE$.gracefulClose(channel, executionContext);
    }

    public static int FrameLengthFieldLength() {
        return NettyTransport$.MODULE$.FrameLengthFieldLength();
    }

    @Override
    public Future<Object> managementCommand(Object cmd) {
        return Transport.managementCommand$(this, cmd);
    }

    public NettyTransportSettings settings() {
        return this.settings;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public String schemeIdentifier() {
        return this.schemeIdentifier;
    }

    @Override
    public int maximumPayloadBytes() {
        return this.settings().MaxFrameSize();
    }

    public final boolean akka$remote$transport$netty$NettyTransport$$isDatagram() {
        return this.akka$remote$transport$netty$NettyTransport$$isDatagram;
    }

    private Address localAddress() {
        return this.localAddress;
    }

    private void localAddress_$eq(Address x$1) {
        this.localAddress = x$1;
    }

    private Address boundTo() {
        return this.boundTo;
    }

    private void boundTo_$eq(Address x$1) {
        this.boundTo = x$1;
    }

    private Channel serverChannel() {
        return this.serverChannel;
    }

    private void serverChannel_$eq(Channel x$1) {
        this.serverChannel = x$1;
    }

    public MarkerLoggingAdapter akka$remote$transport$netty$NettyTransport$$log() {
        return this.akka$remote$transport$netty$NettyTransport$$log;
    }

    public final ConcurrentHashMap<SocketAddress, AssociationHandle.HandleEventListener> udpConnectionTable() {
        return this.udpConnectionTable;
    }

    private Executor createExecutorService() {
        Dispatchers dispatchers = this.system().dispatchers();
        return (Executor)this.settings().UseDispatcherForIo().map((Function1 & Serializable & scala.Serializable)id -> dispatchers.lookup(id)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Executors.newCachedThreadPool(this.system().threadFactory()));
    }

    public DefaultChannelGroup channelGroup() {
        return this.channelGroup;
    }

    private ChannelFactory clientChannelFactory() {
        return this.clientChannelFactory;
    }

    private ChannelFactory serverChannelFactory() {
        return this.serverChannelFactory;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultChannelPipeline akka$remote$transport$netty$NettyTransport$$newPipeline() {
        void var1_1;
        block0: {
            DefaultChannelPipeline pipeline = new DefaultChannelPipeline();
            if (this.akka$remote$transport$netty$NettyTransport$$isDatagram()) break block0;
            pipeline.addLast("FrameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(this.maximumPayloadBytes(), 0, NettyTransport$.MODULE$.FrameLengthFieldLength(), 0, NettyTransport$.MODULE$.FrameLengthFieldLength(), true));
            pipeline.addLast("FrameEncoder", (ChannelHandler)new LengthFieldPrepender(NettyTransport$.MODULE$.FrameLengthFieldLength()));
        }
        return var1_1;
    }

    public Promise<Transport.AssociationEventListener> akka$remote$transport$netty$NettyTransport$$associationListenerPromise() {
        return this.akka$remote$transport$netty$NettyTransport$$associationListenerPromise;
    }

    private SSLEngineProvider sslEngineProvider() {
        return this.sslEngineProvider;
    }

    public SslHandler akka$remote$transport$netty$NettyTransport$$sslHandler(boolean isClient) {
        SSLEngineProvider sSLEngineProvider = this.sslEngineProvider();
        SSLEngineProvider sSLEngineProvider2 = (SSLEngineProvider)OptionVal.Some$.MODULE$.unapply((Object)sSLEngineProvider);
        if (OptionVal$.MODULE$.isEmpty$extension((Object)sSLEngineProvider2)) {
            OptionVal$.MODULE$.None();
            SSLEngineProvider sSLEngineProvider3 = sSLEngineProvider;
            if (!(null != null ? !((Object)null).equals(sSLEngineProvider3) : sSLEngineProvider3 != null)) {
                throw new IllegalStateException("Expected enable-ssl=on");
            }
            throw new MatchError((Object)new OptionVal((Object)sSLEngineProvider));
        }
        SSLEngineProvider sslProvider = (SSLEngineProvider)OptionVal$.MODULE$.get$extension((Object)sSLEngineProvider2);
        SslHandler handler = NettySSLSupport$.MODULE$.apply(sslProvider, isClient);
        handler.setCloseOnSSLException(true);
        SslHandler sslHandler = handler;
        return sslHandler;
    }

    private ChannelPipelineFactory serverPipelineFactory() {
        return this.serverPipelineFactory;
    }

    private ChannelPipelineFactory clientPipelineFactory(Address remoteAddress) {
        return new ChannelPipelineFactory(this, remoteAddress){
            private final /* synthetic */ NettyTransport $outer;
            private final Address remoteAddress$1;

            /*
             * WARNING - void declaration
             */
            public ChannelPipeline getPipeline() {
                void var1_1;
                DefaultChannelPipeline pipeline = this.$outer.akka$remote$transport$netty$NettyTransport$$newPipeline();
                if (this.$outer.settings().EnableSsl()) {
                    pipeline.addFirst("SslHandler", (ChannelHandler)this.$outer.akka$remote$transport$netty$NettyTransport$$sslHandler(true));
                }
                ClientHandler handler = this.$outer.akka$remote$transport$netty$NettyTransport$$isDatagram() ? new UdpClientHandler(this.$outer, this.remoteAddress$1) : new TcpClientHandler(this.$outer, this.remoteAddress$1, (LoggingAdapter)this.$outer.akka$remote$transport$netty$NettyTransport$$log());
                pipeline.addLast("clienthandler", (ChannelHandler)handler);
                return var1_1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.remoteAddress$1 = remoteAddress$1;
            }
        };
    }

    private <B extends Bootstrap> B setupBootstrap(B bootstrap, ChannelPipelineFactory pipelineFactory) {
        bootstrap.setPipelineFactory(pipelineFactory);
        bootstrap.setOption("backlog", (Object)BoxesRunTime.boxToInteger((int)this.settings().Backlog()));
        bootstrap.setOption("child.tcpNoDelay", (Object)BoxesRunTime.boxToBoolean((boolean)this.settings().TcpNodelay()));
        bootstrap.setOption("child.keepAlive", (Object)BoxesRunTime.boxToBoolean((boolean)this.settings().TcpKeepalive()));
        bootstrap.setOption("reuseAddress", (Object)BoxesRunTime.boxToBoolean((boolean)this.settings().TcpReuseAddr()));
        if (this.akka$remote$transport$netty$NettyTransport$$isDatagram()) {
            bootstrap.setOption("receiveBufferSizePredictorFactory", (Object)new FixedReceiveBufferSizePredictorFactory(BoxesRunTime.unboxToInt((Object)this.settings().ReceiveBufferSize().get())));
        }
        this.settings().ReceiveBufferSize().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sz -> bootstrap.setOption("receiveBufferSize", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().SendBufferSize().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sz -> bootstrap.setOption("sendBufferSize", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().WriteBufferHighWaterMark().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sz -> bootstrap.setOption("writeBufferHighWaterMark", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().WriteBufferLowWaterMark().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sz -> bootstrap.setOption("writeBufferLowWaterMark", (Object)BoxesRunTime.boxToInteger((int)sz)));
        return bootstrap;
    }

    private Bootstrap inboundBootstrap() {
        return this.inboundBootstrap;
    }

    /*
     * WARNING - void declaration
     */
    private ClientBootstrap outboundBootstrap(Address remoteAddress) {
        void var2_2;
        ClientBootstrap bootstrap = this.setupBootstrap(new ClientBootstrap(this.clientChannelFactory()), this.clientPipelineFactory(remoteAddress));
        bootstrap.setOption("connectTimeoutMillis", (Object)BoxesRunTime.boxToLong((long)this.settings().ConnectionTimeout().toMillis()));
        bootstrap.setOption("tcpNoDelay", (Object)BoxesRunTime.boxToBoolean((boolean)this.settings().TcpNodelay()));
        bootstrap.setOption("keepAlive", (Object)BoxesRunTime.boxToBoolean((boolean)this.settings().TcpKeepalive()));
        this.settings().ReceiveBufferSize().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sz -> bootstrap.setOption("receiveBufferSize", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().SendBufferSize().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sz -> bootstrap.setOption("sendBufferSize", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().WriteBufferHighWaterMark().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sz -> bootstrap.setOption("writeBufferHighWaterMark", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().WriteBufferLowWaterMark().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sz -> bootstrap.setOption("writeBufferLowWaterMark", (Object)BoxesRunTime.boxToInteger((int)sz)));
        return var2_2;
    }

    @Override
    public boolean isResponsibleFor(Address address) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Future<InetSocketAddress> addressToSocketAddress(Address addr) {
        Address address = addr;
        if (address == null) return Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringBuilder(53).append("Address [").append(addr).append("] does not contain host or port information.").toString()));
        Option option = address.host();
        Option option2 = address.port();
        if (!(option instanceof Some)) return Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringBuilder(53).append("Address [").append(addr).append("] does not contain host or port information.").toString()));
        Some some = (Some)option;
        String host = (String)some.value();
        if (!(option2 instanceof Some)) return Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringBuilder(53).append("Address [").append(addr).append("] does not contain host or port information.").toString()));
        Some some2 = (Some)option2;
        int port = BoxesRunTime.unboxToInt((Object)some2.value());
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (InetSocketAddress)package$.MODULE$.blocking((Function0 & Serializable & scala.Serializable)() -> new InetSocketAddress(InetAddress.getByName(host), port)), this.executionContext());
    }

    @Override
    public Future<Tuple2<Address, Promise<Transport.AssociationEventListener>>> listen() {
        return this.addressToSocketAddress(Address$.MODULE$.apply("", "", this.settings().BindHostname(), this.settings().BindPortSelector())).map((Function1 & Serializable & scala.Serializable)address -> {
            Tuple2 tuple2;
            try {
                Address address2;
                Channel channel;
                Bootstrap bootstrap = this.inboundBootstrap();
                if (bootstrap instanceof ServerBootstrap) {
                    ServerBootstrap serverBootstrap = (ServerBootstrap)bootstrap;
                    channel = serverBootstrap.bind((SocketAddress)address);
                } else if (bootstrap instanceof ConnectionlessBootstrap) {
                    ConnectionlessBootstrap connectionlessBootstrap = (ConnectionlessBootstrap)bootstrap;
                    channel = connectionlessBootstrap.bind((SocketAddress)address);
                } else {
                    throw new MatchError((Object)bootstrap);
                }
                Channel newServerChannel = channel;
                newServerChannel.setReadable(false);
                this.channelGroup().add(newServerChannel);
                this.serverChannel_$eq(newServerChannel);
                Option<Address> option = NettyTransport$.MODULE$.addressFromSocketAddress(newServerChannel.getLocalAddress(), this.schemeIdentifier(), this.system().name(), (Option<String>)new Some((Object)this.settings().Hostname()), (Option<Object>)(this.settings().PortSelector() == 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)this.settings().PortSelector()))));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    address2 = (Address)some.value();
                    Option<Address> option2 = NettyTransport$.MODULE$.addressFromSocketAddress(newServerChannel.getLocalAddress(), this.schemeIdentifier(), this.system().name(), (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$);
                    if (!(option2 instanceof Some)) {
                        if (None$.MODULE$.equals(option2)) {
                            throw new NettyTransportException(new StringBuilder(29).append("Unknown local address type [").append(newServerChannel.getLocalAddress().getClass().getName()).append("]").toString());
                        }
                        throw new MatchError(option2);
                    }
                    Some some2 = (Some)option2;
                    Address address3 = (Address)some2.value();
                    this.boundTo_$eq(address3);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (None$.MODULE$.equals(option)) {
                        throw new NettyTransportException(new StringBuilder(29).append("Unknown local address type [").append(newServerChannel.getLocalAddress().getClass().getName()).append("]").toString());
                    }
                    throw new MatchError(option);
                }
                this.localAddress_$eq(address2);
                this.akka$remote$transport$netty$NettyTransport$$associationListenerPromise().future().foreach((Function1 & Serializable & scala.Serializable)x$4 -> newServerChannel.setReadable(true), this.executionContext());
                Tuple2 tuple22 = new Tuple2((Object)address2, this.akka$remote$transport$netty$NettyTransport$$associationListenerPromise());
                tuple2 = tuple22;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit;
                    Throwable e = (Throwable)option.get();
                    this.akka$remote$transport$netty$NettyTransport$$log().error("failed to bind to {}, shutting down Netty transport", address);
                    try {
                        boxedUnit = this.shutdown();
                    }
                    catch (Throwable throwable3) {
                        Throwable throwable4 = throwable3;
                        Option option3 = NonFatal$.MODULE$.unapply(throwable4);
                        if (option3.isEmpty()) {
                            throw throwable3;
                        }
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        boxedUnit = boxedUnit2;
                    }
                    throw e;
                }
                throw throwable;
            }
            return tuple2;
        }, this.executionContext());
    }

    public Address boundAddress() {
        return this.boundTo();
    }

    @Override
    public Future<AssociationHandle> associate(Address remoteAddress) {
        Future future;
        if (!this.serverChannel().isBound()) {
            future = Future$.MODULE$.failed((Throwable)new NettyTransportException("Transport is not bound"));
        } else {
            ClientBootstrap bootstrap = this.outboundBootstrap(remoteAddress);
            future = this.addressToSocketAddress(remoteAddress).flatMap((Function1 & Serializable & scala.Serializable)socketAddress -> NettyFutureBridge$.MODULE$.apply(bootstrap.connect((SocketAddress)socketAddress)).map((Function1 & Serializable & scala.Serializable)channel -> {
                Object object = this.settings().EnableSsl() ? package$.MODULE$.blocking((Function0 & Serializable & scala.Serializable)() -> ((SslHandler)channel.getPipeline().get(SslHandler.class)).handshake().awaitUninterruptibly()) : BoxedUnit.UNIT;
                Object object2 = !this.akka$remote$transport$netty$NettyTransport$$isDatagram() ? channel.setReadable(false) : BoxedUnit.UNIT;
                return channel;
            }, this.executionContext()).flatMap((Function1 & Serializable & scala.Serializable)readyChannel -> (this.akka$remote$transport$netty$NettyTransport$$isDatagram() ? Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                SocketAddress socketAddress = readyChannel.getRemoteAddress();
                if (!(socketAddress instanceof InetSocketAddress)) {
                    throw new NettyTransportException(new StringBuilder(39).append("Unknown outbound remote address type [").append(socketAddress.getClass().getName()).append("]").toString());
                }
                InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
                UdpAssociationHandle handle = new UdpAssociationHandle(this.localAddress(), remoteAddress, (Channel)readyChannel, this);
                handle.readHandlerPromise().future().foreach((Function1 & Serializable & scala.Serializable)listener -> this.udpConnectionTable().put(inetSocketAddress, (AssociationHandle.HandleEventListener)listener), this.executionContext());
                UdpAssociationHandle udpAssociationHandle = handle;
                return udpAssociationHandle;
            }, this.executionContext()) : ((ClientHandler)readyChannel.getPipeline().get(ClientHandler.class)).statusFuture()).map((Function1 & Serializable & scala.Serializable)handle -> handle, this.executionContext()), this.executionContext()), this.executionContext()).recover((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                    A1 A1 = x4;
                    if (A1 instanceof CancellationException) {
                        throw new NettyTransportExceptionNoStack("Connection was cancelled");
                    }
                    Option option = NonFatal$.MODULE$.unapply(A1);
                    if (!option.isEmpty()) {
                        Throwable t = (Throwable)option.get();
                        String msg = t.getCause() == null ? t.getMessage() : (t.getCause().getCause() == null ? new StringBuilder(13).append(t.getMessage()).append(", caused by: ").append(t.getCause()).toString() : new StringBuilder(26).append(t.getMessage()).append(", caused by: ").append(t.getCause()).append(", caused by: ").append(t.getCause().getCause()).toString());
                        throw new NettyTransportExceptionNoStack(new StringBuilder(2).append(t.getClass().getName()).append(": ").append(msg).toString(), t.getCause());
                    }
                    Object object = function1.apply(x4);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x4) {
                    Option option;
                    Throwable throwable = x4;
                    boolean bl = throwable instanceof CancellationException ? true : !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty();
                    return bl;
                }
            }, this.executionContext());
        }
        return future;
    }

    @Override
    public Future<Object> shutdown() {
        return this.always$2(this.channelGroup().unbind()).flatMap((Function1 & Serializable & scala.Serializable)unbindStatus -> NettyTransport.$anonfun$shutdown$2(this, BoxesRunTime.unboxToBoolean((Object)unbindStatus)), this.executionContext());
    }

    public static final /* synthetic */ boolean $anonfun$shutdown$1(ChannelGroup x$5) {
        return true;
    }

    private final Future always$2(ChannelGroupFuture c) {
        return NettyFutureBridge$.MODULE$.apply(c).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)NettyTransport.$anonfun$shutdown$1(x$5)), this.executionContext()).recover((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                A1 A1 = x5;
                Boolean bl = BoxesRunTime.boxToBoolean((boolean)false);
                return (B1)bl;
            }

            public final boolean isDefinedAt(Throwable x5) {
                Throwable throwable = x5;
                boolean bl = true;
                return bl;
            }
        }, this.executionContext());
    }

    public static final /* synthetic */ boolean $anonfun$shutdown$5(NettyTransport $this, boolean unbindStatus$1, boolean lastWriteStatus$1, boolean disconnectStatus$1, boolean closeStatus) {
        if ($this.settings().UseDispatcherForIo().isDefined()) {
            $this.clientChannelFactory().shutdown();
            $this.serverChannelFactory().shutdown();
        } else {
            $this.clientChannelFactory().releaseExternalResources();
            $this.serverChannelFactory().releaseExternalResources();
        }
        return lastWriteStatus$1 && unbindStatus$1 && disconnectStatus$1 && closeStatus;
    }

    public static final /* synthetic */ Future $anonfun$shutdown$4(NettyTransport $this, boolean unbindStatus$1, boolean lastWriteStatus$1, boolean disconnectStatus) {
        return $this.always$2($this.channelGroup().close()).map((Function1 & Serializable & scala.Serializable)closeStatus -> BoxesRunTime.boxToBoolean((boolean)NettyTransport.$anonfun$shutdown$5($this, unbindStatus$1, lastWriteStatus$1, disconnectStatus, BoxesRunTime.unboxToBoolean((Object)closeStatus))), $this.executionContext());
    }

    public static final /* synthetic */ Future $anonfun$shutdown$3(NettyTransport $this, boolean unbindStatus$1, boolean lastWriteStatus) {
        return $this.always$2($this.channelGroup().disconnect()).flatMap((Function1 & Serializable & scala.Serializable)disconnectStatus -> NettyTransport.$anonfun$shutdown$4($this, unbindStatus$1, lastWriteStatus, BoxesRunTime.unboxToBoolean((Object)disconnectStatus)), $this.executionContext());
    }

    public static final /* synthetic */ Future $anonfun$shutdown$2(NettyTransport $this, boolean unbindStatus) {
        return $this.always$2($this.channelGroup().write((Object)ChannelBuffers.buffer((int)0))).flatMap((Function1 & Serializable & scala.Serializable)lastWriteStatus -> NettyTransport.$anonfun$shutdown$3($this, unbindStatus, BoxesRunTime.unboxToBoolean((Object)lastWriteStatus)), $this.executionContext());
    }

    public NettyTransport(NettyTransportSettings settings, ExtendedActorSystem system) {
        ServerBootstrap serverBootstrap;
        SSLEngineProvider sSLEngineProvider;
        NioDatagramChannelFactory nioDatagramChannelFactory;
        NioDatagramChannelFactory nioDatagramChannelFactory2;
        this.settings = settings;
        this.system = system;
        Transport.$init$(this);
        Dispatchers dispatchers = system.dispatchers();
        this.executionContext = (ExecutionContext)settings.UseDispatcherForIo().orElse((Function0 & Serializable & scala.Serializable)() -> {
            String string = ((RARP)RARP$.MODULE$.apply((ActorSystem)this.system())).provider().remoteSettings().Dispatcher();
            Object object = "".equals(string) ? None$.MODULE$ : new Some((Object)string);
            return object;
        }).map((Function1 & Serializable & scala.Serializable)id -> dispatchers.lookup(id)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.system().dispatcher());
        this.schemeIdentifier = new StringBuilder(0).append(settings.EnableSsl() ? "ssl." : "").append(settings.TransportMode()).toString();
        NettyTransportSettings.Mode mode = settings.TransportMode();
        NettyTransportSettings$Udp$ nettyTransportSettings$Udp$ = NettyTransportSettings$Udp$.MODULE$;
        this.akka$remote$transport$netty$NettyTransport$$isDatagram = !(mode != null ? !mode.equals(nettyTransportSettings$Udp$) : nettyTransportSettings$Udp$ != null);
        this.akka$remote$transport$netty$NettyTransport$$log = Logging$.MODULE$.withMarker((ActorSystem)system, this.getClass(), LogSource$.MODULE$.fromAnyClass());
        this.udpConnectionTable = new ConcurrentHashMap();
        this.channelGroup = new DefaultChannelGroup(new StringBuilder(41).append("akka-netty-transport-driver-channelgroup-").append(NettyTransport$.MODULE$.uniqueIdCounter().getAndIncrement()).toString());
        NettyTransportSettings.Mode mode2 = settings.TransportMode();
        if (NettyTransportSettings$Tcp$.MODULE$.equals(mode2)) {
            Executor boss = this.createExecutorService();
            Executor worker = this.createExecutorService();
            nioDatagramChannelFactory2 = new NioClientSocketChannelFactory(boss, 1, (WorkerPool)new NioWorkerPool(worker, settings.ClientSocketWorkerPoolSize()), (Timer)new HashedWheelTimer(system.threadFactory()));
        } else if (NettyTransportSettings$Udp$.MODULE$.equals(mode2)) {
            nioDatagramChannelFactory2 = new NioDatagramChannelFactory(this.createExecutorService(), settings.ClientSocketWorkerPoolSize());
        } else {
            throw new MatchError((Object)mode2);
        }
        this.clientChannelFactory = nioDatagramChannelFactory2;
        NettyTransportSettings.Mode mode3 = settings.TransportMode();
        if (NettyTransportSettings$Tcp$.MODULE$.equals(mode3)) {
            Executor boss = this.createExecutorService();
            Executor worker = this.createExecutorService();
            nioDatagramChannelFactory = new NioServerSocketChannelFactory(boss, worker, settings.ServerSocketWorkerPoolSize());
        } else if (NettyTransportSettings$Udp$.MODULE$.equals(mode3)) {
            nioDatagramChannelFactory = new NioDatagramChannelFactory(this.createExecutorService(), settings.ServerSocketWorkerPoolSize());
        } else {
            throw new MatchError((Object)mode3);
        }
        this.serverChannelFactory = nioDatagramChannelFactory;
        this.akka$remote$transport$netty$NettyTransport$$associationListenerPromise = Promise$.MODULE$.apply();
        if (settings.EnableSsl()) {
            sSLEngineProvider = (SSLEngineProvider)OptionVal.Some$.MODULE$.apply(system.dynamicAccess().createInstanceFor(settings.SSLEngineProviderClassName(), (scala.collection.immutable.Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2(ActorSystem.class, (Object)system)})), ClassTag$.MODULE$.apply(SSLEngineProvider.class)).recover((PartialFunction)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NettyTransport $outer;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    A1 A1 = x3;
                    throw new ConfigurationException(new StringBuilder(37).append("Could not create SSLEngineProvider [").append(this.$outer.settings().SSLEngineProviderClassName()).append("]").toString(), A1);
                }

                public final boolean isDefinedAt(Throwable x3) {
                    Throwable throwable = x3;
                    boolean bl = true;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }).get());
        } else {
            OptionVal$.MODULE$.None();
            sSLEngineProvider = null;
        }
        this.sslEngineProvider = sSLEngineProvider;
        this.serverPipelineFactory = new ChannelPipelineFactory(this){
            private final /* synthetic */ NettyTransport $outer;

            /*
             * WARNING - void declaration
             */
            public ChannelPipeline getPipeline() {
                void var1_1;
                DefaultChannelPipeline pipeline = this.$outer.akka$remote$transport$netty$NettyTransport$$newPipeline();
                if (this.$outer.settings().EnableSsl()) {
                    pipeline.addFirst("SslHandler", (ChannelHandler)this.$outer.akka$remote$transport$netty$NettyTransport$$sslHandler(false));
                }
                ServerHandler handler = this.$outer.akka$remote$transport$netty$NettyTransport$$isDatagram() ? new UdpServerHandler(this.$outer, (Future<Transport.AssociationEventListener>)this.$outer.akka$remote$transport$netty$NettyTransport$$associationListenerPromise().future()) : new TcpServerHandler(this.$outer, (Future<Transport.AssociationEventListener>)this.$outer.akka$remote$transport$netty$NettyTransport$$associationListenerPromise().future(), (LoggingAdapter)this.$outer.akka$remote$transport$netty$NettyTransport$$log());
                pipeline.addLast("ServerHandler", (ChannelHandler)handler);
                return var1_1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        NettyTransportSettings.Mode mode4 = settings.TransportMode();
        if (NettyTransportSettings$Tcp$.MODULE$.equals(mode4)) {
            serverBootstrap = this.setupBootstrap(new ServerBootstrap(this.serverChannelFactory()), this.serverPipelineFactory());
        } else if (NettyTransportSettings$Udp$.MODULE$.equals(mode4)) {
            serverBootstrap = this.setupBootstrap(new ConnectionlessBootstrap(this.serverChannelFactory()), this.serverPipelineFactory());
        } else {
            throw new MatchError((Object)mode4);
        }
        this.inboundBootstrap = serverBootstrap;
    }

    public NettyTransport(ExtendedActorSystem system, Config conf) {
        this(new NettyTransportSettings(conf), system);
    }
}

