/*
 * Decompiled with CFR 0.152.
 */
package akka.remote;

import akka.event.EventStream;
import akka.event.Logging;
import akka.event.SubchannelClassification;
import akka.remote.FailureDetector;
import akka.remote.FailureDetector$;
import akka.remote.HeartbeatHistory;
import akka.remote.HeartbeatHistory$;
import akka.remote.PhiAccrualFailureDetector$State$;
import akka.util.Helpers;
import akka.util.Helpers$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t5e\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0004\u00155j\u0003\u000e\u001c'/^1m\r\u0006LG.\u001e:f\t\u0016$Xm\u0019;pe*\u00111\u0001B\u0001\u0007e\u0016lw\u000e^3\u000b\u0003\u0015\tA!Y6lC\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\t\u000e\u0003\tI!!\u0005\u0002\u0003\u001f\u0019\u000b\u0017\u000e\\;sK\u0012+G/Z2u_JD\u0001b\u0005\u0001\u0003\u0006\u0004%\t\u0001F\u0001\ni\"\u0014Xm\u001d5pY\u0012,\u0012!\u0006\t\u0003\u0013YI!a\u0006\u0006\u0003\r\u0011{WO\u00197f\u0011!I\u0002A!A!\u0002\u0013)\u0012A\u0003;ie\u0016\u001c\bn\u001c7eA!A1\u0004\u0001BC\u0002\u0013\u0005A$A\u0007nCb\u001c\u0016-\u001c9mKNK'0Z\u000b\u0002;A\u0011\u0011BH\u0005\u0003?)\u00111!\u00138u\u0011!\t\u0003A!A!\u0002\u0013i\u0012AD7bqN\u000bW\u000e\u001d7f'&TX\r\t\u0005\tG\u0001\u0011)\u0019!C\u0001I\u0005yQ.\u001b8Ti\u0012$UM^5bi&|g.F\u0001&!\t13&D\u0001(\u0015\tA\u0013&\u0001\u0005ekJ\fG/[8o\u0015\tQ#\"\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001L\u0014\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\"Aa\u0006\u0001B\u0001B\u0003%Q%\u0001\tnS:\u001cF\u000f\u001a#fm&\fG/[8oA!A\u0001\u0007\u0001BC\u0002\u0013\u0005A%\u0001\rbG\u000e,\u0007\u000f^1cY\u0016DU-\u0019:uE\u0016\fG\u000fU1vg\u0016D\u0001B\r\u0001\u0003\u0002\u0003\u0006I!J\u0001\u001aC\u000e\u001cW\r\u001d;bE2,\u0007*Z1si\n,\u0017\r\u001e)bkN,\u0007\u0005\u0003\u00055\u0001\t\u0015\r\u0011\"\u0001%\u0003Y1\u0017N]:u\u0011\u0016\f'\u000f\u001e2fCR,5\u000f^5nCR,\u0007\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002/\u0019L'o\u001d;IK\u0006\u0014HOY3bi\u0016\u001bH/[7bi\u0016\u0004\u0003\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\u0002\u0017\u00154XM\u001c;TiJ,\u0017-\u001c\t\u0004\u0013ib\u0014BA\u001e\u000b\u0005\u0019y\u0005\u000f^5p]B\u0011Q\bQ\u0007\u0002})\u0011q\bB\u0001\u0006KZ,g\u000e^\u0005\u0003\u0003z\u00121\"\u0012<f]R\u001cFO]3b[\"A1\t\u0001B\u0001B\u0003-A)A\u0003dY>\u001c7\u000e\u0005\u0002F\u001f:\u0011a)\u0014\b\u0003\u000f2s!\u0001S&\u000e\u0003%S!A\u0013\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0011BA\u0002\u0005\u0013\tq%!A\bGC&dWO]3EKR,7\r^8s\u0013\t\u0001\u0016KA\u0003DY>\u001c7N\u0003\u0002O\u0005!)1\u000b\u0001C\u0001)\u00061A(\u001b8jiz\"r!\u0016-Z5ncV\f\u0006\u0002W/B\u0011q\u0002\u0001\u0005\u0006\u0007J\u0003\u001d\u0001\u0012\u0005\u0006'I\u0003\r!\u0006\u0005\u00067I\u0003\r!\b\u0005\u0006GI\u0003\r!\n\u0005\u0006aI\u0003\r!\n\u0005\u0006iI\u0003\r!\n\u0005\u0006qI\u0003\r!\u000f\u0005\u0006'\u0002!\ta\u0018\u000b\u0007A\n\u001cG-\u001a4\u0015\u0005Y\u000b\u0007\"B\"_\u0001\b!\u0005\"B\n_\u0001\u0004)\u0002\"B\u000e_\u0001\u0004i\u0002\"B\u0012_\u0001\u0004)\u0003\"\u0002\u0019_\u0001\u0004)\u0003\"\u0002\u001b_\u0001\u0004)\u0003\"B*\u0001\t\u0003AGc\u0001,ji\")!n\u001aa\u0001W\u000611m\u001c8gS\u001e\u0004\"\u0001\u001c:\u000e\u00035T!A\u001b8\u000b\u0005=\u0004\u0018\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003E\f1aY8n\u0013\t\u0019XN\u0001\u0004D_:4\u0017n\u001a\u0005\u0006k\u001e\u0004\r\u0001P\u0001\u0003KZDqa\u001e\u0001C\u0002\u0013%\u00010\u0001\bgSJ\u001cH\u000fS3beR\u0014W-\u0019;\u0016\u0003e\u0004\"a\u0004>\n\u0005m\u0014!\u0001\u0005%fCJ$(-Z1u\u0011&\u001cHo\u001c:z\u0011\u0019i\b\u0001)A\u0005s\u0006ya-\u001b:ti\"+\u0017M\u001d;cK\u0006$\b\u0005\u0003\u0005\u0000\u0001\t\u0007I\u0011BA\u0001\u0003y\t7mY3qi\u0006\u0014G.\u001a%fCJ$(-Z1u!\u0006,8/Z'jY2L7/\u0006\u0002\u0002\u0004A\u0019\u0011\"!\u0002\n\u0007\u0005\u001d!B\u0001\u0003M_:<\u0007\u0002CA\u0006\u0001\u0001\u0006I!a\u0001\u0002?\u0005\u001c7-\u001a9uC\ndW\rS3beR\u0014W-\u0019;QCV\u001cX-T5mY&\u001c\b\u0005\u0003\u0006\u0002\u0010\u0001\u0001\r\u0011\"\u0001\u0005\u0003#\tq!\u00193ee\u0016\u001c8/\u0006\u0002\u0002\u0014A!\u0011QCA\u000f\u001d\u0011\t9\"!\u0007\u0011\u0005!S\u0011bAA\u000e\u0015\u00051\u0001K]3eK\u001aLA!a\b\u0002\"\t11\u000b\u001e:j]\u001eT1!a\u0007\u000b\u0011)\t)\u0003\u0001a\u0001\n\u0003!\u0011qE\u0001\fC\u0012$'/Z:t?\u0012*\u0017\u000f\u0006\u0003\u0002*\u0005=\u0002cA\u0005\u0002,%\u0019\u0011Q\u0006\u0006\u0003\tUs\u0017\u000e\u001e\u0005\u000b\u0003c\t\u0019#!AA\u0002\u0005M\u0011a\u0001=%c!A\u0011Q\u0007\u0001!B\u0013\t\u0019\"\u0001\u0005bI\u0012\u0014Xm]:!\r\u0019\tI\u0004\u0001$\u0002<\t)1\u000b^1uKN9\u0011q\u0007\u0005\u0002>\u0005\r\u0003cA\u0005\u0002@%\u0019\u0011\u0011\t\u0006\u0003\u000fA\u0013x\u000eZ;diB\u0019\u0011\"!\u0012\n\u0007\u0005\u001d#B\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0006\u0002L\u0005]\"Q3A\u0005\u0002a\fq\u0001[5ti>\u0014\u0018\u0010\u0003\u0006\u0002P\u0005]\"\u0011#Q\u0001\ne\f\u0001\u0002[5ti>\u0014\u0018\u0010\t\u0005\f\u0003'\n9D!f\u0001\n\u0003\t)&A\u0005uS6,7\u000f^1naV\u0011\u0011q\u000b\t\u0005\u0013i\n\u0019\u0001C\u0006\u0002\\\u0005]\"\u0011#Q\u0001\n\u0005]\u0013A\u0003;j[\u0016\u001cH/Y7qA!91+a\u000e\u0005\u0002\u0005}CCBA1\u0003K\n9\u0007\u0005\u0003\u0002d\u0005]R\"\u0001\u0001\t\u000f\u0005-\u0013Q\fa\u0001s\"A\u00111KA/\u0001\u0004\t9\u0006\u0003\u0006\u0002l\u0005]\u0012\u0011!C\u0001\u0003[\nAaY8qsR1\u0011\u0011MA8\u0003cB\u0011\"a\u0013\u0002jA\u0005\t\u0019A=\t\u0015\u0005M\u0013\u0011\u000eI\u0001\u0002\u0004\t9\u0006\u0003\u0006\u0002v\u0005]\u0012\u0013!C\u0001\u0003o\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002z)\u001a\u00110a\u001f,\u0005\u0005u\u0004\u0003BA@\u0003\u0013k!!!!\u000b\t\u0005\r\u0015QQ\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\"\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0017\u000b\tIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!\"a$\u00028E\u0005I\u0011AAI\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a%+\t\u0005]\u00131\u0010\u0005\u000b\u0003/\u000b9$!A\u0005B\u0005e\u0015!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u001cB!\u0011QTAT\u001b\t\tyJ\u0003\u0003\u0002\"\u0006\r\u0016\u0001\u00027b]\u001eT!!!*\u0002\t)\fg/Y\u0005\u0005\u0003?\ty\nC\u0005\u0002,\u0006]\u0012\u0011!C\u00019\u0005a\u0001O]8ek\u000e$\u0018I]5us\"Q\u0011qVA\u001c\u0003\u0003%\t!!-\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111WA]!\rI\u0011QW\u0005\u0004\u0003oS!aA!os\"I\u0011\u0011GAW\u0003\u0003\u0005\r!\b\u0005\u000b\u0003{\u000b9$!A\u0005B\u0005}\u0016a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u0005\u0007CBAb\u0003\u0013\f\u0019,\u0004\u0002\u0002F*\u0019\u0011q\u0019\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002L\u0006\u0015'\u0001C%uKJ\fGo\u001c:\t\u0015\u0005=\u0017qGA\u0001\n\u0003\t\t.\u0001\u0005dC:,\u0015/^1m)\u0011\t\u0019.!7\u0011\u0007%\t).C\u0002\u0002X*\u0011qAQ8pY\u0016\fg\u000e\u0003\u0006\u00022\u00055\u0017\u0011!a\u0001\u0003gC!\"!8\u00028\u0005\u0005I\u0011IAp\u0003!A\u0017m\u001d5D_\u0012,G#A\u000f\t\u0015\u0005\r\u0018qGA\u0001\n\u0003\n)/\u0001\u0005u_N#(/\u001b8h)\t\tY\n\u0003\u0006\u0002j\u0006]\u0012\u0011!C!\u0003W\fa!Z9vC2\u001cH\u0003BAj\u0003[D!\"!\r\u0002h\u0006\u0005\t\u0019AAZ\u000f%\t\t\u0010AA\u0001\u0012\u0013\t\u00190A\u0003Ti\u0006$X\r\u0005\u0003\u0002d\u0005Uh!CA\u001d\u0001\u0005\u0005\t\u0012BA|'\u0019\t)0!?\u0002DAI\u00111 B\u0001s\u0006]\u0013\u0011M\u0007\u0003\u0003{T1!a@\u000b\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\u0001\u0002~\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\t\u000fM\u000b)\u0010\"\u0001\u0003\bQ\u0011\u00111\u001f\u0005\u000b\u0003G\f)0!A\u0005F\u0005\u0015\bB\u0003B\u0007\u0003k\f\t\u0011\"!\u0003\u0010\u0005)\u0011\r\u001d9msR1\u0011\u0011\rB\t\u0005'Aq!a\u0013\u0003\f\u0001\u0007\u0011\u0010\u0003\u0005\u0002T\t-\u0001\u0019AA,\u0011)\u00119\"!>\u0002\u0002\u0013\u0005%\u0011D\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011YBa\t\u0011\t%Q$Q\u0004\t\u0007\u0013\t}\u00110a\u0016\n\u0007\t\u0005\"B\u0001\u0004UkBdWM\r\u0005\u000b\u0005K\u0011)\"!AA\u0002\u0005\u0005\u0014a\u0001=%a!I!\u0011\u0006\u0001C\u0002\u0013%!1F\u0001\u0006gR\fG/Z\u000b\u0003\u0005[\u0001bAa\f\u0003<\u0005\u0005TB\u0001B\u0019\u0015\u0011\u0011\u0019D!\u000e\u0002\r\u0005$x.\\5d\u0015\rQ#q\u0007\u0006\u0005\u0005s\t\u0019+\u0001\u0003vi&d\u0017\u0002\u0002B\u001f\u0005c\u0011q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-\u001a\u0005\t\u0005\u0003\u0002\u0001\u0015!\u0003\u0003.\u000511\u000f^1uK\u0002BqA!\u0012\u0001\t\u0003\u00129%A\u0006jg\u00063\u0018-\u001b7bE2,WCAAj\u0011\u001d\u0011)\u0005\u0001C\u0005\u0005\u0017\"B!a5\u0003N!A\u00111\u000bB%\u0001\u0004\t\u0019\u0001C\u0004\u0003R\u0001!\tEa\u0012\u0002\u0019%\u001cXj\u001c8ji>\u0014\u0018N\\4\t\u000f\tU\u0003\u0001\"\u0012\u0003X\u0005I\u0001.Z1si\n,\u0017\r\u001e\u000b\u0003\u0003SACAa\u0015\u0003\\A!!Q\fB0\u001b\t\t))\u0003\u0003\u0003b\u0005\u0015%a\u0002;bS2\u0014Xm\u0019\u0005\u0007\u0005K\u0002A\u0011\u0001\u000b\u0002\u0007AD\u0017\u000eC\u0004\u0003f\u0001!IA!\u001b\u0015\u0007U\u0011Y\u0007\u0003\u0005\u0002T\t\u001d\u0004\u0019AA\u0002\u0011!\u0011)\u0007\u0001C\u0001\t\t=DcB\u000b\u0003r\tU$\u0011\u0010\u0005\t\u0005g\u0012i\u00071\u0001\u0002\u0004\u0005AA/[7f\t&4g\rC\u0004\u0003x\t5\u0004\u0019A\u000b\u0002\t5,\u0017M\u001c\u0005\b\u0005w\u0012i\u00071\u0001\u0016\u00031\u0019H\u000f\u001a#fm&\fG/[8o\u0011%\u0011y\b\u0001b\u0001\n\u0013\t\t!A\u000bnS:\u001cF\u000f\u001a#fm&\fG/[8o\u001b&dG.[:\t\u0011\t\r\u0005\u0001)A\u0005\u0003\u0007\ta#\\5o'R$G)\u001a<jCRLwN\\'jY2L7\u000f\t\u0005\b\u0005\u000f\u0003A\u0011\u0002BE\u0003])gn];sKZ\u000bG.\u001b3Ti\u0012$UM^5bi&|g\u000eF\u0002\u0016\u0005\u0017CqAa\u001f\u0003\u0006\u0002\u0007Q\u0003")
public class PhiAccrualFailureDetector
implements FailureDetector {
    private volatile PhiAccrualFailureDetector$State$ State$module;
    private final double threshold;
    private final int maxSampleSize;
    private final FiniteDuration minStdDeviation;
    private final FiniteDuration acceptableHeartbeatPause;
    private final FiniteDuration firstHeartbeatEstimate;
    private final Option<EventStream> eventStream;
    private final FailureDetector.Clock clock;
    private final HeartbeatHistory firstHeartbeat;
    private final long acceptableHeartbeatPauseMillis;
    private String address;
    private final AtomicReference<State> state;
    private final long minStdDeviationMillis;

    private PhiAccrualFailureDetector$State$ State() {
        if (this.State$module == null) {
            this.State$lzycompute$1();
        }
        return this.State$module;
    }

    public double threshold() {
        return this.threshold;
    }

    public int maxSampleSize() {
        return this.maxSampleSize;
    }

    public FiniteDuration minStdDeviation() {
        return this.minStdDeviation;
    }

    public FiniteDuration acceptableHeartbeatPause() {
        return this.acceptableHeartbeatPause;
    }

    public FiniteDuration firstHeartbeatEstimate() {
        return this.firstHeartbeatEstimate;
    }

    private HeartbeatHistory firstHeartbeat() {
        return this.firstHeartbeat;
    }

    private long acceptableHeartbeatPauseMillis() {
        return this.acceptableHeartbeatPauseMillis;
    }

    public String address() {
        return this.address;
    }

    public void address_$eq(String x$1) {
        this.address = x$1;
    }

    private AtomicReference<State> state() {
        return this.state;
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable(this.clock.apply$mcJ$sp());
    }

    private boolean isAvailable(long timestamp) {
        return this.phi(timestamp) < this.threshold();
    }

    @Override
    public boolean isMonitoring() {
        return this.state().get().timestamp().nonEmpty();
    }

    @Override
    public final void heartbeat() {
        State newState;
        State oldState;
        do {
            HeartbeatHistory heartbeatHistory;
            long timestamp = this.clock.apply$mcJ$sp();
            oldState = this.state().get();
            Option<Object> option = oldState.timestamp();
            if (None$.MODULE$.equals(option)) {
                heartbeatHistory = this.firstHeartbeat();
            } else if (option instanceof Some) {
                HeartbeatHistory heartbeatHistory2;
                Some some = (Some)option;
                long latestTimestamp = BoxesRunTime.unboxToLong((Object)some.value());
                long interval = timestamp - latestTimestamp;
                if (this.isAvailable(timestamp)) {
                    if (interval >= this.acceptableHeartbeatPauseMillis() / 3L * 2L && this.eventStream.isDefined()) {
                        ((SubchannelClassification)this.eventStream.get()).publish((Object)new Logging.Warning(this.toString(), this.getClass(), (Object)new StringBuilder(61).append("heartbeat interval is growing too large for address ").append(this.address()).append(": ").append(interval).append(" millis").toString()));
                    }
                    heartbeatHistory2 = oldState.history().$colon$plus(interval);
                } else {
                    heartbeatHistory2 = oldState.history();
                }
                heartbeatHistory = heartbeatHistory2;
            } else {
                throw new MatchError(option);
            }
            HeartbeatHistory newHistory = heartbeatHistory;
            newState = oldState.copy(newHistory, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)timestamp)));
        } while (!this.state().compareAndSet(oldState, newState));
    }

    public double phi() {
        return this.phi(this.clock.apply$mcJ$sp());
    }

    private double phi(long timestamp) {
        double d;
        State oldState = this.state().get();
        Option<Object> oldTimestamp = oldState.timestamp();
        if (oldTimestamp.isEmpty()) {
            d = 0.0;
        } else {
            long timeDiff = timestamp - BoxesRunTime.unboxToLong((Object)oldTimestamp.get());
            HeartbeatHistory history = oldState.history();
            double mean = history.mean();
            double stdDeviation = this.ensureValidStdDeviation(history.stdDeviation());
            d = this.phi(timeDiff, mean + (double)this.acceptableHeartbeatPauseMillis(), stdDeviation);
        }
        return d;
    }

    public double phi(long timeDiff, double mean, double stdDeviation) {
        double y = ((double)timeDiff - mean) / stdDeviation;
        double e = package$.MODULE$.exp(-y * (1.5976 + 0.070566 * y * y));
        return (double)timeDiff > mean ? -package$.MODULE$.log10(e / (1.0 + e)) : -package$.MODULE$.log10(1.0 - 1.0 / (1.0 + e));
    }

    private long minStdDeviationMillis() {
        return this.minStdDeviationMillis;
    }

    private double ensureValidStdDeviation(double stdDeviation) {
        return package$.MODULE$.max(stdDeviation, (double)this.minStdDeviationMillis());
    }

    private final void State$lzycompute$1() {
        PhiAccrualFailureDetector phiAccrualFailureDetector = this;
        synchronized (phiAccrualFailureDetector) {
            if (this.State$module == null) {
                this.State$module = new PhiAccrualFailureDetector$State$(this);
            }
        }
    }

    public PhiAccrualFailureDetector(double threshold, int maxSampleSize, FiniteDuration minStdDeviation, FiniteDuration acceptableHeartbeatPause, FiniteDuration firstHeartbeatEstimate, Option<EventStream> eventStream, FailureDetector.Clock clock) {
        this.threshold = threshold;
        this.maxSampleSize = maxSampleSize;
        this.minStdDeviation = minStdDeviation;
        this.acceptableHeartbeatPause = acceptableHeartbeatPause;
        this.firstHeartbeatEstimate = firstHeartbeatEstimate;
        this.eventStream = eventStream;
        this.clock = clock;
        Predef$.MODULE$.require(threshold > 0.0, (Function0 & Serializable & scala.Serializable)() -> "failure-detector.threshold must be > 0");
        Predef$.MODULE$.require(maxSampleSize > 0, (Function0 & Serializable & scala.Serializable)() -> "failure-detector.max-sample-size must be > 0");
        Predef$.MODULE$.require(minStdDeviation.$greater((Object)Duration$.MODULE$.Zero()), (Function0 & Serializable & scala.Serializable)() -> "failure-detector.min-std-deviation must be > 0");
        Predef$.MODULE$.require(acceptableHeartbeatPause.$greater$eq((Object)Duration$.MODULE$.Zero()), (Function0 & Serializable & scala.Serializable)() -> "failure-detector.acceptable-heartbeat-pause must be >= 0");
        Predef$.MODULE$.require(firstHeartbeatEstimate.$greater((Object)Duration$.MODULE$.Zero()), (Function0 & Serializable & scala.Serializable)() -> "failure-detector.heartbeat-interval must be > 0");
        long mean = firstHeartbeatEstimate.toMillis();
        long stdDeviation = mean / 4L;
        this.firstHeartbeat = HeartbeatHistory$.MODULE$.apply(maxSampleSize).$colon$plus(mean - stdDeviation).$colon$plus(mean + stdDeviation);
        this.acceptableHeartbeatPauseMillis = acceptableHeartbeatPause.toMillis();
        this.address = "N/A";
        this.state = new AtomicReference<State>(new State(this, this.firstHeartbeat(), (Option<Object>)None$.MODULE$));
        this.minStdDeviationMillis = minStdDeviation.toMillis();
    }

    public PhiAccrualFailureDetector(double threshold, int maxSampleSize, FiniteDuration minStdDeviation, FiniteDuration acceptableHeartbeatPause, FiniteDuration firstHeartbeatEstimate, FailureDetector.Clock clock) {
        this(threshold, maxSampleSize, minStdDeviation, acceptableHeartbeatPause, firstHeartbeatEstimate, (Option<EventStream>)None$.MODULE$, clock);
    }

    public PhiAccrualFailureDetector(Config config, EventStream ev) {
        this(config.getDouble("threshold"), config.getInt("max-sample-size"), Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "min-std-deviation"), Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "acceptable-heartbeat-pause"), Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "heartbeat-interval"), (Option<EventStream>)new Some((Object)ev), FailureDetector$.MODULE$.defaultClock());
    }

    public final class State
    implements Product,
    scala.Serializable {
        private final HeartbeatHistory history;
        private final Option<Object> timestamp;
        private final /* synthetic */ PhiAccrualFailureDetector $outer;

        public HeartbeatHistory history() {
            return this.history;
        }

        public Option<Object> timestamp() {
            return this.timestamp;
        }

        public State copy(HeartbeatHistory history, Option<Object> timestamp) {
            return new State(this.$outer, history, timestamp);
        }

        public HeartbeatHistory copy$default$1() {
            return this.history();
        }

        public Option<Object> copy$default$2() {
            return this.timestamp();
        }

        public String productPrefix() {
            return "State";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Option<Object> option;
            int n = x$1;
            switch (n) {
                case 0: {
                    option = this.history();
                    break;
                }
                case 1: {
                    option = this.timestamp();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return option;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof State;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof State)) return false;
            if (!true) return false;
            boolean bl = true;
            if (!bl) return false;
            State state = (State)x$1;
            HeartbeatHistory heartbeatHistory = this.history();
            HeartbeatHistory heartbeatHistory2 = state.history();
            if (heartbeatHistory == null) {
                if (heartbeatHistory2 != null) {
                    return false;
                }
            } else if (!((Object)heartbeatHistory).equals(heartbeatHistory2)) return false;
            Option<Object> option = this.timestamp();
            Option<Object> option2 = state.timestamp();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public State(PhiAccrualFailureDetector $outer, HeartbeatHistory history, Option<Object> timestamp) {
            this.history = history;
            this.timestamp = timestamp;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

