/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jcr;

import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.RuntimeRepositoryException;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JcrTemplate {
    private final Repository repository;
    private final Credentials credentials;
    private static final ThreadLocal<Session> SESSION_STORE = new ThreadLocal();
    private static final Logger logger = LoggerFactory.getLogger(JcrTemplate.class);

    @Autowired
    public JcrTemplate(Repository repository, Credentials credentials) {
        this.repository = repository;
        this.credentials = credentials;
    }

    public final <T> T execute(JcrCallback<T> callback) throws RuntimeRepositoryException {
        return this.execute(callback, false);
    }

    public final <T> T execute(JcrCallback<T> callback, boolean createNewSession) throws RuntimeRepositoryException {
        Session session = SESSION_STORE.get();
        boolean newSession = createNewSession;
        if (!newSession) {
            if (session == null) {
                logger.debug("Did not find an existing session, creating a session for one JCR request.");
                newSession = true;
            } else if (!session.isLive()) {
                logger.debug("Existing session is no longer live, creating a session for one JCR request.");
                newSession = true;
            }
        }
        try {
            if (newSession) {
                session = this.getSession();
            }
            T t = callback.doInJcr(session);
            return t;
        }
        catch (RepositoryException e) {
            throw new RuntimeRepositoryException(e.getMessage(), e);
        }
        finally {
            if (newSession && null != session) {
                session.logout();
            }
        }
    }

    private Session getSession() {
        try {
            return this.repository.login(this.credentials);
        }
        catch (AccessDeniedException ade) {
            throw new RuntimeRepositoryException("Failed to complete your request.", (RepositoryException)((Object)ade));
        }
        catch (LoginException le) {
            throw new RuntimeRepositoryException("Couldn't login to the repository", (RepositoryException)((Object)le));
        }
        catch (RepositoryException e) {
            throw new RuntimeRepositoryException(e.getMessage(), e);
        }
    }

    public void login() {
        SESSION_STORE.set(this.getSession());
    }

    public boolean isLoggedIn() {
        return SESSION_STORE.get() != null && SESSION_STORE.get().isLive();
    }

    public void logout() {
        if (SESSION_STORE.get() != null) {
            SESSION_STORE.get().logout();
            SESSION_STORE.remove();
        } else {
            logger.warn("Superfluous logout call found.", (Throwable)new RuntimeException());
        }
    }

    public Repository getRepository() {
        return this.repository;
    }
}

