/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.encryption;

import com.xebialabs.deployit.conversion.AESCoder;
import com.xebialabs.deployit.encryption.IPasswordEncrypter;
import com.xebialabs.deployit.encryption.PasswordEncrypterBase;
import com.xebialabs.deployit.security.SecretKeyHolder;
import com.xebialabs.xlplatform.utils.SecureRandomHolder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.lang.ArrayUtils;

public class AESPasswordEncrypter
extends PasswordEncrypterBase
implements IPasswordEncrypter {
    private static final int AES_BLOCK_SIZE = 16;
    private static final int IV_LENGTH = 16;
    private static final String CIPHER_TRANSFORMATION = "AES/CBC/PKCS5PADDING";

    public AESPasswordEncrypter(SecretKeyHolder encryptionKeyHolder) {
        super(encryptionKeyHolder);
        this.coder = new AESCoder();
    }

    public AESPasswordEncrypter(SecretKey passwordEncryptionKey) {
        this(new SecretKeyHolder(passwordEncryptionKey));
    }

    @Override
    public String doEncrypt(String plaintext) throws GeneralSecurityException {
        byte[] iv = this.getRandomIV();
        Cipher aes = this.encryptionKeyHolder.getEncryption(CIPHER_TRANSFORMATION, new IvParameterSpec(iv));
        byte[] concat = ArrayUtils.addAll((byte[])iv, (byte[])aes.doFinal(plaintext.getBytes(StandardCharsets.UTF_8)));
        return new String(this.coder.encode(concat), StandardCharsets.UTF_8);
    }

    @Override
    public String doDecodeAndDecrypt(String text) throws GeneralSecurityException {
        byte[] decoded = this.coder.decode(text.getBytes(StandardCharsets.UTF_8));
        byte[] iv = Arrays.copyOf(decoded, 16);
        byte[] encrypted = Arrays.copyOfRange(decoded, 16, decoded.length);
        Cipher aes = this.encryptionKeyHolder.getDecryption(CIPHER_TRANSFORMATION, new IvParameterSpec(iv));
        return new String(aes.doFinal(encrypted), StandardCharsets.UTF_8);
    }

    protected byte[] getRandomIV() {
        return SecureRandomHolder.getRandomByteArray((int)16);
    }
}

