/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl.fusing;

import akka.annotation.InternalApi;
import akka.stream.Attributes;
import akka.stream.BufferOverflowException;
import akka.stream.DelayOverflowStrategy;
import akka.stream.OverflowStrategies$Backpressure$;
import akka.stream.OverflowStrategies$DropBuffer$;
import akka.stream.OverflowStrategies$DropHead$;
import akka.stream.OverflowStrategies$DropNew$;
import akka.stream.OverflowStrategies$DropTail$;
import akka.stream.OverflowStrategies$EmitEarly$;
import akka.stream.OverflowStrategies$Fail$;
import akka.stream.impl.Buffer;
import akka.stream.impl.Buffer$;
import akka.stream.impl.Stages$DefaultAttributes$;
import akka.stream.impl.fusing.GraphStages;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.MatchError;
import scala.Tuple2;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001]4Q!\u0001\u0002\u0003\u0011)\u0011Q\u0001R3mCfT!a\u0001\u0003\u0002\r\u0019,8/\u001b8h\u0015\t)a!\u0001\u0003j[Bd'BA\u0004\t\u0003\u0019\u0019HO]3b[*\t\u0011\"\u0001\u0003bW.\fWCA\u0006\"'\t\u0001A\u0002E\u0002\u000e9}q!A\u0004\u000e\u000f\u0005=IbB\u0001\t\u0019\u001d\t\trC\u0004\u0002\u0013-5\t1C\u0003\u0002\u0015+\u00051AH]8piz\u001a\u0001!C\u0001\n\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u00111\u0001B\u0005\u00037\t\t1b\u0012:ba\"\u001cF/Y4fg&\u0011QD\b\u0002\u0017'&l\u0007\u000f\\3MS:,\u0017M]$sCBD7\u000b^1hK*\u00111D\u0001\t\u0003A\u0005b\u0001\u0001B\u0003#\u0001\t\u00071EA\u0001U#\t!#\u0006\u0005\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIcEA\u0004O_RD\u0017N\\4\u0011\u0005\u0015Z\u0013B\u0001\u0017'\u0005\r\te.\u001f\u0005\t]\u0001\u0011)\u0019!C\u0001_\u0005\tA-F\u00011!\t\td'D\u00013\u0015\t\u0019D'\u0001\u0005ekJ\fG/[8o\u0015\t)d%\u0001\u0006d_:\u001cWO\u001d:f]RL!a\u000e\u001a\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\"A\u0011\b\u0001B\u0001B\u0003%\u0001'\u0001\u0002eA!A1\b\u0001BC\u0002\u0013\u0005A(\u0001\u0005tiJ\fG/Z4z+\u0005i\u0004C\u0001 @\u001b\u00051\u0011B\u0001!\u0007\u0005U!U\r\\1z\u001fZ,'O\u001a7poN#(/\u0019;fOfD\u0001B\u0011\u0001\u0003\u0002\u0003\u0006I!P\u0001\ngR\u0014\u0018\r^3hs\u0002BQ\u0001\u0012\u0001\u0005\u0002\u0015\u000ba\u0001P5oSRtDc\u0001$I\u0013B\u0019q\tA\u0010\u000e\u0003\tAQAL\"A\u0002ABQaO\"A\u0002uBaa\u0013\u0001!\n\u0013a\u0015!\u0003;j[\u0016\u0014h*Y7f+\u0005i\u0005C\u0001(T\u001b\u0005y%B\u0001)R\u0003\u0011a\u0017M\\4\u000b\u0003I\u000bAA[1wC&\u0011Ak\u0014\u0002\u0007'R\u0014\u0018N\\4\t\u000fY\u0003!\u0019!C\u0003/\u0006\u0001B)\u001a7bsB\u0013XmY5tS>tWjU\u000b\u00021>\t\u0011,H\u0001\u000b\u0011\u0019Y\u0006\u0001)A\u00071\u0006\tB)\u001a7bsB\u0013XmY5tS>tWj\u0015\u0011\t\u000bu\u0003A\u0011\t0\u0002#%t\u0017\u000e^5bY\u0006#HO]5ckR,7/F\u0001`!\tq\u0004-\u0003\u0002b\r\tQ\u0011\t\u001e;sS\n,H/Z:\t\u000b\r\u0004A\u0011\t3\u0002\u0017\r\u0014X-\u0019;f\u0019><\u0017n\u0019\u000b\u0003K.\u0004\"AZ5\u000e\u0003\u001dT!\u0001\u001b\u0004\u0002\u000bM$\u0018mZ3\n\u0005)<'aD$sCBD7\u000b^1hK2{w-[2\t\u000b1\u0014\u0007\u0019A0\u0002'%t\u0007.\u001a:ji\u0016$\u0017\t\u001e;sS\n,H/Z:\t\u000b9\u0004A\u0011I8\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\u0014\u0015\u0003\u0001E\u0004\"A];\u000e\u0003MT!\u0001\u001e\u0005\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002wg\nY\u0011J\u001c;fe:\fG.\u00119j\u0001")
@InternalApi
public final class Delay<T>
extends GraphStages.SimpleLinearGraphStage<T> {
    private final FiniteDuration d;
    private final DelayOverflowStrategy strategy;

    public FiniteDuration d() {
        return this.d;
    }

    public DelayOverflowStrategy strategy() {
        return this.strategy;
    }

    public String akka$stream$impl$fusing$Delay$$timerName() {
        return "DelayedTimer";
    }

    public final int DelayPrecisionMS() {
        return 10;
    }

    @Override
    public Attributes initialAttributes() {
        return Stages$DefaultAttributes$.MODULE$.delay();
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(this, inheritedAttributes){
            private final int size;
            private final long delayMillis;
            private Buffer<Tuple2<Object, T>> buffer;
            private final Function0<BoxedUnit> onPushWhenBufferFull;
            private final /* synthetic */ Delay $outer;

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$(this);
            }

            public void onUpstreamFailure(Throwable ex) throws Exception {
                InHandler.onUpstreamFailure$(this, ex);
            }

            private int size() {
                return this.size;
            }

            private long delayMillis() {
                return this.delayMillis;
            }

            private Buffer<Tuple2<Object, T>> buffer() {
                return this.buffer;
            }

            private void buffer_$eq(Buffer<Tuple2<Object, T>> x$1) {
                this.buffer = x$1;
            }

            public void preStart() {
                this.buffer_$eq(Buffer$.MODULE$.apply(this.size(), this.materializer()));
            }

            private Function0<BoxedUnit> onPushWhenBufferFull() {
                return this.onPushWhenBufferFull;
            }

            public void onPush() {
                block1: {
                    block0: {
                        if (!this.buffer().isFull()) break block0;
                        this.onPushWhenBufferFull().apply$mcV$sp();
                        break block1;
                    }
                    this.grabAndPull();
                    if (this.isTimerActive(this.$outer.akka$stream$impl$fusing$Delay$$timerName())) break block1;
                    this.scheduleOnce((Object)this.$outer.akka$stream$impl$fusing$Delay$$timerName(), this.$outer.d());
                }
            }

            private boolean pullCondition() {
                DelayOverflowStrategy delayOverflowStrategy = this.$outer.strategy();
                OverflowStrategies$Backpressure$ overflowStrategies$Backpressure$ = OverflowStrategies$Backpressure$.MODULE$;
                return (delayOverflowStrategy != null ? !delayOverflowStrategy.equals(overflowStrategies$Backpressure$) : overflowStrategies$Backpressure$ != null) || this.buffer().used() < this.size();
            }

            private void grabAndPull() {
                block0: {
                    this.buffer().enqueue(new Tuple2((Object)BoxesRunTime.boxToLong((long)System.nanoTime()), this.grab(this.$outer.in())));
                    if (!this.pullCondition()) break block0;
                    this.pull(this.$outer.in());
                }
            }

            public void onUpstreamFinish() {
                this.completeIfReady();
            }

            public void onPull() {
                if (!this.isTimerActive(this.$outer.akka$stream$impl$fusing$Delay$$timerName()) && !this.buffer().isEmpty()) {
                    long waitTime = this.nextElementWaitTime();
                    if (waitTime < 0L) {
                        this.push(this.$outer.out(), this.buffer().dequeue()._2());
                    } else {
                        this.scheduleOnce((Object)this.$outer.akka$stream$impl$fusing$Delay$$timerName(), new package.DurationLong(package$.MODULE$.DurationLong(Math.max(10L, waitTime))).millis());
                    }
                }
                if (!this.isClosed(this.$outer.in()) && !this.hasBeenPulled(this.$outer.in()) && this.pullCondition()) {
                    this.pull(this.$outer.in());
                }
                this.completeIfReady();
            }

            private void completeIfReady() {
                block0: {
                    if (!this.isClosed(this.$outer.in()) || !this.buffer().isEmpty()) break block0;
                    this.completeStage();
                }
            }

            private long nextElementWaitTime() {
                return this.delayMillis() - TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.buffer().peek()._1$mcJ$sp());
            }

            public final void onTimer(Object key) {
                long waitTime;
                if (this.isAvailable(this.$outer.out())) {
                    this.push(this.$outer.out(), this.buffer().dequeue()._2());
                }
                if (!this.buffer().isEmpty() && (waitTime = this.nextElementWaitTime()) > 10L) {
                    this.scheduleOnce((Object)this.$outer.akka$stream$impl$fusing$Delay$$timerName(), new package.DurationLong(package$.MODULE$.DurationLong(waitTime)).millis());
                }
                this.completeIfReady();
            }
            {
                Function0 & Serializable & scala.Serializable intersect;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.shape());
                InHandler.$init$(this);
                OutHandler.$init$(this);
                this.size = ((Attributes.InputBuffer)((Attributes)((Object)inheritedAttributes$15)).mandatoryAttribute(ClassTag$.MODULE$.apply(Attributes.InputBuffer.class))).max();
                this.delayMillis = $outer.d().toMillis();
                DelayOverflowStrategy delayOverflowStrategy = $outer.strategy();
                if (OverflowStrategies$EmitEarly$.MODULE$.equals(delayOverflowStrategy)) {
                    intersect = (Function0 & Serializable & scala.Serializable)() -> {
                        if (!this.isTimerActive($this.$outer.akka$stream$impl$fusing$Delay$$timerName())) {
                            this.push($this.$outer.out(), this.buffer().dequeue()._2());
                        } else {
                            this.cancelTimer($this.$outer.akka$stream$impl$fusing$Delay$$timerName());
                            this.onTimer($this.$outer.akka$stream$impl$fusing$Delay$$timerName());
                        }
                        this.grabAndPull();
                    };
                } else if (OverflowStrategies$DropHead$.MODULE$.equals(delayOverflowStrategy)) {
                    intersect = (Function0 & Serializable & scala.Serializable)() -> {
                        this.buffer().dropHead();
                        this.grabAndPull();
                    };
                } else if (OverflowStrategies$DropTail$.MODULE$.equals(delayOverflowStrategy)) {
                    intersect = (Function0 & Serializable & scala.Serializable)() -> {
                        this.buffer().dropTail();
                        this.grabAndPull();
                    };
                } else if (OverflowStrategies$DropNew$.MODULE$.equals(delayOverflowStrategy)) {
                    intersect = (Function0 & Serializable & scala.Serializable)() -> {
                        block0: {
                            this.grab($this.$outer.in());
                            if (this.isTimerActive($this.$outer.akka$stream$impl$fusing$Delay$$timerName())) break block0;
                            this.scheduleOnce((Object)$this.$outer.akka$stream$impl$fusing$Delay$$timerName(), $this.$outer.d());
                        }
                    };
                } else if (OverflowStrategies$DropBuffer$.MODULE$.equals(delayOverflowStrategy)) {
                    intersect = (Function0 & Serializable & scala.Serializable)() -> {
                        this.buffer().clear();
                        this.grabAndPull();
                    };
                } else if (OverflowStrategies$Fail$.MODULE$.equals(delayOverflowStrategy)) {
                    intersect = (Function0 & Serializable & scala.Serializable)() -> this.failStage(new BufferOverflowException(new StringBuilder(56).append("Buffer overflow for delay operator (max capacity was: ").append(this.size()).append(")!").toString()));
                } else if (OverflowStrategies$Backpressure$.MODULE$.equals(delayOverflowStrategy)) {
                    intersect = (Function0 & Serializable & scala.Serializable)() -> {
                        throw new IllegalStateException("Delay buffer must never overflow in Backpressure mode");
                    };
                } else {
                    throw new MatchError((Object)delayOverflowStrategy);
                }
                this.onPushWhenBufferFull = intersect;
                this.setHandler($outer.in(), this);
                this.setHandler($outer.out(), this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onPushWhenBufferFull$1(akka.stream.impl.fusing.Delay$$anon$7 ), $anonfun$onPushWhenBufferFull$2(akka.stream.impl.fusing.Delay$$anon$7 ), $anonfun$onPushWhenBufferFull$3(akka.stream.impl.fusing.Delay$$anon$7 ), $anonfun$onPushWhenBufferFull$4(akka.stream.impl.fusing.Delay$$anon$7 ), $anonfun$onPushWhenBufferFull$5(akka.stream.impl.fusing.Delay$$anon$7 ), $anonfun$onPushWhenBufferFull$6(akka.stream.impl.fusing.Delay$$anon$7 ), $anonfun$onPushWhenBufferFull$7()}, serializedLambda);
            }
        };
    }

    public String toString() {
        return "Delay";
    }

    public Delay(FiniteDuration d, DelayOverflowStrategy strategy) {
        this.d = d;
        this.strategy = strategy;
    }
}

