/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.transport.netty;

import akka.event.LogMarker$;
import akka.event.MarkerLoggingAdapter;
import akka.japi.Util$;
import akka.remote.RemoteTransportException;
import akka.remote.security.provider.AkkaProvider$;
import com.typesafe.config.Config;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import scala.Function0;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb!B\u0001\u0003\u0001!Q!aC*T\u0019N+G\u000f^5oONT!a\u0001\u0003\u0002\u000b9,G\u000f^=\u000b\u0005\u00151\u0011!\u0003;sC:\u001c\bo\u001c:u\u0015\t9\u0001\"\u0001\u0004sK6|G/\u001a\u0006\u0002\u0013\u0005!\u0011m[6b'\t\u00011\u0002\u0005\u0002\r\u001f5\tQBC\u0001\u000f\u0003\u0015\u00198-\u00197b\u0013\t\u0001RB\u0001\u0004B]f\u0014VM\u001a\u0005\t%\u0001\u0011\t\u0011)A\u0005)\u000511m\u001c8gS\u001e\u001c\u0001\u0001\u0005\u0002\u001675\taC\u0003\u0002\u0013/)\u0011\u0001$G\u0001\tif\u0004Xm]1gK*\t!$A\u0002d_6L!\u0001\b\f\u0003\r\r{gNZ5h\u0011\u0015q\u0002\u0001\"\u0001 \u0003\u0019a\u0014N\\5u}Q\u0011\u0001E\t\t\u0003C\u0001i\u0011A\u0001\u0005\u0006%u\u0001\r\u0001\u0006\u0005\bI\u0001\u0011\r\u0011\"\u0001&\u0003-\u00196\u000bT&fsN#xN]3\u0016\u0003\u0019\u0002\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\t1\fgn\u001a\u0006\u0002W\u0005!!.\u0019<b\u0013\ti\u0003F\u0001\u0004TiJLgn\u001a\u0005\u0007_\u0001\u0001\u000b\u0011\u0002\u0014\u0002\u0019M\u001bFjS3z'R|'/\u001a\u0011\t\u000fE\u0002!\u0019!C\u0001K\u0005i1k\u0015'UeV\u001cHo\u0015;pe\u0016Daa\r\u0001!\u0002\u00131\u0013AD*T\u0019R\u0013Xo\u001d;Ti>\u0014X\r\t\u0005\bk\u0001\u0011\r\u0011\"\u0001&\u0003M\u00196\u000bT&fsN#xN]3QCN\u001cxo\u001c:e\u0011\u00199\u0004\u0001)A\u0005M\u0005!2k\u0015'LKf\u001cFo\u001c:f!\u0006\u001c8o^8sI\u0002Bq!\u000f\u0001C\u0002\u0013\u0005Q%\u0001\bT'2[U-\u001f)bgN<xN\u001d3\t\rm\u0002\u0001\u0015!\u0003'\u0003=\u00196\u000bT&fsB\u000b7o]<pe\u0012\u0004\u0003bB\u001f\u0001\u0005\u0004%\t!J\u0001\u0016'NcEK];tiN#xN]3QCN\u001cxo\u001c:e\u0011\u0019y\u0004\u0001)A\u0005M\u000512k\u0015'UeV\u001cHo\u0015;pe\u0016\u0004\u0016m]:x_J$\u0007\u0005C\u0004B\u0001\t\u0007I\u0011\u0001\"\u0002)M\u001bF*\u00128bE2,G-\u00117h_JLG\u000f[7t+\u0005\u0019\u0005c\u0001#LM9\u0011Q)\u0013\t\u0003\r6i\u0011a\u0012\u0006\u0003\u0011N\ta\u0001\u0010:p_Rt\u0014B\u0001&\u000e\u0003\u0019\u0001&/\u001a3fM&\u0011A*\u0014\u0002\u0004'\u0016$(B\u0001&\u000e\u0011\u0019y\u0005\u0001)A\u0005\u0007\u0006)2k\u0015'F]\u0006\u0014G.\u001a3BY\u001e|'/\u001b;i[N\u0004\u0003bB)\u0001\u0005\u0004%\t!J\u0001\f'Nc\u0005K]8u_\u000e|G\u000e\u0003\u0004T\u0001\u0001\u0006IAJ\u0001\r'Nc\u0005K]8u_\u000e|G\u000e\t\u0005\b+\u0002\u0011\r\u0011\"\u0001&\u0003a\u00196\u000b\u0014*b]\u0012|WNT;nE\u0016\u0014x)\u001a8fe\u0006$xN\u001d\u0005\u0007/\u0002\u0001\u000b\u0011\u0002\u0014\u00023M\u001bFJU1oI>lg*^7cKJ<UM\\3sCR|'\u000f\t\u0005\b3\u0002\u0011\r\u0011\"\u0001[\u0003y\u00196\u000b\u0014*fcVL'/Z'viV\fG.Q;uQ\u0016tG/[2bi&|g.F\u0001\\!\taA,\u0003\u0002^\u001b\t9!i\\8mK\u0006t\u0007BB0\u0001A\u0003%1,A\u0010T'2\u0013V-];je\u0016lU\u000f^;bY\u0006+H\u000f[3oi&\u001c\u0017\r^5p]\u0002Bq!\u0019\u0001C\u0002\u0013%!-\u0001\u0006tg2\u001cuN\u001c;fqR,\u0012a\u0019\t\u0004I.lW\"A3\u000b\u0005\u0019<\u0017AB1u_6L7M\u0003\u0002iS\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005)T\u0013\u0001B;uS2L!\u0001\\3\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004\"A\\;\u000e\u0003=T!\u0001]9\u0002\u0007M\u001cHN\u0003\u0002sg\u0006\u0019a.\u001a;\u000b\u0003Q\fQA[1wCbL!A^8\u0003\u0015M\u001bFjQ8oi\u0016DH\u000f\u0003\u0004y\u0001\u0001\u0006IaY\u0001\fgNd7i\u001c8uKb$\b\u0005C\u0003{\u0001\u0011\u001510\u0001\nhKR|%o\u0011:fCR,7i\u001c8uKb$HCA7}\u0011\u0015i\u0018\u00101\u0001\u007f\u0003\rawn\u001a\t\u0004\u007f\u0006\u0015QBAA\u0001\u0015\r\t\u0019\u0001C\u0001\u0006KZ,g\u000e^\u0005\u0005\u0003\u000f\t\tA\u0001\u000bNCJ\\WM\u001d'pO\u001eLgnZ!eCB$XM\u001d\u0015\u0004s\u0006-\u0001\u0003BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005EQ\"\u0001\u0006b]:|G/\u0019;j_:LA!!\u0006\u0002\u0010\t9A/Y5me\u0016\u001c\u0007bBA\r\u0001\u0011%\u00111D\u0001\u0011G>t7\u000f\u001e:vGR\u001cuN\u001c;fqR$2!\\A\u000f\u0011\u0019i\u0018q\u0003a\u0001}\"9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0012AE2sK\u0006$XmU3dkJ,'+\u00198e_6$B!!\n\u00022A!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,)\n\u0001b]3dkJLG/_\u0005\u0005\u0003_\tIC\u0001\u0007TK\u000e,(/\u001a*b]\u0012|W\u000e\u0003\u0004~\u0003?\u0001\rA ")
public class SSLSettings {
    private final String SSLKeyStore;
    private final String SSLTrustStore;
    private final String SSLKeyStorePassword;
    private final String SSLKeyPassword;
    private final String SSLTrustStorePassword;
    private final Set<String> SSLEnabledAlgorithms;
    private final String SSLProtocol;
    private final String SSLRandomNumberGenerator;
    private final boolean SSLRequireMutualAuthentication;
    private final AtomicReference<SSLContext> sslContext;

    public String SSLKeyStore() {
        return this.SSLKeyStore;
    }

    public String SSLTrustStore() {
        return this.SSLTrustStore;
    }

    public String SSLKeyStorePassword() {
        return this.SSLKeyStorePassword;
    }

    public String SSLKeyPassword() {
        return this.SSLKeyPassword;
    }

    public String SSLTrustStorePassword() {
        return this.SSLTrustStorePassword;
    }

    public Set<String> SSLEnabledAlgorithms() {
        return this.SSLEnabledAlgorithms;
    }

    public String SSLProtocol() {
        return this.SSLProtocol;
    }

    public String SSLRandomNumberGenerator() {
        return this.SSLRandomNumberGenerator;
    }

    public boolean SSLRequireMutualAuthentication() {
        return this.SSLRequireMutualAuthentication;
    }

    private AtomicReference<SSLContext> sslContext() {
        return this.sslContext;
    }

    public final SSLContext getOrCreateContext(MarkerLoggingAdapter log) {
        SSLContext sSLContext;
        block2: {
            SSLContext sSLContext2;
            while ((sSLContext2 = this.sslContext().get()) == null) {
                SSLContext newCtx = this.constructContext(log);
                if (!this.sslContext().compareAndSet(null, newCtx)) {
                    continue;
                }
                sSLContext = newCtx;
                break block2;
            }
            sSLContext = sSLContext2;
        }
        return sSLContext;
    }

    private SSLContext constructContext(MarkerLoggingAdapter log) {
        SSLContext sSLContext;
        try {
            KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            factory.init(SSLSettings.loadKeystore$1(this.SSLKeyStore(), this.SSLKeyStorePassword()), this.SSLKeyPassword().toCharArray());
            KeyManager[] keyManagers = factory.getKeyManagers();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(SSLSettings.loadKeystore$1(this.SSLTrustStore(), this.SSLTrustStorePassword()));
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            SecureRandom rng = this.createSecureRandom(log);
            SSLContext ctx = SSLContext.getInstance(this.SSLProtocol());
            ctx.init(keyManagers, trustManagers, rng);
            sSLContext = ctx;
        }
        catch (FileNotFoundException e) {
            throw new RemoteTransportException("Server SSL connection could not be established because key store could not be loaded", e);
        }
        catch (IOException e) {
            throw new RemoteTransportException("Server SSL connection could not be established because: " + e.getMessage(), e);
        }
        catch (GeneralSecurityException e) {
            throw new RemoteTransportException("Server SSL connection could not be established because SSL context could not be constructed", e);
        }
        return sSLContext;
    }

    public SecureRandom createSecureRandom(MarkerLoggingAdapter log) {
        SecureRandom secureRandom;
        String string = this.SSLRandomNumberGenerator();
        boolean bl = "AES128CounterSecureRNG".equals(string) ? true : "AES256CounterSecureRNG".equals(string);
        if (bl) {
            log.debug("SSL random number generator set to: {}", (Object)string);
            secureRandom = SecureRandom.getInstance(string, AkkaProvider$.MODULE$);
        } else {
            boolean bl2 = "SHA1PRNG".equals(string) ? true : "NativePRNG".equals(string);
            if (bl2) {
                log.debug("SSL random number generator set to: {}", (Object)string);
                secureRandom = SecureRandom.getInstance(string);
            } else if ("".equals(string)) {
                log.debug("SSLRandomNumberGenerator not specified, falling back to SecureRandom");
                secureRandom = new SecureRandom();
            } else {
                log.warning(LogMarker$.MODULE$.Security(), "Unknown SSLRandomNumberGenerator [{}] falling back to SecureRandom", (Object)string);
                secureRandom = new SecureRandom();
            }
        }
        SecureRandom rng = secureRandom;
        rng.nextInt();
        return rng;
    }

    /*
     * WARNING - void declaration
     */
    private static final KeyStore loadKeystore$1(String filename, String password) {
        void var2_2;
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        InputStream fin = Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]);
        try {
            keyStore.load(fin, password.toCharArray());
        }
        finally {
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fin.close());
        }
        return var2_2;
    }

    public SSLSettings(Config config) {
        this.SSLKeyStore = config.getString("key-store");
        this.SSLTrustStore = config.getString("trust-store");
        this.SSLKeyStorePassword = config.getString("key-store-password");
        this.SSLKeyPassword = config.getString("key-password");
        this.SSLTrustStorePassword = config.getString("trust-store-password");
        this.SSLEnabledAlgorithms = (Set)Util$.MODULE$.immutableSeq((Iterable)config.getStringList("enabled-algorithms")).to(Set$.MODULE$.canBuildFrom());
        this.SSLProtocol = config.getString("protocol");
        this.SSLRandomNumberGenerator = config.getString("random-number-generator");
        this.SSLRequireMutualAuthentication = config.getBoolean("require-mutual-authentication");
        this.sslContext = new AtomicReference();
    }
}

