/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.util.concurrent.locks.LockSupport;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.StatusIndicatorReader;
import org.agrona.hints.ThreadHints;

public class ControllableIdleStrategy
implements IdleStrategy {
    public static final int NOT_CONTROLLED = 0;
    public static final int NOOP = 1;
    public static final int BUSY_SPIN = 2;
    public static final int YIELD = 3;
    public static final int PARK = 4;
    private static final long PARK_PERIOD_NANOSECONDS = 100L;
    private final StatusIndicatorReader statusIndicatorReader;

    public ControllableIdleStrategy(StatusIndicatorReader statusIndicatorReader) {
        this.statusIndicatorReader = statusIndicatorReader;
    }

    @Override
    public void idle(int workCount) {
        if (workCount > 0) {
            return;
        }
        this.idle();
    }

    @Override
    public void idle() {
        int status = (int)this.statusIndicatorReader.getVolatile();
        switch (status) {
            case 1: {
                break;
            }
            case 2: {
                ThreadHints.onSpinWait();
                break;
            }
            case 3: {
                Thread.yield();
                break;
            }
            default: {
                LockSupport.parkNanos(100L);
            }
        }
    }

    @Override
    public void reset() {
    }
}

