/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql.commands;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.package;
import com.xebialabs.deployit.engine.spi.event.CiMovedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactRepository;
import com.xebialabs.deployit.repository.sql.base.CIS$;
import com.xebialabs.deployit.repository.sql.base.package$;
import com.xebialabs.deployit.repository.sql.commands.ChangeSetContext;
import com.xebialabs.deployit.repository.sql.commands.CiPathValidation;
import com.xebialabs.deployit.repository.sql.commands.UpdatePathCommand;
import com.xebialabs.deployit.repository.validation.CommandValidator;
import com.xebialabs.deployit.util.Tuple;
import java.io.Serializable;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001B\u0001\u0003\u0001=\u00111\"T8wK\u000e{W.\\1oI*\u00111\u0001B\u0001\tG>lW.\u00198eg*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003\u0013)\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003\u00171\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u00035\t1aY8n\u0007\u0001\u00192\u0001\u0001\t\u0015!\t\t\"#D\u0001\u0003\u0013\t\u0019\"AA\tVa\u0012\fG/\u001a)bi\"\u001cu.\\7b]\u0012\u0004\"!E\u000b\n\u0005Y\u0011!\u0001E\"j!\u0006$\bNV1mS\u0012\fG/[8o\u0011!A\u0002A!b\u0001\n\u0003J\u0012\u0001\u00046eE\u000e$V-\u001c9mCR,W#\u0001\u000e\u0011\u0005m!S\"\u0001\u000f\u000b\u0005uq\u0012\u0001B2pe\u0016T!a\b\u0011\u0002\t)$'m\u0019\u0006\u0003C\t\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002G\u0005\u0019qN]4\n\u0005\u0015b\"\u0001\u0004&eE\u000e$V-\u001c9mCR,\u0007\"C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e)\u00035QGMY2UK6\u0004H.\u0019;fA%\u0011\u0001D\u0005\u0005\tU\u0001\u0011\t\u0011)A\u0005W\u0005\u0011\u0012M\u001d;jM\u0006\u001cGOU3q_NLGo\u001c:z!\tas&D\u0001.\u0015\tqC!A\u0005beRLg-Y2ug&\u0011\u0001'\f\u0002\u0013\u0003J$\u0018NZ1diJ+\u0007o\\:ji>\u0014\u0018\u0010\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0003A\u0019w.\\7b]\u00124\u0016\r\\5eCR|'\u000f\u0005\u00025o5\tQG\u0003\u00027\r\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\n\u0005a*$\u0001E\"p[6\fg\u000e\u001a,bY&$\u0017\r^8s\u0011!Q\u0004A!A!\u0002\u0013Y\u0014aB7pm\u0016\u001c\u0015n\u001d\t\u0004y\u0019KeBA\u001fD\u001d\tq\u0014)D\u0001@\u0015\t\u0001e\"\u0001\u0004=e>|GOP\u0005\u0002\u0005\u0006)1oY1mC&\u0011A)R\u0001\ba\u0006\u001c7.Y4f\u0015\u0005\u0011\u0015BA$I\u0005!IE/\u001a:bE2,'B\u0001#F!\u0011QUjT(\u000e\u0003-S!\u0001\u0014\u0005\u0002\tU$\u0018\u000e\\\u0005\u0003\u001d.\u0013Q\u0001V;qY\u0016\u0004\"\u0001\u0015+\u000f\u0005E\u0013\u0006C\u0001 F\u0013\t\u0019V)\u0001\u0004Qe\u0016$WMZ\u0005\u0003+Z\u0013aa\u0015;sS:<'BA*F\u0011!A\u0006A!b\u0001\n\u0007I\u0016AC:rY\u0012K\u0017\r\\3diV\t!\f\u0005\u0002\\=6\tAL\u0003\u0002\u0006;*\u0011Q\u0004C\u0005\u0003?r\u0013!bU9m\t&\fG.Z2u\u0011!\t\u0007A!A!\u0002\u0013Q\u0016aC:rY\u0012K\u0017\r\\3di\u0002BQa\u0019\u0001\u0005\u0002\u0011\fa\u0001P5oSRtD#B3iS*\\GC\u00014h!\t\t\u0002\u0001C\u0003YE\u0002\u000f!\fC\u0003\u0019E\u0002\u0007!\u0004C\u0003+E\u0002\u00071\u0006C\u00033E\u0002\u00071\u0007C\u0003;E\u0002\u00071\bC\u0003n\u0001\u0011\u0005c.A\u0004fq\u0016\u001cW\u000f^3\u0015\u0005=\u001c\bC\u00019r\u001b\u0005)\u0015B\u0001:F\u0005\u0011)f.\u001b;\t\u000bQd\u0007\u0019A;\u0002\u000f\r|g\u000e^3yiB\u0011\u0011C^\u0005\u0003o\n\u0011\u0001c\u00115b]\u001e,7+\u001a;D_:$X\r\u001f;\t\u000be\u0004A\u0011\t>\u0002\u0011Y\fG.\u001b3bi\u0016$\"a\\>\t\u000bQD\b\u0019A;\t\u000bu\u0004A\u0011\u0002@\u0002\t5|g/\u001a\u000b\u0007_~\f\u0019!a\u0002\t\r\u0005\u0005A\u00101\u0001P\u0003\u0015yG\u000eZ%e\u0011\u0019\t)\u0001 a\u0001\u001f\u0006)a.Z<JI\")A\u000f a\u0001k\"9\u00111\u0002\u0001\u0005\n\u00055\u0011aE9vKJL\u0018I\u001c3Qe\u00164\u0016\r\\5eCR,G\u0003CA\b\u0003_\t\t$a\r\u0011\rA\f\tbTA\u000b\u0013\r\t\u0019\"\u0012\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u000f\u0005]\u0011qD(\u0002$5\u0011\u0011\u0011\u0004\u0006\u0004\u0019\u0006m!BAA\u000f\u0003\u0011Q\u0017M^1\n\t\u0005\u0005\u0012\u0011\u0004\u0002\u0004\u001b\u0006\u0004\b\u0003BA\u0013\u0003Wi!!a\n\u000b\t\u0005%\u00121D\u0001\u0005Y\u0006tw-\u0003\u0003\u0002.\u0005\u001d\"AB(cU\u0016\u001cG\u000fC\u0004\u0002\u0002\u0005%\u0001\u0019A(\t\u000f\u0005\u0015\u0011\u0011\u0002a\u0001\u001f\"1A/!\u0003A\u0002UDq!a\u000e\u0001\t\u0013\tI$\u0001\u0007wC2LG-\u0019;f\u001b>4X\rF\u0004p\u0003w\ti$a\u0010\t\u000f\u0005\u0005\u0011Q\u0007a\u0001\u001f\"9\u0011QAA\u001b\u0001\u0004y\u0005B\u0002;\u00026\u0001\u0007Q\u000f")
public class MoveCommand
extends UpdatePathCommand
implements CiPathValidation {
    private final CommandValidator commandValidator;
    private final Iterable<Tuple<String, String>> moveCis;
    private final SqlDialect sqlDialect;

    @Override
    public void validateCiStoredInCorrectPath(String id, Type ciType, ChangeSetContext context) {
        CiPathValidation.validateCiStoredInCorrectPath$(this, id, ciType, context);
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return super.jdbcTemplate();
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public void execute(ChangeSetContext context) {
        this.moveCis.foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.move((String)t.a, (String)t.b, context);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void validate(ChangeSetContext context) {
        this.moveCis.foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.validateMove((String)t.a, (String)t.b, context);
            return BoxedUnit.UNIT;
        });
    }

    private void move(String oldId, String newId, ChangeSetContext context) {
        String string;
        Map map;
        block3: {
            Tuple2<String, Map<String, Object>> tuple2;
            block2: {
                tuple2 = this.queryAndPreValidate(oldId, newId, context);
                if (tuple2 == null) break block2;
                String oldPath = (String)tuple2._1();
                map = (Map)tuple2._2();
                if (oldPath == null) break block2;
                string = oldPath;
                if (map != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        Map map2 = map;
        Tuple2 tuple2 = new Tuple2((Object)string, (Object)map2);
        Tuple2 tuple22 = tuple2;
        String oldPath = (String)tuple22._1();
        Map map3 = (Map)tuple22._2();
        this.updateNameAndPath(oldPath, package$.MODULE$.idToPath(newId));
        EventBusHolder.publish((Object)new CiMovedEvent(package$.MODULE$.readBaseCiFromMap(map3), newId));
    }

    private Tuple2<String, Map<String, Object>> queryAndPreValidate(String oldId, String newId, ChangeSetContext context) {
        String string = oldId;
        String string2 = newId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot move ci [%s] to same location", (Object[])new Object[]{newId});
        String oldPath = package$.MODULE$.idToPath(oldId);
        Map map = (Map)this.jdbcTemplate().queryForObject(this.SELECT_CI_BY_PATH(), (RowMapper)new package.MapRowMapper(), new Object[]{oldPath});
        Type ciType = Type.valueOf((String)((String)map.get(CIS$.MODULE$.ci_type().name())));
        this.commandValidator.checkMoveAllowed(ciType);
        this.validateCiStoredInCorrectPath(newId, ciType, context);
        return new Tuple2((Object)oldPath, (Object)map);
    }

    private void validateMove(String oldId, String newId, ChangeSetContext context) {
        String string;
        Map map;
        block5: {
            Tuple2<String, Map<String, Object>> tuple2;
            block4: {
                tuple2 = this.queryAndPreValidate(oldId, newId, context);
                if (tuple2 == null) break block4;
                String oldPath = (String)tuple2._1();
                map = (Map)tuple2._2();
                if (oldPath == null) break block4;
                string = oldPath;
                if (map != null) break block5;
            }
            throw new MatchError(tuple2);
        }
        Map map2 = map;
        Tuple2 tuple2 = new Tuple2((Object)string, (Object)map2);
        Tuple2 tuple22 = tuple2;
        String oldPath = (String)tuple22._1();
        Map map3 = (Map)tuple22._2();
        if (this.exists(newId)) {
            throw new ItemAlreadyExistsException("The destination id [%s] exists.", new Object[]{newId});
        }
    }

    public MoveCommand(JdbcTemplate jdbcTemplate, ArtifactRepository artifactRepository, CommandValidator commandValidator, Iterable<Tuple<String, String>> moveCis, SqlDialect sqlDialect) {
        this.commandValidator = commandValidator;
        this.moveCis = moveCis;
        this.sqlDialect = sqlDialect;
        super(jdbcTemplate, artifactRepository);
        CiPathValidation.$init$(this);
    }
}

