/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.jetty;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.springframework.context.Lifecycle;
import org.springframework.core.NamedThreadLocal;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.socket.WebSocketExtension;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.adapter.jetty.JettyWebSocketHandlerAdapter;
import org.springframework.web.socket.adapter.jetty.JettyWebSocketSession;
import org.springframework.web.socket.adapter.jetty.WebSocketToJettyExtensionConfigAdapter;
import org.springframework.web.socket.server.HandshakeFailureException;
import org.springframework.web.socket.server.RequestUpgradeStrategy;

public class JettyRequestUpgradeStrategy
implements RequestUpgradeStrategy,
ServletContextAware,
Lifecycle {
    private static final ThreadLocal<WebSocketHandlerContainer> containerHolder = new NamedThreadLocal("WebSocketHandlerContainer");
    private WebSocketPolicy policy;
    private WebSocketServerFactory factory;
    private ServletContext servletContext;
    private volatile boolean running = false;
    private volatile List<WebSocketExtension> supportedExtensions;

    public JettyRequestUpgradeStrategy() {
        this.policy = WebSocketPolicy.newServerPolicy();
    }

    public JettyRequestUpgradeStrategy(WebSocketPolicy policy) {
        Assert.notNull((Object)policy, (String)"WebSocketPolicy must not be null");
        this.policy = policy;
    }

    public JettyRequestUpgradeStrategy(WebSocketServerFactory factory) {
        Assert.notNull((Object)factory, (String)"WebSocketServerFactory must not be null");
        this.factory = factory;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void start() {
        if (!this.isRunning()) {
            this.running = true;
            try {
                if (this.factory == null) {
                    this.factory = new WebSocketServerFactory(this.servletContext, this.policy);
                }
                this.factory.setCreator(new WebSocketCreator(){

                    public Object createWebSocket(ServletUpgradeRequest request, ServletUpgradeResponse response) {
                        WebSocketHandlerContainer container = (WebSocketHandlerContainer)containerHolder.get();
                        Assert.state((container != null ? 1 : 0) != 0, (String)"Expected WebSocketHandlerContainer");
                        response.setAcceptedSubProtocol(container.getSelectedProtocol());
                        response.setExtensions(container.getExtensionConfigs());
                        return container.getHandler();
                    }
                });
                this.factory.start();
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Unable to start Jetty WebSocketServerFactory", ex);
            }
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.running = false;
            if (this.factory != null) {
                try {
                    this.factory.stop();
                }
                catch (Throwable ex) {
                    throw new IllegalStateException("Unable to stop Jetty WebSocketServerFactory", ex);
                }
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public String[] getSupportedVersions() {
        return new String[]{String.valueOf(13)};
    }

    @Override
    public List<WebSocketExtension> getSupportedExtensions(ServerHttpRequest request) {
        if (this.supportedExtensions == null) {
            this.supportedExtensions = this.buildWebSocketExtensions();
        }
        return this.supportedExtensions;
    }

    private List<WebSocketExtension> buildWebSocketExtensions() {
        Set names = this.factory.getExtensionFactory().getExtensionNames();
        ArrayList<WebSocketExtension> result = new ArrayList<WebSocketExtension>(names.size());
        for (String name : names) {
            result.add(new WebSocketExtension(name));
        }
        return result;
    }

    @Override
    public void upgrade(ServerHttpRequest request, ServerHttpResponse response, String selectedProtocol, List<WebSocketExtension> selectedExtensions, Principal user, WebSocketHandler wsHandler, Map<String, Object> attributes) throws HandshakeFailureException {
        Assert.isInstanceOf(ServletServerHttpRequest.class, (Object)request, (String)"ServletServerHttpRequest required");
        HttpServletRequest servletRequest = ((ServletServerHttpRequest)request).getServletRequest();
        Assert.isInstanceOf(ServletServerHttpResponse.class, (Object)response, (String)"ServletServerHttpResponse required");
        HttpServletResponse servletResponse = ((ServletServerHttpResponse)response).getServletResponse();
        Assert.isTrue((boolean)this.factory.isUpgradeRequest(servletRequest, servletResponse), (String)"Not a WebSocket handshake");
        JettyWebSocketSession session = new JettyWebSocketSession(attributes, user);
        JettyWebSocketHandlerAdapter handlerAdapter = new JettyWebSocketHandlerAdapter(wsHandler, session);
        WebSocketHandlerContainer container = new WebSocketHandlerContainer(handlerAdapter, selectedProtocol, selectedExtensions);
        try {
            containerHolder.set(container);
            this.factory.acceptWebSocket(servletRequest, servletResponse);
        }
        catch (IOException ex) {
            throw new HandshakeFailureException("Response update failed during upgrade to WebSocket: " + request.getURI(), ex);
        }
        finally {
            containerHolder.remove();
        }
    }

    private static class WebSocketHandlerContainer {
        private final JettyWebSocketHandlerAdapter handler;
        private final String selectedProtocol;
        private final List<ExtensionConfig> extensionConfigs;

        public WebSocketHandlerContainer(JettyWebSocketHandlerAdapter handler, String protocol, List<WebSocketExtension> extensions) {
            this.handler = handler;
            this.selectedProtocol = protocol;
            if (CollectionUtils.isEmpty(extensions)) {
                this.extensionConfigs = new ArrayList<ExtensionConfig>(0);
            } else {
                this.extensionConfigs = new ArrayList<ExtensionConfig>(extensions.size());
                for (WebSocketExtension extension : extensions) {
                    this.extensionConfigs.add(new WebSocketToJettyExtensionConfigAdapter(extension));
                }
            }
        }

        public JettyWebSocketHandlerAdapter getHandler() {
            return this.handler;
        }

        public String getSelectedProtocol() {
            return this.selectedProtocol;
        }

        public List<ExtensionConfig> getExtensionConfigs() {
            return this.extensionConfigs;
        }
    }
}

