/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.telnetd.io.toolkit;

import java.io.IOException;
import java.util.Vector;
import net.wimpi.telnetd.io.BasicTerminalIO;
import net.wimpi.telnetd.io.toolkit.ActiveComponent;

public class Selection
extends ActiveComponent {
    private Vector m_Options = new Vector(10, 5);
    private int m_Selected = 0;
    private int m_LastSelected = 0;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;

    public Selection(BasicTerminalIO io, String name) {
        super(io, name);
    }

    public void addOption(String str) {
        this.m_Options.addElement(str);
    }

    public void insertOption(String str, int index) {
        try {
            this.m_Options.insertElementAt(str, index);
        }
        catch (ArrayIndexOutOfBoundsException aex) {
            this.addOption(str);
        }
    }

    public void removeOption(String str) {
        for (int i = 0; i < this.m_Options.size(); ++i) {
            if (!((String)this.m_Options.elementAt(i)).equals(str)) continue;
            this.removeOption(i);
            return;
        }
    }

    public void removeOption(int index) {
        try {
            this.m_Options.removeElementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public String getOption(int index) {
        try {
            Object o = this.m_Options.elementAt(index);
            if (o != null) {
                return (String)o;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    public int getSelected() {
        return this.m_Selected;
    }

    public void setSelected(int index) throws IOException {
        if (index < 0 || index > this.m_Options.size()) {
            return;
        }
        this.m_LastSelected = this.m_Selected;
        this.m_Selected = index;
        this.draw();
    }

    public void run() throws IOException {
        int in = 0;
        this.draw();
        this.m_IO.flush();
        do {
            in = this.m_IO.read();
            switch (in) {
                case 1001: 
                case 1004: {
                    if (this.selectPrevious()) break;
                    this.m_IO.bell();
                    break;
                }
                case 1002: 
                case 1003: {
                    if (this.selectNext()) break;
                    this.m_IO.bell();
                    break;
                }
                case 10: 
                case 1301: {
                    in = -1;
                    break;
                }
                default: {
                    this.m_IO.bell();
                }
            }
            this.m_IO.flush();
        } while (in != -1);
    }

    public void draw() throws IOException {
        String opttext = this.getOption(this.m_Selected);
        int diff = this.getOption(this.m_LastSelected).length() - opttext.length();
        if (diff > 0) {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append(opttext);
            for (int i = 0; i < diff; ++i) {
                sbuf.append(" ");
            }
            opttext = sbuf.toString();
        }
        if (this.m_Position != null) {
            this.m_IO.setCursor(this.m_Position.getRow(), this.m_Position.getColumn());
        }
        this.m_IO.write(opttext);
        this.m_IO.moveLeft(opttext.length());
    }

    private boolean selectNext() throws IOException {
        if (this.m_Selected < this.m_Options.size() - 1) {
            this.setSelected(this.m_Selected + 1);
            return true;
        }
        return false;
    }

    private boolean selectPrevious() throws IOException {
        if (this.m_Selected > 0) {
            this.setSelected(this.m_Selected - 1);
            return true;
        }
        return false;
    }
}

