/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.logbuffer.LogBufferDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.agrona.CloseHelper;
import org.agrona.IoUtil;
import org.agrona.concurrent.UnsafeBuffer;

public class LogBuffers
implements AutoCloseable {
    private final int termLength;
    private final FileChannel fileChannel;
    private final UnsafeBuffer[] termBuffers = new UnsafeBuffer[3];
    private final UnsafeBuffer logMetaDataBuffer;
    private final MappedByteBuffer[] mappedByteBuffers;

    public LogBuffers(String logFileName, FileChannel.MapMode mapMode) {
        try {
            this.fileChannel = FileChannel.open(Paths.get(logFileName, new String[0]), StandardOpenOption.READ, StandardOpenOption.WRITE);
            long logLength = this.fileChannel.size();
            int termLength = LogBufferDescriptor.computeTermLength(logLength);
            LogBufferDescriptor.checkTermLength(termLength);
            this.termLength = termLength;
            if (logLength < Integer.MAX_VALUE) {
                MappedByteBuffer mappedBuffer = this.fileChannel.map(mapMode, 0L, logLength);
                this.mappedByteBuffers = new MappedByteBuffer[]{mappedBuffer};
                for (int i = 0; i < 3; ++i) {
                    this.termBuffers[i] = new UnsafeBuffer((ByteBuffer)mappedBuffer, i * termLength, termLength);
                }
                this.logMetaDataBuffer = new UnsafeBuffer((ByteBuffer)mappedBuffer, (int)(logLength - (long)LogBufferDescriptor.LOG_META_DATA_LENGTH), LogBufferDescriptor.LOG_META_DATA_LENGTH);
            } else {
                MappedByteBuffer metaDataMappedBuffer;
                this.mappedByteBuffers = new MappedByteBuffer[4];
                for (int i = 0; i < 3; ++i) {
                    this.mappedByteBuffers[i] = this.fileChannel.map(mapMode, (long)termLength * (long)i, termLength);
                    this.termBuffers[i] = new UnsafeBuffer((ByteBuffer)this.mappedByteBuffers[i]);
                }
                this.mappedByteBuffers[this.mappedByteBuffers.length - 1] = metaDataMappedBuffer = this.fileChannel.map(mapMode, logLength - (long)LogBufferDescriptor.LOG_META_DATA_LENGTH, LogBufferDescriptor.LOG_META_DATA_LENGTH);
                this.logMetaDataBuffer = new UnsafeBuffer((ByteBuffer)metaDataMappedBuffer);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        for (UnsafeBuffer buffer : this.termBuffers) {
            buffer.verifyAlignment();
        }
        this.logMetaDataBuffer.verifyAlignment();
    }

    public UnsafeBuffer[] termBuffers() {
        return this.termBuffers;
    }

    public UnsafeBuffer metaDataBuffer() {
        return this.logMetaDataBuffer;
    }

    public FileChannel fileChannel() {
        return this.fileChannel;
    }

    @Override
    public void close() {
        for (MappedByteBuffer buffer : this.mappedByteBuffers) {
            IoUtil.unmap((MappedByteBuffer)buffer);
        }
        CloseHelper.close((AutoCloseable)this.fileChannel);
    }

    public int termLength() {
        return this.termLength;
    }
}

