/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class IntIterator
implements Iterator<Integer> {
    private int remaining;
    private int positionCounter;
    private int stopCounter;
    protected boolean isPositionValid = false;
    private int[] values;
    private boolean containsMissingValue;

    protected IntIterator() {
    }

    void reset(int[] values, boolean containsMissingValue, int size) {
        int length;
        this.values = values;
        this.containsMissingValue = containsMissingValue;
        this.remaining = size;
        int i = length = values.length;
        if (values[length - 1] != -1) {
            for (i = 0; i < length && values[i] != -1; ++i) {
            }
        }
        this.stopCounter = i;
        this.positionCounter = i + length;
        this.isPositionValid = false;
    }

    protected int position() {
        return this.positionCounter & this.values.length - 1;
    }

    @Override
    public boolean hasNext() {
        return this.remaining > 0;
    }

    public int remaining() {
        return this.remaining;
    }

    @Override
    public Integer next() {
        return this.nextValue();
    }

    public int nextValue() {
        this.findNext();
        if (this.remaining == 1 && this.containsMissingValue) {
            return -1;
        }
        return this.values[this.position()];
    }

    protected void findNext() {
        int[] values = this.values;
        int mask = values.length - 1;
        this.isPositionValid = true;
        for (int i = this.positionCounter - 1; i >= this.stopCounter; --i) {
            int index = i & mask;
            if (values[index] == -1) continue;
            this.positionCounter = i;
            --this.remaining;
            return;
        }
        if (this.containsMissingValue) {
            --this.remaining;
            return;
        }
        this.isPositionValid = false;
        throw new NoSuchElementException();
    }
}

