/*
 * Decompiled with CFR 0.152.
 */
package akka.http.scaladsl.server.directives;

import akka.http.impl.util.EnhancedString$;
import akka.http.impl.util.package$;
import akka.http.scaladsl.marshalling.ContentTypeOverrider$;
import akka.http.scaladsl.marshalling.Marshaller;
import akka.http.scaladsl.marshalling.Marshaller$;
import akka.http.scaladsl.model.DateTime$;
import akka.http.scaladsl.model.MediaType;
import akka.http.scaladsl.model.MediaTypes$;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.server.directives.DirectoryListing;
import java.io.File;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DirectoryListing$
implements scala.Serializable {
    public static DirectoryListing$ MODULE$;
    private final String[] html;

    static {
        new DirectoryListing$();
    }

    private String[] html() {
        return this.html;
    }

    public Marshaller<DirectoryListing, RequestEntity> directoryMarshaller(boolean renderVanityFooter) {
        return Marshaller$.MODULE$.StringMarshaller().wrapWithEC((MediaType)MediaTypes$.MODULE$.text$divhtml(), (Function1 & Serializable & scala.Serializable)ec -> (Function1 & Serializable & scala.Serializable)listing -> {
            Object object;
            DirectoryListing directoryListing = listing;
            if (directoryListing == null) {
                throw new MatchError((Object)directoryListing);
            }
            String path = directoryListing.path();
            boolean isRoot = directoryListing.isRoot();
            Seq<File> files = directoryListing.files();
            Tuple3 tuple3 = new Tuple3((Object)path, (Object)BoxesRunTime.boxToBoolean((boolean)isRoot), files);
            Tuple3 tuple32 = tuple3;
            String path2 = (String)tuple32._1();
            boolean isRoot2 = BoxesRunTime.unboxToBoolean((Object)tuple32._2());
            Seq files2 = (Seq)tuple32._3();
            Seq filesAndNames = (Seq)((SeqLike)files2.map((Function1 & Serializable & scala.Serializable)file -> Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(file), (Object)file.getName()), Seq$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$6 -> (String)x$6._2(), (Ordering)Ordering.String$.MODULE$);
            Seq deduped = (Seq)((TraversableLike)filesAndNames.zipWithIndex(Seq$.MODULE$.canBuildFrom())).flatMap(arg_0 -> DirectoryListing$.$anonfun$directoryMarshaller$7(filesAndNames, arg_0), Seq$.MODULE$.canBuildFrom());
            Tuple2 tuple2 = deduped.partition((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DirectoryListing$.$anonfun$directoryMarshaller$8(x$7)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq directoryFilesAndNames = (Seq)tuple2._1();
            Seq fileFilesAndNames = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)directoryFilesAndNames, (Object)fileFilesAndNames);
            Tuple2 tuple23 = tuple22;
            Seq directoryFilesAndNames2 = (Seq)tuple23._1();
            Seq fileFilesAndNames2 = (Seq)tuple23._2();
            int maxNameLen = scala.math.package$.MODULE$.max(DirectoryListing$.maxNameLength$1(directoryFilesAndNames2) + 1, DirectoryListing$.maxNameLength$1(fileFilesAndNames2));
            StringBuilder sb = new StringBuilder();
            sb.append(this.html()[0]).append(path2).append(this.html()[1]).append(path2).append(this.html()[2]);
            if (!isRoot2) {
                int secondToLastSlash = path2.lastIndexOf(47, path2.lastIndexOf(47, path2.length() - 1) - 1);
                object = sb.append(new StringOps(Predef$.MODULE$.augmentString("<a href=\"%s/\">../</a>\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path2.substring(0, secondToLastSlash)})));
            } else {
                object = BoxedUnit.UNIT;
            }
            directoryFilesAndNames2.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)DirectoryListing$.$anonfun$directoryMarshaller$10(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                Tuple2 tuple2 = x$10;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                File file = (File)tuple2._1();
                String name = (String)tuple2._2();
                StringBuilder stringBuilder = DirectoryListing$.renderDirectory$1(file, name, path2, maxNameLen, sb);
                return stringBuilder;
            });
            fileFilesAndNames2.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)DirectoryListing$.$anonfun$directoryMarshaller$12(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
                Tuple2 tuple2 = x$11;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                File file = (File)tuple2._1();
                String name = (String)tuple2._2();
                StringBuilder stringBuilder = DirectoryListing$.renderFile$1(file, name, path2, maxNameLen, sb);
                return stringBuilder;
            });
            Object object2 = isRoot2 && files2.isEmpty() ? sb.append("(no files)\n") : BoxedUnit.UNIT;
            sb.append(this.html()[3]);
            Object object3 = renderVanityFooter ? sb.append(this.html()[4]).append(DateTime$.MODULE$.now().toIsoLikeDateTimeString()).append(this.html()[5]) : BoxedUnit.UNIT;
            return sb.append(this.html()[6]).toString();
        }, ContentTypeOverrider$.MODULE$.forEntity());
    }

    public DirectoryListing apply(String path, boolean isRoot, Seq<File> files) {
        return new DirectoryListing(path, isRoot, files);
    }

    public Option<Tuple3<String, Object, Seq<File>>> unapply(DirectoryListing x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.path(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.isRoot()), x$0.files()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Iterable $anonfun$directoryMarshaller$7(Seq filesAndNames$1, Tuple2 x0$1) {
        block3: {
            block2: {
                var3_2 = x0$1;
                if (var3_2 == null) break block2;
                fan = (Tuple2)var3_2._1();
                ix = var3_2._2$mcI$sp();
                if (fan == null) break block2;
                name = (String)fan._2();
                if (ix == 0) ** GOTO lbl-1000
                v0 = ((Tuple2)filesAndNames$1.apply(ix - 1))._2();
                var7_6 = name;
                if (v0 == null ? var7_6 != null : v0.equals(var7_6) == false) lbl-1000:
                // 2 sources

                {
                    v1 = Option$.MODULE$.option2Iterable((Option)new Some((Object)fan));
                } else {
                    v1 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                break block3;
            }
            throw new MatchError((Object)var3_2);
        }
        var2_7 = v1;
        return var2_7;
    }

    public static final /* synthetic */ boolean $anonfun$directoryMarshaller$8(Tuple2 x$7) {
        return ((File)x$7._1()).isDirectory();
    }

    public static final /* synthetic */ int $anonfun$directoryMarshaller$9(Tuple2 x$9) {
        return ((String)x$9._2()).length();
    }

    private static final int maxNameLength$1(Seq seq) {
        return seq.isEmpty() ? 0 : BoxesRunTime.unboxToInt((Object)((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)DirectoryListing$.$anonfun$directoryMarshaller$9(x$9)), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
    }

    private static final String lastModified$2(File file) {
        return DateTime$.MODULE$.apply(file.lastModified()).toIsoLikeDateTimeString();
    }

    private static final StringBuilder start$1(String name, String path$2, int maxNameLen$1, StringBuilder sb$1) {
        return sb$1.append("<a href=\"").append(path$2 + name).append("\">").append(name).append("</a>").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(maxNameLen$1 - name.length()));
    }

    private static final StringBuilder renderDirectory$1(File file, String name, String path$2, int maxNameLen$1, StringBuilder sb$1) {
        return DirectoryListing$.start$1(name + '/', path$2, maxNameLen$1, sb$1).append("        ").append(DirectoryListing$.lastModified$2(file)).append('\n');
    }

    private static final StringBuilder renderFile$1(File file, String name, String path$2, int maxNameLen$1, StringBuilder sb$1) {
        String size = package$.MODULE$.humanReadableByteCount(file.length(), true);
        DirectoryListing$.start$1(name, path$2, maxNameLen$1, sb$1).append("        ").append(DirectoryListing$.lastModified$2(file));
        return sb$1.append("                ".substring(size.length())).append(size).append('\n');
    }

    public static final /* synthetic */ boolean $anonfun$directoryMarshaller$10(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$directoryMarshaller$12(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    private DirectoryListing$() {
        MODULE$ = this;
        this.html = new StringOps(Predef$.MODULE$.augmentString(EnhancedString$.MODULE$.stripMarginWithNewline$extension(package$.MODULE$.enhanceString_("<html>\n      |<head><title>Index of $</title></head>\n      |<body>\n      |<h1>Index of $</h1>\n      |<hr>\n      |<pre>\n      |$</pre>\n      |<hr>$\n      |<div style=\"width:100%;text-align:right;color:gray\">\n      |<small>rendered by <a href=\"http://akka.io\">Akka Http</a> on $</small>\n      |</div>$\n      |</body>\n      |</html>\n      |"), "\n"))).split('$');
    }
}

