/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.JcrQueryTemplateFactory;
import com.xebialabs.deployit.repository.QueryTemplate;
import com.xebialabs.deployit.repository.QueryTemplateFactory;
import com.xebialabs.deployit.repository.SearchParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchQueryBuilder {
    public static final String ESCAPE_CHARACTER = "\\";
    public static final String WILDCARD_CHARACTER = "%";
    static final char ESCAPE_CHAR = "\\".charAt(0);
    static final char WILDCARD_CHAR = "%".charAt(0);
    public static final String CI_SELECTOR_NAME = "ci";
    private static final String EQUALITY_OPERATOR = "=";
    private static final String LIKE_OPERATOR = "LIKE";
    private static final String NAME_IS_OPERATOR = "NAME_IS";
    private static final String NAME_LIKE_OPERATOR = "NAME_LIKE";
    private static final String ISCHILDNODE_OPERATOR = "ISCHILDNODE";
    private static final String ISDESCENDANTNODE_OPERATOR = "ISDESCENDANTNODE";
    private static final String CONTAINS_OPERATOR = "CONTAINS";
    private final SearchParameters parameters;
    private final StringBuilder joins;
    private final List<Condition> conditions;
    private int nextSelectorId = 1;
    private List<Type> baseTypes = Arrays.asList(Type.valueOf(ConfigurationItem.class), Type.valueOf(BaseConfigurationItem.class));
    private static final Logger logger = LoggerFactory.getLogger(SearchQueryBuilder.class);

    public SearchQueryBuilder(SearchParameters parameters) {
        this.parameters = parameters;
        this.joins = new StringBuilder();
        this.conditions = new ArrayList<Condition>();
    }

    protected QueryTemplate createTemplate() {
        return this.createTemplate(new JcrQueryTemplateFactory());
    }

    protected QueryTemplate createTemplate(QueryTemplateFactory factory) {
        this.createJoinsAndConditions();
        String queryString = this.constructQueryString();
        QueryTemplate template = factory.createTemplate(queryString);
        this.addParameters(template);
        template.setResultsPerPage(this.parameters.getResultsPerPage());
        template.setPage(this.parameters.getPage());
        template.setDepth(this.parameters.getDepth());
        return template;
    }

    private String constructQueryString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ci.* FROM [deployit:configurationItem] AS ci");
        builder.append(this.joins.toString());
        if (!this.conditions.isEmpty()) {
            builder.append(" WHERE ");
            builder.append(String.join((CharSequence)" AND ", this.conditions.stream().map(Condition::build).collect(Collectors.toList())));
        }
        builder.append(" ORDER BY NAME(ci)");
        logger.trace("Query string built: {}", (Object)builder.toString());
        return builder.toString();
    }

    private void addParameters(QueryTemplate query) {
        for (Condition condition : this.conditions) {
            if (condition.parameter == null) continue;
            for (int i = 0; i < condition.values.length; ++i) {
                String key = condition.parameter + i;
                Object value = condition.values[i];
                query.setParameter(key, value);
                logger.trace("Bound {} to {}", (Object)key, value);
            }
        }
    }

    private void createJoinsAndConditions() {
        this.createConditionForParent();
        this.createConditionForAncestor();
        this.createConditionForName();
        this.createConditionForConfigurationItemTypeName();
        this.createConditionForDate();
        this.createConditionsForProperties();
        this.createConditionsForOrExpression();
        this.createConditionsForTextSearch();
    }

    private void createConditionForConfigurationItemTypeName() {
        if (this.parameters.getType() != null && !this.isBaseType(this.parameters.getType())) {
            ArrayList<String> types = new ArrayList<String>();
            types.add(this.parameters.getType().toString());
            for (Type subtype : DescriptorRegistry.getSubtypes((Type)this.parameters.getType())) {
                types.add(subtype.toString());
            }
            this.conditions.add(Condition.from(CI_SELECTOR_NAME, "$configuration.item.type", "_configurationItemTypeName", EQUALITY_OPERATOR, false, types.toArray(new Object[types.size()])));
        }
    }

    private boolean isBaseType(Type type) {
        return this.baseTypes.contains(type);
    }

    private void createConditionForParent() {
        if (Strings.isNotBlank((String)this.parameters.getParent())) {
            String parent = this.parameters.getParent();
            if (!parent.startsWith("/")) {
                parent = "/" + parent;
            }
            this.conditions.add(Condition.isChildNode(CI_SELECTOR_NAME, parent));
        }
    }

    private void createConditionForAncestor() {
        if (Strings.isNotBlank((String)this.parameters.getAncestor())) {
            String ancestor = this.parameters.getAncestor();
            if (!ancestor.startsWith("/")) {
                ancestor = "/" + ancestor;
            }
            this.conditions.add(Condition.isDescendantNode(CI_SELECTOR_NAME, ancestor));
        }
    }

    private void createConditionForName() {
        String name = this.parameters.getName();
        if (Strings.isNotBlank((String)name)) {
            if (this.parameters.isExactNameSearch()) {
                this.conditions.add(Condition.nameIs(CI_SELECTOR_NAME, this.parameters.getName()));
            } else if (name.contains(WILDCARD_CHARACTER)) {
                if (SearchQueryBuilder.isWildCardBasedNameSearch(name)) {
                    this.conditions.add(Condition.nameLike(CI_SELECTOR_NAME, name));
                } else {
                    this.conditions.add(Condition.nameIs(CI_SELECTOR_NAME, SearchQueryBuilder.unescapeWildCard(name)));
                }
            } else {
                this.conditions.add(Condition.nameIs(CI_SELECTOR_NAME, name));
            }
        }
    }

    static String unescapeWildCard(String name) {
        return name.replace("\\%", WILDCARD_CHARACTER);
    }

    static boolean isWildCardBasedNameSearch(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch != WILDCARD_CHAR) continue;
            if (i == 0) {
                return true;
            }
            if (name.charAt(i - 1) == ESCAPE_CHAR) continue;
            return true;
        }
        return false;
    }

    private void createConditionForDate() {
        this.createConditionForDate(this.parameters.getBefore(), "_before", "<=");
        this.createConditionForDate(this.parameters.getAfter(), "_after", ">=");
    }

    private void createConditionForDate(Calendar field, String parameter, String operator) {
        if (field != null) {
            this.conditions.add(Condition.from(CI_SELECTOR_NAME, "$lastModified", parameter, operator, field));
        }
    }

    private void createConditionsForProperties() {
        for (Map.Entry entry : this.parameters.getProperties().entrySet()) {
            this.createConditionForProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void createConditionForProperty(String propertyName, String propertyValue) {
        PropertyDescriptor propertyDescriptor;
        Descriptor descriptor;
        if (this.parameters.getType() != null && (descriptor = DescriptorRegistry.getDescriptor((Type)this.parameters.getType())) != null && (propertyDescriptor = descriptor.getPropertyDescriptor(propertyName)) != null) {
            if (propertyDescriptor.getKind() == PropertyKind.CI) {
                String selectorName = "referenced" + this.nextSelectorId;
                this.joins.append(" INNER JOIN [deployit:configurationItem] AS " + selectorName + " ON " + CI_SELECTOR_NAME + ".[" + propertyName + "] = " + selectorName + ".[jcr:uuid]");
                int lastSlash = propertyValue.lastIndexOf(47);
                Checks.checkArgument((lastSlash != -1 ? 1 : 0) != 0, (String)(propertyValue + " is a ID but does not contain a slash (/)"), (Object[])new Object[0]);
                String parent = JcrPathHelper.getAbsolutePathFromId(propertyValue.substring(0, lastSlash));
                String name = propertyValue.substring(lastSlash + 1);
                this.conditions.add(Condition.isChildNode(selectorName, parent));
                this.conditions.add(Condition.nameIs(selectorName, name));
                ++this.nextSelectorId;
                return;
            }
            if (propertyDescriptor.getKind() == PropertyKind.SET_OF_CI || propertyDescriptor.getKind() == PropertyKind.LIST_OF_CI) {
                throw new IllegalArgumentException("Cannot query property " + propertyDescriptor + " because it is of type SET_OF_CIS");
            }
        }
        this.conditions.add(Condition.match(CI_SELECTOR_NAME, propertyName, propertyName, propertyValue));
    }

    private void createConditionsForOrExpression() {
        for (Map.Entry prop : this.parameters.getOrPropertiesExpression().entrySet()) {
            String propertyName = (String)prop.getKey();
            Set<Object> orValues = ((Set)prop.getValue()).stream().map(e -> e.toLowerCase(Locale.ENGLISH)).collect(Collectors.toSet());
            this.conditions.add(Condition.from(CI_SELECTOR_NAME, propertyName, propertyName, EQUALITY_OPERATOR, true, orValues.toArray(new Object[orValues.size()])));
        }
    }

    private void createConditionsForTextSearch() {
        int count = 0;
        for (Map.Entry query : this.parameters.getTextSearchQueries().entrySet()) {
            this.conditions.add(Condition.textSearch((String)query.getKey(), (String)query.getValue(), "textSearch" + count + "_"));
        }
    }

    private static class Condition {
        String selector;
        String field;
        String operator;
        String parameter;
        Object[] values;
        boolean caseInsensitive;
        private static final String NAME_IS_FORMAT = "NAME(%s) = '%s'";
        private static final String NAME_LIKE_FORMAT = "LOWER(NAME(%s)) LIKE '%s'";
        private static final String ISCHILDNODE_FORMAT = "ISCHILDNODE(%s, ['%s'])";
        private static final String ISDESCENDANTNODE_FORMAT = "ISDESCENDANTNODE(%s, ['%s'])";
        private static final String CONTAINS_FORMAT = "contains(%s.[%s], $%s)";
        private static final String CASE_SENSITIVE = "%s.[%s] %s $%s";
        private static final String CASE_INSENSITIVE = "LOWER(%s.[%s]) %s $%s";

        private Condition() {
        }

        String build() {
            StringBuilder conditionString = new StringBuilder();
            conditionString.append("(");
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    conditionString.append(" OR ");
                }
                if (this.operator.equals(SearchQueryBuilder.NAME_IS_OPERATOR)) {
                    conditionString.append(String.format(NAME_IS_FORMAT, this.selector, this.escapeSingleQuote(this.values[i])));
                    continue;
                }
                if (this.operator.equals(SearchQueryBuilder.NAME_LIKE_OPERATOR)) {
                    conditionString.append(String.format(NAME_LIKE_FORMAT, this.selector, this.escapeSingleQuote(this.values[i])));
                    continue;
                }
                if (this.operator.equals(SearchQueryBuilder.ISCHILDNODE_OPERATOR)) {
                    conditionString.append(String.format(ISCHILDNODE_FORMAT, this.selector, this.escapeSingleQuote(this.values[i])));
                    continue;
                }
                if (this.operator.equals(SearchQueryBuilder.ISDESCENDANTNODE_OPERATOR)) {
                    conditionString.append(String.format(ISDESCENDANTNODE_FORMAT, this.selector, this.escapeSingleQuote(this.values[i])));
                    continue;
                }
                if (this.operator.equals(SearchQueryBuilder.CONTAINS_OPERATOR)) {
                    conditionString.append(String.format(CONTAINS_FORMAT, this.selector, this.field, this.parameter + i));
                    continue;
                }
                conditionString.append(String.format(this.caseInsensitive ? CASE_INSENSITIVE : CASE_SENSITIVE, this.selector, this.field, this.operator, this.parameter + i));
            }
            conditionString.append(")");
            return conditionString.toString();
        }

        private String escapeSingleQuote(Object value) {
            return ((String)value).replaceAll("'", "''");
        }

        static Condition match(String selector, String field, String parameter, String value) {
            boolean caseInsensitive;
            String operator;
            if (value.contains(SearchQueryBuilder.WILDCARD_CHARACTER)) {
                operator = SearchQueryBuilder.LIKE_OPERATOR;
                caseInsensitive = true;
            } else {
                operator = SearchQueryBuilder.EQUALITY_OPERATOR;
                caseInsensitive = false;
            }
            return Condition.from(selector, field, parameter, operator, caseInsensitive, value);
        }

        static Condition nameIs(String selector, String value) {
            return Condition.from(selector, null, null, SearchQueryBuilder.NAME_IS_OPERATOR, false, value);
        }

        static Condition nameLike(String selector, String value) {
            return Condition.from(selector, null, null, SearchQueryBuilder.NAME_LIKE_OPERATOR, false, value.toLowerCase());
        }

        static Condition isChildNode(String selector, String value) {
            return Condition.from(selector, null, null, SearchQueryBuilder.ISCHILDNODE_OPERATOR, false, value);
        }

        static Condition isDescendantNode(String selector, String value) {
            return Condition.from(selector, null, null, SearchQueryBuilder.ISDESCENDANTNODE_OPERATOR, false, value);
        }

        static Condition textSearch(String property, String textQuery, String parameterName) {
            return Condition.from(SearchQueryBuilder.CI_SELECTOR_NAME, property, parameterName, SearchQueryBuilder.CONTAINS_OPERATOR, false, textQuery);
        }

        static Condition from(String selector, String field, String parameter, String operator, Object value) {
            return Condition.from(selector, field, parameter, operator, false, value);
        }

        static Condition from(String selector, String field, String parameter, String operator, boolean caseInsensitive, Object ... values) {
            Condition t = new Condition();
            t.selector = selector;
            t.field = field;
            t.parameter = parameter;
            t.operator = operator;
            t.caseInsensitive = caseInsensitive;
            t.values = values;
            return t;
        }
    }
}

