/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.io;

import com.xebialabs.deployit.util.DevNull;
import com.xebialabs.deployit.util.GuavaFiles;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Exploder {
    private static final Logger logger = LoggerFactory.getLogger(Exploder.class);

    public static void explode(Supplier<InputStream> inputZip, File outputDirectory, MessageDigest sha1) throws IOException {
        Exploder.explode(inputZip, outputDirectory, sha1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void explode(Supplier<InputStream> inputZip, File outputDirectory, MessageDigest sha1, boolean digestPaths) throws IOException {
        try (ZipInputStream zipEntryStream = new ZipInputStream(inputZip.get());){
            while (true) {
                ZipEntry entry;
                if ((entry = zipEntryStream.getNextEntry()) == null) {
                    return;
                }
                try {
                    File destinationDir;
                    if (sha1 != null) {
                        Exploder.digestEntryPath(sha1, entry, digestPaths);
                    }
                    if (entry.isDirectory()) {
                        File file = new File(outputDirectory, entry.getName());
                        if (file.exists()) continue;
                        OverthereUtils.checkState((boolean)file.mkdirs(), (String)"Could not create directory: %s", (Object[])new Object[]{entry.getName()});
                        continue;
                    }
                    File destinationFile = new File(outputDirectory, entry.getName());
                    String parentDirPath = destinationFile.getParent();
                    if (parentDirPath != null && !(destinationDir = new File(parentDirPath)).exists()) {
                        OverthereUtils.checkState((boolean)destinationDir.mkdirs(), (String)"Could not create directory: %s", (Object[])new Object[]{entry.getName()});
                    }
                    OverthereUtils.checkState((boolean)destinationFile.createNewFile(), (String)"Could not create file: %s", (Object[])new Object[]{entry.getName()});
                    FileOutputStream fo = new FileOutputStream(destinationFile);
                    Throwable throwable2 = null;
                    try {
                        FilterInputStream from = zipEntryStream;
                        if (sha1 != null) {
                            from = new DigestInputStream(zipEntryStream, sha1);
                        }
                        OverthereUtils.write((InputStream)from, (OutputStream)fo);
                        continue;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (fo == null) continue;
                        if (throwable2 != null) {
                            try {
                                fo.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        fo.close();
                        continue;
                    }
                }
                finally {
                    zipEntryStream.closeEntry();
                    continue;
                }
                break;
            }
        }
        catch (IOException exc) {
            try {
                GuavaFiles.deleteRecursively(outputDirectory);
                throw exc;
            }
            catch (Exception e) {
                logger.error("Could not delete {}", (Object)outputDirectory, (Object)e);
            }
            throw exc;
        }
    }

    public static void calculateCheckSum(Supplier<InputStream> inputZip, MessageDigest sha1) throws IOException {
        Exploder.calculateCheckSum(inputZip, sha1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void calculateCheckSum(Supplier<InputStream> inputZip, MessageDigest sha1, boolean digestPaths) throws IOException {
        try (ZipInputStream zipEntryStream = new ZipInputStream(inputZip.get());){
            while (true) {
                ZipEntry entry;
                if ((entry = zipEntryStream.getNextEntry()) == null) {
                    return;
                }
                try {
                    Exploder.digestEntryPath(sha1, entry, digestPaths);
                    if (entry.isDirectory()) continue;
                    OverthereUtils.write((InputStream)new DigestInputStream(zipEntryStream, sha1), (OutputStream)new DevNull());
                    continue;
                }
                finally {
                    zipEntryStream.closeEntry();
                    continue;
                }
                break;
            }
        }
    }

    private static void digestEntryPath(MessageDigest sha1, ZipEntry zipEntry, boolean digestPaths) throws UnsupportedEncodingException {
        if (digestPaths) {
            sha1.update(zipEntry.getName().getBytes(StandardCharsets.UTF_8));
        }
    }
}

