/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.ser.JodaDateSerializerBase;
import java.io.IOException;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class LocalDateSerializer
extends JodaDateSerializerBase<LocalDate> {
    private static final long serialVersionUID = 1L;

    public LocalDateSerializer() {
        this(FormatConfig.DEFAULT_LOCAL_DATEONLY_FORMAT);
    }

    public LocalDateSerializer(JacksonJodaDateFormat format) {
        super(LocalDate.class, format, true, SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    public LocalDateSerializer withFormat(JacksonJodaDateFormat formatter) {
        return this._format == formatter ? this : new LocalDateSerializer(formatter);
    }

    public void serialize(LocalDate value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this._useTimestamp(provider)) {
            gen.writeStartArray();
            gen.writeNumber(value.year().get());
            gen.writeNumber(value.monthOfYear().get());
            gen.writeNumber(value.dayOfMonth().get());
            gen.writeEndArray();
        } else {
            gen.writeString(this._format.createFormatter(provider).print((ReadablePartial)value));
        }
    }
}

