/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.util;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.conversion.Base64Coder;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.security.SecretKeyHolder;
import com.xebialabs.overthere.util.OverthereUtils;
import java.security.GeneralSecurityException;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class PasswordEncrypter {
    private static final Base64Coder BASE_64_CODER = new Base64Coder();
    private static final AtomicReference<PasswordEncrypter> instance = new AtomicReference();
    private final SecretKeyHolder encryptionKeyHolder;

    public PasswordEncrypter(SecretKeyHolder encryptionKeyHolder) {
        this.encryptionKeyHolder = encryptionKeyHolder;
    }

    public PasswordEncrypter(SecretKey passwordEncryptionKey) {
        this(new SecretKeyHolder(passwordEncryptionKey));
    }

    public static void init(SecretKey secretKey) {
        SecretKeyHolder.init(secretKey);
        instance.set(new PasswordEncrypter(SecretKeyHolder.get()));
    }

    public static PasswordEncrypter getInstance() {
        OverthereUtils.checkState((instance.get() != null ? 1 : 0) != 0, (String)"PasswordEncrypter not yet set, please construct one.", (Object[])new Object[0]);
        return instance.get();
    }

    public boolean isEncoded(String text) {
        try {
            BASE_64_CODER.decode(text.getBytes());
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public boolean isEncrypted(String text) {
        if (this.isEncoded(text)) {
            try {
                this.doDecodeAndDecrypt(text);
                return true;
            }
            catch (GeneralSecurityException e) {
                throw new IllegalStateException("Could not decrypt Base64 encoded password");
            }
        }
        return false;
    }

    public boolean isEncodedAndDecryptable(String text) {
        if (!this.isEncoded(text)) {
            return false;
        }
        try {
            this.doDecodeAndDecrypt(text);
        }
        catch (GeneralSecurityException e) {
            return false;
        }
        return true;
    }

    public String encrypt(String plaintext) {
        Checks.checkArgument(plaintext != null, "The password is null", new Object[0]);
        Checks.checkArgument(!plaintext.startsWith(BASE_64_CODER.identifier()), "The password contains the illegal sequence " + BASE_64_CODER.identifier(), new Object[0]);
        try {
            Cipher aes = this.encryptionKeyHolder.getEncryption();
            return new String(BASE_64_CODER.encode(aes.doFinal(plaintext.getBytes())));
        }
        catch (GeneralSecurityException e) {
            throw new DeployitException("Could not encrypt the password.");
        }
    }

    public String ensureEncrypted(String text) {
        if (this.isEncrypted(text)) {
            return text;
        }
        return this.encrypt(text);
    }

    public String decrypt(String encryptedText) {
        Checks.checkArgument(encryptedText != null, "The password is null", new Object[0]);
        Checks.checkArgument(encryptedText.startsWith(BASE_64_CODER.identifier()), "The password should be Base64 encoded", new Object[0]);
        try {
            return this.doDecodeAndDecrypt(encryptedText);
        }
        catch (GeneralSecurityException e) {
            throw new DeployitException("Could not decrypt the password.");
        }
    }

    public String ensureDecrypted(String text) {
        if (this.isEncrypted(text)) {
            return this.decrypt(text);
        }
        return text;
    }

    public String getKeyFingerprint() {
        return this.encryptionKeyHolder.getKeyFingerprint();
    }

    private String doDecodeAndDecrypt(String text) throws GeneralSecurityException {
        Cipher aes = this.encryptionKeyHolder.getDecryption();
        return new String(aes.doFinal(BASE_64_CODER.decode(text.getBytes())));
    }
}

