/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.repository.QueryTemplate;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class BaseQueryTemplate
implements QueryTemplate {
    protected final String queryString;
    protected final Map<String, Object> parameters = new LinkedHashMap<String, Object>();
    protected long page = 0L;
    protected long resultsPerPage = 0L;
    protected int depth = Integer.MAX_VALUE;

    public BaseQueryTemplate(String query) {
        this.queryString = query;
    }

    public BaseQueryTemplate(String query, Map<String, Object> parameters) {
        this.queryString = query;
        if (parameters != null && !parameters.isEmpty()) {
            this.parameters.putAll(parameters);
        }
    }

    @Override
    public QueryTemplate setParameter(String key, Object value) {
        this.parameters.put(key, value);
        return this;
    }

    @Override
    public QueryTemplate setPage(long page) {
        this.page = page;
        return this;
    }

    @Override
    public QueryTemplate setResultsPerPage(long resultsPerPage) {
        this.resultsPerPage = resultsPerPage;
        return this;
    }

    @Override
    public QueryTemplate setDepth(int depth) {
        this.depth = depth;
        return this;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }
}

