/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.logger.FormsLogger;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.properties.CompoundBorderProperty;
import com.jeta.forms.store.properties.DefaultBorderProperty;
import com.jeta.forms.store.properties.JETAProperty;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class ScrollBarsProperty
extends JETAProperty {
    static final long serialVersionUID = 9130862301613978006L;
    public static final int VERSION = 3;
    private int m_vert_policy = 20;
    private int m_horz_policy = 30;
    private String m_scroll_name;
    private CompoundBorderProperty m_scroll_border = null;
    public static final String PROPERTY_ID = "scollBars";

    public ScrollBarsProperty() {
        super(PROPERTY_ID);
        this.m_vert_policy = 20;
        this.m_horz_policy = 30;
    }

    public ScrollBarsProperty(int n, int n2) {
        super(PROPERTY_ID);
        this.m_vert_policy = n;
        this.m_horz_policy = n2;
    }

    public CompoundBorderProperty getBorderProperty() {
        return this.m_scroll_border;
    }

    public int getVerticalScrollBarPolicy() {
        return this.m_vert_policy;
    }

    public int getHorizontalScrollBarPolicy() {
        return this.m_horz_policy;
    }

    public String getScrollName() {
        return this.m_scroll_name;
    }

    public boolean isScrollable() {
        boolean bl = this.getVerticalScrollBarPolicy() != 21 || this.getHorizontalScrollBarPolicy() != 31;
        return bl;
    }

    public void setHorizontalScrollBarPolicy(int n) {
        this.m_horz_policy = n;
    }

    public void setVerticalScrollBarPolicy(int n) {
        this.m_vert_policy = n;
    }

    public void setScrollName(String string) {
        this.m_scroll_name = string;
    }

    public void setBorderProperty(CompoundBorderProperty compoundBorderProperty) {
        if (compoundBorderProperty == null) {
            this.m_scroll_border = null;
        } else {
            if (this.m_scroll_border == null) {
                this.m_scroll_border = new CompoundBorderProperty();
            }
            this.m_scroll_border.setValue(compoundBorderProperty);
        }
    }

    public void setValue(Object object) {
        if (object instanceof ScrollBarsProperty) {
            ScrollBarsProperty scrollBarsProperty = (ScrollBarsProperty)object;
            this.m_vert_policy = scrollBarsProperty.m_vert_policy;
            this.m_horz_policy = scrollBarsProperty.m_horz_policy;
            this.m_scroll_name = scrollBarsProperty.m_scroll_name;
            if (this.m_scroll_border == null) {
                this.m_scroll_border = new CompoundBorderProperty();
            }
            if (scrollBarsProperty.m_scroll_border == null) {
                this.m_scroll_border.addBorder(new DefaultBorderProperty());
            } else {
                this.m_scroll_border.setValue(scrollBarsProperty.m_scroll_border);
            }
        }
    }

    public void updateBean(JETABean jETABean) {
        Component component = null;
        if (jETABean != null) {
            component = jETABean.getDelegate();
        }
        jETABean.removeAll();
        if (this.isScrollable()) {
            JScrollPane jScrollPane = null;
            Container container = component.getParent();
            if (container instanceof JViewport) {
                jScrollPane = (JScrollPane)container.getParent();
            } else {
                boolean bl = FormUtils.isDesignMode();
                Dimension dimension = new Dimension(80, 80);
                jScrollPane = new JScrollPane(component);
                jScrollPane.setPreferredSize(dimension);
            }
            jScrollPane.setHorizontalScrollBarPolicy(this.m_horz_policy);
            jScrollPane.setVerticalScrollBarPolicy(this.m_vert_policy);
            if (component.isOpaque()) {
                jScrollPane.setOpaque(true);
            }
            if (this.m_scroll_name != null) {
                jScrollPane.setName(this.m_scroll_name);
            }
            if (this.m_scroll_border != null) {
                try {
                    jScrollPane.setBorder(this.m_scroll_border.createBorder(jScrollPane));
                }
                catch (Exception exception) {
                    FormsLogger.severe(exception);
                }
            }
            jETABean.add((Component)jScrollPane, "Center");
        } else {
            jETABean.add(component, "Center");
        }
    }

    public void read(JETAObjectInput jETAObjectInput) throws ClassNotFoundException, IOException {
        super.read(jETAObjectInput.getSuperClassInput());
        int n = jETAObjectInput.readVersion();
        this.m_vert_policy = jETAObjectInput.readInt("verticalpolicy");
        this.m_horz_policy = jETAObjectInput.readInt("horizontalpolicy");
        if (n >= 2) {
            this.m_scroll_name = (String)jETAObjectInput.readObject("scrollname");
        }
        if (n >= 3) {
            this.m_scroll_border = (CompoundBorderProperty)jETAObjectInput.readObject("border");
        }
    }

    public void write(JETAObjectOutput jETAObjectOutput) throws IOException {
        super.write(jETAObjectOutput.getSuperClassOutput(JETAProperty.class));
        jETAObjectOutput.writeVersion(3);
        jETAObjectOutput.writeInt("verticalpolicy", this.m_vert_policy);
        jETAObjectOutput.writeInt("horizontalpolicy", this.m_horz_policy);
        jETAObjectOutput.writeObject("scrollname", this.m_scroll_name);
        jETAObjectOutput.writeObject("border", this.m_scroll_border);
    }
}

