/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.pqc.crypto.xmss;

import java.io.IOException;
import java.text.ParseException;
import java.util.Map;
import java.util.TreeMap;
import org.python.bouncycastle.pqc.crypto.xmss.BDS;
import org.python.bouncycastle.pqc.crypto.xmss.XMSS;
import org.python.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import org.python.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import org.python.bouncycastle.pqc.crypto.xmss.XMSSUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMSSMTPrivateKeyParameters
implements XMSSStoreableObjectInterface {
    private final XMSSMTParameters params;
    private final long index;
    private final byte[] secretKeySeed;
    private final byte[] secretKeyPRF;
    private final byte[] publicSeed;
    private final byte[] root;
    private final Map<Integer, BDS> bdsState;

    private XMSSMTPrivateKeyParameters(Builder builder) throws ParseException, ClassNotFoundException, IOException {
        this.params = builder.params;
        if (this.params == null) {
            throw new NullPointerException("params == null");
        }
        int n = this.params.getDigestSize();
        byte[] byArray = builder.privateKey;
        if (byArray != null) {
            if (builder.xmss == null) {
                throw new NullPointerException("xmss == null");
            }
            int n2 = this.params.getHeight();
            int n3 = (int)Math.ceil((double)n2 / 8.0);
            int n4 = n;
            int n5 = n;
            int n6 = n;
            int n7 = n;
            int n8 = 0;
            this.index = XMSSUtil.bytesToXBigEndian(byArray, n8, n3);
            if (!XMSSUtil.isIndexValid(n2, this.index)) {
                throw new ParseException("index out of bounds", 0);
            }
            this.secretKeySeed = XMSSUtil.extractBytesAtOffset(byArray, n8 += n3, n4);
            this.secretKeyPRF = XMSSUtil.extractBytesAtOffset(byArray, n8 += n4, n5);
            this.publicSeed = XMSSUtil.extractBytesAtOffset(byArray, n8 += n5, n6);
            this.root = XMSSUtil.extractBytesAtOffset(byArray, n8 += n6, n7);
            byte[] byArray2 = XMSSUtil.extractBytesAtOffset(byArray, n8 += n7, byArray.length - n8);
            TreeMap treeMap = (TreeMap)XMSSUtil.deserialize(byArray2);
            for (Integer n9 : treeMap.keySet()) {
                BDS bDS = (BDS)treeMap.get(n9);
                bDS.setXMSS(builder.xmss);
                bDS.validate();
            }
            this.bdsState = treeMap;
        } else {
            this.index = builder.index;
            byte[] byArray3 = builder.secretKeySeed;
            if (byArray3 != null) {
                if (byArray3.length != n) {
                    throw new IllegalArgumentException("size of secretKeySeed needs to be equal size of digest");
                }
                this.secretKeySeed = byArray3;
            } else {
                this.secretKeySeed = new byte[n];
            }
            byte[] byArray4 = builder.secretKeyPRF;
            if (byArray4 != null) {
                if (byArray4.length != n) {
                    throw new IllegalArgumentException("size of secretKeyPRF needs to be equal size of digest");
                }
                this.secretKeyPRF = byArray4;
            } else {
                this.secretKeyPRF = new byte[n];
            }
            byte[] byArray5 = builder.publicSeed;
            if (byArray5 != null) {
                if (byArray5.length != n) {
                    throw new IllegalArgumentException("size of publicSeed needs to be equal size of digest");
                }
                this.publicSeed = byArray5;
            } else {
                this.publicSeed = new byte[n];
            }
            byte[] byArray6 = builder.root;
            if (byArray6 != null) {
                if (byArray6.length != n) {
                    throw new IllegalArgumentException("size of root needs to be equal size of digest");
                }
                this.root = byArray6;
            } else {
                this.root = new byte[n];
            }
            Map<Object, Object> map = builder.bdsState;
            this.bdsState = map != null ? map : new TreeMap<Integer, BDS>();
        }
    }

    @Override
    public byte[] toByteArray() {
        int n = this.params.getDigestSize();
        int n2 = (int)Math.ceil((double)this.params.getHeight() / 8.0);
        int n3 = n;
        int n4 = n;
        int n5 = n;
        int n6 = n;
        int n7 = n2 + n3 + n4 + n5 + n6;
        byte[] byArray = new byte[n7];
        int n8 = 0;
        byte[] byArray2 = XMSSUtil.toBytesBigEndian(this.index, n2);
        XMSSUtil.copyBytesAtOffset(byArray, byArray2, n8);
        XMSSUtil.copyBytesAtOffset(byArray, this.secretKeySeed, n8 += n2);
        XMSSUtil.copyBytesAtOffset(byArray, this.secretKeyPRF, n8 += n3);
        XMSSUtil.copyBytesAtOffset(byArray, this.publicSeed, n8 += n4);
        XMSSUtil.copyBytesAtOffset(byArray, this.root, n8 += n5);
        byte[] byArray3 = null;
        try {
            byArray3 = XMSSUtil.serialize(this.bdsState);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("error serializing bds state");
        }
        return XMSSUtil.concat(byArray, byArray3);
    }

    public long getIndex() {
        return this.index;
    }

    public byte[] getSecretKeySeed() {
        return XMSSUtil.cloneArray(this.secretKeySeed);
    }

    public byte[] getSecretKeyPRF() {
        return XMSSUtil.cloneArray(this.secretKeyPRF);
    }

    public byte[] getPublicSeed() {
        return XMSSUtil.cloneArray(this.publicSeed);
    }

    public byte[] getRoot() {
        return XMSSUtil.cloneArray(this.root);
    }

    public Map<Integer, BDS> getBDSState() {
        return this.bdsState;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private final XMSSMTParameters params;
        private long index = 0L;
        private byte[] secretKeySeed = null;
        private byte[] secretKeyPRF = null;
        private byte[] publicSeed = null;
        private byte[] root = null;
        private Map<Integer, BDS> bdsState = null;
        private byte[] privateKey = null;
        private XMSS xmss = null;

        public Builder(XMSSMTParameters xMSSMTParameters) {
            this.params = xMSSMTParameters;
        }

        public Builder withIndex(long l) {
            this.index = l;
            return this;
        }

        public Builder withSecretKeySeed(byte[] byArray) {
            this.secretKeySeed = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withSecretKeyPRF(byte[] byArray) {
            this.secretKeyPRF = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withPublicSeed(byte[] byArray) {
            this.publicSeed = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withRoot(byte[] byArray) {
            this.root = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withBDSState(Map<Integer, BDS> map) {
            this.bdsState = map;
            return this;
        }

        public Builder withPrivateKey(byte[] byArray, XMSS xMSS) {
            this.privateKey = XMSSUtil.cloneArray(byArray);
            this.xmss = xMSS;
            return this;
        }

        public XMSSMTPrivateKeyParameters build() throws ParseException, ClassNotFoundException, IOException {
            return new XMSSMTPrivateKeyParameters(this);
        }
    }
}

