/*
 * Decompiled with CFR 0.152.
 */
package com.tqdev.metrics.influxdb;

import com.tqdev.metrics.core.MetricRegistry;
import com.tqdev.metrics.influxdb.InfluxDbReporter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.zip.GZIPOutputStream;

public class InfluxDbFileReporter
extends InfluxDbReporter {
    protected final String metricPath;
    protected final int maxFileCount;
    protected final String dateFormat;

    public InfluxDbFileReporter(MetricRegistry registry, String instanceName, String metricPath, String dateFormat, int maxFileCount) {
        super(registry, instanceName);
        this.metricPath = metricPath;
        this.dateFormat = dateFormat;
        this.maxFileCount = maxFileCount;
    }

    public InfluxDbFileReporter(MetricRegistry registry, String instanceName, String metricPath, String dateFormat, int maxFileCount, int intervalInSeconds) {
        super(registry, instanceName);
        this.metricPath = metricPath;
        this.dateFormat = dateFormat;
        this.maxFileCount = maxFileCount;
        this.run(intervalInSeconds);
    }

    @Override
    public boolean report() {
        if (!this.registry.isEnabled()) {
            return true;
        }
        File dir = new File(this.metricPath);
        if (!dir.exists() && !dir.mkdir()) {
            return false;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(this.dateFormat);
        String filename = this.metricPath + "/" + formatter.format(new Date(this.registry.getMillis())) + ".txt";
        try {
            FileOutputStream fos = new FileOutputStream(filename, true);
            BufferedOutputStream out = new BufferedOutputStream(fos, 8192);
            this.write(out);
            this.compress(filename);
            this.remove(this.maxFileCount);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private void compress(String filename) throws IOException {
        File current = new File(filename);
        File dir = new File(this.metricPath);
        FilenameFilter textFileFilter = (f, s) -> s.endsWith(".txt");
        File[] directoryListing = dir.listFiles(textFileFilter);
        if (directoryListing != null) {
            for (File file : directoryListing) {
                if (file.getCanonicalPath() == current.getCanonicalPath()) continue;
                try (FileOutputStream fos = new FileOutputStream(file.getPath() + ".gz");
                     GZIPOutputStream gzos = new GZIPOutputStream(fos);){
                    byte[] buffer = new byte[8192];
                    try (FileInputStream fis = new FileInputStream(file.getPath());){
                        int length;
                        while ((length = fis.read(buffer)) > 0) {
                            gzos.write(buffer, 0, length);
                        }
                    }
                }
                file.delete();
            }
        } else {
            throw new IOException("Directory not listable: " + this.metricPath);
        }
    }

    private void remove(int maxFileCount) throws IOException {
        File dir = new File(this.metricPath);
        FilenameFilter gzipFileFilter = (f, s) -> s.endsWith(".gz");
        Object[] directoryListing = dir.listFiles(gzipFileFilter);
        if (directoryListing != null) {
            Arrays.sort(directoryListing);
            for (int i = 0; i < directoryListing.length - maxFileCount; ++i) {
                ((File)directoryListing[i]).delete();
            }
        } else {
            throw new IOException("Directory not listable: " + this.metricPath);
        }
    }
}

