/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.bootstrap;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.crsh.cli.impl.Delimiter;
import org.crsh.cli.impl.bootstrap.CommandProvider;
import org.crsh.cli.impl.descriptor.HelpDescriptor;
import org.crsh.cli.impl.invocation.InvocationMatch;
import org.crsh.cli.impl.invocation.InvocationMatcher;
import org.crsh.cli.impl.lang.CommandFactory;
import org.crsh.cli.impl.lang.Instance;
import org.crsh.cli.impl.lang.ObjectCommandDescriptor;
import org.crsh.cli.impl.lang.Util;

public class Main {
    public static void main(String[] args) throws Exception {
        ServiceLoader<CommandProvider> loader = ServiceLoader.load(CommandProvider.class);
        Iterator<CommandProvider> iterator = loader.iterator();
        if (iterator.hasNext()) {
            StringBuilder line = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    line.append(' ');
                }
                Delimiter.EMPTY.escape(args[i], line);
            }
            CommandProvider commandProvider = iterator.next();
            Class<?> commandClass = commandProvider.getCommandClass();
            Main.handle(commandClass, line.toString());
        }
    }

    private static <T> void handle(Class<T> commandClass, String line) throws Exception {
        T instance;
        ObjectCommandDescriptor<T> descriptor = CommandFactory.DEFAULT.create(commandClass);
        HelpDescriptor<T> helpDescriptor = HelpDescriptor.create(descriptor);
        InvocationMatcher matcher = helpDescriptor.matcher();
        InvocationMatch<Instance<T>> match = matcher.parse(line);
        Object o = match.invoke(Util.wrap(instance = commandClass.newInstance()));
        if (o != null) {
            System.out.println(o);
        }
    }
}

