/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.InternalReportProxy;
import com.xebialabs.deployit.core.api.Ordering;
import com.xebialabs.deployit.core.api.Paging;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.dto.ReportLine;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.config.XldConfig;
import com.xebialabs.deployit.core.rest.api.DownloadResource;
import com.xebialabs.deployit.core.rest.api.TaskWithStepsView;
import com.xebialabs.deployit.core.rest.api.reports.AggregatedDeploymentsKeyIndicator;
import com.xebialabs.deployit.core.rest.api.reports.DeploymentsForEnvironmentReport;
import com.xebialabs.deployit.core.rest.api.reports.DeploymentsKeyIndicator;
import com.xebialabs.deployit.core.rest.api.reports.DeploymentsStateBreakdownReport;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.api.reports.widgets.WidgetRegistry;
import com.xebialabs.deployit.core.rest.resteasy.WorkDirTemplate;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.SerializableTask;
import com.xebialabs.deployit.engine.api.execution.StepBlockState;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.PermissionHandler;
import com.xebialabs.deployit.security.permission.PermissionHelper;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.FilterType;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.deployit.task.archive.TaskArchive;
import com.xebialabs.deployit.task.archive.sql.TaskReader;
import com.xebialabs.deployit.task.archive.sql.schema.ArchivedControlTasks;
import com.xebialabs.deployit.task.archive.sql.schema.ArchivedDeploymentTasks;
import com.xebialabs.deployit.task.archive.sql.schema.ArchivedTasksShared;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;

@Controller
public class ReportResource
extends AbstractSecuredResource
implements InternalReportProxy {
    private static final Logger log = LoggerFactory.getLogger(ReportResource.class);
    private static final Set<String> DEPLOYMENT_ALLOWED_SORT_FIELDS = new HashSet<String>(Arrays.asList("id", "failures", "owner", "state", "startDate", "completionDate", "application", "environment_id", "taskType"));
    private static final Set<String> CONTROL_ALLOWED_SORT_FIELDS = new HashSet<String>(Arrays.asList("id", "failures", "owner", "state", "startDate", "completionDate", "description", "controlTaskTargetCI", "taskName"));
    @Context
    private HttpResponse response;
    @Autowired
    private TaskArchive taskArchive;
    @Autowired
    private DownloadResource downloadResource;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private XldConfig config;
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyyMMdd");

    @Transactional(value="reportingTransactionManager", readOnly=true)
    public Report deploymentsForEnvironment(String environment, Date date) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Checks.checkNotNull((Object)environment, (String)"environment");
        Checks.checkNotNull((Object)date, (String)"date");
        Checks.checkNotNull((Object)date.getCalendar(), (String)"date");
        DeploymentsForEnvironmentReport report = new DeploymentsForEnvironmentReport(this.taskArchive);
        return report.report(environment, date.asDateTime());
    }

    @Workdir(prefix="download")
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadDeploymentsForEnvironment(String environment, Date date) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        return (String)WorkDirTemplate.cleanOnException(workDir -> {
            Report report = this.deploymentsForEnvironment(environment, date);
            String fileName = String.format("deployments-%s-%s.csv", environment.replaceAll("/", "_"), DATE_FORMAT.print((ReadableInstant)date.asDateTime()));
            return this.createDownloadToken(() -> ReportUtils.toCsv(report), fileName);
        });
    }

    @Deprecated
    public TaskWithSteps getTask(String taskId) {
        return new TaskWithStepsView((SerializableTask)this.retrieveTask(taskId, true));
    }

    public TaskWithBlock getTaskWithBlock(String taskId) {
        return this.retrieveTask(taskId, false);
    }

    private TaskWithBlock retrieveTask(String taskId, boolean loadSteps) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        TaskReader taskReader = this.taskArchive.getTask(taskId);
        ArchivedTask t = loadSteps ? taskReader.fully() : taskReader.withoutSteps();
        this.checkAccessTo(t.getMetadata());
        return t;
    }

    public StepBlockState getStepBlock(String taskId, String blockId) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        TaskReader taskReader = this.taskArchive.getTask(taskId);
        this.checkAccessTo(taskReader.metadata());
        BlockState block = taskReader.block(blockId);
        if (block instanceof StepBlockState) {
            return (StepBlockState)block;
        }
        throw new DeployitException("Block [%s] from task [%s] is a composite block so it has no steps", new Object[]{blockId, taskId});
    }

    private void checkAccessTo(Map<String, String> taskMetadata) {
        boolean isCloudTask;
        boolean isControlTask = TaskType.CONTROL.name().equals(taskMetadata.get("taskType"));
        boolean bl = isCloudTask = taskMetadata.get("cloudOperation") != null;
        if (isCloudTask) {
            this.doCloudTaskPermissionCheck(taskMetadata);
        } else if (isControlTask) {
            this.doControlTaskPermissionCheck(taskMetadata);
        } else {
            this.doDeploymentTaskPermissionCheck(taskMetadata);
        }
    }

    private void doDeploymentTaskPermissionCheck(Map<String, String> taskMetadata) {
        String envId = taskMetadata.get("environment_id");
        String appName = taskMetadata.get("application");
        List applications = this.repositoryService.list(new SearchParameters().setType(Type.valueOf(Application.class)).setName(appName));
        if (applications.size() != 1) {
            throw new DeployitException("Unable to locate application for report");
        }
        String appId = ((ConfigurationItemData)applications.get(0)).getId();
        if (!this.hasPermission(PlatformPermissions.READ, envId) || !this.hasPermission(PlatformPermissions.READ, appId)) {
            throw PermissionDeniedException.withMessage((String)"You need read permissions for both the environment and application to view the archived task.");
        }
    }

    private void doControlTaskPermissionCheck(Map<String, String> taskMetadata) {
        String ciID = taskMetadata.get("controlTaskTargetCI");
        if (Strings.isNullOrEmpty((String)ciID) && !PermissionHelper.isCurrentUserAdmin()) {
            throw PermissionDeniedException.withMessage((String)"Control tasks that don't have their target CI archived can only be viewed by admin.");
        }
        if (!this.hasPermission(DeployitPermissions.CONTROLTASK_EXECUTE, ciID)) {
            throw PermissionDeniedException.withMessage((String)"You need controltask#execute permission on an archived control task's target CI to view it.");
        }
    }

    private void doCloudTaskPermissionCheck(Map<String, String> taskMetadata) {
        String cloudEnvId = taskMetadata.get("cloudEnvironmentId");
        String cloudTemplId = taskMetadata.get("cloudEnvironmentTemplateId");
        if (!this.hasPermission(PlatformPermissions.READ, cloudEnvId) || !this.hasPermission(PlatformPermissions.READ, cloudTemplId)) {
            throw PermissionDeniedException.withMessage((String)"You need read permissions for both the environment and the environment template to view the archived cloud task.");
        }
    }

    public Stream<ReportLine> getTaskReport(Date begin, Date end, Paging paging, List<Ordering> order, String filterType, List<ConfigurationItemId> configurationItemIds) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Paging limited = this.getLimitedPaging(paging);
        ArchivedTaskSearchParameters searchParameters = this.buildFilteredTaskSearchParameters(begin, end, limited, order, filterType, configurationItemIds, DEPLOYMENT_ALLOWED_SORT_FIELDS);
        this.addPagingHeaderIfNeeded(paging, limited, searchParameters);
        return this.streamTaskReport(searchParameters);
    }

    private Stream<ReportLine> streamTaskReport(ArchivedTaskSearchParameters searchParameters) {
        return this.taskArchive.searchForMaps(searchParameters, true).map(ReportResource::asDeploymentTask).map(ReportLine::fromMap);
    }

    private ArchivedTaskSearchParameters buildFilteredTaskSearchParameters(Date begin, Date end, Paging paging, List<Ordering> order, String filterType, List<ConfigurationItemId> configurationItemIds, Set<String> allowedSortFields) {
        FilterType filter;
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        ArchivedTaskSearchParameters searchParameters = this.buildTaskSearchParameters(paging, order, EnumSet.of(TaskType.INITIAL, TaskType.ROLLBACK, TaskType.UNDEPLOY, TaskType.UPGRADE), allowedSortFields);
        searchParameters.createdBetween(begin.asDateTime(), end.asDateTime());
        if (filterType != null && (filter = FilterType.valueOf((String)filterType.toUpperCase())) != FilterType.NONE) {
            searchParameters.forFilterType(filter, configurationItemIds);
        }
        return searchParameters;
    }

    private Paging getLimitedPaging(Paging input) {
        if (input.getResultsPerPage() == 0 || input.getResultsPerPage() > this.config.restApi().maxPageSize()) {
            return new Paging(input.getPage(), this.config.restApi().maxPageSize());
        }
        return input;
    }

    private ArchivedTaskSearchParameters buildTaskSearchParameters(Paging paging, List<Ordering> order, EnumSet<TaskType> taskTypes, Set<String> allowedSortFields) {
        paging.validate();
        for (Ordering ordering : order) {
            ordering.validate(allowedSortFields);
        }
        ArchivedTaskSearchParameters searchParameters = new ArchivedTaskSearchParameters();
        searchParameters.thatAreOfType(taskTypes);
        if (order.isEmpty()) {
            searchParameters.orderBy("startDate", false);
        } else {
            for (Ordering ordering : order) {
                searchParameters.orderBy(ordering.getField(), ordering.getDirection() == Ordering.Direction.ASC);
            }
        }
        searchParameters.showPage(paging.getPage(), paging.getResultsPerPage());
        return searchParameters;
    }

    @Workdir(prefix="download")
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadTaskReport(Date begin, Date end, String filterType, List<ConfigurationItemId> configurationItemIds) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        return (String)WorkDirTemplate.cleanOnException(workDir -> {
            Stream<ReportLine> report = this.streamTaskReport(this.buildFilteredTaskSearchParameters(begin, end, Paging.ALL, Collections.emptyList(), filterType, configurationItemIds, DEPLOYMENT_ALLOWED_SORT_FIELDS));
            String fileName = String.format("tasks-%s-%s.csv", DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
            return this.createDownloadToken(() -> ReportUtils.toCsv(report), fileName);
        });
    }

    public Report deploymentsStateBreakdown(String filterType, Date begin, Date end, List<ConfigurationItemId> configurationItemIds) {
        Checks.checkNotNull((Object)filterType, (String)"filterType");
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)begin.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        Checks.checkNotNull((Object)end.getCalendar(), (String)"end");
        Checks.checkNotNull(configurationItemIds, (String)"configurationItemIds");
        DeploymentsStateBreakdownReport report = new DeploymentsStateBreakdownReport(this.taskArchive);
        FilterType reportFilterType = FilterType.valueOf((String)filterType.toUpperCase());
        return report.report(reportFilterType, configurationItemIds);
    }

    @Workdir(prefix="download")
    public String downloadDeploymentsStateBreakdown(String filterType, Date begin, Date end, List<ConfigurationItemId> configurationItemIds) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        return (String)WorkDirTemplate.cleanOnException(workDir -> {
            Report report = this.deploymentsStateBreakdown(filterType, begin, end, configurationItemIds);
            String fileName = String.format("deployments-by-state-%s-%s.csv", DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
            return this.createDownloadToken(() -> ReportUtils.toCsv(report), fileName);
        });
    }

    @Transactional(value="reportingTransactionManager", readOnly=true)
    public Report deploymentsKeyIndicator(Date begin, Date end, String filterType, List<ConfigurationItemId> configurationItemIds) {
        FilterType filter;
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)begin.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        Checks.checkNotNull((Object)end.getCalendar(), (String)"end");
        DeploymentsKeyIndicator report = new DeploymentsKeyIndicator(this.taskArchive);
        report.getSearchParameters().createdBetween(begin.asDateTime(), end.asDateTime());
        if (filterType != null && (filter = FilterType.valueOf((String)filterType.toUpperCase())) != FilterType.NONE) {
            report.getSearchParameters().forFilterType(filter, configurationItemIds);
        }
        return report.report();
    }

    public Stream<ReportLine> getControlTasksReport(Date begin, Date end, Paging paging, List<Ordering> order) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Paging limited = this.getLimitedPaging(paging);
        ArchivedTaskSearchParameters searchParameters = this.buildTaskSearchParameters(limited, order, EnumSet.of(TaskType.CONTROL), CONTROL_ALLOWED_SORT_FIELDS);
        searchParameters.inDateTimeRange(this.safeDateTime(begin, null), this.safeDateTime(end, null));
        this.addPagingHeaderIfNeeded(paging, limited, searchParameters);
        return this.streamControlTasksReport(searchParameters);
    }

    private void addPagingHeaderIfNeeded(Paging paging, Paging limited, ArchivedTaskSearchParameters searchParameters) {
        if (limited.getResultsPerPage() > 0) {
            int count = this.taskArchive.countTotalResults(searchParameters);
            if (paging.getResultsPerPage() == 0 && count > limited.getResultsPerPage()) {
                log.warn("Limiting total number of results {} to maximum {}", (Object)count, (Object)limited.getResultsPerPage());
            }
            this.response.getOutputHeaders().putSingle((Object)"X-Total-Count", (Object)count);
        }
    }

    private Stream<ReportLine> streamControlTasksReport(ArchivedTaskSearchParameters searchParameters) {
        PermissionHandler permissionHandler = DeployitPermissions.CONTROLTASK_EXECUTE.getPermissionHandler();
        return this.taskArchive.searchForMaps(searchParameters, true).filter(line -> {
            String targetCI = (String)line.get("target_ci");
            return permissionHandler.isCurrentUserAdmin() || !Strings.isNullOrEmpty((String)targetCI) && permissionHandler.hasPermission(targetCI);
        }).map(ReportResource::asControlTask).map(ReportLine::fromMap);
    }

    @Workdir(prefix="download")
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadControlTasksReport(Date begin, Date end) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        return (String)WorkDirTemplate.cleanOnException(workDir -> {
            ArchivedTaskSearchParameters searchParameters = this.buildTaskSearchParameters(Paging.ALL, Collections.emptyList(), EnumSet.of(TaskType.CONTROL), CONTROL_ALLOWED_SORT_FIELDS);
            searchParameters.inDateTimeRange(this.safeDateTime(begin, null), this.safeDateTime(end, null));
            Stream<ReportLine> report = this.streamControlTasksReport(searchParameters);
            DateTime beginDT = this.safeDateTime(begin, new DateTime(1, 1, 1, 0, 0, 0));
            DateTime endDT = this.safeDateTime(end, new DateTime());
            String fileName = String.format("tasks-%s-%s.csv", DATE_FORMAT.print((ReadableInstant)beginDT), DATE_FORMAT.print((ReadableInstant)endDT));
            return this.createDownloadToken(() -> ReportUtils.toCsv(report), fileName);
        });
    }

    private DateTime safeDateTime(Date date, DateTime defaultValue) {
        return date == null ? defaultValue : date.asDateTime();
    }

    @Transactional(value="reportingTransactionManager", readOnly=true)
    public Report deploymentsKeyIndicatorAggregatedByFilterType(String filterType, Date begin, Date end, List<ConfigurationItemId> configurationItemIds) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Checks.checkNotNull((Object)filterType, (String)"filterType");
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)begin.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        Checks.checkNotNull((Object)end.getCalendar(), (String)"end");
        Checks.checkNotNull(configurationItemIds, (String)"configurationItemIds");
        FilterType reportFilterType = FilterType.valueOf((String)filterType.toUpperCase());
        AggregatedDeploymentsKeyIndicator report = new AggregatedDeploymentsKeyIndicator(this.taskArchive);
        report.getSearchParameters().createdBetween(new DateTime((Object)begin.getCalendar()), new DateTime((Object)end.getCalendar()));
        return report.report(reportFilterType, configurationItemIds);
    }

    @Workdir(prefix="download")
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadDeploymentsKeyIndicator(String filterType, Date begin, Date end, List<ConfigurationItemId> cis) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        return (String)WorkDirTemplate.cleanOnException(workDir -> {
            Report report = this.deploymentsKeyIndicator(begin, end, filterType, cis);
            String fileName = String.format("deployments-key-indicator-%s-%s.csv", DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
            return this.createDownloadToken(() -> ReportUtils.toCsv(report), fileName);
        });
    }

    @Workdir(prefix="download")
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadDeploymentsKeyIndicatorAggregatedByFilterType(String filterType, Date begin, Date end, List<ConfigurationItemId> configurationItemIds) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        return (String)WorkDirTemplate.cleanOnException(workDir -> {
            Report report = this.deploymentsKeyIndicatorAggregatedByFilterType(filterType, begin, end, configurationItemIds);
            String fileName = String.format("aggregated-deployments-key-indicator-%s-%s-%s.csv", filterType, DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
            return this.createDownloadToken(() -> ReportUtils.toCsv(report), fileName);
        });
    }

    @Transactional(value="reportingTransactionManager", readOnly=true)
    public Report getDashboardWidgetReport(String widget, Date begin, Date end) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Checks.checkNotNull((Object)widget, (String)"widget");
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)begin.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        Checks.checkNotNull((Object)end.getCalendar(), (String)"end");
        Preconditions.checkArgument((begin.getCalendar().getTime().compareTo(end.getCalendar().getTime()) <= 0 ? 1 : 0) != 0);
        return WidgetRegistry.valueOf(WidgetRegistry.class, widget.toUpperCase()).getWidget(this.taskArchive).getReport(begin.asDateTime(), end.asDateTime());
    }

    public List<ConfigurationItemId> listEnvironments() {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        List environments = this.taskArchive.getAllEnvironments();
        Collections.sort(environments);
        return environments.stream().map(input -> new ConfigurationItemId(input, Type.valueOf((String)"udm.Environment"))).collect(Collectors.toList());
    }

    private String createDownloadToken(Supplier<Stream<String>> report, String fileName) {
        try {
            File to = new File(WorkdirHolder.get().getPath(), fileName);
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(to), Charset.defaultCharset()));
                 Stream<String> s = report.get();){
                s.forEachOrdered(line -> {
                    try {
                        writer.write((String)line);
                        writer.write(10);
                    }
                    catch (IOException io) {
                        throw new RuntimeException(io);
                    }
                });
            }
            return this.downloadResource.register(to, WorkdirHolder.get(), "text/csv");
        }
        catch (Exception re) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Oops!", (Throwable)re);
            WorkdirHolder.get().delete();
            throw new IllegalStateException(re);
        }
    }

    private static Map<String, Object> asDeploymentTask(Map<String, Object> map) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("taskId", map.get(ArchivedTasksShared.task_id().name()));
        values.put("startDate", map.get(ArchivedTasksShared.start_date().name()));
        values.put("completionDate", map.get(ArchivedDeploymentTasks.end_date().name()));
        values.put("status", map.get(ArchivedDeploymentTasks.status().name()));
        values.put("type", ReportResource.transformTaskType(TaskType.valueOf((String)((String)map.get(ArchivedDeploymentTasks.task_type().name())))));
        values.put("user", map.get(ArchivedDeploymentTasks.owner().name()));
        String environment = (String)map.get(ArchivedDeploymentTasks.environment().name());
        values.put("environment", environment.substring(environment.lastIndexOf(47) + 1));
        values.put("environmentId", environment);
        values.put("environmentIdWithoutRoot", environment.substring(environment.indexOf(47) + 1));
        values.put("package", map.get(ArchivedDeploymentTasks.packages().name()));
        return values;
    }

    private static Map<String, Object> asControlTask(Map<String, Object> map) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("taskId", map.get(ArchivedControlTasks.task_id().name()));
        values.put("started", map.get(ArchivedControlTasks.start_date().name()));
        values.put("finished", map.get(ArchivedControlTasks.end_date().name()));
        values.put("state", map.get(ArchivedControlTasks.status().name()));
        values.put("owner", map.get(ArchivedControlTasks.owner().name()));
        values.put("taskName", map.get(ArchivedControlTasks.control_task_name().name()));
        values.put("controlTaskTargetCI", map.get(ArchivedControlTasks.target_ci().name()));
        values.put("description", map.get(ArchivedControlTasks.description().name()));
        return values;
    }

    public void setTaskArchive(TaskArchive taskArchive) {
        this.taskArchive = taskArchive;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    private static String transformTaskType(TaskType taskType) {
        switch (taskType) {
            case INITIAL: {
                return "Initial";
            }
            case UPGRADE: {
                return "Update";
            }
            case UNDEPLOY: {
                return "Undeployment";
            }
            case ROLLBACK: {
                return "Rollback";
            }
        }
        return "Unknown";
    }
}

