/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.spring;

import com.xebialabs.deployit.conversion.StringCoder;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.deployit.util.PasswordUtil;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.util.StringUtils;

public class DecodingPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(DecodingPropertyPlaceholderConfigurer.class);

    protected String parseStringValue(String strVal, Properties props, Set visitedPlaceholders) throws BeanDefinitionStoreException {
        String decodedString = StringCoder.decode((String)strVal);
        if (logger.isDebugEnabled() && !strVal.equals(decodedString)) {
            logger.debug("Decoded property value: " + strVal);
        }
        return super.parseStringValue(decodedString, props, visitedPlaceholders);
    }

    protected String resolvePlaceholder(String placeholder, Properties props, int systemPropertiesMode) {
        String value;
        if (PasswordUtil.isCustomPassword(placeholder) && !StringUtils.isEmpty((Object)(value = props.getProperty(placeholder))) && PasswordEncrypter.getInstance().isEncodedAndDecryptable(value)) {
            return PasswordEncrypter.getInstance().decrypt(value);
        }
        return super.resolvePlaceholder(placeholder, props, systemPropertiesMode);
    }
}

