/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.verification;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.schmizz.sshj.common.Base64;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.LoggerFactory;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.transport.mac.HMACSHA1;
import net.schmizz.sshj.transport.mac.MAC;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import org.slf4j.Logger;

public class OpenSSHKnownHosts
implements HostKeyVerifier {
    protected final Logger log;
    protected final File khFile;
    protected final List<HostEntry> entries = new ArrayList<HostEntry>();
    private static final String LS = System.getProperty("line.separator");

    public OpenSSHKnownHosts(File khFile) throws IOException {
        this(khFile, LoggerFactory.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OpenSSHKnownHosts(File khFile, LoggerFactory loggerFactory) throws IOException {
        this.khFile = khFile;
        this.log = loggerFactory.getLogger(this.getClass());
        if (!khFile.exists()) return;
        EntryFactory entryFactory = new EntryFactory();
        BufferedReader br = new BufferedReader(new FileReader(khFile));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                try {
                    HostEntry entry = entryFactory.parseEntry(line);
                    if (entry == null) continue;
                    this.entries.add(entry);
                }
                catch (SSHException ignore) {
                    this.log.debug("Bad line ({}): {} ", (Object)ignore.toString(), (Object)line);
                }
                catch (SSHRuntimeException ignore) {
                    this.log.debug("Failed to process line ({}): {} ", (Object)ignore.toString(), (Object)line);
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(br);
            throw throwable;
        }
        IOUtils.closeQuietly(br);
    }

    public File getFile() {
        return this.khFile;
    }

    @Override
    public boolean verify(String hostname, int port, PublicKey key) {
        KeyType type = KeyType.fromKey(key);
        if (type == KeyType.UNKNOWN) {
            return false;
        }
        String adjustedHostname = port != 22 ? "[" + hostname + "]:" + port : hostname;
        for (HostEntry e : this.entries) {
            try {
                if (!e.appliesTo(type, adjustedHostname)) continue;
                return e.verify(key) || this.hostKeyChangedAction(e, adjustedHostname, key);
            }
            catch (IOException ioe) {
                this.log.error("Error with {}: {}", (Object)e, (Object)ioe);
                return false;
            }
        }
        return this.hostKeyUnverifiableAction(adjustedHostname, key);
    }

    protected boolean hostKeyUnverifiableAction(String hostname, PublicKey key) {
        return false;
    }

    protected boolean hostKeyChangedAction(HostEntry entry, String hostname, PublicKey key) {
        this.log.warn("Host key for `{}` has changed!", (Object)hostname);
        return false;
    }

    public List<HostEntry> entries() {
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.khFile));
        try {
            for (HostEntry entry : this.entries) {
                bos.write((entry.getLine() + LS).getBytes(IOUtils.UTF8));
            }
        }
        finally {
            bos.close();
        }
    }

    public void write(HostEntry entry) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.khFile, true));
        try {
            writer.write(entry.getLine());
            writer.newLine();
            writer.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly(writer);
    }

    public static File detectSSHDir() {
        File sshDir = new File(System.getProperty("user.home"), ".ssh");
        return sshDir.exists() ? sshDir : null;
    }

    public static enum Marker {
        CA_CERT("@cert-authority"),
        REVOKED("@revoked");

        private final String sMarker;

        private Marker(String sMarker) {
            this.sMarker = sMarker;
        }

        public String getMarkerString() {
            return this.sMarker;
        }

        public static Marker fromString(String str) {
            for (Marker m : Marker.values()) {
                if (!m.sMarker.equals(str)) continue;
                return m;
            }
            return null;
        }
    }

    public static class HashedEntry
    extends AbstractEntry {
        private final MAC sha1 = new HMACSHA1();
        private final String hashedHost;
        private final String salt;
        private byte[] saltyBytes;

        public HashedEntry(Marker marker, String hash, KeyType type, PublicKey key) throws SSHException {
            super(marker, type, key);
            this.hashedHost = hash;
            String[] hostParts = this.hashedHost.split("\\|");
            if (hostParts.length != 4) {
                throw new SSHException("Unrecognized format for hashed hostname");
            }
            this.salt = hostParts[2];
        }

        @Override
        public boolean appliesTo(String host) throws IOException {
            return this.hashedHost.equals(this.hashHost(host));
        }

        @Override
        public boolean appliesTo(KeyType type, String host) throws IOException {
            return this.type == type && this.hashedHost.equals(this.hashHost(host));
        }

        private String hashHost(String host) throws IOException {
            this.sha1.init(this.getSaltyBytes());
            return "|1|" + this.salt + "|" + Base64.encodeBytes(this.sha1.doFinal(host.getBytes(IOUtils.UTF8)));
        }

        private byte[] getSaltyBytes() throws IOException {
            if (this.saltyBytes == null) {
                this.saltyBytes = Base64.decode(this.salt);
            }
            return this.saltyBytes;
        }

        @Override
        protected String getHostPart() {
            return this.hashedHost;
        }
    }

    public static class SimpleEntry
    extends AbstractEntry {
        private final List<String> hosts;
        private final String hostnames;

        public SimpleEntry(Marker marker, String hostnames, KeyType type, PublicKey key) {
            super(marker, type, key);
            this.hostnames = hostnames;
            this.hosts = Arrays.asList(hostnames.split(","));
        }

        @Override
        protected String getHostPart() {
            return this.hostnames;
        }

        @Override
        public boolean appliesTo(String host) throws IOException {
            return this.hosts.contains(host);
        }

        @Override
        public boolean appliesTo(KeyType type, String host) throws IOException {
            return type == this.type && this.hosts.contains(host);
        }
    }

    public static abstract class AbstractEntry
    implements HostEntry {
        protected final Marker marker;
        protected final KeyType type;
        protected final PublicKey key;

        public AbstractEntry(Marker marker, KeyType type, PublicKey key) {
            this.marker = marker;
            this.type = type;
            this.key = key;
        }

        @Override
        public KeyType getType() {
            return this.type;
        }

        @Override
        public String getFingerprint() {
            return SecurityUtils.getFingerprint(this.key);
        }

        @Override
        public boolean verify(PublicKey key) throws IOException {
            return key.equals(this.key) && this.marker != Marker.REVOKED;
        }

        @Override
        public String getLine() {
            StringBuilder line = new StringBuilder();
            if (this.marker != null) {
                line.append(this.marker.getMarkerString()).append(" ");
            }
            line.append(this.getHostPart());
            line.append(" ").append(this.type.toString());
            line.append(" ").append(this.getKeyString());
            return line.toString();
        }

        private String getKeyString() {
            Buffer.PlainBuffer buf = (Buffer.PlainBuffer)new Buffer.PlainBuffer().putPublicKey(this.key);
            return Base64.encodeBytes(buf.array(), buf.rpos(), buf.available());
        }

        protected abstract String getHostPart();
    }

    public static class CommentEntry
    implements HostEntry {
        private final String comment;

        public CommentEntry(String comment) {
            this.comment = comment;
        }

        @Override
        public KeyType getType() {
            return KeyType.UNKNOWN;
        }

        @Override
        public String getFingerprint() {
            return null;
        }

        @Override
        public boolean appliesTo(String host) throws IOException {
            return false;
        }

        @Override
        public boolean appliesTo(KeyType type, String host) {
            return false;
        }

        @Override
        public boolean verify(PublicKey key) {
            return false;
        }

        @Override
        public String getLine() {
            return this.comment;
        }
    }

    public static interface HostEntry {
        public KeyType getType();

        public String getFingerprint();

        public boolean appliesTo(String var1) throws IOException;

        public boolean appliesTo(KeyType var1, String var2) throws IOException;

        public boolean verify(PublicKey var1) throws IOException;

        public String getLine();
    }

    public class EntryFactory {
        EntryFactory() {
        }

        public HostEntry parseEntry(String line) throws IOException {
            PublicKey key;
            String sType;
            KeyType type;
            int i;
            if (this.isComment(line)) {
                return new CommentEntry(line);
            }
            String[] split = line.split(" ");
            Marker marker = Marker.fromString(split[i = 0]);
            if (marker != null) {
                ++i;
            }
            if (split.length < 3) {
                OpenSSHKnownHosts.this.log.error("Error reading entry `{}`", (Object)line);
                return null;
            }
            String hostnames = split[i++];
            if ((type = KeyType.fromString(sType = split[i++])) != KeyType.UNKNOWN) {
                String sKey = split[i++];
                key = new Buffer.PlainBuffer(Base64.decode(sKey)).readPublicKey();
            } else if (this.isBits(sType)) {
                type = KeyType.RSA;
                BigInteger e = new BigInteger(split[i++]);
                BigInteger n = new BigInteger(split[i++]);
                try {
                    KeyFactory keyFactory = SecurityUtils.getKeyFactory("RSA");
                    key = keyFactory.generatePublic(new RSAPublicKeySpec(n, e));
                }
                catch (Exception ex) {
                    OpenSSHKnownHosts.this.log.error("Error reading entry `{}`, could not create key", (Object)line, (Object)ex);
                    return null;
                }
            } else {
                OpenSSHKnownHosts.this.log.error("Error reading entry `{}`, could not determine type", (Object)line);
                return null;
            }
            if (this.isHashed(hostnames)) {
                return new HashedEntry(marker, hostnames, type, key);
            }
            return new SimpleEntry(marker, hostnames, type, key);
        }

        private boolean isBits(String type) {
            try {
                Integer.parseInt(type);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        private boolean isComment(String line) {
            return line.isEmpty() || line.startsWith("#");
        }

        public boolean isHashed(String line) {
            return line.startsWith("|1|");
        }
    }
}

