/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.DataPacketHandler;
import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.PublicationImage;
import io.aeron.driver.Receiver;
import io.aeron.driver.SetupMessageHandler;
import io.aeron.driver.exceptions.UnknownSubscriptionException;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.protocol.DataHeaderFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.SetupFlyweight;
import java.net.InetSocketAddress;
import org.agrona.collections.BiInt2ObjectMap;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.concurrent.UnsafeBuffer;

public class DataPacketDispatcher
implements DataPacketHandler,
SetupMessageHandler {
    private final BiInt2ObjectMap<SessionStatus> ignoredSessionsMap = new BiInt2ObjectMap();
    private final Int2ObjectHashMap<Int2ObjectHashMap<PublicationImage>> sessionsByStreamIdMap = new Int2ObjectHashMap();
    private final DriverConductorProxy conductorProxy;
    private final Receiver receiver;

    public DataPacketDispatcher(DriverConductorProxy conductorProxy, Receiver receiver) {
        this.conductorProxy = conductorProxy;
        this.receiver = receiver;
    }

    public void addSubscription(int streamId) {
        if (null == this.sessionsByStreamIdMap.get(streamId)) {
            this.sessionsByStreamIdMap.put(streamId, (Object)new Int2ObjectHashMap());
        }
    }

    public void removeSubscription(int streamId) {
        Int2ObjectHashMap imageBySessionIdMap = (Int2ObjectHashMap)this.sessionsByStreamIdMap.remove(streamId);
        if (null == imageBySessionIdMap) {
            throw new UnknownSubscriptionException("No subscription registered on stream " + streamId);
        }
        imageBySessionIdMap.values().forEach(PublicationImage::ifActiveGoInactive);
    }

    public void addPublicationImage(PublicationImage image) {
        int sessionId = image.sessionId();
        int streamId = image.streamId();
        Int2ObjectHashMap imageBySessionIdMap = (Int2ObjectHashMap)this.sessionsByStreamIdMap.get(streamId);
        imageBySessionIdMap.put(sessionId, (Object)image);
        this.ignoredSessionsMap.remove(sessionId, streamId);
        image.status(PublicationImage.Status.ACTIVE);
    }

    public void removePublicationImage(PublicationImage image) {
        int sessionId = image.sessionId();
        int streamId = image.streamId();
        Int2ObjectHashMap imageBySessionIdMap = (Int2ObjectHashMap)this.sessionsByStreamIdMap.get(streamId);
        if (null != imageBySessionIdMap) {
            imageBySessionIdMap.remove(sessionId);
            this.ignoredSessionsMap.remove(sessionId, streamId);
        }
        image.ifActiveGoInactive();
        this.ignoredSessionsMap.put(sessionId, streamId, (Object)SessionStatus.ON_COOL_DOWN);
    }

    public void removePendingSetup(int sessionId, int streamId) {
        if (SessionStatus.PENDING_SETUP_FRAME == this.ignoredSessionsMap.get(sessionId, streamId)) {
            this.ignoredSessionsMap.remove(sessionId, streamId);
        }
    }

    public void removeCoolDown(int sessionId, int streamId) {
        if (SessionStatus.ON_COOL_DOWN == this.ignoredSessionsMap.get(sessionId, streamId)) {
            this.ignoredSessionsMap.remove(sessionId, streamId);
        }
    }

    @Override
    public int onDataPacket(ReceiveChannelEndpoint channelEndpoint, DataHeaderFlyweight header, UnsafeBuffer buffer, int length, InetSocketAddress srcAddress) {
        int streamId = header.streamId();
        Int2ObjectHashMap imageBySessionIdMap = (Int2ObjectHashMap)this.sessionsByStreamIdMap.get(streamId);
        if (null != imageBySessionIdMap) {
            int sessionId = header.sessionId();
            int termId = header.termId();
            PublicationImage image = (PublicationImage)imageBySessionIdMap.get(sessionId);
            if (null != image) {
                return image.insertPacket(termId, header.termOffset(), buffer, length);
            }
            if (null == this.ignoredSessionsMap.get(sessionId, streamId)) {
                this.elicitSetupMessageFromSource(channelEndpoint, srcAddress, streamId, sessionId);
            }
        }
        return 0;
    }

    @Override
    public void onSetupMessage(ReceiveChannelEndpoint channelEndpoint, SetupFlyweight header, UnsafeBuffer buffer, InetSocketAddress srcAddress) {
        int streamId = header.streamId();
        Int2ObjectHashMap imageBySessionIdMap = (Int2ObjectHashMap)this.sessionsByStreamIdMap.get(streamId);
        if (null != imageBySessionIdMap) {
            int sessionId = header.sessionId();
            int initialTermId = header.initialTermId();
            int activeTermId = header.activeTermId();
            PublicationImage image = (PublicationImage)imageBySessionIdMap.get(sessionId);
            if (null == image && this.isNotAlreadyInProgressOrOnCoolDown(streamId, sessionId)) {
                if (channelEndpoint.isMulticast() && channelEndpoint.multicastTtl() < header.ttl()) {
                    channelEndpoint.possibleTtlAsymmetryEncountered();
                }
                this.createPublicationImage(channelEndpoint, srcAddress, streamId, sessionId, initialTermId, activeTermId, header.termOffset(), header.termLength(), header.mtuLength());
            }
        }
    }

    public void onRttMeasurement(ReceiveChannelEndpoint channelEndpoint, RttMeasurementFlyweight header, InetSocketAddress srcAddress) {
        int sessionId;
        PublicationImage image;
        int streamId = header.streamId();
        Int2ObjectHashMap imageBySessionIdMap = (Int2ObjectHashMap)this.sessionsByStreamIdMap.get(streamId);
        if (null != imageBySessionIdMap && null != (image = (PublicationImage)imageBySessionIdMap.get(sessionId = header.sessionId()))) {
            if (128 == (header.flags() & 0x80)) {
                InetSocketAddress controlAddress = channelEndpoint.isMulticast() ? channelEndpoint.udpChannel().remoteControl() : srcAddress;
                channelEndpoint.sendRttMeasurement(controlAddress, sessionId, streamId, header.echoTimestamp(), 0L, false);
            } else {
                image.onRttMeasurement(header, srcAddress);
            }
        }
    }

    public boolean shouldElicitSetupMessage() {
        return !this.sessionsByStreamIdMap.isEmpty();
    }

    private boolean isNotAlreadyInProgressOrOnCoolDown(int streamId, int sessionId) {
        SessionStatus status = (SessionStatus)((Object)this.ignoredSessionsMap.get(sessionId, streamId));
        return SessionStatus.INIT_IN_PROGRESS != status && SessionStatus.ON_COOL_DOWN != status;
    }

    private void elicitSetupMessageFromSource(ReceiveChannelEndpoint channelEndpoint, InetSocketAddress srcAddress, int streamId, int sessionId) {
        InetSocketAddress controlAddress = channelEndpoint.isMulticast() ? channelEndpoint.udpChannel().remoteControl() : srcAddress;
        this.ignoredSessionsMap.put(sessionId, streamId, (Object)SessionStatus.PENDING_SETUP_FRAME);
        channelEndpoint.sendSetupElicitingStatusMessage(controlAddress, sessionId, streamId);
        this.receiver.addPendingSetupMessage(sessionId, streamId, channelEndpoint, false, controlAddress);
    }

    private void createPublicationImage(ReceiveChannelEndpoint channelEndpoint, InetSocketAddress srcAddress, int streamId, int sessionId, int initialTermId, int activeTermId, int termOffset, int termLength, int mtuLength) {
        InetSocketAddress controlAddress = channelEndpoint.isMulticast() ? channelEndpoint.udpChannel().remoteControl() : srcAddress;
        this.ignoredSessionsMap.put(sessionId, streamId, (Object)SessionStatus.INIT_IN_PROGRESS);
        this.conductorProxy.createPublicationImage(sessionId, streamId, initialTermId, activeTermId, termOffset, termLength, mtuLength, controlAddress, srcAddress, channelEndpoint);
    }

    public static enum SessionStatus {
        PENDING_SETUP_FRAME,
        INIT_IN_PROGRESS,
        ON_COOL_DOWN;

    }
}

