/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.udm;

import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.validation.ApplicationDependenciesFormat;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@PublicApiRef
@Metadata(description="A package of a certain version of an application. Groups all deployable artifact CIs for an application for a certain version. Is contained by the Application CI.")
public class DeploymentPackage
extends Version {
    @Property(description="The set of deployables that are part of this package", asContainment=true, required=false)
    private Set<Deployable> deployables = new HashSet<Deployable>();
    @Property(description="The versions of other applications that this package depends on, as a mapping from application name to version range", required=false, category="Dependencies")
    @ApplicationDependenciesFormat
    private Map<String, String> applicationDependencies;
    @Property(description="The resolution to use for application dependencies when deploying this application. Should be 'LATEST' or 'EXISTING'. A placeholder can be used.", defaultValue="LATEST", category="Dependencies")
    private String dependencyResolution = "LATEST";
    @Property(description="Whether to undeploy direct or transient dependencies of this application. Dependency is undeployed if there are not other application that depend on it. Should be 'true' or 'false'. A placeholder can be used.", required=false, defaultValue="false", category="Dependencies", label="Undeploy Unused Dependencies")
    private String undeployDependencies;

    public DeploymentPackage() {
    }

    public DeploymentPackage(Deployable ... deployables) {
        this.deployables = new HashSet<Deployable>(Arrays.asList(deployables));
    }

    @Override
    public Set<Deployable> getDeployables() {
        return Collections.unmodifiableSet(this.deployables);
    }

    public void setDeployables(Set<Deployable> deployables) {
        this.deployables = deployables;
    }

    public void addDeployable(Deployable deployable) {
        if (deployable == null) {
            throw new NullPointerException("Cannot add a null deployable");
        }
        this.deployables.add(deployable);
    }

    public Map<String, String> getApplicationDependencies() {
        return this.applicationDependencies;
    }

    public void setApplicationDependencies(Map<String, String> applicationDependencies) {
        this.applicationDependencies = applicationDependencies;
    }

    public String getDependencyResolution() {
        return this.dependencyResolution;
    }

    public void setDependencyResolution(String dependencyResolution) {
        this.dependencyResolution = dependencyResolution;
    }

    public String getUndeployDependencies() {
        return this.undeployDependencies;
    }

    public void setUndeployDependencies(String undeployDependencies) {
        this.undeployDependencies = undeployDependencies;
    }

    public static interface DependencyResolution {
        public static final String LATEST = "LATEST";
        public static final String EXISTING = "EXISTING";
    }
}

