/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.xstream;

import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.xebialabs.deployit.plugin.api.udm.CiAttributes;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.xltype.serialization.CiListReader;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.xstream.DateTimeAdapter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class CiXstreamReader
implements CiReader,
CiListReader {
    private final HierarchicalStreamReader reader;
    private final DateTimeAdapter dateTimeAdapter = new DateTimeAdapter();

    public CiXstreamReader(HierarchicalStreamReader reader) {
        this.reader = reader;
    }

    @Override
    public String getType() {
        return this.reader.getNodeName();
    }

    @Override
    public String getId() {
        return this.reader.getAttribute("id");
    }

    @Override
    public String getToken() {
        return this.reader.getAttribute("token");
    }

    @Override
    public CiAttributes getCiAttributes() {
        return new CiAttributes(this.reader.getAttribute("created-by"), this.getDateAttribute("created-at"), this.reader.getAttribute("last-modified-by"), this.getDateAttribute("last-modified-at"));
    }

    private DateTime getDateAttribute(String attrName) {
        String attribute = this.reader.getAttribute(attrName);
        if (attribute != null) {
            return this.dateTimeAdapter.unmarshal(attribute);
        }
        return null;
    }

    @Override
    public boolean hasMoreProperties() {
        return this.reader.hasMoreChildren();
    }

    @Override
    public void moveIntoProperty() {
        this.reader.moveDown();
    }

    @Override
    public CiReader moveIntoNestedProperty() {
        this.reader.moveDown();
        return this;
    }

    @Override
    public void moveOutOfProperty() {
        this.reader.moveUp();
    }

    @Override
    public String getCurrentPropertyName() {
        return this.reader.getNodeName();
    }

    @Override
    public String getStringValue() {
        return this.reader.getValue();
    }

    @Override
    public List<String> getStringValues() {
        ArrayList<String> strings = new ArrayList<String>();
        while (this.reader.hasMoreChildren()) {
            this.reader.moveDown();
            strings.add(this.reader.getValue());
            this.reader.moveUp();
        }
        return strings;
    }

    @Override
    public Map<String, String> getStringMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        while (this.reader.hasMoreChildren()) {
            this.reader.moveDown();
            map.put(this.reader.getAttribute("key"), this.reader.getValue());
            this.reader.moveUp();
        }
        return map;
    }

    @Override
    public boolean isCiReference() {
        return this.reader.getAttribute("ref") != null;
    }

    @Override
    public String getCiReference() {
        return this.reader.getAttribute("ref");
    }

    @Override
    public List<String> getCiReferences() {
        ArrayList<String> references = new ArrayList<String>();
        while (this.reader.hasMoreChildren()) {
            this.reader.moveDown();
            references.add(this.getCiReference());
            this.reader.moveUp();
        }
        return references;
    }

    @Override
    public CiListReader getCurrentCiListReader() {
        return this;
    }

    @Override
    public List<ValidationMessage> getValidationMessages() {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        while (this.reader.hasMoreChildren()) {
            this.reader.moveDown();
            String property = this.reader.getAttribute("property");
            String level = this.reader.getAttribute("level");
            messages.add(new ValidationMessage(this.reader.getAttribute("ci"), property, this.getStringValue(), level));
            this.reader.moveUp();
        }
        return messages;
    }

    @Override
    public boolean hasMoreChildren() {
        return this.reader.hasMoreChildren();
    }

    @Override
    public void moveIntoChild() {
        this.reader.moveDown();
    }

    @Override
    public void moveOutOfChild() {
        this.reader.moveUp();
    }

    @Override
    public CiReader getCurrentCiReader() {
        return this;
    }
}

