/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.xml;

import com.xebialabs.deployit.core.AbstractStringView;
import com.xebialabs.deployit.core.ListOfStringView;
import com.xebialabs.deployit.core.MapStringStringView;
import com.xebialabs.deployit.core.SetOfStringView;
import com.xebialabs.deployit.core.StringValue;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.EncryptedDictionary;
import com.xebialabs.deployit.repository.StringValueConverter;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.CiWriter;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PasswordEncryptingCiConverter
extends ConfigurationItemConverter {
    private final PasswordEncrypter passwordEncrypter = PasswordEncrypter.getInstance();
    private final StringValueConverter converter = new StringValueConverter(this.passwordEncrypter);

    public PasswordEncryptingCiConverter() {
        this.setWriteValidationMessages(true);
    }

    protected void writeStringProperty(Object value, PropertyDescriptor propertyDescriptor, CiWriter writer) {
        if (propertyDescriptor.isPassword()) {
            writer.valueAsString((Object)this.passwordEncrypter.ensureEncrypted(value.toString()));
        } else {
            super.writeStringProperty(value, propertyDescriptor, writer);
        }
    }

    protected void writeCollectionOfStringProperty(Object value, PropertyDescriptor propertyDescriptor, CiWriter writer) {
        if (value instanceof AbstractStringView) {
            if (propertyDescriptor.isPassword()) {
                value = ((AbstractStringView)value).encrypt();
            }
            Collection wrapped = ((AbstractStringView)value).getWrapped();
            value = wrapped.stream().map(v -> (String)StringValueConverter.valueToString((PasswordEncrypter)this.passwordEncrypter, (boolean)true).apply(v)).collect(Collectors.toList());
        }
        super.writeCollectionOfStringProperty((Object)value, propertyDescriptor, writer);
    }

    protected void writeMapStringStringProperty(Object value, PropertyDescriptor propertyDescriptor, CiWriter writer) {
        if (value instanceof MapStringStringView) {
            if (propertyDescriptor.isPassword()) {
                value = ((MapStringStringView)value).encrypt();
            }
            Map wrapped = ((MapStringStringView)value).getWrapped();
            value = wrapped.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)StringValueConverter.valueToString((PasswordEncrypter)this.passwordEncrypter, (boolean)true).apply(e.getValue())));
        }
        super.writeMapStringStringProperty((Object)value, propertyDescriptor, writer);
    }

    protected void writeCollectionOfCiProperty(Object value, PropertyDescriptor propertyDescriptor, CiWriter writer) {
        Collection cis = (Collection)value;
        ArrayList<String> ids = new ArrayList<String>(cis.size());
        for (ConfigurationItem ci : cis) {
            ids.add(ci.getId());
        }
        writer.ciReferences(ids);
    }

    protected void readStringProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, CiReader reader) {
        if (propertyDescriptor.isPassword()) {
            propertyDescriptor.set(configurationItem, (Object)this.passwordEncrypter.ensureDecrypted(reader.getStringValue()));
        } else {
            super.readStringProperty(configurationItem, propertyDescriptor, reader);
        }
    }

    protected void readCollectionOfStringProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, CiReader reader) {
        Object strings = propertyDescriptor.getKind() == PropertyKind.SET_OF_STRING ? new SetOfStringView((Set)this.readConverted(reader, new LinkedHashSet())) : new ListOfStringView((List)this.readConverted(reader, new ArrayList()));
        if (propertyDescriptor.isPassword()) {
            strings = strings.encrypt();
        }
        propertyDescriptor.set(configurationItem, strings);
    }

    private <T extends Collection<StringValue>> T readConverted(CiReader reader, T convertedStrings) {
        List rawStrings = reader.getStringValues();
        for (String string : rawStrings) {
            convertedStrings.add((StringValue)this.converter.convert(string));
        }
        return convertedStrings;
    }

    protected void readMapStringStringProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, CiReader reader) {
        HashMap map = new HashMap();
        boolean encrypt = configurationItem.getType().equals((Object)Type.valueOf(EncryptedDictionary.class));
        for (Map.Entry entry : reader.getStringMap().entrySet()) {
            map.put(entry.getKey(), this.converter.convert((String)entry.getValue(), encrypt));
        }
        MapStringStringView value = new MapStringStringView(map);
        if (propertyDescriptor.isPassword()) {
            value = value.encrypt();
        }
        propertyDescriptor.set(configurationItem, (Object)value);
    }
}

