/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.lang;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.crsh.cli.Argument;
import org.crsh.cli.Command;
import org.crsh.cli.Named;
import org.crsh.cli.Option;
import org.crsh.cli.Required;
import org.crsh.cli.descriptor.Description;
import org.crsh.cli.descriptor.ParameterDescriptor;
import org.crsh.cli.impl.ParameterType;
import org.crsh.cli.impl.descriptor.IntrospectionException;
import org.crsh.cli.impl.lang.Binding;
import org.crsh.cli.impl.lang.BoundArgumentDescriptor;
import org.crsh.cli.impl.lang.BoundOptionDescriptor;
import org.crsh.cli.impl.lang.ClassDescriptor;
import org.crsh.cli.impl.lang.ClassFieldBinding;
import org.crsh.cli.impl.lang.MethodArgumentBinding;
import org.crsh.cli.impl.lang.MethodDescriptor;
import org.crsh.cli.impl.lang.ObjectCommandDescriptor;
import org.crsh.cli.type.ValueTypeFactory;

public class CommandFactory {
    public static final CommandFactory DEFAULT = new CommandFactory();
    private static final Logger log = Logger.getLogger(CommandFactory.class.getName());
    protected final ValueTypeFactory valueTypeFactory;

    public CommandFactory() {
        this.valueTypeFactory = ValueTypeFactory.DEFAULT;
    }

    public CommandFactory(ClassLoader loader) throws NullPointerException {
        this(new ValueTypeFactory(loader));
    }

    public CommandFactory(ValueTypeFactory valueTypeFactory) throws NullPointerException {
        if (valueTypeFactory == null) {
            throw new NullPointerException("No null value type factory accepted");
        }
        this.valueTypeFactory = valueTypeFactory;
    }

    private List<Method> findAllMethods(Class<?> introspected) throws IntrospectionException {
        ArrayList<Method> methods;
        Class<?> superIntrospected = introspected.getSuperclass();
        if (superIntrospected == null) {
            methods = new ArrayList();
        } else {
            methods = this.findAllMethods(superIntrospected);
            for (Method method : introspected.getDeclaredMethods()) {
                if (method.getAnnotation(Command.class) == null) continue;
                methods.add(method);
            }
        }
        return methods;
    }

    public <T> ObjectCommandDescriptor<T> create(Class<T> type) throws IntrospectionException {
        List<Method> methods = this.findAllMethods(type);
        String commandName = type.getAnnotation(Named.class) != null ? type.getAnnotation(Named.class).value() : type.getSimpleName();
        if (methods.size() == 1 && methods.get(0).getName().equals("main")) {
            MethodDescriptor<T> methodDescriptor = this.create(null, commandName, methods.get(0));
            for (ParameterDescriptor parameter : this.parameters(type)) {
                methodDescriptor.addParameter(parameter);
            }
            return methodDescriptor;
        }
        LinkedHashMap methodMap = new LinkedHashMap();
        ClassDescriptor<T> classDescriptor = new ClassDescriptor<T>(type, commandName, methodMap, new Description(type));
        for (Method method : methods) {
            String methodName = method.getAnnotation(Named.class) != null ? method.getAnnotation(Named.class).value() : method.getName();
            MethodDescriptor<T> methodDescriptor = this.create(classDescriptor, methodName, method);
            methodMap.put(methodDescriptor.getName(), methodDescriptor);
        }
        for (ParameterDescriptor parameter : this.parameters(type)) {
            classDescriptor.addParameter(parameter);
        }
        return classDescriptor;
    }

    private <T> MethodDescriptor<T> create(ClassDescriptor<T> classDescriptor, String name, Method method) throws IntrospectionException {
        Description info = new Description(method);
        MethodDescriptor<T> methodDescriptor = new MethodDescriptor<T>(classDescriptor, method, name, info);
        Type[] parameterTypes = method.getGenericParameterTypes();
        Annotation[][] parameterAnnotationMatrix = method.getParameterAnnotations();
        for (int i = 0; i < parameterAnnotationMatrix.length; ++i) {
            Annotation[] parameterAnnotations = parameterAnnotationMatrix[i];
            Type parameterType = parameterTypes[i];
            Tuple tuple = CommandFactory.get(parameterAnnotations);
            MethodArgumentBinding binding = new MethodArgumentBinding(i);
            ParameterDescriptor parameter = this.create(binding, parameterType, tuple.argumentAnn, tuple.optionAnn, tuple.required, tuple.descriptionAnn, tuple.ann);
            if (parameter != null) {
                methodDescriptor.addParameter(parameter);
                continue;
            }
            log.log(Level.FINE, "Method argument with index " + i + " of method " + method + " is not annotated");
        }
        return methodDescriptor;
    }

    private ParameterDescriptor create(Binding binding, Type type, Argument argumentAnn, Option optionAnn, boolean required, Description info, Annotation ann) throws IntrospectionException {
        if (argumentAnn != null) {
            if (optionAnn != null) {
                throw new IntrospectionException();
            }
            return new BoundArgumentDescriptor(binding, argumentAnn.name(), ParameterType.create(this.valueTypeFactory, type), info, required, false, argumentAnn.unquote(), argumentAnn.completer(), ann);
        }
        if (optionAnn != null) {
            return new BoundOptionDescriptor(binding, ParameterType.create(this.valueTypeFactory, type), Collections.unmodifiableList(Arrays.asList(optionAnn.names())), info, required, false, optionAnn.unquote(), optionAnn.completer(), ann);
        }
        return null;
    }

    private static Tuple get(Annotation ... ab) {
        Argument argumentAnn = null;
        Option optionAnn = null;
        Boolean required = null;
        Description description = new Description(ab);
        Annotation info = null;
        for (Annotation parameterAnnotation : ab) {
            Required metaReq;
            if (parameterAnnotation instanceof Option) {
                optionAnn = (Option)parameterAnnotation;
                continue;
            }
            if (parameterAnnotation instanceof Argument) {
                argumentAnn = (Argument)parameterAnnotation;
                continue;
            }
            if (parameterAnnotation instanceof Required) {
                required = ((Required)parameterAnnotation).value();
                continue;
            }
            if (info != null) continue;
            Class<? extends Annotation> a = parameterAnnotation.annotationType();
            if (a.getAnnotation(Option.class) != null) {
                optionAnn = a.getAnnotation(Option.class);
                info = parameterAnnotation;
            } else if (a.getAnnotation(Argument.class) != null) {
                argumentAnn = a.getAnnotation(Argument.class);
                info = parameterAnnotation;
            }
            if (info == null) continue;
            description = new Description(description, new Description(a));
            if (required != null || (metaReq = a.getAnnotation(Required.class)) == null) continue;
            required = metaReq.value();
        }
        return new Tuple(argumentAnn, optionAnn, required != null && required != false, description, info);
    }

    private List<ParameterDescriptor> parameters(Class<?> introspected) throws IntrospectionException {
        ArrayList<ParameterDescriptor> parameters;
        Class<?> superIntrospected = introspected.getSuperclass();
        if (superIntrospected == null) {
            parameters = new ArrayList();
        } else {
            parameters = this.parameters(superIntrospected);
            for (Field f : introspected.getDeclaredFields()) {
                Tuple tuple = CommandFactory.get(f.getAnnotations());
                ClassFieldBinding binding = new ClassFieldBinding(f);
                ParameterDescriptor parameter = this.create(binding, f.getGenericType(), tuple.argumentAnn, tuple.optionAnn, tuple.required, tuple.descriptionAnn, tuple.ann);
                if (parameter == null) continue;
                parameters.add(parameter);
            }
        }
        return parameters;
    }

    protected static class Tuple {
        final Argument argumentAnn;
        final Option optionAnn;
        final boolean required;
        final Description descriptionAnn;
        final Annotation ann;

        private Tuple(Argument argumentAnn, Option optionAnn, boolean required, Description info, Annotation ann) {
            this.argumentAnn = argumentAnn;
            this.optionAnn = optionAnn;
            this.required = required;
            this.descriptionAnn = info;
            this.ann = ann;
        }
    }
}

