/*
 * Decompiled with CFR 0.152.
 */
package akka.http.scaladsl.unmarshalling;

import akka.http.scaladsl.model.ContentTypeRange;
import akka.http.scaladsl.model.ContentTypeRange$;
import akka.http.scaladsl.model.ErrorInfo;
import akka.http.scaladsl.model.FormData;
import akka.http.scaladsl.model.FormData$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.IllegalUriException;
import akka.http.scaladsl.model.MediaType;
import akka.http.scaladsl.model.MediaTypes$;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.unmarshalling.PredefinedFromEntityUnmarshallers;
import akka.http.scaladsl.unmarshalling.Unmarshaller;
import akka.http.scaladsl.unmarshalling.Unmarshaller$;
import akka.http.scaladsl.unmarshalling.Unmarshaller$EnhancedFromEntityUnmarshaller$;
import akka.http.scaladsl.unmarshalling.Unmarshaller$EnhancedUnmarshaller$;
import akka.http.scaladsl.util.FastFuture$;
import akka.parboiled2.ParserInput;
import akka.parboiled2.ParserInput$;
import akka.stream.Materializer;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.nio.CharBuffer;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;

public abstract class PredefinedFromEntityUnmarshallers$class {
    public static Unmarshaller byteStringUnmarshaller(PredefinedFromEntityUnmarshallers $this) {
        return Unmarshaller$.MODULE$.withMaterializer(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Function1<Materializer, Function1<HttpEntity, Future<ByteString>>> apply(ExecutionContext x$1) {
                return new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Function1<HttpEntity, Future<ByteString>> apply(Materializer mat) {
                        return new Serializable(this, mat){
                            public static final long serialVersionUID = 0L;
                            private final Materializer mat$1;

                            public final Future<ByteString> apply(HttpEntity x0$1) {
                                Future future;
                                HttpEntity httpEntity = x0$1;
                                if (httpEntity instanceof HttpEntity.Strict) {
                                    HttpEntity.Strict strict2 = (HttpEntity.Strict)httpEntity;
                                    ByteString data = strict2.data();
                                    future = (Future)FastFuture$.MODULE$.successful().apply((Object)data);
                                } else {
                                    future = httpEntity.dataBytes().runFold((Object)ByteString$.MODULE$.empty(), (Function2)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final ByteString apply(ByteString x$2, ByteString x$3) {
                                            return x$2.$plus$plus(x$3);
                                        }
                                    }, this.mat$1);
                                }
                                return future;
                            }
                            {
                                this.mat$1 = mat$1;
                            }
                        };
                    }
                };
            }
        });
    }

    public static Unmarshaller byteArrayUnmarshaller(PredefinedFromEntityUnmarshallers $this) {
        return $this.byteStringUnmarshaller().map(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(ByteString x$4) {
                return (byte[])x$4.toArray(ClassTag$.MODULE$.Byte());
            }
        });
    }

    public static Unmarshaller charArrayUnmarshaller(PredefinedFromEntityUnmarshallers $this) {
        return Unmarshaller$EnhancedUnmarshaller$.MODULE$.mapWithInput$extension(Unmarshaller$.MODULE$.EnhancedUnmarshaller($this.byteStringUnmarshaller()), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final char[] apply(HttpEntity entity2, ByteString bytes) {
                char[] cArray;
                if (entity2.isKnownEmpty()) {
                    cArray = Array$.MODULE$.emptyCharArray();
                } else {
                    CharBuffer charBuffer = Unmarshaller$.MODULE$.bestUnmarshallingCharsetFor(entity2).nioCharset().decode(bytes.asByteBuffer());
                    char[] array = new char[charBuffer.length()];
                    charBuffer.get(array);
                    cArray = array;
                }
                return cArray;
            }
        });
    }

    public static Unmarshaller stringUnmarshaller(PredefinedFromEntityUnmarshallers $this) {
        return Unmarshaller$EnhancedUnmarshaller$.MODULE$.mapWithInput$extension(Unmarshaller$.MODULE$.EnhancedUnmarshaller($this.byteStringUnmarshaller()), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(HttpEntity entity2, ByteString bytes) {
                return entity2.isKnownEmpty() ? "" : bytes.decodeString(Unmarshaller$.MODULE$.bestUnmarshallingCharsetFor(entity2).nioCharset());
            }
        });
    }

    public static Unmarshaller defaultUrlEncodedFormDataUnmarshaller(PredefinedFromEntityUnmarshallers $this) {
        return $this.urlEncodedFormDataUnmarshaller((Seq<ContentTypeRange>)Predef$.MODULE$.wrapRefArray((Object[])new ContentTypeRange[]{ContentTypeRange$.MODULE$.apply((MediaType)MediaTypes$.MODULE$.application$divx$minuswww$minusform$minusurlencoded())}));
    }

    public static Unmarshaller urlEncodedFormDataUnmarshaller(PredefinedFromEntityUnmarshallers $this, Seq ranges) {
        return Unmarshaller$EnhancedUnmarshaller$.MODULE$.mapWithInput$extension(Unmarshaller$.MODULE$.EnhancedUnmarshaller(Unmarshaller$EnhancedFromEntityUnmarshaller$.MODULE$.forContentTypes$extension(Unmarshaller$.MODULE$.EnhancedFromEntityUnmarshaller($this.stringUnmarshaller()), (Seq<ContentTypeRange>)ranges)), new Serializable($this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final FormData apply(HttpEntity entity2, String string) {
                FormData formData;
                if (entity2.isKnownEmpty()) {
                    formData = FormData$.MODULE$.Empty();
                    return formData;
                }
                try {
                    formData = new FormData(Uri.Query$.MODULE$.apply((ParserInput)ParserInput$.MODULE$.apply(string), Unmarshaller$.MODULE$.bestUnmarshallingCharsetFor(entity2).nioCharset(), Uri.Query$.MODULE$.apply$default$3()));
                    return formData;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!(throwable2 instanceof IllegalUriException)) throw throwable;
                    IllegalUriException illegalUriException = (IllegalUriException)throwable2;
                    ErrorInfo info = illegalUriException.info();
                    throw new IllegalArgumentException(info.formatPretty().replace("Query,", "form content,"));
                }
            }
        });
    }

    public static void $init$(PredefinedFromEntityUnmarshallers $this) {
    }
}

