/*
 * Decompiled with CFR 0.152.
 */
package akka.http.scaladsl.server.directives;

import akka.actor.ActorSystem;
import akka.event.LoggingAdapter;
import akka.http.scaladsl.marshalling.Marshaller;
import akka.http.scaladsl.marshalling.Marshaller$;
import akka.http.scaladsl.marshalling.ToResponseMarshallable;
import akka.http.scaladsl.marshalling.ToResponseMarshallable$;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.DateTime;
import akka.http.scaladsl.model.DateTime$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.headers.EntityTag;
import akka.http.scaladsl.model.headers.EntityTag$;
import akka.http.scaladsl.server.Directive;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteConcatenation$;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.StandardRoute;
import akka.http.scaladsl.server.directives.BasicDirectives$;
import akka.http.scaladsl.server.directives.CacheConditionDirectives$;
import akka.http.scaladsl.server.directives.ContentTypeResolver;
import akka.http.scaladsl.server.directives.DirectoryListing;
import akka.http.scaladsl.server.directives.FileAndResourceDirectives;
import akka.http.scaladsl.server.directives.FileAndResourceDirectives$;
import akka.http.scaladsl.server.directives.FileAndResourceDirectives$$anonfun$getFromFile$1$;
import akka.http.scaladsl.server.directives.FileAndResourceDirectives$$anonfun$getFromFile$1$$anonfun$apply$1$;
import akka.http.scaladsl.server.directives.FileAndResourceDirectives$$anonfun$getFromResource$1$;
import akka.http.scaladsl.server.directives.FileAndResourceDirectives$$anonfun$getFromResource$1$$anonfun$apply$5$;
import akka.http.scaladsl.server.directives.FileAndResourceDirectives$$anonfun$getFromResource$1$$anonfun$apply$5$$anonfun$apply$6$;
import akka.http.scaladsl.server.directives.FileAndResourceDirectives$$anonfun$listDirectoryContents$1$;
import akka.http.scaladsl.server.directives.FileAndResourceDirectives$$anonfun$listDirectoryContents$1$$anonfun$apply$11$;
import akka.http.scaladsl.server.directives.FileAndResourceDirectives$ResourceFile$;
import akka.http.scaladsl.server.directives.MethodDirectives$;
import akka.http.scaladsl.server.directives.RouteDirectives$;
import akka.http.scaladsl.server.util.ApplyConverter$;
import akka.http.scaladsl.server.util.Tuple$;
import akka.http.scaladsl.settings.RoutingSettings;
import akka.stream.ActorAttributes$;
import akka.stream.scaladsl.FileIO$;
import akka.stream.scaladsl.StreamConverters$;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Future;
import scala.math.package$;
import scala.runtime.BoxedUnit;

public abstract class FileAndResourceDirectives$class {
    public static Function1 getFromFile(FileAndResourceDirectives $this, String fileName, ContentTypeResolver resolver) {
        return $this.getFromFile(new File(fileName), resolver);
    }

    public static Function1 getFromFile(FileAndResourceDirectives $this, File file, ContentTypeResolver resolver) {
        return $this.getFromFile(file, resolver.apply(file.getName()));
    }

    public static Function1 getFromFile(FileAndResourceDirectives $this, File file, ContentType contentType) {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(MethodDirectives$.MODULE$.get()).apply((Object)new Serializable($this, file, contentType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileAndResourceDirectives $outer;
            public final File file$1;
            public final ContentType contentType$1;

            public final Function1<RequestContext, Future<RouteResult>> apply() {
                return this.file$1.isFile() && this.file$1.canRead() ? (Function1)Directive$.MODULE$.addByNameNullaryApply(FileAndResourceDirectives$class.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$conditionalFor(this.$outer, this.file$1.length(), this.file$1.lastModified())).apply((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FileAndResourceDirectives$.anonfun.getFromFile.1 $outer;

                    public final Function1<RequestContext, Future<RouteResult>> apply() {
                        return this.$outer.file$1.length() > 0L ? (Function1)Directive$.MODULE$.addDirectiveApply(FileAndResourceDirectives$.MODULE$.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$withRangeSupportAndPrecompressedMediaTypeSupportAndExtractSettings(), ApplyConverter$.MODULE$.hac1()).apply((Object)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ FileAndResourceDirectives$$anonfun$getFromFile$1$.anonfun.apply.1 $outer;

                            public final StandardRoute apply(RoutingSettings settings) {
                                return RouteDirectives$.MODULE$.complete((Function0<ToResponseMarshallable>)new Serializable(this, settings){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ FileAndResourceDirectives$$anonfun$getFromFile$1$$anonfun$apply$1$.anonfun.apply.2 $outer;
                                    private final RoutingSettings settings$1;

                                    public final ToResponseMarshallable apply() {
                                        return ToResponseMarshallable$.MODULE$.apply(new HttpEntity.Default(this.$outer.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$anonfun$$anonfun$$anonfun$$$outer().akka$http$scaladsl$server$directives$FileAndResourceDirectives$$anonfun$$anonfun$$$outer().contentType$1, this.$outer.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$anonfun$$anonfun$$anonfun$$$outer().akka$http$scaladsl$server$directives$FileAndResourceDirectives$$anonfun$$anonfun$$$outer().file$1.length(), FileIO$.MODULE$.fromPath(this.$outer.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$anonfun$$anonfun$$anonfun$$$outer().akka$http$scaladsl$server$directives$FileAndResourceDirectives$$anonfun$$anonfun$$$outer().file$1.toPath(), FileIO$.MODULE$.fromPath$default$2()).withAttributes(ActorAttributes$.MODULE$.dispatcher(this.settings$1.fileIODispatcher()))), Marshaller$.MODULE$.liftMarshaller(Marshaller$.MODULE$.MessageEntityMarshaller()));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.settings$1 = settings$1;
                                    }
                                });
                            }

                            public /* synthetic */ FileAndResourceDirectives$$anonfun$getFromFile$1$.anonfun.apply.1 akka$http$scaladsl$server$directives$FileAndResourceDirectives$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }) : RouteDirectives$.MODULE$.complete((Function0<ToResponseMarshallable>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final ToResponseMarshallable apply() {
                                return ToResponseMarshallable$.MODULE$.apply(HttpEntity$.MODULE$.Empty(), Marshaller$.MODULE$.liftMarshaller(Marshaller$.MODULE$.MessageEntityMarshaller()));
                            }
                        });
                    }

                    public /* synthetic */ FileAndResourceDirectives$.anonfun.getFromFile.1 akka$http$scaladsl$server$directives$FileAndResourceDirectives$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }) : RouteDirectives$.MODULE$.reject();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.file$1 = file$1;
                this.contentType$1 = contentType$1;
            }
        });
    }

    public static Directive akka$http$scaladsl$server$directives$FileAndResourceDirectives$$conditionalFor(FileAndResourceDirectives $this, long length, long lastModified) {
        return Directive$.MODULE$.SingleValueModifiers(BasicDirectives$.MODULE$.extractSettings()).flatMap(new Serializable($this, length, lastModified){
            public static final long serialVersionUID = 0L;
            private final long length$1;
            private final long lastModified$1;

            public final Directive<BoxedUnit> apply(RoutingSettings settings) {
                Directive<BoxedUnit> directive;
                if (settings.fileGetConditional()) {
                    String tag = Long.toHexString(this.lastModified$1 ^ Long.reverse(this.length$1));
                    DateTime lastModifiedDateTime = DateTime$.MODULE$.apply(package$.MODULE$.min(this.lastModified$1, System.currentTimeMillis()));
                    directive = CacheConditionDirectives$.MODULE$.conditional(new EntityTag(tag, EntityTag$.MODULE$.apply$default$2()), lastModifiedDateTime);
                } else {
                    directive = BasicDirectives$.MODULE$.pass();
                }
                return directive;
            }
            {
                this.length$1 = length$1;
                this.lastModified$1 = lastModified$1;
            }
        }, Tuple$.MODULE$.forUnit());
    }

    public static Function1 getFromResource(FileAndResourceDirectives $this, String resourceName, ContentTypeResolver resolver) {
        return $this.getFromResource(resourceName, resolver.apply(resourceName), $this.getFromResource$default$3());
    }

    public static Function1 getFromResource(FileAndResourceDirectives $this, String resourceName, ContentType contentType, ClassLoader classLoader) {
        return resourceName.endsWith("/") ? RouteDirectives$.MODULE$.reject() : (Function1)Directive$.MODULE$.addByNameNullaryApply(MethodDirectives$.MODULE$.get()).apply((Object)new Serializable($this, resourceName, contentType, classLoader){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileAndResourceDirectives $outer;
            private final String resourceName$1;
            public final ContentType contentType$2;
            private final ClassLoader classLoader$1;

            public final Function1<RequestContext, Future<RouteResult>> apply() {
                StandardRoute standardRoute;
                Some some;
                FileAndResourceDirectives.ResourceFile resourceFile;
                Option option = Option$.MODULE$.apply((Object)this.classLoader$1.getResource(this.resourceName$1)).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<FileAndResourceDirectives.ResourceFile> apply(URL url) {
                        return FileAndResourceDirectives$ResourceFile$.MODULE$.apply(url);
                    }
                });
                if (option instanceof Some && (resourceFile = (FileAndResourceDirectives.ResourceFile)(some = (Some)option).x()) != null) {
                    URL url = resourceFile.url();
                    long length = resourceFile.length();
                    long lastModified = resourceFile.lastModified();
                    standardRoute = (Function1)Directive$.MODULE$.addByNameNullaryApply(FileAndResourceDirectives$class.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$conditionalFor(this.$outer, length, lastModified)).apply((Object)new Serializable(this, url, length){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ FileAndResourceDirectives$.anonfun.getFromResource.1 $outer;
                        public final URL url$2;
                        public final long length$2;

                        public final Function1<RequestContext, Future<RouteResult>> apply() {
                            return this.length$2 > 0L ? (Function1)Directive$.MODULE$.addDirectiveApply(FileAndResourceDirectives$.MODULE$.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$withRangeSupportAndPrecompressedMediaTypeSupportAndExtractSettings(), ApplyConverter$.MODULE$.hac1()).apply((Object)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ FileAndResourceDirectives$$anonfun$getFromResource$1$.anonfun.apply.5 $outer;

                                public final StandardRoute apply(RoutingSettings settings) {
                                    return RouteDirectives$.MODULE$.complete((Function0<ToResponseMarshallable>)new Serializable(this, settings){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ FileAndResourceDirectives$$anonfun$getFromResource$1$$anonfun$apply$5$.anonfun.apply.6 $outer;
                                        private final RoutingSettings settings$2;

                                        public final ToResponseMarshallable apply() {
                                            return ToResponseMarshallable$.MODULE$.apply(new HttpEntity.Default(this.$outer.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$anonfun$$anonfun$$anonfun$$$outer().akka$http$scaladsl$server$directives$FileAndResourceDirectives$$anonfun$$anonfun$$$outer().contentType$2, this.$outer.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$anonfun$$anonfun$$anonfun$$$outer().length$2, StreamConverters$.MODULE$.fromInputStream((Function0)new Serializable(this){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ FileAndResourceDirectives$$anonfun$getFromResource$1$$anonfun$apply$5$$anonfun$apply$6$.anonfun.apply.7 $outer;

                                                public final InputStream apply() {
                                                    return this.$outer.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().akka$http$scaladsl$server$directives$FileAndResourceDirectives$$anonfun$$anonfun$$anonfun$$$outer().url$2.openStream();
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                }
                                            }, StreamConverters$.MODULE$.fromInputStream$default$2()).withAttributes(ActorAttributes$.MODULE$.dispatcher(this.settings$2.fileIODispatcher()))), Marshaller$.MODULE$.liftMarshaller(Marshaller$.MODULE$.MessageEntityMarshaller()));
                                        }

                                        public /* synthetic */ FileAndResourceDirectives$$anonfun$getFromResource$1$$anonfun$apply$5$.anonfun.apply.6 akka$http$scaladsl$server$directives$FileAndResourceDirectives$$anonfun$$anonfun$$anonfun$$anonfun$$$outer() {
                                            return this.$outer;
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.settings$2 = settings$2;
                                        }
                                    });
                                }

                                public /* synthetic */ FileAndResourceDirectives$$anonfun$getFromResource$1$.anonfun.apply.5 akka$http$scaladsl$server$directives$FileAndResourceDirectives$$anonfun$$anonfun$$anonfun$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }) : RouteDirectives$.MODULE$.complete((Function0<ToResponseMarshallable>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final ToResponseMarshallable apply() {
                                    return ToResponseMarshallable$.MODULE$.apply(HttpEntity$.MODULE$.Empty(), Marshaller$.MODULE$.liftMarshaller(Marshaller$.MODULE$.MessageEntityMarshaller()));
                                }
                            });
                        }

                        public /* synthetic */ FileAndResourceDirectives$.anonfun.getFromResource.1 akka$http$scaladsl$server$directives$FileAndResourceDirectives$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.url$2 = url$2;
                            this.length$2 = length$2;
                        }
                    });
                } else {
                    standardRoute = RouteDirectives$.MODULE$.reject();
                }
                return standardRoute;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.resourceName$1 = resourceName$1;
                this.contentType$2 = contentType$2;
                this.classLoader$1 = classLoader$1;
            }
        });
    }

    public static ClassLoader getFromResource$default$3(FileAndResourceDirectives $this) {
        return $this._defaultClassLoader();
    }

    public static Function1 getFromDirectory(FileAndResourceDirectives $this, String directoryName, ContentTypeResolver resolver) {
        return (Function1)Directive$.MODULE$.addDirectiveApply(BasicDirectives$.MODULE$.extractUnmatchedPath(), ApplyConverter$.MODULE$.hac1()).apply((Object)new Serializable($this, directoryName, resolver){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileAndResourceDirectives $outer;
            public final String directoryName$1;
            public final ContentTypeResolver resolver$1;

            public final Function1<RequestContext, Future<RouteResult>> apply(Uri.Path unmatchedPath) {
                return (Function1)Directive$.MODULE$.addDirectiveApply(BasicDirectives$.MODULE$.extractLog(), ApplyConverter$.MODULE$.hac1()).apply((Object)new Serializable(this, unmatchedPath){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FileAndResourceDirectives$.anonfun.getFromDirectory.1 $outer;
                    private final Uri.Path unmatchedPath$1;

                    public final Function1<RequestContext, Future<RouteResult>> apply(LoggingAdapter log) {
                        String string = FileAndResourceDirectives$.MODULE$.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$safeDirectoryChildPath(FileAndResourceDirectives$.MODULE$.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$withTrailingSlash(this.$outer.directoryName$1), this.unmatchedPath$1, log, FileAndResourceDirectives$.MODULE$.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$safeDirectoryChildPath$default$4());
                        Function1<RequestContext, Future<RouteResult>> function1 = "".equals(string) ? RouteDirectives$.MODULE$.reject() : this.$outer.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$anonfun$$$outer().getFromFile(string, this.$outer.resolver$1);
                        return function1;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.unmatchedPath$1 = unmatchedPath$1;
                    }
                });
            }

            public /* synthetic */ FileAndResourceDirectives akka$http$scaladsl$server$directives$FileAndResourceDirectives$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.directoryName$1 = directoryName$1;
                this.resolver$1 = resolver$1;
            }
        });
    }

    public static Function1 listDirectoryContents(FileAndResourceDirectives $this, Seq directories, FileAndResourceDirectives.DirectoryRenderer renderer) {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(MethodDirectives$.MODULE$.get()).apply((Object)new Serializable($this, directories, renderer){
            public static final long serialVersionUID = 0L;
            public final Seq directories$1;
            public final FileAndResourceDirectives.DirectoryRenderer renderer$1;

            public final Function1<RequestContext, Future<RouteResult>> apply() {
                return (Function1)Directive$.MODULE$.addDirectiveApply(BasicDirectives$.MODULE$.extractRequestContext(), ApplyConverter$.MODULE$.hac1()).apply((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FileAndResourceDirectives$.anonfun.listDirectoryContents.1 $outer;

                    public final Function1<RequestContext, Future<RouteResult>> apply(RequestContext ctx) {
                        return (Function1)Directive$.MODULE$.addDirectiveApply(BasicDirectives$.MODULE$.extractMatchedPath(), ApplyConverter$.MODULE$.hac1()).apply((Object)new Serializable(this, ctx){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ FileAndResourceDirectives$$anonfun$listDirectoryContents$1$.anonfun.apply.11 $outer;
                            public final RequestContext ctx$1;

                            public final Function1<RequestContext, Future<RouteResult>> apply(Uri.Path matched) {
                                String prefixPath = matched.toString();
                                Uri.Path remainingPath = this.ctx$1.unmatchedPath();
                                String pathString = FileAndResourceDirectives$.MODULE$.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$withTrailingSlash(FileAndResourceDirectives$.MODULE$.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$safeJoinPaths("/", remainingPath, this.ctx$1.log(), '/'));
                                Seq dirs = (Seq)this.$outer.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$anonfun$$anonfun$$$outer().directories$1.flatMap((Function1)new Serializable(this, remainingPath){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ FileAndResourceDirectives$$anonfun$listDirectoryContents$1$$anonfun$apply$11$.anonfun.apply.12 $outer;
                                    private final Uri.Path remainingPath$1;

                                    public final Iterable<File> apply(String dir) {
                                        File file;
                                        String string = FileAndResourceDirectives$.MODULE$.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$safeDirectoryChildPath(FileAndResourceDirectives$.MODULE$.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$withTrailingSlash(dir), this.remainingPath$1, this.$outer.ctx$1.log(), FileAndResourceDirectives$.MODULE$.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$safeDirectoryChildPath$default$4());
                                        Iterable iterable = "".equals(string) ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : ((file = new File(string)).isDirectory() && file.canRead() ? Option$.MODULE$.option2Iterable((Option)new Some((Object)file)) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$));
                                        return iterable;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.remainingPath$1 = remainingPath$1;
                                    }
                                }, Seq$.MODULE$.canBuildFrom());
                                Marshaller<DirectoryListing, RequestEntity> marshaller = this.$outer.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$anonfun$$anonfun$$$outer().renderer$1.marshaller(this.ctx$1.settings().renderVanityFooter());
                                return dirs.isEmpty() ? RouteDirectives$.MODULE$.reject() : RouteDirectives$.MODULE$.complete((Function0<ToResponseMarshallable>)new Serializable(this, prefixPath, pathString, dirs, marshaller){
                                    public static final long serialVersionUID = 0L;
                                    private final String prefixPath$1;
                                    private final String pathString$1;
                                    private final Seq dirs$1;
                                    private final Marshaller marshaller$1;

                                    public final ToResponseMarshallable apply() {
                                        String string = this.pathString$1;
                                        String string2 = "/";
                                        return ToResponseMarshallable$.MODULE$.apply(new DirectoryListing(new StringBuilder().append((Object)this.prefixPath$1).append((Object)this.pathString$1).toString(), !(string != null ? !string.equals(string2) : string2 != null), (Seq<File>)((Seq)this.dirs$1.flatMap((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final ArrayOps<File> apply(File x$1) {
                                                return Predef$.MODULE$.refArrayOps((Object[])x$1.listFiles());
                                            }
                                        }, Seq$.MODULE$.canBuildFrom()))), Marshaller$.MODULE$.liftMarshaller(this.marshaller$1));
                                    }
                                    {
                                        this.prefixPath$1 = prefixPath$1;
                                        this.pathString$1 = pathString$1;
                                        this.dirs$1 = dirs$1;
                                        this.marshaller$1 = marshaller$1;
                                    }
                                });
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.ctx$1 = ctx$1;
                            }
                        });
                    }

                    public /* synthetic */ FileAndResourceDirectives$.anonfun.listDirectoryContents.1 akka$http$scaladsl$server$directives$FileAndResourceDirectives$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.directories$1 = directories$1;
                this.renderer$1 = renderer$1;
            }
        });
    }

    public static Function1 getFromBrowseableDirectory(FileAndResourceDirectives $this, String directory, FileAndResourceDirectives.DirectoryRenderer renderer, ContentTypeResolver resolver) {
        return $this.getFromBrowseableDirectories((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{directory}), renderer, resolver);
    }

    public static Function1 getFromBrowseableDirectories(FileAndResourceDirectives $this, Seq directories, FileAndResourceDirectives.DirectoryRenderer renderer, ContentTypeResolver resolver) {
        return RouteConcatenation$.MODULE$._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)((Function1)((TraversableOnce)directories.map((Function1)new Serializable($this, resolver){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileAndResourceDirectives $outer;
            private final ContentTypeResolver resolver$2;

            public final Function1<RequestContext, Future<RouteResult>> apply(String directoryName) {
                return this.$outer.getFromDirectory(directoryName, this.resolver$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.resolver$2 = resolver$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).reduceLeft((Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Function1<RequestContext, Future<RouteResult>> apply(Function1<RequestContext, Future<RouteResult>> x$2, Function1<RequestContext, Future<RouteResult>> x$3) {
                return RouteConcatenation$.MODULE$._enhanceRouteWithConcatenation(x$2).$tilde(x$3);
            }
        }))).$tilde($this.listDirectoryContents((Seq<String>)directories, renderer));
    }

    public static Function1 getFromResourceDirectory(FileAndResourceDirectives $this, String directoryName, ClassLoader classLoader, ContentTypeResolver resolver) {
        String base = directoryName.isEmpty() ? "" : FileAndResourceDirectives$.MODULE$.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$withTrailingSlash(directoryName);
        return (Function1)Directive$.MODULE$.addDirectiveApply(BasicDirectives$.MODULE$.extractUnmatchedPath(), ApplyConverter$.MODULE$.hac1()).apply((Object)new Serializable($this, base, classLoader, resolver){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileAndResourceDirectives $outer;
            public final String base$2;
            public final ClassLoader classLoader$2;
            public final ContentTypeResolver resolver$3;

            public final Function1<RequestContext, Future<RouteResult>> apply(Uri.Path path2) {
                return (Function1)Directive$.MODULE$.addDirectiveApply(BasicDirectives$.MODULE$.extractLog(), ApplyConverter$.MODULE$.hac1()).apply((Object)new Serializable(this, path2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FileAndResourceDirectives$.anonfun.getFromResourceDirectory.1 $outer;
                    private final Uri.Path path$3;

                    public final Function1<RequestContext, Future<RouteResult>> apply(LoggingAdapter log) {
                        String string = FileAndResourceDirectives$.MODULE$.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$safeJoinPaths(this.$outer.base$2, this.path$3, log, '/');
                        Function1<RequestContext, Future<RouteResult>> function1 = "".equals(string) ? RouteDirectives$.MODULE$.reject() : this.$outer.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$anonfun$$$outer().getFromResource(string, this.$outer.resolver$3.apply(string), this.$outer.classLoader$2);
                        return function1;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.path$3 = path$3;
                    }
                });
            }

            public /* synthetic */ FileAndResourceDirectives akka$http$scaladsl$server$directives$FileAndResourceDirectives$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.base$2 = base$2;
                this.classLoader$2 = classLoader$2;
                this.resolver$3 = resolver$3;
            }
        });
    }

    public static ClassLoader getFromResourceDirectory$default$2(FileAndResourceDirectives $this) {
        return $this._defaultClassLoader();
    }

    public static ClassLoader _defaultClassLoader(FileAndResourceDirectives $this) {
        return ActorSystem.class.getClassLoader();
    }

    public static void $init$(FileAndResourceDirectives $this) {
    }
}

