/*
 * Decompiled with CFR 0.152.
 */
package akka.http.scaladsl.model;

import akka.http.impl.util.EnhancedString$;
import akka.http.impl.util.Util;
import akka.http.impl.util.package$;
import akka.http.javadsl.model.ContentType;
import akka.http.javadsl.model.headers.Authorization;
import akka.http.javadsl.model.headers.HttpCredentials;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpEntity$HttpEntityScalaDSLSugar$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpHeader$;
import akka.http.scaladsl.model.HttpMessage;
import akka.http.scaladsl.model.HttpMessage$;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.headers.Connection;
import akka.http.scaladsl.model.headers.Content$minusEncoding;
import akka.http.scaladsl.model.headers.Content$minusType;
import akka.http.scaladsl.model.headers.Content$minusType$;
import akka.http.scaladsl.model.headers.HttpEncoding;
import akka.http.scaladsl.model.headers.HttpEncodings$;
import akka.http.scaladsl.util.FastFuture$;
import akka.http.scaladsl.util.FastFuture$EnhancedFuture$;
import akka.stream.Materializer;
import akka.util.ByteString;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

public abstract class HttpMessage$class {
    public static HttpMessage.DiscardedEntity discardEntityBytes(HttpMessage $this, Materializer mat) {
        return HttpEntity$HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(HttpEntity$.MODULE$.HttpEntityScalaDSLSugar($this.entity()), mat);
    }

    public static HttpMessage withHeaders(HttpMessage $this, Seq headers) {
        return $this.withHeaders((scala.collection.immutable.Seq<HttpHeader>)headers.toList());
    }

    public static HttpMessage withDefaultHeaders(HttpMessage $this, Seq defaultHeaders) {
        return $this.withDefaultHeaders((scala.collection.immutable.Seq<HttpHeader>)defaultHeaders.toList());
    }

    public static HttpMessage withDefaultHeaders(HttpMessage $this, scala.collection.immutable.Seq defaultHeaders) {
        return $this.withHeaders((scala.collection.immutable.Seq<HttpHeader>)($this.headers().isEmpty() ? defaultHeaders : (scala.collection.immutable.Seq)defaultHeaders.foldLeft($this.headers(), (Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpMessage $outer;

            public final scala.collection.immutable.Seq<HttpHeader> apply(scala.collection.immutable.Seq<HttpHeader> acc, HttpHeader h) {
                scala.collection.immutable.Seq seq;
                if (this.$outer.headers().exists((Function1)new Serializable(this, h){
                    public static final long serialVersionUID = 0L;
                    private final HttpHeader h$1;

                    public final boolean apply(HttpHeader x$1) {
                        return x$1.is(this.h$1.lowercaseName());
                    }
                    {
                        this.h$1 = h$1;
                    }
                })) {
                    seq = acc;
                } else {
                    HttpHeader httpHeader = h;
                    seq = (scala.collection.immutable.Seq)acc.$plus$colon((Object)httpHeader, Seq$.MODULE$.canBuildFrom());
                }
                return seq;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })));
    }

    public static Future toStrict(HttpMessage $this, FiniteDuration timeout, ExecutionContext ec, Materializer fm) {
        return FastFuture$.MODULE$.map$extension(FastFuture$EnhancedFuture$.MODULE$.fast$extension(FastFuture$.MODULE$.EnhancedFuture($this.entity().toStrict(timeout, fm))), new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpMessage $outer;

            public final HttpMessage apply(RequestEntity entity) {
                return this.$outer.withEntity(entity);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ec);
    }

    public static HttpMessage mapHeaders(HttpMessage $this, Function1 f) {
        return $this.withHeaders((scala.collection.immutable.Seq<HttpHeader>)((scala.collection.immutable.Seq)f.apply($this.headers())));
    }

    public static HttpEncoding encoding(HttpMessage $this) {
        Option option;
        block4: {
            HttpEncoding httpEncoding;
            block3: {
                block2: {
                    option = $this.header(ClassTag$.MODULE$.apply(Content$minusEncoding.class));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Content$minusEncoding x = (Content$minusEncoding)some.x();
                    httpEncoding = (HttpEncoding)x.encodings().head();
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                httpEncoding = HttpEncodings$.MODULE$.identity();
            }
            return httpEncoding;
        }
        throw new MatchError(option);
    }

    public static Option header(HttpMessage $this, ClassTag evidence$1) {
        Object object;
        Class clazz = scala.reflect.package$.MODULE$.classTag(evidence$1).runtimeClass();
        Object t = HttpHeader$.MODULE$.fastFind(clazz, $this.headers());
        akka.http.javadsl.model.HttpHeader httpHeader = (akka.http.javadsl.model.HttpHeader)OptionVal.Some$.MODULE$.unapply(t);
        if (OptionVal$.MODULE$.isEmpty$extension((Object)httpHeader)) {
            Class clazz2 = clazz;
            Class<Content$minusType> clazz3 = Content$minusType.class;
            object = !(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null) ? new Some((Object)Content$minusType$.MODULE$.apply($this.entity().contentType())) : None$.MODULE$;
        } else {
            akka.http.javadsl.model.HttpHeader h = (akka.http.javadsl.model.HttpHeader)OptionVal$.MODULE$.get$extension((Object)httpHeader);
            object = new Some((Object)h);
        }
        return object;
    }

    public static boolean connectionCloseExpected(HttpMessage $this) {
        return HttpMessage$.MODULE$.connectionCloseExpected($this.protocol(), $this.header(ClassTag$.MODULE$.apply(Connection.class)));
    }

    public static HttpMessage addHeader(HttpMessage $this, akka.http.javadsl.model.HttpHeader header) {
        return $this.mapHeaders((Function1<scala.collection.immutable.Seq<HttpHeader>, scala.collection.immutable.Seq<HttpHeader>>)new Serializable($this, header){
            public static final long serialVersionUID = 0L;
            private final akka.http.javadsl.model.HttpHeader header$1;

            public final scala.collection.immutable.Seq<HttpHeader> apply(scala.collection.immutable.Seq<HttpHeader> x$3) {
                return (scala.collection.immutable.Seq)x$3.$colon$plus((Object)((HttpHeader)this.header$1), Seq$.MODULE$.canBuildFrom());
            }
            {
                this.header$1 = header$1;
            }
        });
    }

    public static HttpMessage addCredentials(HttpMessage $this, HttpCredentials credentials) {
        return $this.addHeader(Authorization.create(credentials));
    }

    public static HttpMessage removeHeader(HttpMessage $this, String headerName) {
        String lowerHeaderName = EnhancedString$.MODULE$.toRootLowerCase$extension(package$.MODULE$.enhanceString_(headerName));
        return $this.mapHeaders((Function1<scala.collection.immutable.Seq<HttpHeader>, scala.collection.immutable.Seq<HttpHeader>>)new Serializable($this, lowerHeaderName){
            public static final long serialVersionUID = 0L;
            public final String lowerHeaderName$1;

            public final scala.collection.immutable.Seq<HttpHeader> apply(scala.collection.immutable.Seq<HttpHeader> x$4) {
                return (scala.collection.immutable.Seq)x$4.filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HttpMessage$.anonfun.removeHeader.1 $outer;

                    public final boolean apply(HttpHeader x$5) {
                        return x$5.is(this.$outer.lowerHeaderName$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.lowerHeaderName$1 = lowerHeaderName$1;
            }
        });
    }

    public static HttpMessage withEntity(HttpMessage $this, String string) {
        return $this.withEntity(HttpEntity$.MODULE$.apply(string));
    }

    public static HttpMessage withEntity(HttpMessage $this, byte[] bytes) {
        return $this.withEntity(HttpEntity$.MODULE$.apply(bytes));
    }

    public static HttpMessage withEntity(HttpMessage $this, ByteString bytes) {
        return $this.withEntity(HttpEntity$.MODULE$.apply(bytes));
    }

    public static HttpMessage withEntity(HttpMessage $this, ContentType.NonBinary contentType, String string) {
        return $this.withEntity(HttpEntity$.MODULE$.apply((ContentType.NonBinary)contentType, string));
    }

    public static HttpMessage withEntity(HttpMessage $this, akka.http.javadsl.model.ContentType contentType, byte[] bytes) {
        return $this.withEntity(HttpEntity$.MODULE$.apply((ContentType)contentType, bytes));
    }

    public static HttpMessage withEntity(HttpMessage $this, akka.http.javadsl.model.ContentType contentType, ByteString bytes) {
        return $this.withEntity(HttpEntity$.MODULE$.apply((ContentType)contentType, bytes));
    }

    public static HttpMessage withEntity(HttpMessage $this, akka.http.javadsl.model.ContentType contentType, File file) {
        return $this.withEntity(HttpEntity$.MODULE$.apply((ContentType)contentType, file, HttpEntity$.MODULE$.apply$default$3()));
    }

    public static HttpMessage withEntity(HttpMessage $this, akka.http.javadsl.model.ContentType contentType, Path file) {
        return $this.withEntity(HttpEntity$.MODULE$.fromPath((ContentType)contentType, file, HttpEntity$.MODULE$.fromPath$default$3()));
    }

    public static java.lang.Iterable getHeaders(HttpMessage $this) {
        return (java.lang.Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter($this.headers()).asJava();
    }

    public static Optional getHeader(HttpMessage $this, Class headerClass) {
        Optional<Object> optional;
        Object t = HttpHeader$.MODULE$.fastFind(headerClass, $this.headers());
        akka.http.javadsl.model.HttpHeader httpHeader = (akka.http.javadsl.model.HttpHeader)OptionVal.Some$.MODULE$.unapply(t);
        if (OptionVal$.MODULE$.isEmpty$extension((Object)httpHeader)) {
            optional = Optional.empty();
        } else {
            akka.http.javadsl.model.HttpHeader h = (akka.http.javadsl.model.HttpHeader)OptionVal$.MODULE$.get$extension((Object)httpHeader);
            optional = Optional.of(h);
        }
        return optional;
    }

    public static Optional getHeader(HttpMessage $this, String headerName) {
        String lowerCased = EnhancedString$.MODULE$.toRootLowerCase$extension(package$.MODULE$.enhanceString_(headerName));
        return Util.convertOption($this.headers().find((Function1)new Serializable($this, lowerCased){
            public static final long serialVersionUID = 0L;
            private final String lowerCased$1;

            public final boolean apply(HttpHeader x$6) {
                return x$6.is(this.lowerCased$1);
            }
            {
                this.lowerCased$1 = lowerCased$1;
            }
        }));
    }

    public static HttpMessage addHeaders(HttpMessage $this, java.lang.Iterable headers) {
        return $this.mapHeaders((Function1<scala.collection.immutable.Seq<HttpHeader>, scala.collection.immutable.Seq<HttpHeader>>)new Serializable($this, headers){
            public static final long serialVersionUID = 0L;
            private final java.lang.Iterable headers$1;

            public final scala.collection.immutable.Seq<HttpHeader> apply(scala.collection.immutable.Seq<HttpHeader> x$7) {
                return (scala.collection.immutable.Seq)x$7.$plus$plus((GenTraversableOnce)((Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.headers$1).asScala()), Seq$.MODULE$.canBuildFrom());
            }
            {
                this.headers$1 = headers$1;
            }
        });
    }

    public static void $init$(HttpMessage $this) {
    }
}

