/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.parsing;

import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.http.impl.engine.parsing.HttpHeaderParser;
import akka.http.impl.engine.parsing.ParsingException;
import akka.http.impl.engine.parsing.SpecializedHeaderValueParsers$;
import akka.http.impl.engine.parsing.SpecializedHeaderValueParsers$ContentLengthParser$;
import akka.http.impl.engine.parsing.package$;
import akka.http.impl.model.parser.CharacterClasses$;
import akka.http.impl.model.parser.HeaderParser$;
import akka.http.impl.util.EnhancedString$;
import akka.http.scaladsl.model.ErrorInfo;
import akka.http.scaladsl.model.ErrorInfo$;
import akka.http.scaladsl.model.IllegalHeaderException;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.model.headers.EmptyHeader$;
import akka.http.scaladsl.settings.ParserSettings;
import akka.http.scaladsl.settings.ParserSettings$IllegalResponseHeaderValueProcessingMode$Error$;
import akka.http.scaladsl.settings.ParserSettings$IllegalResponseHeaderValueProcessingMode$Ignore$;
import akka.http.scaladsl.settings.ParserSettings$IllegalResponseHeaderValueProcessingMode$Warn$;
import akka.util.ByteString;
import akka.util.ByteString$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@InternalApi
public final class HttpHeaderParser$ {
    public static final HttpHeaderParser$ MODULE$;

    static {
        new HttpHeaderParser$();
    }

    private Seq<String> predefinedHeaders() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Accept: *", "Accept: */*", "Connection: Keep-Alive", "Connection: close", "Connection: keep-alive", "Content-Length: 0", "Cache-Control: max-age=0", "Cache-Control: no-cache", "Expect: 100-continue"}));
    }

    public HttpHeaderParser apply(HttpHeaderParser.Settings settings, LoggingAdapter log, Function1<ErrorInfo, BoxedUnit> onIllegalHeader) {
        return this.prime(this.unprimed(settings, log, onIllegalHeader));
    }

    public Function1<ErrorInfo, BoxedUnit> apply$default$3(HttpHeaderParser.Settings settings, LoggingAdapter log) {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(ErrorInfo info) {
                throw new IllegalHeaderException(info);
            }
        };
    }

    public HttpHeaderParser unprimed(HttpHeaderParser.Settings settings, LoggingAdapter log, Function1<ErrorInfo, BoxedUnit> warnOnIllegalHeader) {
        return new HttpHeaderParser(settings, log, warnOnIllegalHeader, this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8(), this.$lessinit$greater$default$9(), this.akka$http$impl$engine$parsing$HttpHeaderParser$$$lessinit$greater$default$10());
    }

    public HttpHeaderParser prime(HttpHeaderParser parser) {
        Seq valueParsers = (Seq)HeaderParser$.MODULE$.ruleNames().map((Function1)new Serializable(parser){
            public static final long serialVersionUID = 0L;
            private final HttpHeaderParser parser$1;

            public final HttpHeaderParser.ModeledHeaderValueParser apply(String name) {
                return new HttpHeaderParser.ModeledHeaderValueParser(name, this.parser$1.settings().maxHeaderValueLength(), this.parser$1.settings().headerValueCacheLimit(name), this.parser$1.log(), this.parser$1.settings());
            }
            {
                this.parser$1 = parser$1;
            }
        }, scala.collection.package$.MODULE$.breakOut(Predef$.MODULE$.fallbackStringCanBuildFrom()));
        Seq x$324 = (Seq)valueParsers.sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(HttpHeaderParser.HeaderValueParser x$15) {
                return x$15.headerName();
            }
        }, (Ordering)Ordering.String$.MODULE$);
        int x$325 = this.insertInGoodOrder$default$2$1(x$324);
        int x$326 = this.insertInGoodOrder$default$3$1(x$324);
        this.insertInGoodOrder$1(x$324, x$325, x$326, parser);
        Seq<SpecializedHeaderValueParsers$ContentLengthParser$> x$327 = SpecializedHeaderValueParsers$.MODULE$.specializedHeaderValueParsers();
        int x$328 = this.insertInGoodOrder$default$2$1(x$327);
        int x$329 = this.insertInGoodOrder$default$3$1(x$327);
        this.insertInGoodOrder$1(x$327, x$328, x$329, parser);
        Seq x$330 = (Seq)this.predefinedHeaders().sorted((Ordering)Ordering.String$.MODULE$);
        int x$331 = this.insertInGoodOrder$default$2$1(x$330);
        int x$332 = this.insertInGoodOrder$default$3$1(x$330);
        this.insertInGoodOrder$1(x$330, x$331, x$332, parser);
        ByteString x$333 = ByteString$.MODULE$.apply("\r\n");
        EmptyHeader$ x$334 = EmptyHeader$.MODULE$;
        int x$335 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$3(x$333, x$334);
        int x$336 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$4(x$333, x$334);
        int x$337 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$5(x$333, x$334);
        int x$338 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$6(x$333, x$334);
        parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert(x$333, x$334, x$335, x$336, x$337, x$338);
        ByteString x$339 = ByteString$.MODULE$.apply("\n");
        EmptyHeader$ x$340 = EmptyHeader$.MODULE$;
        int x$341 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$3(x$339, x$340);
        int x$342 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$4(x$339, x$340);
        int x$343 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$5(x$339, x$340);
        int x$344 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$6(x$339, x$340);
        parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert(x$339, x$340, x$341, x$342, x$343, x$344);
        return parser;
    }

    public void insert(HttpHeaderParser parser, ByteString input, Object value) {
        ByteString x$345 = input;
        Object x$346 = value;
        int x$347 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$3(x$345, x$346);
        int x$348 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$4(x$345, x$346);
        int x$349 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$5(x$345, x$346);
        int x$350 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$6(x$345, x$346);
        parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insert(x$345, x$346, x$347, x$348, x$349, x$350);
    }

    public void insertRemainingCharsAsNewNodes(HttpHeaderParser parser, ByteString input, Object value) {
        ByteString x$351 = input;
        Object x$352 = value;
        int x$353 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$3(x$351, x$352);
        int x$354 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$4(x$351, x$352);
        int x$355 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$5(x$351, x$352);
        int x$356 = parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$6(x$351, x$352);
        parser.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes(x$351, x$352, x$353, x$354, x$355, x$356);
    }

    public int akka$http$impl$engine$parsing$HttpHeaderParser$$scanHeaderNameAndReturnIndexOfColon(ByteString input, int start, int limit, int ix) {
        block3: while (ix < limit) {
            char c = package$.MODULE$.byteChar(input, ix);
            switch (c) {
                default: {
                    if (BoxesRunTime.unboxToBoolean((Object)CharacterClasses$.MODULE$.tchar().apply((Object)BoxesRunTime.boxToCharacter((char)c)))) {
                        ++ix;
                        continue block3;
                    }
                    throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal character '", "' in header name"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.escape(c)})));
                }
                case ':': 
            }
            return ix;
        }
        throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HTTP header name exceeds the configured limit of ", " characters"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(limit - start - 1))})));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<String, Object> akka$http$impl$engine$parsing$HttpHeaderParser$$scanHeaderValue(HttpHeaderParser hhp, ByteString input, int start, int limit, LoggingAdapter log, ParserSettings.IllegalResponseHeaderValueProcessingMode mode, StringBuilder sb, int ix) {
        block14: while (ix < limit) {
            char c = package$.MODULE$.byteChar(input, ix);
            switch (c) {
                case '\n': {
                    if (BoxesRunTime.unboxToBoolean((Object)CharacterClasses$.MODULE$.WSP().apply((Object)BoxesRunTime.boxToCharacter((char)package$.MODULE$.byteChar(input, ix + 1))))) {
                        StringBuilder stringBuilder = this.appended$1(' ', input, start, sb, ix);
                        ix += 2;
                        sb = stringBuilder;
                        continue block14;
                    }
                    Tuple2 tuple2 = new Tuple2((Object)(sb == null ? package$.MODULE$.asciiString(input, start, ix) : sb.toString()), (Object)BoxesRunTime.boxToInteger((int)(ix + 1)));
                    return tuple2;
                }
                case '\r': {
                    Tuple2 tuple2;
                    if (package$.MODULE$.byteChar(input, ix + 1) == '\n') {
                        if (BoxesRunTime.unboxToBoolean((Object)CharacterClasses$.MODULE$.WSP().apply((Object)BoxesRunTime.boxToCharacter((char)package$.MODULE$.byteChar(input, ix + 2))))) {
                            StringBuilder stringBuilder = this.appended$1(' ', input, start, sb, ix);
                            ix += 3;
                            sb = stringBuilder;
                            continue block14;
                        }
                        tuple2 = new Tuple2((Object)(sb == null ? package$.MODULE$.asciiString(input, start, ix) : sb.toString()), (Object)BoxesRunTime.boxToInteger((int)(ix + 2)));
                        return tuple2;
                    }
                }
                default: {
                    StringBuilder stringBuilder;
                    int nix = ix + 1;
                    if (' ' <= c && c <= '\u007f') {
                        stringBuilder = sb == null ? null : sb.append(c);
                    } else if ((c & 0xE0) == 192) {
                        hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put((byte)c);
                        hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 1));
                        nix = ix + 2;
                        int n = hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$decodeByteBuffer();
                        switch (n) {
                            default: {
                                stringBuilder = this.appended2$1(n, input, start, sb, ix);
                                break;
                            }
                            case -1: {
                                if (sb == null) {
                                    stringBuilder = null;
                                    break;
                                }
                                stringBuilder = sb.append(c).append(package$.MODULE$.byteChar(input, ix + 1));
                                break;
                            }
                        }
                    } else if ((c & 0xF0) == 224) {
                        hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put((byte)c);
                        hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 1));
                        hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 2));
                        nix = ix + 3;
                        int n = hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$decodeByteBuffer();
                        switch (n) {
                            default: {
                                stringBuilder = this.appended2$1(n, input, start, sb, ix);
                                break;
                            }
                            case -1: {
                                if (sb == null) {
                                    stringBuilder = null;
                                    break;
                                }
                                stringBuilder = sb.append(c).append(package$.MODULE$.byteChar(input, ix + 1)).append(package$.MODULE$.byteChar(input, ix + 2));
                                break;
                            }
                        }
                    } else if ((c & 0xF8) == 240) {
                        hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put((byte)c);
                        hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 1));
                        hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 2));
                        hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 3));
                        nix = ix + 4;
                        int n = hhp.akka$http$impl$engine$parsing$HttpHeaderParser$$decodeByteBuffer();
                        switch (n) {
                            default: {
                                stringBuilder = this.appended2$1(n, input, start, sb, ix);
                                break;
                            }
                            case -1: {
                                if (sb == null) {
                                    stringBuilder = null;
                                    break;
                                }
                                stringBuilder = sb.append(c).append(package$.MODULE$.byteChar(input, ix + 1)).append(package$.MODULE$.byteChar(input, ix + 2)).append(package$.MODULE$.byteChar(input, ix + 3));
                                break;
                            }
                        }
                    } else {
                        StringBuilder stringBuilder2;
                        ParserSettings.IllegalResponseHeaderValueProcessingMode illegalResponseHeaderValueProcessingMode = mode;
                        if (ParserSettings$IllegalResponseHeaderValueProcessingMode$Error$.MODULE$.equals(illegalResponseHeaderValueProcessingMode)) {
                            throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal character '", "' in header value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.escape(c)})));
                        }
                        if (ParserSettings$IllegalResponseHeaderValueProcessingMode$Warn$.MODULE$.equals(illegalResponseHeaderValueProcessingMode)) {
                            log.warning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal character '", "' in header value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.escape(c)})));
                            stringBuilder2 = sb;
                        } else {
                            if (!ParserSettings$IllegalResponseHeaderValueProcessingMode$Ignore$.MODULE$.equals(illegalResponseHeaderValueProcessingMode)) throw new MatchError((Object)illegalResponseHeaderValueProcessingMode);
                            stringBuilder2 = sb;
                        }
                        stringBuilder = stringBuilder2;
                    }
                    StringBuilder nsb = stringBuilder;
                    ix = nix;
                    sb = nsb;
                    continue block14;
                }
                case '\t': 
            }
            StringBuilder stringBuilder = this.appended$1(' ', input, start, sb, ix);
            ++ix;
            sb = stringBuilder;
        }
        throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HTTP header value exceeds the configured limit of ", " characters"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(limit - start - 2))})));
    }

    public StringBuilder akka$http$impl$engine$parsing$HttpHeaderParser$$scanHeaderValue$default$7(HttpHeaderParser hhp, ByteString input, int start, int limit, LoggingAdapter log, ParserSettings.IllegalResponseHeaderValueProcessingMode mode) {
        return null;
    }

    public int akka$http$impl$engine$parsing$HttpHeaderParser$$scanHeaderValue$default$8(HttpHeaderParser hhp, ByteString input, int start, int limit, LoggingAdapter log, ParserSettings.IllegalResponseHeaderValueProcessingMode mode) {
        return start;
    }

    public Nothing$ fail(String summary) {
        throw new ParsingException((StatusCode)StatusCodes$.MODULE$.BadRequest(), new ErrorInfo(summary, ErrorInfo$.MODULE$.apply$default$2()));
    }

    private char[] $lessinit$greater$default$4() {
        return new char[512];
    }

    private int $lessinit$greater$default$5() {
        return 0;
    }

    private short[] $lessinit$greater$default$6() {
        return new short[762];
    }

    private int $lessinit$greater$default$7() {
        return 0;
    }

    private Object[] $lessinit$greater$default$8() {
        return new Object[255];
    }

    private int $lessinit$greater$default$9() {
        return 0;
    }

    public boolean akka$http$impl$engine$parsing$HttpHeaderParser$$$lessinit$greater$default$10() {
        return false;
    }

    private final void insertInGoodOrder$1(Seq items, int startIx, int endIx, HttpHeaderParser parser$1) {
        while (endIx - startIx > 0) {
            Object object;
            block8: {
                int pivot;
                block7: {
                    Integer n;
                    block6: {
                        BoxedUnit boxedUnit;
                        pivot = (startIx + endIx) / 2;
                        object = items.apply(pivot);
                        if (!(object instanceof HttpHeaderParser.HeaderValueParser)) break block6;
                        HttpHeaderParser.HeaderValueParser headerValueParser = (HttpHeaderParser.HeaderValueParser)object;
                        String insertName = new scala.collection.mutable.StringBuilder().append((Object)EnhancedString$.MODULE$.toRootLowerCase$extension(akka.http.impl.util.package$.MODULE$.enhanceString_(headerValueParser.headerName()))).append((Object)BoxesRunTime.boxToCharacter((char)':')).toString();
                        if (parser$1.isEmpty()) {
                            ByteString x$308 = ByteString$.MODULE$.apply(insertName);
                            HttpHeaderParser.HeaderValueParser x$309 = headerValueParser;
                            int x$310 = parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$3(x$308, x$309);
                            int x$311 = parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$4(x$308, x$309);
                            int x$312 = parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$5(x$308, x$309);
                            int x$313 = parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$6(x$308, x$309);
                            parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes(x$308, x$309, x$310, x$311, x$312, x$313);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            ByteString x$314 = ByteString$.MODULE$.apply(insertName);
                            HttpHeaderParser.HeaderValueParser x$315 = headerValueParser;
                            int x$316 = parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$3(x$314, x$315);
                            int x$317 = parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$4(x$314, x$315);
                            int x$318 = parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$5(x$314, x$315);
                            int x$319 = parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insert$default$6(x$314, x$315);
                            parser$1.akka$http$impl$engine$parsing$HttpHeaderParser$$insert(x$314, x$315, x$316, x$317, x$318, x$319);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        n = boxedUnit;
                        break block7;
                    }
                    if (!(object instanceof String)) break block8;
                    String string = (String)object;
                    ByteString x$320 = ByteString$.MODULE$.apply(new scala.collection.mutable.StringBuilder().append((Object)string).append((Object)"\r\nx").toString());
                    int x$321 = parser$1.parseHeaderLine$default$2();
                    int x$322 = parser$1.parseHeaderLine$default$3(x$320, x$321);
                    int x$323 = parser$1.parseHeaderLine$default$4(x$320, x$321);
                    n = BoxesRunTime.boxToInteger((int)parser$1.parseHeaderLine(x$320, x$321, x$322, x$323));
                }
                this.insertInGoodOrder$1(items, startIx, pivot, parser$1);
                startIx = pivot + 1;
                continue;
            }
            throw new MatchError(object);
        }
    }

    private final int insertInGoodOrder$default$2$1(Seq items) {
        return 0;
    }

    private final int insertInGoodOrder$default$3$1(Seq items) {
        return items.size();
    }

    private final StringBuilder appended$1(char c, ByteString input$3, int start$1, StringBuilder sb$1, int ix$1) {
        return (sb$1 == null ? new StringBuilder(package$.MODULE$.asciiString(input$3, start$1, ix$1)) : sb$1).append(c);
    }

    private final StringBuilder appended2$1(int c, ByteString input$3, int start$1, StringBuilder sb$1, int ix$1) {
        return c >> 16 != 0 ? this.appended$1((char)c, input$3, start$1, sb$1, ix$1).append((char)(c >> 16)) : this.appended$1((char)c, input$3, start$1, sb$1, ix$1);
    }

    private HttpHeaderParser$() {
        MODULE$ = this;
    }
}

