/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl.io;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.annotation.InternalApi;
import akka.stream.ActorAttributes;
import akka.stream.ActorMaterializer;
import akka.stream.ActorMaterializerHelper$;
import akka.stream.ActorMaterializerSettings;
import akka.stream.Attributes;
import akka.stream.IOResult;
import akka.stream.MaterializationContext;
import akka.stream.SourceShape;
import akka.stream.actor.ActorPublisher$;
import akka.stream.impl.SourceModule;
import akka.stream.impl.Stages$DefaultAttributes$;
import akka.stream.impl.io.FilePublisher$;
import akka.util.ByteString;
import java.nio.file.Path;
import org.reactivestreams.Publisher;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y4Q!\u0001\u0002\u0003\u0011)\u0011!BR5mKN{WO]2f\u0015\t\u0019A!\u0001\u0002j_*\u0011QAB\u0001\u0005S6\u0004HN\u0003\u0002\b\u0011\u000511\u000f\u001e:fC6T\u0011!C\u0001\u0005C.\\\u0017m\u0005\u0002\u0001\u0017A!A\"D\b\u0016\u001b\u0005!\u0011B\u0001\b\u0005\u00051\u0019v.\u001e:dK6{G-\u001e7f!\t\u00012#D\u0001\u0012\u0015\t\u0011\u0002\"\u0001\u0003vi&d\u0017B\u0001\u000b\u0012\u0005)\u0011\u0015\u0010^3TiJLgn\u001a\t\u0004-miR\"A\f\u000b\u0005aI\u0012AC2p]\u000e,(O]3oi*\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d/\t1a)\u001e;ve\u0016\u0004\"AH\u0010\u000e\u0003\u0019I!\u0001\t\u0004\u0003\u0011%{%+Z:vYRD\u0001B\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\u0002M\u000e\u0001\u0001CA\u0013-\u001b\u00051#BA\u0014)\u0003\u00111\u0017\u000e\\3\u000b\u0005%R\u0013a\u00018j_*\t1&\u0001\u0003kCZ\f\u0017BA\u0017'\u0005\u0011\u0001\u0016\r\u001e5\t\u0011=\u0002!\u0011!Q\u0001\nA\n\u0011b\u00195v].\u001c\u0016N_3\u0011\u0005E\u0012T\"A\r\n\u0005MJ\"aA%oi\"AQ\u0007\u0001B\u0001B\u0003%a'A\u0007ti\u0006\u0014H\u000fU8tSRLwN\u001c\t\u0003c]J!\u0001O\r\u0003\t1{gn\u001a\u0005\tu\u0001\u0011)\u0019!C\u0001w\u0005Q\u0011\r\u001e;sS\n,H/Z:\u0016\u0003q\u0002\"AH\u001f\n\u0005y2!AC!uiJL'-\u001e;fg\"A\u0001\t\u0001B\u0001B\u0003%A(A\u0006biR\u0014\u0018NY;uKN\u0004\u0003\"\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\"G\u0003\u0015\u0019\b.\u00199f!\rqBiD\u0005\u0003\u000b\u001a\u00111bU8ve\u000e,7\u000b[1qK&\u0011!)\u0004\u0005\u0006\u0011\u0002!\t!S\u0001\u0007y%t\u0017\u000e\u001e \u0015\r)cUJT(Q!\tY\u0005!D\u0001\u0003\u0011\u0015\u0011s\t1\u0001%\u0011\u0015ys\t1\u00011\u0011\u0015)t\t1\u00017\u0011\u0015Qt\t1\u0001=\u0011\u0015\u0011u\t1\u0001D\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0003\u0019\u0019'/Z1uKR\u0011Ak\u0018\t\u0005cU;V#\u0003\u0002W3\t1A+\u001e9mKJ\u00022\u0001W/\u0010\u001b\u0005I&B\u0001.\\\u0003=\u0011X-Y2uSZ,7\u000f\u001e:fC6\u001c(\"\u0001/\u0002\u0007=\u0014x-\u0003\u0002_3\nI\u0001+\u001e2mSNDWM\u001d\u0005\u0006AF\u0003\r!Y\u0001\bG>tG/\u001a=u!\tq\"-\u0003\u0002d\r\t1R*\u0019;fe&\fG.\u001b>bi&|gnQ8oi\u0016DH\u000fC\u0003f\u0001\u0011Ec-A\u0006oK^Len\u001d;b]\u000e,GCA\u0006h\u0011\u0015\u0011E\r1\u0001D\u0011\u0015I\u0007\u0001\"\u0011k\u000399\u0018\u000e\u001e5BiR\u0014\u0018NY;uKN$\"aC6\t\u000b1D\u0007\u0019\u0001\u001f\u0002\t\u0005$HO\u001d\u0005\u0006]\u0002!\tf\\\u0001\u0006Y\u0006\u0014W\r\\\u000b\u0002aB\u0011\u0011\u000f\u001e\b\u0003cIL!a]\r\u0002\rA\u0013X\rZ3g\u0013\t)hO\u0001\u0004TiJLgn\u001a\u0006\u0003gfA#\u0001\u0001=\u0011\u0005edX\"\u0001>\u000b\u0005mD\u0011AC1o]>$\u0018\r^5p]&\u0011QP\u001f\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000e")
@InternalApi
public final class FileSource
extends SourceModule<ByteString, Future<IOResult>> {
    private final Path f;
    private final int chunkSize;
    private final long startPosition;
    private final Attributes attributes;

    @Override
    public Attributes attributes() {
        return this.attributes;
    }

    @Override
    public Tuple2<Publisher<ByteString>, Future<IOResult>> create(MaterializationContext context) {
        ActorMaterializer materializer = ActorMaterializerHelper$.MODULE$.downcast(context.materializer());
        ActorMaterializerSettings settings = materializer.effectiveSettings(context.effectiveAttributes());
        Promise ioResultPromise = Promise$.MODULE$.apply();
        Props props2 = FilePublisher$.MODULE$.props(this.f, (Promise<IOResult>)ioResultPromise, this.chunkSize, this.startPosition, settings.initialInputBufferSize(), settings.maxInputBufferSize());
        String dispatcher = context.effectiveAttributes().get(Stages$DefaultAttributes$.MODULE$.IODispatcher(), ClassTag$.MODULE$.apply(ActorAttributes.Dispatcher.class)).dispatcher();
        ActorRef ref = materializer.actorOf(context, props2.withDispatcher(dispatcher));
        return new Tuple2(ActorPublisher$.MODULE$.apply(ref), (Object)ioResultPromise.future());
    }

    @Override
    public SourceModule<ByteString, Future<IOResult>> newInstance(SourceShape<ByteString> shape) {
        return new FileSource(this.f, this.chunkSize, this.startPosition, this.attributes(), shape);
    }

    @Override
    public SourceModule<ByteString, Future<IOResult>> withAttributes(Attributes attr) {
        return new FileSource(this.f, this.chunkSize, this.startPosition, attr, this.amendShape(attr));
    }

    @Override
    public String label() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FileSource(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.f, BoxesRunTime.boxToInteger((int)this.chunkSize)}));
    }

    public FileSource(Path f, int chunkSize, long startPosition, Attributes attributes, SourceShape<ByteString> shape) {
        this.f = f;
        this.chunkSize = chunkSize;
        this.startPosition = startPosition;
        this.attributes = attributes;
        super(shape);
        Predef$.MODULE$.require(chunkSize > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "chunkSize must be greater than 0";
            }
        });
        Predef$.MODULE$.require(startPosition >= 0L, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "startPosition must be equal or greater than 0";
            }
        });
    }
}

