/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.dsl.api;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.DslApiProxy;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.dsl.DirectorySpec;
import com.xebialabs.deployit.dsl.ForDirectories;
import com.xebialabs.deployit.dsl.ScopeSpec;
import com.xebialabs.deployit.dsl.XldSpec;
import com.xebialabs.deployit.dsl.execute.CiCommand;
import com.xebialabs.deployit.dsl.execute.CommandCreator;
import com.xebialabs.deployit.dsl.execute.CommandExecutor;
import com.xebialabs.deployit.dsl.execute.DeleteCiCommand;
import com.xebialabs.deployit.dsl.execute.DslCommand;
import com.xebialabs.deployit.dsl.execute.DslExecutor;
import com.xebialabs.deployit.dsl.execute.DslReferenceResolver;
import com.xebialabs.deployit.dsl.export.DSLGenerator;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.service.validation.Validator;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.convert.WrapAsScala;
import scala.collection.convert.package$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Controller
@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001B\u0001\u0003\u00015\u0011a\u0001R:m\u0003BL'BA\u0002\u0005\u0003\r\t\u0007/\u001b\u0006\u0003\u000b\u0019\t1\u0001Z:m\u0015\t9\u0001\"\u0001\u0005eKBdw._5u\u0015\tI!\"A\u0005yK\nL\u0017\r\\1cg*\t1\"A\u0002d_6\u001c\u0001aE\u0002\u0001\u001da\u0001\"a\u0004\f\u000e\u0003AQ!!\u0005\n\u0002\u000fM,7-\u001e:fI*\u00111\u0003F\u0001\u0005e\u0016\u001cHO\u0003\u0002\u0016\r\u0005!1m\u001c:f\u0013\t9\u0002CA\fBEN$(/Y2u'\u0016\u001cWO]3e%\u0016\u001cx.\u001e:dKB\u0011\u0011dG\u0007\u00025)\u00111\u0001F\u0005\u00039i\u00111\u0002R:m\u0003BL\u0007K]8ys\"Aa\u0004\u0001B\u0001B\u0003%q$A\tsKB|7/\u001b;pef\u001cVM\u001d<jG\u0016\u0004\"\u0001I\u0012\u000e\u0003\u0005R!A\t\u0004\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002%C\t\t\"+\u001a9pg&$xN]=TKJ4\u0018nY3\t\u0011\u0019\u0002!\u0011!Q\u0001\n\u001d\nA\u0002Z:m\u000f\u0016tWM]1u_J\u0004\"\u0001K\u0016\u000e\u0003%R!A\u000b\u0003\u0002\r\u0015D\bo\u001c:u\u0013\ta\u0013F\u0001\u0007E'2;UM\\3sCR|'\u000f\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u0003-!7\u000f\\#yK\u000e,Ho\u001c:\u0011\u0005A\u001aT\"A\u0019\u000b\u0005I\"\u0011aB3yK\u000e,H/Z\u0005\u0003iE\u00121\u0002R:m\u000bb,7-\u001e;pe\"Aa\u0007\u0001B\u0001B\u0003%q'\u0001\u000beg2\u0014VMZ3sK:\u001cWMU3t_24XM\u001d\t\u0003aaJ!!O\u0019\u0003)\u0011\u001bHNU3gKJ,gnY3SKN|GN^3s\u0011!Y\u0004A!A!\u0002\u0013a\u0014AD2p[6\fg\u000eZ\"sK\u0006$xN\u001d\t\u0003auJ!AP\u0019\u0003\u001d\r{W.\\1oI\u000e\u0013X-\u0019;pe\"A\u0001\t\u0001B\u0001B\u0003%\u0011)A\bd_6l\u0017M\u001c3Fq\u0016\u001cW\u000f^8s!\t\u0001$)\u0003\u0002Dc\ty1i\\7nC:$W\t_3dkR|'\u000f\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0003%1\u0018\r\\5eCR|'\u000f\u0005\u0002H\u00196\t\u0001J\u0003\u0002J\u0015\u0006Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0005-3\u0011aB:feZL7-Z\u0005\u0003\u001b\"\u0013\u0011BV1mS\u0012\fGo\u001c:\t\u000b=\u0003A\u0011\u0001)\u0002\rqJg.\u001b;?)!\t6\u000bV+W/bK\u0006C\u0001*\u0001\u001b\u0005\u0011\u0001\"\u0002\u0010O\u0001\u0004y\u0002\"\u0002\u0014O\u0001\u00049\u0003\"\u0002\u0018O\u0001\u0004y\u0003\"\u0002\u001cO\u0001\u00049\u0004\"B\u001eO\u0001\u0004a\u0004\"\u0002!O\u0001\u0004\t\u0005\"B#O\u0001\u00041\u0005F\u0001(\\!\tav-D\u0001^\u0015\tqv,\u0001\u0006b]:|G/\u0019;j_:T!\u0001Y1\u0002\u000f\u0019\f7\r^8ss*\u0011!mY\u0001\u0006E\u0016\fgn\u001d\u0006\u0003I\u0016\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002M\u0006\u0019qN]4\n\u0005!l&!C!vi><\u0018N]3e\u0011\u0015Q\u0007\u0001\"\u0001l\u0003-9WM\\3sCR,Gi\u001d7\u0015\u000514\bCA7t\u001d\tq\u0017/D\u0001p\u0015\u0005\u0001\u0018!B:dC2\f\u0017B\u0001:p\u0003\u0019\u0001&/\u001a3fM&\u0011A/\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I|\u0007\"B<j\u0001\u0004A\u0018a\u00024pY\u0012,'o\u001d\t\u0004szdW\"\u0001>\u000b\u0005md\u0018\u0001B;uS2T\u0011!`\u0001\u0005U\u00064\u0018-\u0003\u0002\u0000u\n!A*[:u\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000b\t\u0001\"\u00199qYf$5\u000f\u001c\u000b\u0005\u0003\u000f\ti\u0001E\u0002o\u0003\u0013I1!a\u0003p\u0005\u0011)f.\u001b;\t\r\u0015\t\t\u00011\u0001m\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'\t\u0001d\u00195fG.\u001cuN\u001c3ji&|gn\u00148YY\u0012\u001c\u0006/Z2t)\u0019\t9!!\u0006\u0002>!A\u0011qCA\b\u0001\u0004\tI\"A\u0005d_:$\u0017\u000e^5p]B9a.a\u0007\u0002 \u0005\u001d\u0011bAA\u000f_\nIa)\u001e8di&|g.\r\t\u0007\u0003C\t\t$!\u000e\u000f\t\u0005\r\u0012Q\u0006\b\u0005\u0003K\tY#\u0004\u0002\u0002()\u0019\u0011\u0011\u0006\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0018bAA\u0018_\u00069\u0001/Y2lC\u001e,\u0017bA@\u00024)\u0019\u0011qF8\u0011\t\u0005]\u0012\u0011H\u0007\u0002\t%\u0019\u00111\b\u0003\u0003\u001b\u0011K'/Z2u_JL8\u000b]3d\u0011!\ty$a\u0004A\u0002\u0005\u0005\u0013\u0001\u0003=mIN\u0003XmY:\u0011\r\u0005\u0005\u0012\u0011GA\"!\u0011\t9$!\u0012\n\u0007\u0005\u001dCAA\u0004YY\u0012\u001c\u0006/Z2\t\u000f\u0005-\u0003\u0001\"\u0001\u0002N\u0005i2\r[3dWB+'/\\5tg&|gNR8s\t&\u0014Xm\u0019;pe&,7\u000f\u0006\u0003\u0002\b\u0005=\u0003\u0002CA)\u0003\u0013\u0002\r!a\b\u0002\t\u0011L'o\u001d\u0005\b\u0003+\u0002A\u0011AA,\u0003m\u0019\u0007.Z2l!\u0016\u0014X.[:tS>tgi\u001c:ESJ,7\r^8ssR!\u0011qAA-\u0011!\tY&a\u0015A\u0002\u0005U\u0012a\u00013je\"9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0014AH2iK\u000e\\7+Z2ve&$\u0018\u0010U3s[&\u001c8/[8o\r>\u0014Xk]3s)\u0011\t9!a\u0019\t\u0011\u0005E\u0013Q\fa\u0001\u0003?Aq!a\u001a\u0001\t\u0013\tI'\u0001\u0007dCN$\u0018I\u001c3DQ\u0016\u001c7.\u0006\u0003\u0002l\u0005EDCBA7\u0003\u001f\u000b\u0019\n\u0005\u0003\u0002p\u0005ED\u0002\u0001\u0003\t\u0003g\n)G1\u0001\u0002v\t\tA+\u0005\u0003\u0002x\u0005u\u0004c\u00018\u0002z%\u0019\u00111P8\u0003\u000f9{G\u000f[5oOB!\u0011qPAF\u001b\t\t\tI\u0003\u0003\u0002\u0004\u0006\u0015\u0015aA;e[*\u00191!a\"\u000b\u0007\u0005%e!\u0001\u0004qYV<\u0017N\\\u0005\u0005\u0003\u001b\u000b\tIA\tD_:4\u0017nZ;sCRLwN\\%uK6D\u0001\"!%\u0002f\u0001\u0007\u0011QP\u0001\u0003G&D\u0001\"!&\u0002f\u0001\u0007\u0011qS\u0001\u0006G2\f'P\u001f\t\u0006[\u0006e\u0015QN\u0005\u0004\u00037+(!B\"mCN\u001c\b\u0002DAP\u0001A\u0005\t\u0011!A\u0005\u0002\u0005\u0005\u0016!\u00079s_R,7\r^3eI\rDWmY6QKJl\u0017n]:j_:$B!a)\u0002HR1\u0011qAAS\u0003sC!\"a*\u0002\u001e\u0006\u0005\t\u0019AAU\u0003\rAH%\r\t\u0005\u0003W\u000b),\u0004\u0002\u0002.*!\u0011qVAY\u0003)\u0001XM]7jgNLwN\u001c\u0006\u0004\u0003g3\u0011\u0001C:fGV\u0014\u0018\u000e^=\n\t\u0005]\u0016Q\u0016\u0002\u000b!\u0016\u0014X.[:tS>t\u0007BCA^\u0003;\u000b\t\u00111\u0001\u0002>\u0006\u0019\u0001\u0010\n\u001a\u0011\t\u0005}\u0016QY\u0007\u0003\u0003\u0003T1!a1}\u0003\u0011a\u0017M\\4\n\u0007Q\f\t\rC\u0005\u0002(\u0006u\u0015\u0011!a\u0001#\"\u001a\u0001!a3\u0011\t\u00055\u00171[\u0007\u0003\u0003\u001fT1!!5d\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003+\fyM\u0001\u0006D_:$(o\u001c7mKJ\u0004")
public class DslApi
extends AbstractSecuredResource
implements DslApiProxy {
    private final RepositoryService repositoryService;
    private final DSLGenerator dslGenerator;
    private final DslExecutor dslExecutor;
    public final DslReferenceResolver com$xebialabs$deployit$dsl$api$DslApi$$dslReferenceResolver;
    public final CommandCreator com$xebialabs$deployit$dsl$api$DslApi$$commandCreator;
    private final CommandExecutor commandExecutor;
    private final Validator validator;

    public /* synthetic */ void protected$checkPermission(DslApi x$1, Permission x$12, String x$2) {
        x$1.checkPermission(x$12, x$2);
    }

    public String generateDsl(java.util.List<String> folders) {
        ((WrapAsScala)package$.MODULE$.wrapAll()).asScalaBuffer(folders).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DslApi $outer;

            public final void apply(String x$1) {
                this.$outer.protected$checkPermission(this.$outer, DeployitPermissions.GENERATE_DSL, x$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        List directories = ((TraversableOnce)((WrapAsScala)package$.MODULE$.wrapAll()).asScalaBuffer(this.repositoryService.read(folders, 0, false)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DslApi $outer;

            public final Directory apply(ConfigurationItem x$2) {
                return this.$outer.com$xebialabs$deployit$dsl$api$DslApi$$castAndCheck(x$2, Directory.class);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList();
        return this.dslGenerator.generate((List<Directory>)directories);
    }

    public void applyDsl(String dsl) {
        List<XldSpec> xldSpecs = this.dslExecutor.execute(dsl);
        this.checkConditionOnXldSpecs((Function1<List<DirectorySpec>, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DslApi $outer;

            public final void apply(List<DirectorySpec> dirs) {
                this.$outer.checkPermissionForDirectories(dirs);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, xldSpecs);
        this.checkConditionOnXldSpecs((Function1<List<DirectorySpec>, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DslApi $outer;

            public final void apply(List<DirectorySpec> dirs) {
                this.$outer.checkSecurityPermissionForUser(dirs);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, xldSpecs);
        List commands = (List)xldSpecs.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DslApi $outer;

            public final List<DslCommand> apply(XldSpec spec) {
                this.$outer.com$xebialabs$deployit$dsl$api$DslApi$$dslReferenceResolver.resolveAll(spec);
                return this.$outer.com$xebialabs$deployit$dsl$api$DslApi$$commandCreator.create(spec);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom());
        this.validator.validateCis(new ArrayList(package$.MODULE$.wrapAll().seqAsJavaList((Seq)commands.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<ConfigurationItem> apply(DslCommand x0$1) {
                Iterable iterable;
                DslCommand dslCommand = x0$1;
                if (dslCommand instanceof DeleteCiCommand) {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                } else if (dslCommand instanceof CiCommand) {
                    CiCommand ciCommand = (CiCommand)dslCommand;
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)ciCommand.ci()));
                } else {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }
        }, List$.MODULE$.canBuildFrom()))));
        this.commandExecutor.execute((List<DslCommand>)commands);
    }

    public void checkConditionOnXldSpecs(Function1<List<DirectorySpec>, BoxedUnit> condition, List<XldSpec> xldSpecs) {
        ((List)((List)xldSpecs.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Buffer<ScopeSpec> apply(XldSpec x$3) {
                return ((WrapAsScala)package$.MODULE$.wrapAll()).asScalaBuffer(x$3.getScopes());
            }
        }, List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ForDirectories apply(ScopeSpec x$4) {
                return x$4.getForDirectories();
            }
        }, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, condition){
            public static final long serialVersionUID = 0L;
            private final Function1 condition$1;

            public final void apply(ForDirectories dirs) {
                List list = Option$.MODULE$.apply((Object)dirs.getForEnvironments()).toList();
                List specs = Option$.MODULE$.apply((Object)dirs.getForInfrastructure()).toList().$colon$colon$colon(list);
                this.condition$1.apply((Object)specs);
            }
            {
                this.condition$1 = condition$1;
            }
        });
    }

    public void checkPermissionForDirectories(List<DirectorySpec> dirs) {
        dirs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DslApi $outer;

            public final void apply(DirectorySpec dir) {
                this.$outer.checkPermissionForDirectory(dir);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void checkPermissionForDirectory(DirectorySpec dir) {
        if (dir.getId() != null) {
            this.checkPermission(PlatformPermissions.EDIT_REPO, JcrPathHelper.getParentId((String)dir.getId()));
        }
    }

    public void checkSecurityPermissionForUser(List<DirectorySpec> dirs) {
        if (((TraversableOnce)dirs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<Role, Set<Permission>> apply(DirectorySpec x$6) {
                return x$6.getPermissions();
            }
        }, List$.MODULE$.canBuildFrom())).nonEmpty()) {
            this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        }
    }

    public <T extends ConfigurationItem> T com$xebialabs$deployit$dsl$api$DslApi$$castAndCheck(ConfigurationItem ci2, Class<T> clazz) {
        Checks.checkArgument((boolean)clazz.isAssignableFrom(ci2.getClass()), (String)"%s is not a %s", (Object[])new Object[]{ci2, clazz.getSimpleName()});
        return (T)((ConfigurationItem)clazz.cast(ci2));
    }

    @Autowired
    public DslApi(RepositoryService repositoryService, DSLGenerator dslGenerator, DslExecutor dslExecutor, DslReferenceResolver dslReferenceResolver, CommandCreator commandCreator, CommandExecutor commandExecutor, Validator validator) {
        this.repositoryService = repositoryService;
        this.dslGenerator = dslGenerator;
        this.dslExecutor = dslExecutor;
        this.com$xebialabs$deployit$dsl$api$DslApi$$dslReferenceResolver = dslReferenceResolver;
        this.com$xebialabs$deployit$dsl$api$DslApi$$commandCreator = commandCreator;
        this.commandExecutor = commandExecutor;
        this.validator = validator;
    }
}

