/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecificationWithDependencies;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.BaseProvisionedContainer;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployed;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployedContainer;
import com.xebialabs.deployit.repository.ChangeSet;
import java.util.Collection;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeSetBuilder {
    public static final Function<ConfigurationItem, String> CI_2_NAME_FUNCTION = ConfigurationItem::getName;
    private static final Logger logger = LoggerFactory.getLogger(ChangeSetBuilder.class);

    public static ChangeSet determineChanges(DeltaSpecificationWithDependencies specification) {
        ChangeSet changeSet2 = new ChangeSet();
        for (DeltaSpecification deltaSpecification : specification.getAllDeltaSpecifications()) {
            ChangeSetBuilder.determineChanges(changeSet2, deltaSpecification);
        }
        return changeSet2;
    }

    public static ChangeSet determineChanges(DeltaSpecification specification) {
        ChangeSet changeSet2 = new ChangeSet();
        ChangeSetBuilder.determineChanges(changeSet2, specification);
        return changeSet2;
    }

    private static void determineChanges(ChangeSet changeSet2, DeltaSpecification specification) {
        logger.debug("Determining change set for deployed application [{}]", (Object)specification.getDeployedApplication());
        ChangeSetBuilder.addDeployedApplication(changeSet2, specification);
        DeployedApplication xDeployedApplication = specification.getDeployedApplication();
        for (Delta delta : specification.getDeltas()) {
            switch (delta.getOperation()) {
                case CREATE: {
                    changeSet2.create((ConfigurationItem)delta.getDeployed());
                    ChangeSetBuilder.addEmbeddeds(changeSet2, null, delta.getDeployed(), Operation.CREATE);
                    xDeployedApplication.addDeployed(delta.getDeployed());
                    logger.debug("The CI [{}] will be {} in the repository", (Object)delta.getDeployed().getId(), (Object)delta.getOperation());
                    break;
                }
                case MODIFY: 
                case NOOP: {
                    changeSet2.update((ConfigurationItem)delta.getDeployed());
                    ChangeSetBuilder.addEmbeddeds(changeSet2, delta.getPrevious(), delta.getDeployed(), delta.getOperation());
                    xDeployedApplication.addDeployed(delta.getDeployed());
                    logger.debug("The CI [{}] will be {} in the repository", (Object)delta.getDeployed().getId(), (Object)delta.getOperation());
                    break;
                }
                case DESTROY: {
                    if (delta.getPrevious() instanceof BaseProvisionedContainer) break;
                    changeSet2.delete((ConfigurationItem)delta.getPrevious());
                    ChangeSetBuilder.addEmbeddeds(changeSet2, delta.getPrevious(), null, Operation.DESTROY);
                    logger.debug("The CI [{}] will be {} in the repository", (Object)delta.getPrevious().getId(), (Object)delta.getOperation());
                }
            }
        }
        logger.debug("DeployedApplication [{}] will contain the following {} deployeds: {}", new Object[]{xDeployedApplication, xDeployedApplication.getDeployeds().size(), xDeployedApplication.getDeployeds()});
    }

    private static void addDeployedApplication(ChangeSet changeSet2, DeltaSpecification specification) {
        DeployedApplication deployedApplication = specification.getDeployedApplication();
        switch (specification.getOperation()) {
            case CREATE: {
                changeSet2.create((ConfigurationItem)deployedApplication);
                break;
            }
            case MODIFY: {
                changeSet2.update((ConfigurationItem)deployedApplication);
                break;
            }
            case DESTROY: {
                changeSet2.delete((ConfigurationItem)deployedApplication);
                break;
            }
        }
    }

    private static void addEmbeddeds(ChangeSet changeSet2, EmbeddedDeployedContainer<?, ?> previous, EmbeddedDeployedContainer<?, ?> current, Operation operation) {
        EmbeddedDeployedContainer<?, ?> edc = operation != Operation.DESTROY ? current : previous;
        logger.trace("Going to scan whether {}[{}] has embeddeds", (Object)edc.getType(), (Object)edc.getId());
        for (PropertyDescriptor propertyDescriptor : edc.getType().getDescriptor().getPropertyDescriptors()) {
            logger.trace("Analyzing property [{}]", (Object)propertyDescriptor.getFqn());
            if (!ChangeSetBuilder.isEmbeddedProperty(propertyDescriptor)) {
                logger.trace("[{}] is not an embedded property", (Object)propertyDescriptor.getFqn());
                continue;
            }
            logger.debug("Determining changeset for embeddeds in property [{}] of [{}]", (Object)propertyDescriptor.getFqn(), (Object)edc.getId());
            if (operation == Operation.CREATE || operation == Operation.DESTROY) {
                Collection embeddeds = (Collection)propertyDescriptor.get(edc);
                if (embeddeds == null || embeddeds.isEmpty()) continue;
                for (EmbeddedDeployed embedded : embeddeds) {
                    if (operation == Operation.CREATE) {
                        changeSet2.create((ConfigurationItem)embedded);
                        logger.debug("The CI {} will be {} in the repository", (Object)embedded.getId(), (Object)operation);
                        ChangeSetBuilder.addEmbeddeds(changeSet2, null, embedded, operation);
                        continue;
                    }
                    logger.debug("The CI {} will be {} in the repository", (Object)embedded.getId(), (Object)operation);
                    ChangeSetBuilder.addEmbeddeds(changeSet2, embedded, null, operation);
                }
                continue;
            }
            Collection currentEmbeddeds = (Collection)propertyDescriptor.get(current);
            currentEmbeddeds = currentEmbeddeds != null ? currentEmbeddeds : Sets.newHashSet();
            Collection previousEmbeddeds = (Collection)propertyDescriptor.get(previous);
            previousEmbeddeds = previousEmbeddeds != null ? previousEmbeddeds : Sets.newHashSet();
            ImmutableListMultimap nameToCiMap = Multimaps.index((Iterable)Iterables.concat((Iterable)previousEmbeddeds, (Iterable)currentEmbeddeds), CI_2_NAME_FUNCTION);
            for (String ciName : nameToCiMap.keySet()) {
                EmbeddedDeployed embedded;
                ImmutableList embeddedDeployeds = nameToCiMap.get((Object)ciName);
                if (embeddedDeployeds.size() == 2) {
                    embedded = (EmbeddedDeployed)embeddedDeployeds.get(1);
                    changeSet2.update((ConfigurationItem)embedded);
                    logger.debug("The CI {} will be {} in the repository", (Object)embedded.getId(), (Object)operation);
                    ChangeSetBuilder.addEmbeddeds(changeSet2, (EmbeddedDeployedContainer)embeddedDeployeds.get(0), embedded, operation);
                    continue;
                }
                if (embeddedDeployeds.size() == 1) {
                    embedded = (EmbeddedDeployed)embeddedDeployeds.get(0);
                    if (currentEmbeddeds.contains(embedded)) {
                        changeSet2.create((ConfigurationItem)embedded);
                        logger.debug("The CI {} will be {} in the repository", (Object)embedded.getId(), (Object)Operation.CREATE);
                        ChangeSetBuilder.addEmbeddeds(changeSet2, null, embedded, Operation.CREATE);
                        continue;
                    }
                    changeSet2.delete((ConfigurationItem)embedded);
                    logger.debug("The CI {} will be {} in the repository", (Object)embedded.getId(), (Object)Operation.DESTROY);
                    ChangeSetBuilder.addEmbeddeds(changeSet2, embedded, null, Operation.DESTROY);
                    continue;
                }
                throw new IllegalStateException("Shouldn't have seen more than 2 ConfigurationItems with the same name (" + ciName + "): " + nameToCiMap);
            }
        }
    }

    private static boolean isEmbeddedProperty(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.isAsContainment() && EnumSet.of(PropertyKind.SET_OF_CI, PropertyKind.LIST_OF_CI).contains(propertyDescriptor.getKind()) && propertyDescriptor.getReferencedType().isSubTypeOf(Type.valueOf(EmbeddedDeployed.class));
    }
}

