/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.transport.tcp;

import com.hierynomus.mssmb2.SMB2Packet;
import com.hierynomus.mssmb2.messages.SMB2ResponseMessageFactory;
import com.hierynomus.protocol.Packet;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.protocol.commons.buffer.Endian;
import com.hierynomus.smbj.common.SMBBuffer;
import com.hierynomus.smbj.transport.PacketReader;
import com.hierynomus.smbj.transport.PacketReceiver;
import com.hierynomus.smbj.transport.TransportException;
import java.io.IOException;
import java.io.InputStream;

public class DirectTcpPacketReader
extends PacketReader {
    public DirectTcpPacketReader(String host, InputStream in, PacketReceiver handler) {
        super(host, in, handler);
    }

    private SMB2Packet _readSMB2Packet(int packetLength) throws IOException, Buffer.BufferException {
        byte[] buf = new byte[packetLength];
        int read = 0;
        for (int count = 0; count < packetLength && (read = this.in.read(buf, count, packetLength - count)) != -1; count += read) {
        }
        if (read == -1) {
            throw new TransportException("EOF while reading packet");
        }
        SMBBuffer buffer = new SMBBuffer(buf);
        return SMB2ResponseMessageFactory.read(buffer);
    }

    protected Packet doRead() throws TransportException {
        try {
            int smb2PacketLength = this._readTcpHeader();
            return this._readSMB2Packet(smb2PacketLength);
        }
        catch (Buffer.BufferException | IOException e) {
            throw new TransportException(e);
        }
    }

    private int _readTcpHeader() throws IOException, Buffer.BufferException {
        byte[] tcpHeader = new byte[4];
        this.in.read(tcpHeader);
        Buffer.PlainBuffer plainBuffer = new Buffer.PlainBuffer(tcpHeader, Endian.BE);
        plainBuffer.readByte();
        int packetLength = plainBuffer.readUInt24();
        return packetLength;
    }
}

