/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.mssmb2.messages;

import com.hierynomus.msdtyp.MsDataTypes;
import com.hierynomus.mserref.NtStatus;
import com.hierynomus.msfscc.FileAttributes;
import com.hierynomus.mssmb2.SMB2FileId;
import com.hierynomus.mssmb2.SMB2Packet;
import com.hierynomus.protocol.commons.EnumWithValue;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.smbj.common.SMBBuffer;
import java.util.Date;
import java.util.EnumSet;

public class SMB2CreateResponse
extends SMB2Packet {
    private Date creationTime;
    private Date lastAccessTime;
    private Date lastWriteTime;
    private Date changeTime;
    private EnumSet<FileAttributes> fileAttributes;
    private SMB2FileId fileId;

    @Override
    protected void readMessage(SMBBuffer buffer) throws Buffer.BufferException {
        if (this.header.getStatus() == NtStatus.STATUS_SUCCESS) {
            buffer.readUInt16();
            buffer.readByte();
            buffer.readByte();
            buffer.readUInt32();
            this.creationTime = MsDataTypes.readFileTime(buffer);
            this.lastAccessTime = MsDataTypes.readFileTime(buffer);
            this.lastWriteTime = MsDataTypes.readFileTime(buffer);
            this.changeTime = MsDataTypes.readFileTime(buffer);
            buffer.readRawBytes(8);
            buffer.readRawBytes(8);
            this.fileAttributes = EnumWithValue.EnumUtils.toEnumSet(buffer.readUInt32(), FileAttributes.class);
            buffer.skip(4);
            this.fileId = SMB2FileId.read(buffer);
            buffer.readUInt32();
            buffer.readUInt32();
        }
    }

    public Date getCreationTime() {
        return this.copyOf(this.creationTime);
    }

    public Date getLastAccessTime() {
        return this.copyOf(this.lastAccessTime);
    }

    public Date getLastWriteTime() {
        return this.copyOf(this.lastWriteTime);
    }

    public Date getChangeTime() {
        return this.copyOf(this.changeTime);
    }

    public EnumSet<FileAttributes> getFileAttributes() {
        return this.fileAttributes;
    }

    public SMB2FileId getFileId() {
        return this.fileId;
    }

    private Date copyOf(Date d) {
        return d != null ? new Date(d.getTime()) : null;
    }
}

