/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.msdtyp.ace;

import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.msdtyp.SID;
import com.hierynomus.msdtyp.ace.ACE;
import com.hierynomus.msdtyp.ace.AceFlags;
import com.hierynomus.msdtyp.ace.AceHeader;
import com.hierynomus.msdtyp.ace.AceType;
import com.hierynomus.protocol.commons.EnumWithValue;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.smbj.common.SMBBuffer;
import java.util.Arrays;
import java.util.EnumSet;

class AceType3
extends ACE {
    private byte[] applicationData;

    AceType3() {
    }

    AceType3(AceType aceType, EnumSet<AceFlags> aceFlags, EnumSet<AccessMask> accessMask, SID sid, byte[] applicationData) {
        super(new AceHeader(aceType, aceFlags, ACE.HEADER_STRUCTURE_SIZE + 4 + 4 + sid.byteCount() + applicationData.length), EnumWithValue.EnumUtils.toLong(accessMask), sid);
        this.applicationData = applicationData;
    }

    @Override
    protected void writeTo(SMBBuffer buffer) {
        buffer.putUInt32(this.accessMask);
        this.getSid().write(buffer);
        buffer.putRawBytes(this.applicationData);
    }

    @Override
    protected void readMessage(SMBBuffer buffer) throws Buffer.BufferException {
        this.accessMask = buffer.readUInt32();
        this.getSid().read(buffer);
        this.applicationData = buffer.readRawBytes(this.aceHeader.getAceSize() - 4 + 4 + this.getSid().byteCount());
    }

    @Override
    public String toString() {
        return "AceType3{applicationData=" + Arrays.toString(this.applicationData) + "} " + super.toString();
    }
}

