/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.msdtyp;

import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.protocol.commons.buffer.Endian;
import java.util.Date;
import java.util.UUID;

public class MsDataTypes {
    public static final int NANO100_TO_MILLI = 10000;
    public static final long WINDOWS_TO_UNIX_EPOCH = 116444736000000000L;

    private MsDataTypes() {
    }

    public static void putGuid(UUID guid, Buffer<?> buffer) {
        long leastSignificantBits = guid.getLeastSignificantBits();
        long mostSignificantBits = guid.getMostSignificantBits();
        buffer.putUInt32(mostSignificantBits >>> 32);
        buffer.putUInt16((int)(mostSignificantBits >>> 16 & 0xFFFFL));
        buffer.putUInt16((int)(mostSignificantBits & 0xFFFFL));
        buffer.putLong(leastSignificantBits, Endian.BE);
    }

    public static UUID readGuid(Buffer<?> buffer) throws Buffer.BufferException {
        long mostSigBits = buffer.readUInt32();
        mostSigBits <<= 16;
        mostSigBits |= (long)buffer.readUInt16();
        mostSigBits <<= 16;
        long leastSigBits = buffer.readLong(Endian.BE);
        return new UUID(mostSigBits |= (long)buffer.readUInt16(), leastSigBits);
    }

    public static Date readFileTime(Buffer<?> buffer) throws Buffer.BufferException {
        long lowOrder = buffer.readUInt32();
        long highOrder = buffer.readUInt32();
        long windowsTimeStamp = highOrder << 32 | lowOrder;
        return new Date((windowsTimeStamp - 116444736000000000L) / 10000L);
    }

    public static long nowAsFileTime() {
        return System.currentTimeMillis() * 10000L + 116444736000000000L;
    }
}

