/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.msdtyp;

import com.hierynomus.msdtyp.ace.ACE;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.smbj.common.SMBBuffer;
import java.util.Arrays;

public class ACL {
    private byte revision;
    private int aceCount;
    private byte[] sidIdentifierAuthority;
    private long[] subAuthorities;
    private ACE[] aces;
    private int aclSize;

    public void write(SMBBuffer buffer) {
        this.aces = this.aces == null ? new ACE[]{} : this.aces;
        buffer.putByte(this.revision);
        buffer.putReserved1();
        this.aclSize = 8;
        for (ACE ace : this.aces) {
            this.aclSize += ace.getAceHeader().getAceSize();
        }
        buffer.putUInt16(this.aclSize);
        buffer.putUInt16(this.aces.length);
        buffer.putReserved2();
        for (ACE ace : this.aces) {
            ace.write(buffer);
        }
    }

    public void read(SMBBuffer buffer) throws Buffer.BufferException {
        this.revision = buffer.readByte();
        buffer.skip(1);
        this.aclSize = buffer.readUInt16();
        int aceCount = buffer.readUInt16();
        buffer.skip(2);
        this.aces = new ACE[aceCount];
        for (int i = 0; i < aceCount; ++i) {
            this.aces[i] = ACE.factory(buffer);
        }
    }

    public int getAceCount() {
        return this.aceCount;
    }

    public byte[] getSidIdentifierAuthority() {
        return this.sidIdentifierAuthority;
    }

    public long[] getSubAuthorities() {
        return this.subAuthorities;
    }

    public ACE[] getAces() {
        return Arrays.copyOf(this.aces, this.aces.length);
    }

    public int getAclSize() {
        return this.aclSize;
    }

    public String toString() {
        return "ACL{revision=" + this.revision + ", aceCount=" + this.aceCount + ", sidIdentifierAuthority=" + Arrays.toString(this.sidIdentifierAuthority) + ", subAuthorities=" + Arrays.toString(this.subAuthorities) + ", aces=" + Arrays.toString(this.aces) + '}';
    }
}

