/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.mssmb2;

import com.hierynomus.mssmb2.SMB2Dialect;
import com.hierynomus.mssmb2.SMB2Header;
import com.hierynomus.mssmb2.SMB2MessageCommandCode;
import com.hierynomus.protocol.Packet;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.smbj.common.SMBBuffer;

public class SMB2Packet
implements Packet<SMB2Packet, SMBBuffer> {
    public static final int SINGLE_CREDIT_PAYLOAD_SIZE = 65536;
    protected final SMB2Header header = new SMB2Header();
    protected int structureSize;
    SMBBuffer buffer;

    public SMB2Packet() {
    }

    public SMB2Packet(int structureSize, SMB2Dialect dialect, SMB2MessageCommandCode messageType) {
        this(structureSize, dialect, messageType, 0L, 0L);
    }

    public SMB2Packet(int structureSize, SMB2Dialect dialect, SMB2MessageCommandCode messageType, long sessionId) {
        this(structureSize, dialect, messageType, sessionId, 0L);
    }

    public SMB2Packet(int structureSize, SMB2Dialect dialect, SMB2MessageCommandCode messageType, long sessionId, long treeId) {
        this.structureSize = structureSize;
        this.header.setDialect(dialect);
        this.header.setMessageType(messageType);
        this.header.setSessionId(sessionId);
        this.header.setTreeId(treeId);
    }

    public SMB2Header getHeader() {
        return this.header;
    }

    public long getSequenceNumber() {
        return this.header.getMessageId();
    }

    public int getStructureSize() {
        return this.structureSize;
    }

    public SMBBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public void write(SMBBuffer buffer) {
        this.header.writeTo(buffer);
        this.writeTo(buffer);
    }

    protected void writeTo(SMBBuffer buffer) {
        throw new UnsupportedOperationException("Should be implemented by specific message type");
    }

    @Override
    public final SMB2Packet read(SMBBuffer buffer) throws Buffer.BufferException {
        this.buffer = buffer;
        this.header.readFrom(buffer);
        this.readMessage(buffer);
        return this;
    }

    protected void readMessage(SMBBuffer buffer) throws Buffer.BufferException {
        throw new UnsupportedOperationException("Should be implemented by specific message type");
    }

    public int getMaxPayloadSize() {
        return 65536;
    }

    public int getCreditsAssigned() {
        return this.getHeader().getCreditCharge();
    }

    public void setCreditsAssigned(int creditsAssigned) {
        this.getHeader().setCreditCharge(creditsAssigned);
    }
}

