/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.msdtyp.ace;

import com.hierynomus.msdtyp.ace.AceFlags;
import com.hierynomus.msdtyp.ace.AceType;
import com.hierynomus.protocol.commons.EnumWithValue;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.smbj.common.SMBBuffer;
import java.util.EnumSet;

public class AceHeader {
    private AceType aceType;
    private EnumSet<AceFlags> aceFlags;
    private int aceSize;

    AceHeader() {
    }

    AceHeader(AceType aceType, EnumSet<AceFlags> aceFlags, int aceSize) {
        this.aceType = aceType;
        this.aceFlags = aceFlags;
        this.aceSize = aceSize;
    }

    public void writeTo(SMBBuffer buffer) {
        buffer.putByte((byte)this.aceType.getValue());
        buffer.putByte((byte)EnumWithValue.EnumUtils.toLong(this.aceFlags));
        buffer.putUInt16(this.aceSize);
    }

    public void readFrom(SMBBuffer buffer) throws Buffer.BufferException {
        this.aceType = EnumWithValue.EnumUtils.valueOf(buffer.readByte(), AceType.class, null);
        this.aceFlags = EnumWithValue.EnumUtils.toEnumSet(buffer.readByte(), AceFlags.class);
        this.aceSize = buffer.readUInt16();
    }

    public int getAceSize() {
        return this.aceSize;
    }

    void setAceSize(int aceSize) {
        this.aceSize = aceSize;
    }

    public AceType getAceType() {
        return this.aceType;
    }

    public EnumSet<AceFlags> getAceFlags() {
        return this.aceFlags;
    }

    public String toString() {
        return "AceHeader{aceType=" + this.aceType + ", aceFlags=" + this.aceFlags + ", aceSize=" + this.aceSize + '}';
    }
}

