/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster;

import akka.ConfigurationException;
import akka.actor.ActorPath;
import akka.actor.ActorRef;
import akka.actor.ActorRefProvider;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.Cancellable;
import akka.actor.Deploy$;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.Props$;
import akka.actor.RootActorPath;
import akka.actor.ScalaActorRef;
import akka.actor.Scheduler;
import akka.actor.package$;
import akka.cluster.Cluster$;
import akka.cluster.Cluster$InfoLogger$;
import akka.cluster.ClusterActorRefProvider;
import akka.cluster.ClusterDaemon;
import akka.cluster.ClusterEvent;
import akka.cluster.ClusterEvent$InitialStateAsSnapshot$;
import akka.cluster.ClusterJmx;
import akka.cluster.ClusterReadView;
import akka.cluster.ClusterSettings;
import akka.cluster.ClusterUserAction;
import akka.cluster.DowningProvider;
import akka.cluster.DowningProvider$;
import akka.cluster.InternalClusterAction;
import akka.cluster.InternalClusterAction$GetClusterCoreRef$;
import akka.cluster.UniqueAddress;
import akka.dispatch.MonitorableThreadFactory;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.japi.Util$;
import akka.pattern.AskableActorRef$;
import akka.remote.AddressUidExtension;
import akka.remote.AddressUidExtension$;
import akka.remote.DefaultFailureDetectorRegistry;
import akka.remote.FailureDetector;
import akka.remote.FailureDetectorLoader$;
import akka.remote.FailureDetectorRegistry;
import akka.util.Timeout;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Closeable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r=q!B\u0001\u0003\u0011\u00039\u0011aB\"mkN$XM\u001d\u0006\u0003\u0007\u0011\tqa\u00197vgR,'OC\u0001\u0006\u0003\u0011\t7n[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\t91\t\\;ti\u0016\u00148#B\u0005\r%\t}\u0007CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\rE\u0002\u0014-ai\u0011\u0001\u0006\u0006\u0003+\u0011\tQ!Y2u_JL!a\u0006\u000b\u0003\u0017\u0015CH/\u001a8tS>t\u0017\n\u001a\t\u0003\u0011e1AA\u0003\u0002\u00015M\u0019\u0011\u0004D\u000e\u0011\u0005Ma\u0012BA\u000f\u0015\u0005%)\u0005\u0010^3og&|g\u000e\u0003\u0005 3\t\u0015\r\u0011\"\u0001!\u0003\u0019\u0019\u0018p\u001d;f[V\t\u0011\u0005\u0005\u0002\u0014E%\u00111\u0005\u0006\u0002\u0014\u000bb$XM\u001c3fI\u0006\u001bGo\u001c:TsN$X-\u001c\u0005\tKe\u0011\t\u0011)A\u0005C\u000591/_:uK6\u0004\u0003\"B\u0014\u001a\t\u0003A\u0013A\u0002\u001fj]&$h\b\u0006\u0002\u0019S!)qD\na\u0001C!91&\u0007b\u0001\n\u0003a\u0013\u0001C:fiRLgnZ:\u0016\u00035\u0002\"\u0001\u0003\u0018\n\u0005=\u0012!aD\"mkN$XM]*fiRLgnZ:\t\rEJ\u0002\u0015!\u0003.\u0003%\u0019X\r\u001e;j]\u001e\u001c\b\u0005C\u000443\t\u0007I\u0011\u0001\u001b\u0002#M,GNZ+oSF,X-\u00113ee\u0016\u001c8/F\u00016!\tAa'\u0003\u00028\u0005\tiQK\\5rk\u0016\fE\r\u001a:fgNDa!O\r!\u0002\u0013)\u0014AE:fY\u001a,f.[9vK\u0006#GM]3tg\u0002BQaO\r\u0005\u0002q\n1b]3mM\u0006#GM]3tgV\tQ\b\u0005\u0002\u0014}%\u0011q\b\u0006\u0002\b\u0003\u0012$'/Z:t\u0011\u0015\t\u0015\u0004\"\u0001C\u0003%\u0019X\r\u001c4S_2,7/F\u0001D!\r!uI\u0013\b\u0003\u001b\u0015K!A\u0012\b\u0002\rA\u0013X\rZ3g\u0013\tA\u0015JA\u0002TKRT!A\u0012\b\u0011\u0005\u0011[\u0015B\u0001'J\u0005\u0019\u0019FO]5oO\")a*\u0007C\u0001\u001f\u0006aq-\u001a;TK24'k\u001c7fgV\t\u0001\u000bE\u0002R-*k\u0011A\u0015\u0006\u0003'R\u000bA!\u001e;jY*\tQ+\u0001\u0003kCZ\f\u0017B\u0001%S\u0011\u001dA\u0016D1A\u0005\ne\u000bQbX5t)\u0016\u0014X.\u001b8bi\u0016$W#\u0001.\u0011\u0005m\u0003W\"\u0001/\u000b\u0005us\u0016AB1u_6L7M\u0003\u0002`%\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\u0005d&!D!u_6L7MQ8pY\u0016\fg\u000e\u0003\u0004d3\u0001\u0006IAW\u0001\u000f?&\u001cH+\u001a:nS:\fG/\u001a3!\u0011\u001d)\u0017D1A\u0005\n\u0019\f1\u0001\\8h+\u00059\u0007C\u00015l\u001b\u0005I'B\u00016\u0005\u0003\u0015)g/\u001a8u\u0013\ta\u0017N\u0001\bM_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\t\r9L\u0002\u0015!\u0003h\u0003\u0011awn\u001a\u0011\t\u000fAL\u0002\u0019!C\u0005c\u0006Q1\r\\;ti\u0016\u0014(*\u001c=\u0016\u0003I\u00042!D:v\u0013\t!hB\u0001\u0004PaRLwN\u001c\t\u0003\u0011YL!a\u001e\u0002\u0003\u0015\rcWo\u001d;fe*k\u0007\u0010C\u0004z3\u0001\u0007I\u0011\u0002>\u0002\u001d\rdWo\u001d;fe*k\u0007p\u0018\u0013fcR\u00111P \t\u0003\u001bqL!! \b\u0003\tUs\u0017\u000e\u001e\u0005\b\u007fb\f\t\u00111\u0001s\u0003\rAH%\r\u0005\b\u0003\u0007I\u0002\u0015)\u0003s\u0003-\u0019G.^:uKJTU\u000e\u001f\u0011\t\u0013\u0005\u001d\u0011D1A\u0005\u0002\u0005%\u0011a\u00044bS2,(/\u001a#fi\u0016\u001cGo\u001c:\u0016\u0005\u0005-\u0001#BA\u0007\u0003'iTBAA\b\u0015\r\t\t\u0002B\u0001\u0007e\u0016lw\u000e^3\n\t\u0005U\u0011q\u0002\u0002\u0018\r\u0006LG.\u001e:f\t\u0016$Xm\u0019;peJ+w-[:uefD\u0001\"!\u0007\u001aA\u0003%\u00111B\u0001\u0011M\u0006LG.\u001e:f\t\u0016$Xm\u0019;pe\u0002B!\"!\b\u001a\u0011\u000b\u0007I\u0011AA\u0010\u0003=!wn\u001e8j]\u001e\u0004&o\u001c<jI\u0016\u0014XCAA\u0011!\rA\u00111E\u0005\u0004\u0003K\u0011!a\u0004#po:Lgn\u001a)s_ZLG-\u001a:\t\u0015\u0005%\u0012\u0004#A!B\u0013\t\t#\u0001\te_^t\u0017N\\4Qe>4\u0018\u000eZ3sA!Q\u0011QF\rC\u0002\u0013\u0005!!a\f\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014XCAA\u0019!\r\u0019\u00121G\u0005\u0004\u0003k!\"!C*dQ\u0016$W\u000f\\3s\u0011!\tI$\u0007Q\u0001\n\u0005E\u0012AC:dQ\u0016$W\u000f\\3sA!I\u0011QH\rC\u0002\u0013%\u0011qH\u0001\u000fG2,8\u000f^3s\t\u0006,Wn\u001c8t+\t\t\t\u0005E\u0002\u0014\u0003\u0007J1!!\u0012\u0015\u0005!\t5\r^8s%\u00164\u0007\u0002CA%3\u0001\u0006I!!\u0011\u0002\u001f\rdWo\u001d;fe\u0012\u000bW-\\8og\u0002B!\"!\u0014\u001a\u0005\u0004%\tAAA \u0003-\u0019G.^:uKJ\u001cuN]3\t\u0011\u0005E\u0013\u0004)A\u0005\u0003\u0003\nAb\u00197vgR,'oQ8sK\u0002B!\"!\u0016\u001a\u0005\u0004%\tAAA,\u0003!\u0011X-\u00193WS\u0016<XCAA-!\rA\u00111L\u0005\u0004\u0003;\u0012!aD\"mkN$XM\u001d*fC\u00124\u0016.Z<\t\u0011\u0005\u0005\u0014\u0004)A\u0005\u00033\n\u0011B]3bIZKWm\u001e\u0011\t\u000f\u0005\u0015\u0014\u0004\"\u0001\u0002h\u0005a\u0011n\u001d+fe6Lg.\u0019;fIV\u0011\u0011\u0011\u000e\t\u0004\u001b\u0005-\u0014bAA7\u001d\t9!i\\8mK\u0006t\u0007bBA93\u0011\u0005\u00111O\u0001\u0006gR\fG/Z\u000b\u0003\u0003k\u0002B!a\u001e\u0002~9\u0019\u0001\"!\u001f\n\u0007\u0005m$!\u0001\u0007DYV\u001cH/\u001a:Fm\u0016tG/\u0003\u0003\u0002\u0000\u0005\u0005%aE\"veJ,g\u000e^\"mkN$XM]*uCR,'bAA>\u0005!9\u0011QQ\r\u0005\u0002\u0005\u001d\u0015!C:vEN\u001c'/\u001b2f)\u0015Y\u0018\u0011RAG\u0011!\tY)a!A\u0002\u0005\u0005\u0013AC:vEN\u001c'/\u001b2fe\"A\u0011qRAB\u0001\u0004\t\t*\u0001\u0002u_B)Q\"a%\u0002\u0018&\u0019\u0011Q\u0013\b\u0003\u0015q\u0012X\r]3bi\u0016$g\b\r\u0003\u0002\u001a\u0006\r\u0006#\u0002#\u0002\u001c\u0006}\u0015bAAO\u0013\n)1\t\\1tgB!\u0011\u0011UAR\u0019\u0001!A\"!*\u0002\u000e\u0006\u0005\t\u0011!B\u0001\u0003O\u00131a\u0018\u00132#\u0011\tI+a,\u0011\u00075\tY+C\u0002\u0002.:\u0011qAT8uQ&tw\rE\u0002\u000e\u0003cK1!a-\u000f\u0005\r\te.\u001f\u0015\u0005\u0003\u0007\u000b9\f\u0005\u0003\u0002:\u0006}VBAA^\u0015\r\tiLD\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAa\u0003w\u0013qA^1sCJ<7\u000fC\u0004\u0002\u0006f!\t!!2\u0015\u000fm\f9-!3\u0002T\"A\u00111RAb\u0001\u0004\t\t\u0005\u0003\u0005\u0002L\u0006\r\u0007\u0019AAg\u0003AIg.\u001b;jC2\u001cF/\u0019;f\u001b>$W\r\u0005\u0003\u0002x\u0005=\u0017\u0002BAi\u0003\u0003\u0013AdU;cg\u000e\u0014\u0018\u000e\u001d;j_:Le.\u001b;jC2\u001cF/\u0019;f\u001b>$W\r\u0003\u0005\u0002\u0010\u0006\r\u0007\u0019AAk!\u0015i\u00111SAla\u0011\tI.!8\u0011\u000b\u0011\u000bY*a7\u0011\t\u0005\u0005\u0016Q\u001c\u0003\r\u0003?\f\u0019.!A\u0001\u0002\u000b\u0005\u0011q\u0015\u0002\u0004?\u0012\u0012\u0004\u0006BAb\u0003oCq!!:\u001a\t\u0003\t9/A\u0006v]N,(m]2sS\n,GcA>\u0002j\"A\u00111RAr\u0001\u0004\t\t\u0005C\u0004\u0002ff!\t!!<\u0015\u000bm\fy/!=\t\u0011\u0005-\u00151\u001ea\u0001\u0003\u0003B\u0001\"a$\u0002l\u0002\u0007\u00111\u001f\u0019\u0005\u0003k\fI\u0010E\u0003E\u00037\u000b9\u0010\u0005\u0003\u0002\"\u0006eH\u0001DA~\u0003c\f\t\u0011!A\u0003\u0002\u0005\u001d&aA0%g!9\u0011q`\r\u0005\u0002\t\u0005\u0011aF:f]\u0012\u001cUO\u001d:f]R\u001cE.^:uKJ\u001cF/\u0019;f)\rY(1\u0001\u0005\t\u0005\u000b\ti\u00101\u0001\u0002B\u0005A!/Z2fSZ,'\u000fC\u0004\u0003\ne!\tAa\u0003\u0002\t)|\u0017N\u001c\u000b\u0004w\n5\u0001b\u0002B\b\u0005\u000f\u0001\r!P\u0001\bC\u0012$'/Z:t\u0011\u001d\u0011\u0019\"\u0007C\u0005\u0005+\t\u0011BZ5mY2{7-\u00197\u0015\u0007u\u00129\u0002C\u0004\u0003\u0010\tE\u0001\u0019A\u001f\t\u000f\tm\u0011\u0004\"\u0001\u0003\u001e\u0005i!n\\5o'\u0016,GMT8eKN$2a\u001fB\u0010\u0011!\u0011\tC!\u0007A\u0002\t\r\u0012!C:fK\u0012tu\u000eZ3t!\u0015\u0011)Ca\f>\u001b\t\u00119C\u0003\u0003\u0003*\t-\u0012!C5n[V$\u0018M\u00197f\u0015\r\u0011iCD\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u0019\u0005O\u00111aU3r\u0011\u001d\u0011Y\"\u0007C\u0001\u0005k!2a\u001fB\u001c\u0011!\u0011\tCa\rA\u0002\te\u0002\u0003B)\u0003<uJ1A!\u0010S\u0005\u0011a\u0015n\u001d;\t\u000f\t\u0005\u0013\u0004\"\u0001\u0003D\u0005)A.Z1wKR\u00191P!\u0012\t\u000f\t=!q\ba\u0001{!9!\u0011J\r\u0005\u0002\t-\u0013\u0001\u00023po:$2a\u001fB'\u0011\u001d\u0011yAa\u0012A\u0002uBqA!\u0015\u001a\t\u0003\u0011\u0019&\u0001\nsK\u001eL7\u000f^3s\u001f:lU-\u001c2feV\u0003X\u0003\u0002B+\u0005G\"2a\u001fB,\u0011%\u0011IFa\u0014\u0005\u0002\u0004\u0011Y&\u0001\u0003d_\u0012,\u0007#B\u0007\u0003^\t\u0005\u0014b\u0001B0\u001d\tAAHY=oC6,g\b\u0005\u0003\u0002\"\n\rD\u0001\u0003B3\u0005\u001f\u0012\r!a*\u0003\u0003QCqA!\u0015\u001a\t\u0003\u0011I\u0007F\u0002|\u0005WB\u0001B!\u001c\u0003h\u0001\u0007!qN\u0001\tG\u0006dGNY1dWB!!\u0011\u000fB<\u001b\t\u0011\u0019HC\u0002\u0003vQ\u000bA\u0001\\1oO&!!\u0011\u0010B:\u0005!\u0011VO\u001c8bE2,\u0007b\u0002B?3\u0011\u0005!qP\u0001\u0018e\u0016<\u0017n\u001d;fe>sW*Z7cKJ\u0014V-\\8wK\u0012,BA!!\u0003\nR\u00191Pa!\t\u0013\te#1\u0010CA\u0002\t\u0015\u0005#B\u0007\u0003^\t\u001d\u0005\u0003BAQ\u0005\u0013#\u0001B!\u001a\u0003|\t\u0007\u0011q\u0015\u0005\b\u0005{JB\u0011\u0001BG)\rY(q\u0012\u0005\t\u0005[\u0012Y\t1\u0001\u0003p!9!1S\r\u0005\u0002\tU\u0015\u0001\u0004:f[>$X\rU1uQ>3G\u0003\u0002BL\u0005;\u00032a\u0005BM\u0013\r\u0011Y\n\u0006\u0002\n\u0003\u000e$xN\u001d)bi\"D\u0001Ba(\u0003\u0012\u0002\u0007\u0011\u0011I\u0001\tC\u000e$xN\u001d*fM\"A!1U\r\u0005\u0002\t\u0011)+\u0001\u0005tQV$Hm\\<o)\u0005Y\bb\u0002BU3\u0011%!QU\u0001\u000fG2|7/Z*dQ\u0016$W\u000f\\3s\u000f!\u0011i+\u0007E\u0001\u0005\t=\u0016AC%oM>dunZ4feB!!\u0011\u0017BZ\u001b\u0005Ib\u0001\u0003B[3!\u0005!Aa.\u0003\u0015%sgm\u001c'pO\u001e,'oE\u0002\u000342Aqa\nBZ\t\u0003\u0011Y\f\u0006\u0002\u00030\"A!q\u0018BZ\t\u0003\u0011\t-A\u0004m_\u001eLeNZ8\u0015\u0007m\u0014\u0019\rC\u0004\u0003F\nu\u0006\u0019\u0001&\u0002\u000f5,7o]1hK\"A!q\u0018BZ\t\u0003\u0011I\rF\u0003|\u0005\u0017\u0014y\rC\u0004\u0003N\n\u001d\u0007\u0019\u0001&\u0002\u0011Q,W\u000e\u001d7bi\u0016D\u0001B!5\u0003H\u0002\u0007\u0011qV\u0001\u0005CJ<\u0017\u0007\u0003\u0005\u0003@\nMF\u0011\u0001Bk)\u001dY(q\u001bBm\u00057DqA!4\u0003T\u0002\u0007!\n\u0003\u0005\u0003R\nM\u0007\u0019AAX\u0011!\u0011iNa5A\u0002\u0005=\u0016\u0001B1sOJ\u00022a\u0005Bq\u0013\r\u0011\u0019\u000f\u0006\u0002\u0014\u000bb$XM\\:j_:LE\r\u0015:pm&$WM\u001d\u0005\u0007O%!\tAa:\u0015\u0003\u001dAqAa;\n\t\u0003\u0012i/A\u0002hKR$2\u0001\u0007Bx\u0011\u001dy\"\u0011\u001ea\u0001\u0005c\u00042a\u0005Bz\u0013\r\u0011)\u0010\u0006\u0002\f\u0003\u000e$xN]*zgR,W\u000eC\u0004\u0003z&!\tEa?\u0002\r1|wn[;q)\t\u0011iP\u0004\u0002\t\u0001!91\u0011A\u0005\u0005B\r\r\u0011aD2sK\u0006$X-\u0012=uK:\u001c\u0018n\u001c8\u0015\u0007a\u0019)\u0001\u0003\u0004 \u0005\u007f\u0004\r!\t\u0005\u000b\u0007\u0013I!\u0019!C\u0003\u0005\u0005\u001d\u0014!G5t\u0003N\u001cXM\u001d;J]Z\f'/[1oiN,e.\u00192mK\u0012D\u0001b!\u0004\nA\u00035\u0011\u0011N\u0001\u001bSN\f5o]3si&sg/\u0019:jC:$8/\u00128bE2,G\r\t")
public class Cluster
implements Extension {
    private final ExtendedActorSystem system;
    private final ClusterSettings settings;
    private final UniqueAddress selfUniqueAddress;
    private final AtomicBoolean _isTerminated;
    private final LoggingAdapter akka$cluster$Cluster$$log;
    private Option<ClusterJmx> clusterJmx;
    private final FailureDetectorRegistry<Address> failureDetector;
    private DowningProvider downingProvider;
    private final Scheduler scheduler;
    private final ActorRef clusterDaemons;
    private final ActorRef clusterCore;
    private final ClusterReadView readView;
    private volatile Cluster$InfoLogger$ InfoLogger$module;
    private volatile boolean bitmap$0;

    public static Extension apply(ActorSystem actorSystem) {
        return Cluster$.MODULE$.apply(actorSystem);
    }

    public static Cluster createExtension(ExtendedActorSystem extendedActorSystem) {
        return Cluster$.MODULE$.createExtension(extendedActorSystem);
    }

    public static Cluster$ lookup() {
        return Cluster$.MODULE$.lookup();
    }

    public static Cluster get(ActorSystem actorSystem) {
        return Cluster$.MODULE$.get(actorSystem);
    }

    private DowningProvider downingProvider$lzycompute() {
        Cluster cluster = this;
        synchronized (cluster) {
            if (!this.bitmap$0) {
                this.downingProvider = DowningProvider$.MODULE$.load(this.settings().DowningProviderClassName(), (ActorSystem)this.system());
                this.bitmap$0 = true;
            }
            return this.downingProvider;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Cluster$InfoLogger$ InfoLogger$lzycompute() {
        Cluster cluster = this;
        synchronized (cluster) {
            if (this.InfoLogger$module != null) return this.InfoLogger$module;
            this.InfoLogger$module = new Cluster$InfoLogger$(this);
            return this.InfoLogger$module;
        }
    }

    public void subscribe(ActorRef subscriber, Class<?> ... to) {
        this.subscribe(subscriber, (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])to));
    }

    public void subscribe(ActorRef subscriber, ClusterEvent.SubscriptionInitialStateMode initialStateMode, Class<?> ... to) {
        this.subscribe(subscriber, initialStateMode, (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])to));
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public ClusterSettings settings() {
        return this.settings;
    }

    public UniqueAddress selfUniqueAddress() {
        return this.selfUniqueAddress;
    }

    public Address selfAddress() {
        return this.selfUniqueAddress().address();
    }

    public scala.collection.immutable.Set<String> selfRoles() {
        return this.settings().Roles();
    }

    public Set<String> getSelfRoles() {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.selfRoles()).asJava();
    }

    private AtomicBoolean _isTerminated() {
        return this._isTerminated;
    }

    public LoggingAdapter akka$cluster$Cluster$$log() {
        return this.akka$cluster$Cluster$$log;
    }

    private Option<ClusterJmx> clusterJmx() {
        return this.clusterJmx;
    }

    private void clusterJmx_$eq(Option<ClusterJmx> x$1) {
        this.clusterJmx = x$1;
    }

    public FailureDetectorRegistry<Address> failureDetector() {
        return this.failureDetector;
    }

    public DowningProvider downingProvider() {
        return this.bitmap$0 ? this.downingProvider : this.downingProvider$lzycompute();
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    private ActorRef clusterDaemons() {
        return this.clusterDaemons;
    }

    public ActorRef clusterCore() {
        return this.clusterCore;
    }

    public ClusterReadView readView() {
        return this.readView;
    }

    public boolean isTerminated() {
        return this._isTerminated().get();
    }

    public ClusterEvent.CurrentClusterState state() {
        return this.readView().state();
    }

    public void subscribe(ActorRef subscriber, Seq<Class<?>> to) {
        this.subscribe(subscriber, (ClusterEvent.SubscriptionInitialStateMode)ClusterEvent$InitialStateAsSnapshot$.MODULE$, to);
    }

    public void subscribe(ActorRef subscriber, ClusterEvent.SubscriptionInitialStateMode initialStateMode, Seq<Class<?>> to) {
        Predef$.MODULE$.require(to.length() > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "at least one `ClusterDomainEvent` class is required";
            }
        });
        Predef$.MODULE$.require(to.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Class<?> x$1) {
                return ClusterEvent.ClusterDomainEvent.class.isAssignableFrom(x$1);
            }
        }), (Function0)new Serializable(this, to){
            public static final long serialVersionUID = 0L;
            private final Seq to$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"subscribe to `akka.cluster.ClusterEvent.ClusterDomainEvent` or subclasses, was [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.to$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Class<?> x$1) {
                        return x$1.getName();
                    }
                }, scala.collection.Seq$.MODULE$.canBuildFrom())).mkString(", ")}));
            }
            {
                this.to$1 = to$1;
            }
        });
        ScalaActorRef qual$2 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.Subscribe x$6 = new InternalClusterAction.Subscribe(subscriber, initialStateMode, to.toSet());
        ActorRef x$7 = qual$2.$bang$default$2((Object)x$6);
        qual$2.$bang((Object)x$6, x$7);
    }

    public void unsubscribe(ActorRef subscriber) {
        ScalaActorRef qual$3 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.Unsubscribe x$8 = new InternalClusterAction.Unsubscribe(subscriber, (Option<Class<?>>)None$.MODULE$);
        ActorRef x$9 = qual$3.$bang$default$2((Object)x$8);
        qual$3.$bang((Object)x$8, x$9);
    }

    public void unsubscribe(ActorRef subscriber, Class<?> to) {
        ScalaActorRef qual$4 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.Unsubscribe x$10 = new InternalClusterAction.Unsubscribe(subscriber, (Option<Class<?>>)new Some(to));
        ActorRef x$11 = qual$4.$bang$default$2((Object)x$10);
        qual$4.$bang((Object)x$10, x$11);
    }

    public void sendCurrentClusterState(ActorRef receiver) {
        ScalaActorRef qual$5 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.SendCurrentClusterState x$12 = new InternalClusterAction.SendCurrentClusterState(receiver);
        ActorRef x$13 = qual$5.$bang$default$2((Object)x$12);
        qual$5.$bang((Object)x$12, x$13);
    }

    public void join(Address address) {
        ScalaActorRef qual$6 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        ClusterUserAction.JoinTo x$14 = new ClusterUserAction.JoinTo(this.akka$cluster$Cluster$$fillLocal(address));
        ActorRef x$15 = qual$6.$bang$default$2((Object)x$14);
        qual$6.$bang((Object)x$14, x$15);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Address akka$cluster$Cluster$$fillLocal(Address address) {
        Address address2;
        if (address.hasLocalScope()) {
            String string = address.system();
            String string2 = this.selfAddress().system();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                address2 = this.selfAddress();
                return address2;
            }
        }
        address2 = address;
        return address2;
    }

    public void joinSeedNodes(scala.collection.immutable.Seq<Address> seedNodes) {
        ScalaActorRef qual$7 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.JoinSeedNodes x$16 = new InternalClusterAction.JoinSeedNodes((IndexedSeq<Address>)((IndexedSeq)seedNodes.toVector().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cluster $outer;

            public final Address apply(Address address) {
                return this.$outer.akka$cluster$Cluster$$fillLocal(address);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Vector$.MODULE$.canBuildFrom())));
        ActorRef x$17 = qual$7.$bang$default$2((Object)x$16);
        qual$7.$bang((Object)x$16, x$17);
    }

    public void joinSeedNodes(List<Address> seedNodes) {
        this.joinSeedNodes((scala.collection.immutable.Seq<Address>)Util$.MODULE$.immutableSeq(seedNodes));
    }

    public void leave(Address address) {
        ScalaActorRef qual$8 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        ClusterUserAction.Leave x$18 = new ClusterUserAction.Leave(this.akka$cluster$Cluster$$fillLocal(address));
        ActorRef x$19 = qual$8.$bang$default$2((Object)x$18);
        qual$8.$bang((Object)x$18, x$19);
    }

    public void down(Address address) {
        ScalaActorRef qual$9 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        ClusterUserAction.Down x$20 = new ClusterUserAction.Down(this.akka$cluster$Cluster$$fillLocal(address));
        ActorRef x$21 = qual$9.$bang$default$2((Object)x$20);
        qual$9.$bang((Object)x$20, x$21);
    }

    public <T> void registerOnMemberUp(Function0<T> code) {
        this.registerOnMemberUp(new Runnable(this, code){
            private final Function0 code$1;

            public void run() {
                this.code$1.apply();
            }
            {
                this.code$1 = code$1;
            }
        });
    }

    public void registerOnMemberUp(Runnable callback) {
        ScalaActorRef qual$10 = package$.MODULE$.actorRef2Scala(this.clusterDaemons());
        InternalClusterAction.AddOnMemberUpListener x$22 = new InternalClusterAction.AddOnMemberUpListener(callback);
        ActorRef x$23 = qual$10.$bang$default$2((Object)x$22);
        qual$10.$bang((Object)x$22, x$23);
    }

    public <T> void registerOnMemberRemoved(Function0<T> code) {
        this.registerOnMemberRemoved(new Runnable(this, code){
            private final Function0 code$2;

            public void run() {
                this.code$2.apply();
            }
            {
                this.code$2 = code$2;
            }
        });
    }

    public void registerOnMemberRemoved(Runnable callback) {
        if (this._isTerminated().get()) {
            callback.run();
        } else {
            ScalaActorRef qual$11 = package$.MODULE$.actorRef2Scala(this.clusterDaemons());
            InternalClusterAction.AddOnMemberRemovedListener x$24 = new InternalClusterAction.AddOnMemberRemovedListener(callback);
            ActorRef x$25 = qual$11.$bang$default$2((Object)x$24);
            qual$11.$bang((Object)x$24, x$25);
        }
    }

    public ActorPath remotePathOf(ActorRef actorRef) {
        ActorPath actorPath;
        ActorPath path = actorRef.path();
        if (path.address().host().isDefined()) {
            actorPath = path;
        } else {
            RootActorPath qual$12 = path.root();
            Address x$26 = this.selfAddress();
            String x$27 = qual$12.copy$default$2();
            actorPath = qual$12.copy(x$26, x$27).$div((Iterable)path.elements()).withUid(path.uid());
        }
        return actorPath;
    }

    public void shutdown() {
        if (this._isTerminated().compareAndSet(false, true)) {
            this.InfoLogger().logInfo("Shutting down...");
            this.system().stop(this.clusterDaemons());
            if (this.readView() != null) {
                this.readView().close();
            }
            this.closeScheduler();
            this.clusterJmx().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ClusterJmx x$2) {
                    x$2.unregisterMBean();
                }
            });
            this.InfoLogger().logInfo("Successfully shut down");
        }
    }

    private void closeScheduler() {
        Scheduler scheduler = this.scheduler();
        if (scheduler instanceof Closeable) {
            Scheduler scheduler2 = scheduler;
            ((Closeable)scheduler2).close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Cluster$InfoLogger$ InfoLogger() {
        return this.InfoLogger$module == null ? this.InfoLogger$lzycompute() : this.InfoLogger$module;
    }

    public final FailureDetector akka$cluster$Cluster$$createFailureDetector$1() {
        return FailureDetectorLoader$.MODULE$.load(this.settings().FailureDetectorImplementationClass(), this.settings().FailureDetectorConfig(), (ActorSystem)this.system());
    }

    private final ActorRef liftedTree1$1(Timeout timeout$1) {
        ActorRef actorRef;
        try {
            ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.clusterDaemons());
            InternalClusterAction$GetClusterCoreRef$ x$3 = InternalClusterAction$GetClusterCoreRef$.MODULE$;
            Timeout x$4 = timeout$1;
            ActorRef x$5 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$3);
            actorRef = (ActorRef)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$3, x$4, x$5).mapTo(ClassTag$.MODULE$.apply(ActorRef.class)), (Duration)timeout$1.duration());
        }
        catch (Throwable throwable) {
            ActorRef actorRef2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.akka$cluster$Cluster$$log().error(e, "Failed to startup Cluster. You can try to increase 'akka.actor.creation-timeout'.");
            this.shutdown();
            actorRef = actorRef2 = this.system().deadLetters();
        }
        return actorRef;
    }

    public Cluster(ExtendedActorSystem system) {
        this.system = system;
        this.settings = new ClusterSettings(system.settings().config(), system.name());
        ActorRefProvider actorRefProvider = system.provider();
        if (actorRefProvider instanceof ClusterActorRefProvider) {
            Scheduler scheduler;
            UniqueAddress uniqueAddress;
            ClusterActorRefProvider clusterActorRefProvider = (ClusterActorRefProvider)actorRefProvider;
            this.selfUniqueAddress = uniqueAddress = new UniqueAddress(clusterActorRefProvider.transport().defaultAddress(), ((AddressUidExtension)AddressUidExtension$.MODULE$.apply((ActorSystem)system)).longAddressUid());
            this._isTerminated = new AtomicBoolean(false);
            this.akka$cluster$Cluster$$log = Logging$.MODULE$.apply((ActorSystem)system, (Object)this.getClass().getName(), LogSource$.MODULE$.fromString());
            this.clusterJmx = None$.MODULE$;
            this.InfoLogger().logInfo("Starting up...");
            this.failureDetector = new DefaultFailureDetectorRegistry((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cluster $outer;

                public final FailureDetector apply() {
                    return this.$outer.akka$cluster$Cluster$$createFailureDetector$1();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            package.DurationInt durationInt = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1));
            if (system.scheduler().maxFrequency() < durationInt.second().$div((Duration)this.settings().SchedulerTickDuration())) {
                ThreadFactory threadFactory;
                this.InfoLogger().logInfo("Using a dedicated scheduler for cluster. Default scheduler can be used if configured with 'akka.scheduler.tick-duration' [{} ms] <=  'akka.cluster.scheduler.tick-duration' [{} ms].", BoxesRunTime.boxToInteger((int)((int)((double)1000 / system.scheduler().maxFrequency()))), BoxesRunTime.boxToLong((long)this.settings().SchedulerTickDuration().toMillis()));
                Config cfg = ConfigFactory.parseString((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"akka.scheduler.tick-duration=", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.settings().SchedulerTickDuration().toMillis())}))).withFallback((ConfigMergeable)system.settings().config());
                ThreadFactory threadFactory2 = system.threadFactory();
                if (threadFactory2 instanceof MonitorableThreadFactory) {
                    MonitorableThreadFactory monitorableThreadFactory = (MonitorableThreadFactory)threadFactory2;
                    threadFactory = monitorableThreadFactory.withName(new StringBuilder().append((Object)monitorableThreadFactory.name()).append((Object)"-cluster-scheduler").toString());
                } else {
                    threadFactory = threadFactory2;
                }
                ThreadFactory threadFactory3 = threadFactory;
                scheduler = (Scheduler)system.dynamicAccess().createInstanceFor(system.settings().SchedulerClass(), (scala.collection.immutable.Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(Config.class), (Object)cfg), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(LoggingAdapter.class), (Object)this.akka$cluster$Cluster$$log()), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(ThreadFactory.class), (Object)threadFactory3)})), ClassTag$.MODULE$.apply(Scheduler.class)).get();
            } else {
                Scheduler systemScheduler = system.scheduler();
                scheduler = new Scheduler(this, systemScheduler){
                    private final Scheduler systemScheduler$1;

                    public final Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                        return Scheduler.class.schedule((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                    }

                    public final Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, Function0<BoxedUnit> f, ExecutionContext executor) {
                        return Scheduler.class.schedule((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, f, (ExecutionContext)executor);
                    }

                    public final Cancellable scheduleOnce(FiniteDuration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                        return Scheduler.class.scheduleOnce((Scheduler)this, (FiniteDuration)delay, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                    }

                    public final Cancellable scheduleOnce(FiniteDuration delay, Function0<BoxedUnit> f, ExecutionContext executor) {
                        return Scheduler.class.scheduleOnce((Scheduler)this, (FiniteDuration)delay, f, (ExecutionContext)executor);
                    }

                    public final ActorRef schedule$default$6(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message) {
                        return Scheduler.class.schedule$default$6((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, (ActorRef)receiver, (Object)message);
                    }

                    public final ActorRef scheduleOnce$default$5(FiniteDuration delay, ActorRef receiver, Object message) {
                        return Scheduler.class.scheduleOnce$default$5((Scheduler)this, (FiniteDuration)delay, (ActorRef)receiver, (Object)message);
                    }

                    public void close() {
                    }

                    public double maxFrequency() {
                        return this.systemScheduler$1.maxFrequency();
                    }

                    public Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, Runnable runnable, ExecutionContext executor) {
                        return this.systemScheduler$1.schedule(initialDelay, interval, runnable, executor);
                    }

                    public Cancellable scheduleOnce(FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
                        return this.systemScheduler$1.scheduleOnce(delay, runnable, executor);
                    }
                    {
                        this.systemScheduler$1 = systemScheduler$1;
                        Scheduler.class.$init$((Scheduler)this);
                    }
                };
            }
            this.scheduler = scheduler;
            this.clusterDaemons = system.systemActorOf(Props$.MODULE$.apply(ClusterDaemon.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.settings()})).withDispatcher(this.settings().UseDispatcher()).withDeploy(Deploy$.MODULE$.local()), "cluster");
            Timeout timeout = system.settings().CreationTimeout();
            this.clusterCore = this.liftedTree1$1(timeout);
            this.readView = new ClusterReadView(this);
            system.registerOnTermination((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cluster $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.shutdown();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            if (this.settings().JmxEnabled()) {
                ClusterJmx jmx = new ClusterJmx(this, this.akka$cluster$Cluster$$log());
                jmx.createMBean();
                this.clusterJmx_$eq((Option<ClusterJmx>)new Some((Object)jmx));
            }
            this.InfoLogger().logInfo("Started up successfully");
            return;
        }
        throw new ConfigurationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ActorSystem [", "] needs to have a 'ClusterActorRefProvider' enabled in the configuration, currently uses [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{system, actorRefProvider.getClass().getName()})));
    }
}

