/*
 * Decompiled with CFR 0.152.
 */
package scalax.io;

import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.CharsetEncoder;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Range$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scalax.io.CloseAction;
import scalax.io.CloseAction$;
import scalax.io.CloseAction$Noop$;
import scalax.io.CloseAction$class;
import scalax.io.Codec;
import scalax.io.Codec$;
import scalax.io.Input;
import scalax.io.InputResource;
import scalax.io.LongTraversable;
import scalax.io.OpenOption;
import scalax.io.OpenedResource;
import scalax.io.Output;
import scalax.io.OutputConverter;
import scalax.io.OutputConverter$;
import scalax.io.OutputConverter$ByteArrayConverter$;
import scalax.io.OutputConverter$TraversableByteConverter$;
import scalax.io.OutputConverter$TraversableIntAsByteConverter$;
import scalax.io.OutputResource;
import scalax.io.Overwrite;
import scalax.io.OverwriteAll$;
import scalax.io.OverwriteSome;
import scalax.io.Resource$;
import scalax.io.Seekable;
import scalax.io.Seekable$;
import scalax.io.SeekableByteChannel;
import scalax.io.TraversableOnceOps$;
import scalax.io.managed.ByteChannelResource;
import scalax.io.managed.SeekableByteChannelResource;
import scalax.io.managed.WritableByteChannelResource;
import scalax.io.managed.WritableByteChannelResource$;
import scalax.io.processing.SeekableProcessor;

public abstract class Seekable$class {
    /*
     * WARNING - void declaration
     */
    public static Object readWriteChannel(Seekable $this, Function1 f) {
        Object object;
        OpenedResource<SeekableByteChannel> resource = $this.underlyingChannel(false);
        try {
            object = f.apply((Object)resource.get());
            resource.close();
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static Object appendChannel(Seekable $this, Function1 f) {
        Object object;
        OpenedResource<SeekableByteChannel> resource = $this.underlyingChannel(true);
        try {
            object = f.apply((Object)resource.get());
            resource.close();
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        return object;
    }

    public static SeekableProcessor seekableProcessor(Seekable $this) {
        return new SeekableProcessor((Function0<OpenedResource<SeekableByteChannel>>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Seekable $outer;

            public final OpenedResource<SeekableByteChannel> apply() {
                return this.$outer.underlyingChannel(false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, $this.context());
    }

    public static void patch(Seekable $this, long position2, String string2, Overwrite overwrite, Codec codec) {
        block12: {
            block9: {
                long l;
                block11: {
                    block10: {
                        block8: {
                            long l2;
                            boolean bl = position2 >= 0L;
                            Predef$ predef$ = Predef$.MODULE$;
                            if (!bl) {
                                throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)"The patch starting position must be greater than or equal 0").toString());
                            }
                            Serializable serializable = new Serializable($this, position2){
                                public static final long serialVersionUID = 0L;
                                public final long position$4;

                                public final boolean apply(long x$1) {
                                    return this.apply$mcZJ$sp(x$1);
                                }

                                public boolean apply$mcZJ$sp(long x$1) {
                                    return this.position$4 >= x$1;
                                }
                                {
                                    this.position$4 = position$4;
                                }
                            };
                            Option<Object> option = $this.size();
                            if (!(option.isEmpty() || serializable.position$4 >= (l2 = BoxesRunTime.unboxToLong((Object)option.get()))) && !codec.hasConstantSize()) break block8;
                            OutputConverter$ outputConverter$ = OutputConverter$.MODULE$;
                            $this.patch(position2, Predef$.MODULE$.wrapString(string2), overwrite, new OutputConverter.TraversableCharConverter(codec));
                            break block9;
                        }
                        if (!OverwriteAll$.MODULE$.equals(overwrite)) break block10;
                        l = Long.MIN_VALUE;
                        break block11;
                    }
                    if (!(overwrite instanceof OverwriteSome)) break block12;
                    OverwriteSome overwriteSome = (OverwriteSome)overwrite;
                    l = overwriteSome.replacementLength();
                }
                byte[] bytes2 = string2.getBytes(codec.name());
                long posInBytes = Seekable$class.charCountToByteCount($this, 0L, position2, codec);
                if (overwrite.exists((Function1<Object, Object>)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(long x$2) {
                        return this.apply$mcZJ$sp(x$2);
                    }

                    public boolean apply$mcZJ$sp(long x$2) {
                        return x$2 < 0L;
                    }
                })) {
                    $this.insert(posInBytes, bytes2, OutputConverter$ByteArrayConverter$.MODULE$);
                } else {
                    long l3;
                    Overwrite overwrite2 = overwrite;
                    OverwriteAll$ overwriteAll$ = OverwriteAll$.MODULE$;
                    if (overwrite2 != null && overwrite2.equals(overwriteAll$)) {
                        Predef$ predef$ = Predef$.MODULE$;
                        l3 = new StringOps(string2).size();
                    } else {
                        l3 = l;
                    }
                    long replacedInBytes = Seekable$class.charCountToByteCount($this, position2, position2 + l3, codec);
                    Predef$ predef$ = Predef$.MODULE$;
                    $this.patch(posInBytes, bytes2, (Overwrite)new OverwriteSome(package$.MODULE$.max(l, replacedInBytes)), OutputConverter$ByteArrayConverter$.MODULE$);
                }
            }
            return;
        }
        throw new MatchError((Object)overwrite);
    }

    public static void patch(Seekable $this, long position2, Object data, Overwrite overwrite, OutputConverter converter) {
        boolean insertData;
        long l;
        boolean bl = position2 >= 0L;
        Predef$ predef$ = Predef$.MODULE$;
        if (!bl) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)"The patch starting position must be greater than or equal 0").toString());
        }
        TraversableOnce<Object> bytes2 = converter.toBytes(data);
        long actualPosition = (long)converter.sizeInBytes() * position2;
        boolean bl2 = actualPosition >= 0L;
        Predef$ predef$2 = Predef$.MODULE$;
        if (!bl2) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)"The patch starting position must be greater than or equal 0").toString());
        }
        long replaced = overwrite.getOrElse((Function0<Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return Long.MIN_VALUE;
            }

            public long apply$mcJ$sp() {
                return Long.MIN_VALUE;
            }
        });
        Serializable serializable = new Serializable($this, actualPosition){
            public static final long serialVersionUID = 0L;
            public final long actualPosition$1;

            public final boolean apply(long x$3) {
                return this.apply$mcZJ$sp(x$3);
            }

            public boolean apply$mcZJ$sp(long x$3) {
                return this.actualPosition$1 >= x$3;
            }
            {
                this.actualPosition$1 = actualPosition$1;
            }
        };
        Option<Object> option = $this.size();
        boolean appendData = option.isEmpty() || serializable.actualPosition$1 >= (l = BoxesRunTime.unboxToLong((Object)option.get()));
        boolean bl3 = insertData = replaced <= 0L && replaced != Long.MIN_VALUE;
        if (appendData) {
            $this.append(bytes2, OutputConverter$TraversableByteConverter$.MODULE$);
        } else if (insertData) {
            $this.insert(actualPosition, bytes2, OutputConverter$TraversableByteConverter$.MODULE$);
        } else {
            Seekable$class.overwriteFileData($this, actualPosition, bytes2, replaced);
        }
    }

    public static Codec patch$default$4(Seekable $this, long position2, String string2, Overwrite overwrite) {
        return Codec$.MODULE$.default();
    }

    public static void patchIntsAsBytes(Seekable $this, long position2, Overwrite overwrite, Seq data) {
        $this.patch(position2, data, overwrite, OutputConverter$TraversableIntAsByteConverter$.MODULE$);
    }

    public static void insert(Seekable $this, long position2, String string2, Codec codec) {
        $this.insert(position2, codec.encode(string2), OutputConverter$ByteArrayConverter$.MODULE$);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Object insert(Seekable $this, long position2, Object data, OutputConverter converter) {
        Object object;
        TraversableOnce<Object> bytes2 = converter.toBytes(data);
        if (position2 > -1L) {
            Serializable serializable = new Serializable($this, position2){
                public static final long serialVersionUID = 0L;
                public final long position$5;

                public final boolean apply(long x$4) {
                    return this.apply$mcZJ$sp(x$4);
                }

                public boolean apply$mcZJ$sp(long x$4) {
                    return x$4 <= this.position$5;
                }
                {
                    this.position$5 = position$5;
                }
            };
            Option<Object> option = $this.size();
            if (option.isEmpty() || BoxesRunTime.unboxToLong((Object)option.get()) <= serializable.position$5) {
                $this.append(bytes2, OutputConverter$TraversableByteConverter$.MODULE$);
                object = BoxedUnit.UNIT;
                return object;
            }
        }
        if (bytes2.hasDefiniteSize() && bytes2.size() <= 0xA00000) {
            Predef$ predef$ = Predef$.MODULE$;
            object = BoxesRunTime.boxToInteger((int)Seekable$class.insertDataInMemory($this, package$.MODULE$.max(position2, 0L), bytes2));
            return object;
        }
        Predef$ predef$ = Predef$.MODULE$;
        object = Seekable$class.insertDataTmpFile($this, package$.MODULE$.max(position2, 0L), bytes2);
        return object;
    }

    public static Codec insert$default$3(Seekable $this, long position2, String string2) {
        return Codec$.MODULE$.default();
    }

    public static Object insertIntsAsBytes(Seekable $this, long position2, Seq data) {
        return $this.insert(position2, data, OutputConverter$TraversableIntAsByteConverter$.MODULE$);
    }

    public static void append(Seekable $this, Object data, OutputConverter converter) {
        TraversableOnce<Object> bytes2 = converter.toBytes(data);
        $this.appendChannel(new Serializable($this, bytes2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Seekable $outer;
            private final TraversableOnce bytes$4;

            public final Tuple2<Object, Object> apply(SeekableByteChannel x$5) {
                return Seekable$class.scalax$io$Seekable$$writeTo(this.$outer, x$5, this.bytes$4, -1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bytes$4 = bytes$4;
            }
        });
    }

    public static void appendIntsAsBytes(Seekable $this, Seq data) {
        $this.append(data, OutputConverter$TraversableIntAsByteConverter$.MODULE$);
    }

    public static void append(Seekable $this, String string2, Codec codec) {
        $this.append(codec.encode(string2), OutputConverter$ByteArrayConverter$.MODULE$);
    }

    public static Codec append$default$2(Seekable $this, String string2) {
        return Codec$.MODULE$.default();
    }

    public static void appendStrings(Seekable $this, Traversable strings, String separator, Codec codec) {
        byte[] sepBytes = codec.encode(separator);
        $this.appendChannel(new Serializable($this, sepBytes, strings, codec){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ Seekable $outer;
            public final byte[] sepBytes$1;
            private final Traversable strings$1;
            public final Codec codec$2;

            public final boolean apply(SeekableByteChannel channel) {
                return BoxesRunTime.unboxToBoolean((Object)this.strings$1.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2)new Serializable(this, channel){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Seekable$.anonfun.appendStrings.1 $outer;
                    private final SeekableByteChannel channel$2;

                    public final boolean apply(boolean addSep, String string2) {
                        Object object = addSep ? Seekable$class.scalax$io$Seekable$$writeTo(this.$outer.$outer, this.channel$2, (TraversableOnce)Predef$.MODULE$.byteArrayOps(this.$outer.sepBytes$1), Long.MAX_VALUE) : BoxedUnit.UNIT;
                        Seekable$class.scalax$io$Seekable$$writeTo(this.$outer.$outer, this.channel$2, (TraversableOnce)Predef$.MODULE$.byteArrayOps(this.$outer.codec$2.encode(string2)), Long.MAX_VALUE);
                        return true;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.channel$2 = channel$2;
                    }
                }));
            }

            public /* synthetic */ Seekable scalax$io$Seekable$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sepBytes$1 = sepBytes$1;
                this.strings$1 = strings$1;
                this.codec$2 = codec$2;
            }
        });
    }

    public static String appendStrings$default$2(Seekable $this) {
        return "";
    }

    public static Codec appendStrings$default$3(Seekable $this, Traversable strings, String separator) {
        return Codec$.MODULE$.default();
    }

    public static void truncate(Seekable $this, long position2) {
        $this.readWriteChannel(new Serializable($this, position2){
            public static final long serialVersionUID = 0L;
            private final long position$6;

            public final SeekableByteChannel apply(SeekableByteChannel x$6) {
                return x$6.truncate(this.position$6);
            }
            {
                this.position$6 = position$6;
            }
        });
    }

    public static void truncateString(Seekable $this, long position2, Codec codec) {
        long posInBytes = Seekable$class.charCountToByteCount($this, 0L, position2, codec);
        $this.appendChannel(new Serializable($this, posInBytes){
            public static final long serialVersionUID = 0L;
            private final long posInBytes$1;

            public final SeekableByteChannel apply(SeekableByteChannel x$7) {
                return x$7.truncate(this.posInBytes$1);
            }
            {
                this.posInBytes$1 = posInBytes$1;
            }
        });
    }

    public static Codec truncateString$default$2(Seekable $this, long position2) {
        return Codec$.MODULE$.default();
    }

    private static int insertDataInMemory(Seekable $this, long position2, TraversableOnce bytes2) {
        return BoxesRunTime.unboxToInt($this.readWriteChannel(new Serializable($this, position2, bytes2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Seekable $outer;
            private final long position$1;
            private final TraversableOnce bytes$1;

            public final int apply(SeekableByteChannel channel) {
                channel.position(this.position$1);
                long l = channel.size() - this.position$1;
                Predef$ predef$ = Predef$.MODULE$;
                int dataToMove = (int)RichLong$.MODULE$.min$extension(l, 0xA00000L);
                Tuple2 buffers = new Tuple2((Object)ByteBuffer.allocateDirect(dataToMove), (Object)ByteBuffer.allocateDirect(dataToMove));
                channel.read((ByteBuffer)buffers._1());
                ((Buffer)buffers._1()).flip();
                buffers = buffers.swap();
                channel.position(this.position$1);
                Seekable$class.scalax$io$Seekable$$writeTo(this.$outer, channel, this.bytes$1, this.bytes$1.size());
                while (channel.position() < channel.size() - (long)((Buffer)buffers._2()).remaining()) {
                    channel.read((ByteBuffer)buffers._1());
                    ((Buffer)buffers._1()).flip();
                    channel.write((ByteBuffer)buffers._2(), channel.position() - (long)this.bytes$1.size());
                    buffers = buffers.swap();
                }
                return channel.write((ByteBuffer)buffers._2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.position$1 = position$1;
                this.bytes$1 = bytes$1;
            }
        }));
    }

    public static Input tempFile(Seekable $this) {
        File file = File.createTempFile("SeekableCache", "tmp");
        return Resource$.MODULE$.fromFile(file);
    }

    private static Tuple2 insertDataTmpFile(Seekable $this, long position2, TraversableOnce insertBytes) {
        Input tmp = $this.tempFile();
        ((Output)((Object)tmp)).write($this.bytes().ldrop(position2), OutputConverter$TraversableByteConverter$.MODULE$);
        return (Tuple2)$this.readWriteChannel(new Serializable($this, position2, insertBytes, tmp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Seekable $outer;
            private final long position$2;
            private final TraversableOnce insertBytes$1;
            private final Input tmp$1;

            public final Tuple2<Object, Object> apply(SeekableByteChannel channel) {
                channel.position(this.position$2);
                Seekable$class.scalax$io$Seekable$$writeTo(this.$outer, channel, this.insertBytes$1, -1L);
                return Seekable$class.scalax$io$Seekable$$writeTo(this.$outer, channel, this.tmp$1.bytes(), BoxesRunTime.unboxToLong((Object)this.tmp$1.size().get()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.position$2 = position$2;
                this.insertBytes$1 = insertBytes$1;
                this.tmp$1 = tmp$1;
            }
        });
    }

    private static Object overwriteFileData(Seekable $this, long position2, TraversableOnce bytes2, long replaced) {
        return $this.readWriteChannel(new Serializable($this, position2, bytes2, replaced){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Seekable $outer;
            private final long position$3;
            private final TraversableOnce bytes$3;
            private final long replaced$1;

            public final Object apply(SeekableByteChannel channel) {
                channel.position(this.position$3);
                Tuple2 tuple2 = Seekable$class.scalax$io$Seekable$$writeTo(this.$outer, channel, this.bytes$3, this.replaced$1);
                if (tuple2 != null) {
                    Object object;
                    Tuple2.mcJZ.sp sp2 = new Tuple2.mcJZ.sp(tuple2._1$mcJ$sp(), tuple2._2$mcZ$sp());
                    long wrote = sp2._1$mcJ$sp();
                    boolean earlyTermination = sp2._2$mcZ$sp();
                    if (this.replaced$1 > channel.size() || this.position$3 + this.replaced$1 > channel.size()) {
                        object = channel.truncate(channel.position());
                    } else if (this.replaced$1 > wrote) {
                        long length = channel.size() - this.position$3 - this.replaced$1;
                        long srcIndex = this.position$3 + this.replaced$1;
                        long destIndex = this.position$3 + wrote;
                        Seekable$class.scalax$io$Seekable$$copySlice(this.$outer, channel, srcIndex, destIndex, (int)length);
                        object = channel.truncate(destIndex + length);
                    } else if (earlyTermination) {
                        Object object2;
                        long adjustedPosition = this.position$3 + this.replaced$1;
                        TraversableOnce traversableOnce = this.bytes$3;
                        if (traversableOnce instanceof LongTraversable) {
                            LongTraversable longTraversable = (LongTraversable)traversableOnce;
                            object2 = this.$outer.insert(adjustedPosition, longTraversable.ldrop(wrote), OutputConverter$TraversableByteConverter$.MODULE$);
                        } else if (traversableOnce instanceof Traversable) {
                            Traversable traversable = (Traversable)traversableOnce;
                            object2 = this.$outer.insert(adjustedPosition, traversable.drop((int)wrote), OutputConverter$TraversableByteConverter$.MODULE$);
                        } else {
                            object2 = traversableOnce instanceof Iterator ? this.$outer.insert(adjustedPosition, this.bytes$3, OutputConverter$TraversableByteConverter$.MODULE$) : this.$outer.insert(adjustedPosition, TraversableOnceOps$.MODULE$.drop(this.bytes$3, (int)wrote), OutputConverter$TraversableByteConverter$.MODULE$);
                        }
                        object = object2;
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    return object;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.position$3 = position$3;
                this.bytes$3 = bytes$3;
                this.replaced$1 = replaced$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void scalax$io$Seekable$$copySlice(Seekable $this, SeekableByteChannel channel, long srcIndex, long destIndex, int length) {
        ByteBuffer buf = $this.context().createNioBuffer((Option<Object>)None$.MODULE$, (Option<Channel>)new Some((Object)channel), false);
        Predef$ predef$ = Predef$.MODULE$;
        Range range = Range$.MODULE$.inclusive(0, length).by(buf.capacity());
        range.scala$collection$immutable$Range$$validateMaxLength();
        boolean bl = range.start() != Integer.MIN_VALUE || range.end() != Integer.MIN_VALUE;
        int n = range.start();
        int n2 = 0;
        int n3 = range.terminalElement();
        int n4 = range.step();
        while (!bl ? n2 < range.numRangeElements() : n != n3) {
            void var11_5;
            Seekable$class.write$1($this, n, channel, srcIndex, destIndex, length, (ByteBuffer)var11_5);
            ++n2;
            n += n4;
        }
        return;
    }

    public static Tuple2 scalax$io$Seekable$$writeTo(Seekable $this, WritableByteChannel c, TraversableOnce bytes2, long length) {
        Tuple2 tuple2;
        if (bytes2 instanceof WrappedArray) {
            WrappedArray wrappedArray = (WrappedArray)bytes2;
            tuple2 = Seekable$class.writeArray$1($this, (byte[])wrappedArray.array(), c, bytes2, length);
        } else if (bytes2 instanceof ArrayOps) {
            ArrayOps arrayOps = (ArrayOps)bytes2;
            tuple2 = Seekable$class.writeArray$1($this, (byte[])arrayOps.toArray(ClassTag$.MODULE$.Byte()), c, bytes2, length);
        } else {
            ByteBuffer buf = $this.context().createNioBuffer((Option<Object>)(length < 0L ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)length))), (Option<Channel>)new Some((Object)c), false);
            BooleanRef earlyTermination = BooleanRef.create((boolean)false);
            tuple2 = new Tuple2.mcJZ.sp(Seekable$class.write$2($this, 0L, bytes2, 0L, c, length, buf, earlyTermination), earlyTermination.elem);
        }
        return tuple2;
    }

    public static OutputResource underlyingOutput(Seekable $this) {
        OpenedResource<SeekableByteChannel> resource = $this.underlyingChannel(false);
        return new WritableByteChannelResource<Object>((Function0<Object>)new Serializable($this, resource){
            public static final long serialVersionUID = 0L;
            private final OpenedResource resource$2;

            public final SeekableByteChannel apply() {
                return (SeekableByteChannel)this.resource$2.get();
            }
            {
                this.resource$2 = resource$2;
            }
        }, resource.context(), WritableByteChannelResource$.MODULE$.$lessinit$greater$default$3());
    }

    public static InputResource toByteChannelResource(Seekable $this) {
        return new ByteChannelResource<Object>((Function0<Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Seekable $outer;

            public final ByteChannel apply() {
                return Seekable$class.opened$1(this.$outer);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, $this.context(), CloseAction$Noop$.MODULE$, (Function0<Option<Object>>)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final None$ apply() {
                return None$.MODULE$;
            }
        });
    }

    public static LongTraversable chars(Seekable $this, Codec codec) {
        return $this.toByteChannelResource().chars(codec);
    }

    public static LongTraversable bytesAsInts(Seekable $this) {
        return $this.toByteChannelResource().bytesAsInts();
    }

    public static LongTraversable bytes(Seekable $this) {
        return $this.toByteChannelResource().bytes();
    }

    public static LongTraversable blocks(Seekable $this, Option blockSize) {
        return $this.toByteChannelResource().blocks(blockSize);
    }

    public static Option blocks$default$1(Seekable $this) {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private static long charCountToByteCount(Seekable $this, long start, long end2, Codec codec) {
        long l;
        CharsetEncoder encoder2 = codec.encoder();
        CharBuffer charBuffer = CharBuffer.allocate(1);
        OpenedResource<SeekableByteChannel> resource = $this.underlyingChannel(false);
        try {
            Serializable serializable = new Serializable($this, resource){
                public static final long serialVersionUID = 0L;
                private final OpenedResource resource$1;

                public final void apply(Object x$11) {
                    this.resource$1.close();
                }
                {
                    this.resource$1 = resource$1;
                }
            };
            CloseAction$ closeAction$ = CloseAction$.MODULE$;
            LongTraversable<Object> chars2 = new SeekableByteChannelResource(new Serializable($this, resource){
                public static final long serialVersionUID = 0L;
                private final OpenedResource resource$1;

                public final SeekableByteChannel apply(Seq<OpenOption> x$10) {
                    return (SeekableByteChannel)this.resource$1.get();
                }
                {
                    this.resource$1 = resource$1;
                }
            }, resource.context(), new CloseAction<A>((Function1)serializable){
                private final Function1 f$1;

                public <B extends A> CloseAction<B> $plus$colon(CloseAction<B> other) {
                    return CloseAction$class.$plus$colon(this, other);
                }

                public <B extends A> CloseAction<B> $colon$plus(CloseAction<B> other) {
                    return CloseAction$class.$colon$plus(this, other);
                }

                public List<Throwable> apply(A resource) {
                    return CloseAction$class.apply(this, resource);
                }

                public Nil$ closeImpl(A a) {
                    this.f$1.apply(a);
                    return Nil$.MODULE$;
                }
                {
                    this.f$1 = f$1;
                    CloseAction$class.$init$(this);
                }
            }, (Function0<Option<Object>>)new Serializable($this, resource){
                public static final long serialVersionUID = 0L;
                private final OpenedResource resource$1;

                public final Some<Object> apply() {
                    return new Some((Object)BoxesRunTime.boxToLong((long)((SeekableByteChannel)this.resource$1.get()).size()));
                }
                {
                    this.resource$1 = resource$1;
                }
            }, (Option<Seq<OpenOption>>)None$.MODULE$).chars(codec);
            LongTraversable segment = (LongTraversable)chars2.lslice(start, end2);
            l = BoxesRunTime.unboxToLong((Object)segment.$div$colon(BoxesRunTime.boxToLong((long)0L), (Function2)new Serializable($this, codec, encoder2, charBuffer){
                public static final long serialVersionUID = 0L;
                private final Codec codec$1;
                private final CharsetEncoder encoder$1;
                private final CharBuffer charBuffer$1;

                public final long apply(long replacedInBytes, char nextChar) {
                    this.charBuffer$1.clear();
                    this.charBuffer$1.put(nextChar);
                    this.charBuffer$1.flip();
                    ByteBuffer encoded = this.encoder$1.encode(this.charBuffer$1);
                    Predef$.MODULE$.byteArrayOps(((Object)BoxesRunTime.boxToCharacter((char)nextChar)).toString().getBytes(this.codec$1.name())).size();
                    return replacedInBytes + (long)encoded.limit();
                }
                {
                    this.codec$1 = codec$1;
                    this.encoder$1 = encoder$1;
                    this.charBuffer$1 = charBuffer$1;
                }
            }));
            resource.close();
        }
        catch (Throwable throwable) {
            void var12_6;
            var12_6.close();
            throw throwable;
        }
        return l;
    }

    public static final void write$1(Seekable $this, int done, SeekableByteChannel channel$1, long srcIndex$1, long destIndex$1, int length$2, ByteBuffer buf$1) {
        Object object = length$2 < done + buf$1.capacity() ? buf$1.limit(length$2 - done) : BoxedUnit.UNIT;
        buf$1.clear();
        channel$1.read(buf$1, srcIndex$1 + (long)done);
        buf$1.flip();
        channel$1.write(buf$1, destIndex$1 + (long)done);
    }

    private static final Tuple2 writeArray$1(Seekable $this, byte[] array, WritableByteChannel c$1, TraversableOnce bytes$2, long length$1) {
        long l;
        if (length$1 < 0L) {
            l = bytes$2.size();
        } else {
            Predef$ predef$ = Predef$.MODULE$;
            l = RichLong$.MODULE$.min$extension(length$1, (long)bytes$2.size());
        }
        long count2 = l;
        int wrote = c$1.write(ByteBuffer.wrap(array, 0, (int)count2));
        boolean isWriteAll = length$1 > 0L;
        return new Tuple2.mcJZ.sp((long)wrote, isWriteAll && length$1 < (long)bytes$2.size());
    }

    private static final long write$2(Seekable $this, long written, TraversableOnce data, long acc, WritableByteChannel c$1, long length$1, ByteBuffer buf$2, BooleanRef earlyTermination$1) {
        Tuple2 tuple2;
        while (true) {
            int n;
            boolean bl;
            if (bl = -1L == length$1 ? true : Long.MIN_VALUE == length$1) {
                n = buf$2.capacity();
            } else {
                long l = length$1 - written;
                Predef$ predef$ = Predef$.MODULE$;
                n = (int)RichLong$.MODULE$.min$extension(l, (long)buf$2.capacity());
            }
            tuple2 = TraversableOnceOps$.MODULE$.splitAt(data, n);
            if (tuple2 == null) break;
            Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
            TraversableOnce toWrite = (TraversableOnce)tuple22._1();
            TraversableOnce remaining = (TraversableOnce)tuple22._2();
            if (n <= 0 && !remaining.nonEmpty()) {
                Predef$.MODULE$.assert(n > 0 || remaining.nonEmpty());
            }
            buf$2.clear();
            toWrite.foreach((Function1)new Serializable($this, buf$2){
                public static final long serialVersionUID = 0L;
                private final ByteBuffer buf$2;

                public final ByteBuffer apply(byte x$1) {
                    return this.buf$2.put(x$1);
                }
                {
                    this.buf$2 = buf$2;
                }
            });
            buf$2.flip();
            long currentWrite = c$1.write(buf$2);
            boolean bl2 = earlyTermination$1.elem = length$1 <= written + (long)n && remaining.nonEmpty();
            if (earlyTermination$1.elem || remaining.isEmpty()) {
                return currentWrite + acc;
            }
            acc = currentWrite + acc;
            data = remaining;
            written += (long)n;
        }
        throw new MatchError(tuple2);
    }

    public static final ByteChannel opened$1(Seekable $this) {
        OpenedResource<SeekableByteChannel> r = $this.underlyingChannel(false);
        r.get().position(0L);
        return new ByteChannel($this, r){
            private final SeekableByteChannel wrapped;
            private final OpenedResource r$1;

            public boolean isOpen() {
                return this.wrapped.isOpen();
            }

            public void close() {
                this.r$1.close();
            }

            public int write(ByteBuffer src) {
                return this.wrapped.write(src);
            }

            public int read(ByteBuffer dst) {
                return this.wrapped.read(dst);
            }
            {
                this.r$1 = r$1;
                this.wrapped = (SeekableByteChannel)r$1.get();
            }
        };
    }

    public static void $init$(Seekable $this) {
    }
}

