/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import io.aeron.logbuffer.FrameDescriptor;
import org.agrona.BitUtil;
import org.agrona.concurrent.UnsafeBuffer;

public class TermGapScanner {
    private static final int ALIGNED_HEADER_LENGTH = BitUtil.align((int)32, (int)32);

    public static int scanForGap(UnsafeBuffer termBuffer, int termId, int scanOffset, int limitOffset, GapHandler handler) {
        int frameLength;
        while ((frameLength = FrameDescriptor.frameLengthVolatile(termBuffer, scanOffset)) > 0 && (scanOffset += BitUtil.align((int)frameLength, (int)32)) < limitOffset) {
        }
        int gapBeginOffset = scanOffset;
        if (scanOffset < limitOffset) {
            int limit = limitOffset - ALIGNED_HEADER_LENGTH;
            while (scanOffset < limit) {
                if (0 == termBuffer.getIntVolatile(scanOffset += 32)) continue;
                scanOffset -= ALIGNED_HEADER_LENGTH;
                break;
            }
            int gapLength = scanOffset - gapBeginOffset + ALIGNED_HEADER_LENGTH;
            handler.onGap(termId, gapBeginOffset, gapLength);
        }
        return gapBeginOffset;
    }

    @FunctionalInterface
    public static interface GapHandler {
        public void onGap(int var1, int var2, int var3);
    }
}

