/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.ClientConductor;
import io.aeron.LogBuffers;
import io.aeron.ReservedValueSupplier;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.HeaderWriter;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.logbuffer.TermAppender;
import org.agrona.DirectBuffer;
import org.agrona.ManagedResource;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.ReadablePosition;

public class Publication
implements AutoCloseable {
    public static final long NOT_CONNECTED = -1L;
    public static final long BACK_PRESSURED = -2L;
    public static final long ADMIN_ACTION = -3L;
    public static final long CLOSED = -4L;
    private final long registrationId;
    private int refCount = 0;
    private final int streamId;
    private final int sessionId;
    private final int initialTermId;
    private final int maxMessageLength;
    private final int maxPayloadLength;
    private final int positionBitsToShift;
    private volatile boolean isClosed = false;
    private final TermAppender[] termAppenders = new TermAppender[3];
    private final ReadablePosition positionLimit;
    private final UnsafeBuffer logMetaDataBuffer;
    private final HeaderWriter headerWriter;
    private final LogBuffers logBuffers;
    private final ClientConductor clientConductor;
    private final String channel;

    Publication(ClientConductor clientConductor, String channel, int streamId, int sessionId, ReadablePosition positionLimit, LogBuffers logBuffers, long registrationId) {
        UnsafeBuffer[] buffers = logBuffers.termBuffers();
        UnsafeBuffer logMetaDataBuffer = logBuffers.metaDataBuffer();
        for (int i = 0; i < 3; ++i) {
            this.termAppenders[i] = new TermAppender(buffers[i], logMetaDataBuffer, i);
        }
        int termLength = logBuffers.termLength();
        this.maxPayloadLength = LogBufferDescriptor.mtuLength(logMetaDataBuffer) - 32;
        this.maxMessageLength = FrameDescriptor.computeMaxMessageLength(termLength);
        this.clientConductor = clientConductor;
        this.channel = channel;
        this.streamId = streamId;
        this.sessionId = sessionId;
        this.initialTermId = LogBufferDescriptor.initialTermId(logMetaDataBuffer);
        this.logMetaDataBuffer = logMetaDataBuffer;
        this.registrationId = registrationId;
        this.positionLimit = positionLimit;
        this.logBuffers = logBuffers;
        this.positionBitsToShift = Integer.numberOfTrailingZeros(termLength);
        this.headerWriter = new HeaderWriter(LogBufferDescriptor.defaultFrameHeader(logMetaDataBuffer));
    }

    public int termBufferLength() {
        return this.logBuffers.termLength();
    }

    public String channel() {
        return this.channel;
    }

    public int streamId() {
        return this.streamId;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public int initialTermId() {
        return this.initialTermId;
    }

    public int maxMessageLength() {
        return this.maxMessageLength;
    }

    public int maxPayloadLength() {
        return this.maxPayloadLength;
    }

    public boolean isConnected() {
        return !this.isClosed && this.clientConductor.isPublicationConnected(LogBufferDescriptor.timeOfLastStatusMessage(this.logMetaDataBuffer));
    }

    @Override
    public void close() {
        this.clientConductor.mainLock().lock();
        try {
            if (--this.refCount == 0) {
                this.release();
            }
        }
        finally {
            this.clientConductor.mainLock().unlock();
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    void release() {
        if (!this.isClosed) {
            this.isClosed = true;
            this.clientConductor.releasePublication(this);
        }
    }

    public long position() {
        if (this.isClosed) {
            return -4L;
        }
        long rawTail = LogBufferDescriptor.rawTailVolatile(this.logMetaDataBuffer);
        int termOffset = LogBufferDescriptor.termOffset(rawTail, this.logBuffers.termLength());
        return LogBufferDescriptor.computePosition(LogBufferDescriptor.termId(rawTail), termOffset, this.positionBitsToShift, this.initialTermId);
    }

    public long positionLimit() {
        if (this.isClosed) {
            return -4L;
        }
        return this.positionLimit.getVolatile();
    }

    public long offer(DirectBuffer buffer) {
        return this.offer(buffer, 0, buffer.capacity());
    }

    public long offer(DirectBuffer buffer, int offset, int length) {
        return this.offer(buffer, offset, length, null);
    }

    public long offer(DirectBuffer buffer, int offset, int length, ReservedValueSupplier reservedValueSupplier) {
        long newPosition = -4L;
        if (!this.isClosed) {
            long limit = this.positionLimit.getVolatile();
            int partitionIndex = LogBufferDescriptor.activePartitionIndex(this.logMetaDataBuffer);
            TermAppender termAppender = this.termAppenders[partitionIndex];
            long rawTail = termAppender.rawTailVolatile();
            long termOffset = rawTail & 0xFFFFFFFFL;
            long position = LogBufferDescriptor.computeTermBeginPosition(LogBufferDescriptor.termId(rawTail), this.positionBitsToShift, this.initialTermId) + termOffset;
            if (position < limit) {
                long result;
                if (length <= this.maxPayloadLength) {
                    result = termAppender.appendUnfragmentedMessage(this.headerWriter, buffer, offset, length, reservedValueSupplier);
                } else {
                    this.checkForMaxMessageLength(length);
                    result = termAppender.appendFragmentedMessage(this.headerWriter, buffer, offset, length, this.maxPayloadLength, reservedValueSupplier);
                }
                newPosition = this.newPosition(partitionIndex, (int)termOffset, position, result);
            } else {
                newPosition = this.clientConductor.isPublicationConnected(LogBufferDescriptor.timeOfLastStatusMessage(this.logMetaDataBuffer)) ? -2L : -1L;
            }
        }
        return newPosition;
    }

    public long tryClaim(int length, BufferClaim bufferClaim) {
        long newPosition = -4L;
        if (!this.isClosed) {
            this.checkForMaxPayloadLength(length);
            long limit = this.positionLimit.getVolatile();
            int partitionIndex = LogBufferDescriptor.activePartitionIndex(this.logMetaDataBuffer);
            TermAppender termAppender = this.termAppenders[partitionIndex];
            long rawTail = termAppender.rawTailVolatile();
            long termOffset = rawTail & 0xFFFFFFFFL;
            long position = LogBufferDescriptor.computeTermBeginPosition(LogBufferDescriptor.termId(rawTail), this.positionBitsToShift, this.initialTermId) + termOffset;
            if (position < limit) {
                long result = termAppender.claim(this.headerWriter, length, bufferClaim);
                newPosition = this.newPosition(partitionIndex, (int)termOffset, position, result);
            } else {
                newPosition = this.clientConductor.isPublicationConnected(LogBufferDescriptor.timeOfLastStatusMessage(this.logMetaDataBuffer)) ? -2L : -1L;
            }
        }
        return newPosition;
    }

    public long registrationId() {
        return this.registrationId;
    }

    void incRef() {
        ++this.refCount;
    }

    private long newPosition(int index, int currentTail, long position, long result) {
        long newPosition = -3L;
        int termOffset = TermAppender.termOffset(result);
        if (termOffset > 0) {
            newPosition = position - (long)currentTail + (long)termOffset;
        } else if (termOffset == -1) {
            int nextIndex = LogBufferDescriptor.nextPartitionIndex(index);
            this.termAppenders[nextIndex].tailTermId(TermAppender.termId(result) + 1);
            LogBufferDescriptor.activePartitionIndex(this.logMetaDataBuffer, nextIndex);
        }
        return newPosition;
    }

    private void checkForMaxPayloadLength(int length) {
        if (length > this.maxPayloadLength) {
            throw new IllegalArgumentException(String.format("Claim exceeds maxPayloadLength of %d, length=%d", this.maxPayloadLength, length));
        }
    }

    private void checkForMaxMessageLength(int length) {
        if (length > this.maxMessageLength) {
            throw new IllegalArgumentException(String.format("Encoded message exceeds maxMessageLength of %d, length=%d", this.maxMessageLength, length));
        }
    }

    ManagedResource managedResource() {
        return new PublicationManagedResource();
    }

    private class PublicationManagedResource
    implements ManagedResource {
        private long timeOfLastStateChange = 0L;

        private PublicationManagedResource() {
        }

        public void timeOfLastStateChange(long time) {
            this.timeOfLastStateChange = time;
        }

        public long timeOfLastStateChange() {
            return this.timeOfLastStateChange;
        }

        public void delete() {
            Publication.this.logBuffers.close();
        }
    }
}

